/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import codechicken.lib.vec.Rotation;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IHasFluidDisplayItem;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.net.GT_Packet_ClientPreference;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_ClientPreference;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_PlayedSound;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Proxy;
import gregtech.common.entities.GT_Entity_Arrow;
import gregtech.common.entities.GT_Entity_Arrow_Potion;
import gregtech.common.net.MessageUpdateFluidDisplayItem;
import gregtech.common.render.GT_CapeRenderer;
import gregtech.common.render.GT_FlaskRenderer;
import gregtech.common.render.GT_FluidDisplayStackRenderer;
import gregtech.common.render.GT_MetaGenerated_Item_Renderer;
import gregtech.common.render.GT_MetaGenerated_Tool_Renderer;
import gregtech.common.render.GT_PollutionRenderer;
import gregtech.common.render.GT_Renderer_Block;
import gregtech.common.render.GT_Renderer_Entity_Arrow;
import ic2.api.tile.IWrenchable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class GT_Client
extends GT_Proxy
implements Runnable {
    private static List ROTATABLE_VANILLA_BLOCKS = Arrays.asList(Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150460_al, Blocks.field_150470_am, Blocks.field_150409_cd, Blocks.field_150367_z, Blocks.field_150486_ae, Blocks.field_150447_bR, Blocks.field_150477_bB, Blocks.field_150438_bZ, Blocks.field_150423_aK, Blocks.field_150428_aP);
    private final HashSet<String> mCapeList = new HashSet();
    public static final GT_PollutionRenderer mPollutionRenderer = new GT_PollutionRenderer();
    private final GT_CapeRenderer mCapeRenderer;
    private final List mPosR;
    private final List mPosG;
    private final List mPosB;
    private final List mPosA = Arrays.asList(new Object[0]);
    private final List mNegR;
    private final List mNegG;
    private final List mNegB;
    private final List mNegA = Arrays.asList(new Object[0]);
    private final List mMoltenPosR;
    private final List mMoltenPosG;
    private final List mMoltenPosB;
    private final List mMoltenPosA = Arrays.asList(new Object[0]);
    private final List mMoltenNegR;
    private final List mMoltenNegG;
    private final List mMoltenNegB;
    private final List mMoltenNegA = Arrays.asList(new Object[0]);
    private long mAnimationTick = 0L;
    private long afterSomeTime;
    private boolean mAnimationDirection = false;
    private int mLastUpdatedBlockX;
    private int mLastUpdatedBlockY;
    private int mLastUpdatedBlockZ;
    private boolean isFirstClientPlayerTick = true;
    private String mMessage = "";
    private GT_ClientPreference mPreference;
    private boolean mFirstTick = false;
    private static boolean checkedForChicken = false;
    public static int hideValue = 0;
    public static int changeDetected = 0;

    public GT_Client() {
        this.mCapeRenderer = new GT_CapeRenderer(this.mCapeList);
        this.mPosR = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mPosG = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mPosB = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mNegR = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegG = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegB = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mMoltenPosR = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mMoltenPosG = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mMoltenPosB = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mMoltenNegR = Arrays.asList(Materials.InfusedEntropy);
        this.mMoltenNegG = Arrays.asList(Materials.InfusedEntropy);
        this.mMoltenNegB = Arrays.asList(Materials.InfusedEntropy);
    }

    private static void drawGrid(DrawBlockHighlightEvent aEvent, boolean showCoverConnections) {
        if (!checkedForChicken) {
            try {
                Class.forName("codechicken.lib.vec.Rotation");
            }
            catch (Throwable e) {
                if (GT_Values.D1) {
                    e.printStackTrace(GT_Log.err);
                }
                return;
            }
            checkedForChicken = true;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-(aEvent.player.field_70142_S + (aEvent.player.field_70165_t - aEvent.player.field_70142_S) * (double)aEvent.partialTicks)), (double)(-(aEvent.player.field_70137_T + (aEvent.player.field_70163_u - aEvent.player.field_70137_T) * (double)aEvent.partialTicks)), (double)(-(aEvent.player.field_70136_U + (aEvent.player.field_70161_v - aEvent.player.field_70136_U) * (double)aEvent.partialTicks)));
        GL11.glTranslated((double)((float)aEvent.target.field_72311_b + 0.5f), (double)((float)aEvent.target.field_72312_c + 0.5f), (double)((float)aEvent.target.field_72309_d + 0.5f));
        Rotation.sideRotations[aEvent.target.field_72310_e].glApply();
        GL11.glTranslated((double)0.0, (double)-0.501, (double)0.0);
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
        TileEntity tTile = aEvent.player.field_70170_p.func_147438_o(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        int tConnections = 0;
        if (tTile instanceof ICoverable) {
            if (showCoverConnections) {
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    if (((ICoverable)tTile).getCoverIDAtSide(i) <= 0) continue;
                    tConnections = (byte)(tConnections + (1 << i));
                }
            } else if (tTile instanceof BaseMetaPipeEntity) {
                tConnections = ((BaseMetaPipeEntity)tTile).mConnections;
            }
        }
        if (tConnections > 0) {
            int[][] GridSwitchArr = new int[][]{{0, 5, 3, 1, 2, 4}, {5, 0, 1, 3, 2, 4}, {1, 3, 0, 5, 2, 4}, {3, 1, 5, 0, 2, 4}, {4, 2, 3, 1, 0, 5}, {2, 4, 3, 1, 5, 0}};
            block11: for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                if ((tConnections & 1 << i) == 0) continue;
                switch (GridSwitchArr[aEvent.target.field_72310_e][i]) {
                    case 0: {
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 1: {
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
                        continue block11;
                    }
                    case 2: {
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 3: {
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
                        continue block11;
                    }
                    case 4: {
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 5: {
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
                    }
                }
            }
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private static void drawGrid(DrawBlockHighlightEvent aEvent) {
        GT_Client.drawGrid(aEvent, false);
    }

    @Override
    public boolean isServerSide() {
        return true;
    }

    @Override
    public boolean isClientSide() {
        return true;
    }

    @Override
    public boolean isBukkitSide() {
        return false;
    }

    @Override
    public EntityPlayer getThePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public int addArmor(String aPrefix) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)aPrefix);
    }

    @Override
    public void onPreLoad() {
        super.onPreLoad();
        for (String tName : new String[]{"renadi", "hanakocz", "MysteryDump", "Flaver4", "x_Fame", "Peluche321", "Goshen_Ithilien", "manf", "Bimgo", "leagris", "IAmMinecrafter02", "Cerous", "Devilin_Pixy", "Bkarlsson87", "BadAlchemy", "CaballoCraft", "melanclock", "Resursator", "demanzke", "AndrewAmmerlaan", "Deathlycraft", "Jirajha", "Axlegear", "kei_kouma", "Dracion", "dungi", "Dorfschwein", "Zero Tw0", "mattiagraz85", "sebastiank30", "Plem", "invultri", "grillo126", "malcanteth", "Malevolence_", "Nicholas_Manuel", "Sirbab", "kehaan", "bpgames123", "semig0d", "9000bowser", "Sovereignty89", "Kris1432", "xander_cage_", "samuraijp", "bsaa", "SpwnX", "tworf", "Kadah", "kanni", "Stute", "Hegik", "Onlyme", "t3hero", "Hotchi", "jagoly", "Nullav", "BH5432", "Sibmer", "inceee", "foxxx0", "Hartok", "TMSama", "Shlnen", "Carsso", "zessirb", "meep310", "Seldron", "yttr1um", "hohounk", "freebug", "Sylphio", "jmarler", "Saberawr", "r00teniy", "Neonbeta", "yinscape", "voooon24", "Quintine", "peach774", "lepthymo", "bildeman", "Kremnari", "Aerosalo", "OndraSter", "oscares91", "mr10movie", "Daxx367x2", "EGERTRONx", "aka13_404", "Abouttabs", "Johnstaal", "djshiny99", "megatronp", "DZCreeper", "Kane_Hart", "Truculent", "vidplace7", "simon6689", "MomoNasty", "UnknownXLV", "goreacraft", "Fluttermine", "Daddy_Cecil", "MrMaleficus", "TigersFangs", "cublikefoot", "chainman564", "NikitaBuker", "Misha999777", "25FiveDetail", "AntiCivilBoy", "michaelbrady", "xXxIceFirexXx", "Speedynutty68", "GarretSidzaka", "HallowCharm977", "mastermind1919", "The_Hypersonic", "diamondguy2798", "zF4ll3nPr3d4t0r", "CrafterOfMines57", "XxELIT3xSNIP3RxX", "SuterusuKusanagi", "xavier0014", "adamros", "alexbegt"}) {
            this.mCapeList.add(tName.toLowerCase());
        }
        new Thread(this).start();
        mPollutionRenderer.preLoad();
        this.mPreference = new GT_ClientPreference(GregTech_API.sClientDataFile);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        new GT_Renderer_Block();
        new GT_MetaGenerated_Item_Renderer();
        new GT_MetaGenerated_Tool_Renderer();
        new GT_Renderer_Entity_Arrow(GT_Entity_Arrow.class, "arrow");
        new GT_Renderer_Entity_Arrow(GT_Entity_Arrow_Potion.class, "arrow_potions");
        new GT_FlaskRenderer();
        new GT_FluidDisplayStackRenderer();
    }

    @Override
    public void onPostLoad() {
        super.onPostLoad();
        try {
            for (int i = 1; i < GregTech_API.METATILEENTITIES.length; ++i) {
                while (i < GregTech_API.METATILEENTITIES.length) {
                    if (GregTech_API.METATILEENTITIES[i] != null) {
                        GregTech_API.METATILEENTITIES[i].getStackForm(1L).func_82840_a(null, true);
                        GT_Log.out.println("META " + i + " " + GregTech_API.METATILEENTITIES[i].getMetaName());
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    public void run() {
        String tName;
        Scanner tScanner2;
        try {
            GT_Log.out.println("GT_Mod: Downloading Cape List.");
            tScanner2 = new Scanner(new URL("http://gregtech.overminddl1.com/com/gregoriust/gregtech/supporterlist.txt").openStream());
            while (tScanner2.hasNextLine()) {
                tName = tScanner2.nextLine();
                if (this.mCapeList.contains(tName.toLowerCase())) continue;
                this.mCapeList.add(tName.toLowerCase());
            }
        }
        catch (Throwable tScanner2) {
            // empty catch block
        }
        try {
            GT_Log.out.println("GT New Horizons: Downloading Cape List.");
            tScanner2 = new Scanner(new URL("https://raw.githubusercontent.com/GTNewHorizons/CustomGTCapeHook-Cape-List/master/capes.txt").openStream());
            while (tScanner2.hasNextLine()) {
                tName = tScanner2.nextLine();
                if (tName.contains(":")) {
                    int splitLocation = tName.indexOf(":");
                    String username = tName.substring(0, splitLocation);
                    if (this.mCapeList.contains(username.toLowerCase()) || this.mCapeList.contains(tName.toLowerCase())) continue;
                    this.mCapeList.add(tName.toLowerCase());
                    continue;
                }
                if (this.mCapeList.contains(tName.toLowerCase())) continue;
                this.mCapeList.add(tName.toLowerCase());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
        this.mFirstTick = true;
    }

    @SubscribeEvent
    public void receiveRenderSpecialsEvent(RenderPlayerEvent.Specials.Pre aEvent) {
        this.mCapeRenderer.receiveRenderSpecialsEvent(aEvent);
    }

    @SubscribeEvent
    public void onPlayerTickEventClient(TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isClient() && aEvent.phase == TickEvent.Phase.END && !aEvent.player.field_70128_L) {
            MovingObjectPosition movingObjectPosition;
            if (this.mFirstTick) {
                this.mFirstTick = false;
                GT_Values.NW.sendToServer(new GT_Packet_ClientPreference(this.mPreference));
            }
            ++this.afterSomeTime;
            if (this.afterSomeTime >= 100L) {
                this.afterSomeTime = 0L;
                StatFileWriter sfw = Minecraft.func_71410_x().field_71439_g.func_146107_m();
                try {
                    for (GT_Recipe gT_Recipe : GT_Recipe.GT_Recipe_Map.sAssemblylineVisualRecipes.mRecipeList) {
                        gT_Recipe.mHidden = GT_Values.hideAssLineRecipes && !sfw.func_77443_a(GT_Mod.achievements.getAchievement(gT_Recipe.getOutput(0).func_77977_a()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList tList = new ArrayList();
            for (Map.Entry entry : GT_Utility.sPlayedSoundMap.entrySet()) {
                if ((Integer)entry.getValue() < 0) {
                    tList.add(entry.getKey());
                    continue;
                }
                entry.setValue((Integer)entry.getValue() - 1);
            }
            for (GT_PlayedSound tKey : tList) {
                GT_Utility.sPlayedSoundMap.remove(tKey);
            }
            if (!GregTech_API.mServerStarted) {
                GregTech_API.mServerStarted = true;
            }
            if (GT_Values.updateFluidDisplayItems && (movingObjectPosition = Minecraft.func_71410_x().field_71476_x) != null && movingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (this.mLastUpdatedBlockX != movingObjectPosition.field_72311_b && this.mLastUpdatedBlockY != movingObjectPosition.field_72312_c && this.mLastUpdatedBlockZ != movingObjectPosition.field_72309_d || this.afterSomeTime % 10L == 0L)) {
                IGregTechTileEntity gtTile;
                this.mLastUpdatedBlockX = movingObjectPosition.field_72311_b;
                this.mLastUpdatedBlockY = movingObjectPosition.field_72312_c;
                this.mLastUpdatedBlockZ = movingObjectPosition.field_72309_d;
                TileEntity tileEntity = aEvent.player.field_70170_p.func_147438_o(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d);
                if (tileEntity instanceof IGregTechTileEntity && (gtTile = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof IHasFluidDisplayItem) {
                    GT_Values.NW.sendToServer(new MessageUpdateFluidDisplayItem(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d, gtTile.getWorld().field_73011_w.field_76574_g));
                }
            }
        }
    }

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent aEvent) {
        Block aBlock = aEvent.player.field_70170_p.func_147439_a(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        TileEntity aTileEntity = aEvent.player.field_70170_p.func_147438_o(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        if (GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sWrenchList)) {
            if (aTileEntity instanceof ITurnable || ROTATABLE_VANILLA_BLOCKS.contains(aBlock) || aTileEntity instanceof IWrenchable) {
                GT_Client.drawGrid(aEvent, false);
            }
            return;
        }
        if (!(aTileEntity instanceof ICoverable)) {
            return;
        }
        if (GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sWireCutterList) || GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sSolderingToolList)) {
            if (((ICoverable)aTileEntity).getCoverIDAtSide((byte)aEvent.target.field_72310_e) == 0) {
                GT_Client.drawGrid(aEvent, false);
            }
            return;
        }
        if (aEvent.currentItem == null && aEvent.player.func_70093_af() || GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sCrowbarList) || GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sScrewdriverList)) {
            if (((ICoverable)aTileEntity).getCoverIDAtSide((byte)aEvent.target.field_72310_e) == 0) {
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    if (((ICoverable)aTileEntity).getCoverIDAtSide(i) <= 0) continue;
                    GT_Client.drawGrid(aEvent, true);
                    return;
                }
            }
            return;
        }
        if (GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sCovers.keySet()) && ((ICoverable)aTileEntity).getCoverIDAtSide((byte)aEvent.target.field_72310_e) == 0) {
            GT_Client.drawGrid(aEvent, true);
        }
    }

    @SubscribeEvent
    public void receiveRenderEvent(RenderPlayerEvent.Pre aEvent) {
        if (GT_Utility.getFullInvisibility(aEvent.entityPlayer)) {
            aEvent.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent aEvent) {
        if (aEvent.phase == TickEvent.Phase.END) {
            int newHideValue;
            if (changeDetected > 0) {
                --changeDetected;
            }
            if ((newHideValue = GT_Client.shouldHeldItemHideThings()) != hideValue) {
                hideValue = newHideValue;
                changeDetected = 5;
            }
            ++this.mAnimationTick;
            if (this.mAnimationTick % 50L == 0L) {
                this.mAnimationDirection = !this.mAnimationDirection;
            }
            int tDirection = this.mAnimationDirection ? 1 : -1;
            for (Materials tMaterial : this.mPosR) {
                tMaterial.mRGBa[0] = (short)(tMaterial.mRGBa[0] + tDirection);
            }
            for (Materials tMaterial : this.mPosG) {
                tMaterial.mRGBa[1] = (short)(tMaterial.mRGBa[1] + tDirection);
            }
            for (Materials tMaterial : this.mPosB) {
                tMaterial.mRGBa[2] = (short)(tMaterial.mRGBa[2] + tDirection);
            }
            for (Materials tMaterial : this.mPosA) {
                tMaterial.mRGBa[3] = (short)(tMaterial.mRGBa[3] + tDirection);
            }
            for (Materials tMaterial : this.mNegR) {
                tMaterial.mRGBa[0] = (short)(tMaterial.mRGBa[0] - tDirection);
            }
            for (Materials tMaterial : this.mNegG) {
                tMaterial.mRGBa[1] = (short)(tMaterial.mRGBa[1] - tDirection);
            }
            for (Materials tMaterial : this.mNegB) {
                tMaterial.mRGBa[2] = (short)(tMaterial.mRGBa[2] - tDirection);
            }
            for (Materials tMaterial : this.mNegA) {
                tMaterial.mRGBa[3] = (short)(tMaterial.mRGBa[3] - tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosR) {
                tMaterial.mMoltenRGBa[0] = (short)(tMaterial.mMoltenRGBa[0] + tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosG) {
                tMaterial.mMoltenRGBa[1] = (short)(tMaterial.mMoltenRGBa[1] + tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosB) {
                tMaterial.mMoltenRGBa[2] = (short)(tMaterial.mMoltenRGBa[2] + tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosA) {
                tMaterial.mMoltenRGBa[3] = (short)(tMaterial.mMoltenRGBa[3] + tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegR) {
                tMaterial.mMoltenRGBa[0] = (short)(tMaterial.mMoltenRGBa[0] - tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegG) {
                tMaterial.mMoltenRGBa[1] = (short)(tMaterial.mMoltenRGBa[1] - tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegB) {
                tMaterial.mMoltenRGBa[2] = (short)(tMaterial.mMoltenRGBa[2] - tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegA) {
                tMaterial.mMoltenRGBa[3] = (short)(tMaterial.mMoltenRGBa[3] - tDirection);
            }
        }
    }

    @Override
    public void doSonictronSound(ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        String tString = "note.harp";
        int j = this.mSoundItems.size();
        for (int i = 0; i < j; ++i) {
            if (!GT_Utility.areStacksEqual((ItemStack)this.mSoundItems.get(i), aStack)) continue;
            tString = (String)this.mSoundNames.get(i);
            break;
        }
        if (tString.startsWith("random.explode")) {
            if (aStack.field_77994_a == 3) {
                tString = "random.fuse";
            } else if (aStack.field_77994_a == 2) {
                tString = "random.old_explode";
            }
        }
        if (tString.startsWith("streaming.")) {
            switch (aStack.field_77994_a) {
                case 1: {
                    tString = tString + "13";
                    break;
                }
                case 2: {
                    tString = tString + "cat";
                    break;
                }
                case 3: {
                    tString = tString + "blocks";
                    break;
                }
                case 4: {
                    tString = tString + "chirp";
                    break;
                }
                case 5: {
                    tString = tString + "far";
                    break;
                }
                case 6: {
                    tString = tString + "mall";
                    break;
                }
                case 7: {
                    tString = tString + "mellohi";
                    break;
                }
                case 8: {
                    tString = tString + "stal";
                    break;
                }
                case 9: {
                    tString = tString + "strad";
                    break;
                }
                case 10: {
                    tString = tString + "ward";
                    break;
                }
                case 11: {
                    tString = tString + "11";
                    break;
                }
                case 12: {
                    tString = tString + "wait";
                    break;
                }
                default: {
                    tString = tString + "wherearewenow";
                }
            }
        }
        if (tString.startsWith("streaming.")) {
            new WorldSpawnedEventBuilder.RecordEffectEventBuilder().setIdentifier(tString.substring(10)).setPosition(aX, aY, aZ).run();
        } else {
            new WorldSpawnedEventBuilder.SoundEventBuilder().setVolume(3.0f).setPitch(tString.startsWith("note.") ? (float)Math.pow(2.0, (double)(aStack.field_77994_a - 13) / 12.0) : 1.0f).setIdentifier(tString).setPosition(aX, aY, aZ).run();
        }
    }

    private static int shouldHeldItemHideThings() {
        try {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return 0;
            }
            ItemStack tCurrentItem = player.func_71045_bC();
            if (tCurrentItem == null) {
                return 0;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)tCurrentItem);
            int hide = 0;
            for (int i : ids) {
                if (!OreDictionary.getOreName((int)i).equals("craftingToolSolderingIron")) continue;
                hide |= 1;
                break;
            }
            if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList) || GregTech_API.sCovers.containsKey(new GT_ItemStack(tCurrentItem))) {
                hide |= 2;
            }
            return hide;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void recieveChunkPollutionPacket(ChunkCoordIntPair chunk, int pollution) {
        mPollutionRenderer.processPacket(chunk, pollution);
    }
}

