/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.IMutationCustom;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.bees.GT_AlleleBeeSpecies;
import gregtech.common.bees.GT_Bee_Mutation;
import gregtech.common.items.CombType;
import gregtech.common.items.DropType;
import gregtech.common.items.PropolisType;
import gregtech.loaders.misc.GT_Bees;
import gregtech.loaders.misc.GT_BranchDefinition;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;

public enum GT_BeeDefinition implements IBeeDefinition
{
    CLAY(GT_BranchDefinition.ORGANIC, "Clay", true, new Color(13158618), new Color(255), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
        beeSpecies.addProduct(new ItemStack(Items.field_151119_aD, 1), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("BiomesOPlenty", "mudball", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Industrious"), GT_BeeDefinition.getSpecies((byte)0, "Diligent"), 10);
        tMutation.requireResource(Blocks.field_150435_aG, 0);
    }),
    SLIMEBALL(GT_BranchDefinition.ORGANIC, "SlimeBall", true, new Color(5152341), new Color(65301), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 15), Float.valueOf(0.3f));
        beeSpecies.addProduct(new ItemStack(Items.field_151123_aH, 1), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STICKY), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        if (Loader.isModLoaded((String)"TConstruct")) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("TConstruct", "strangeFood", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("TConstruct", "slime.gel", 1L, 2), Float.valueOf(0.01f));
        }
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.MUSHROOMS);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "water"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Marshy"), CLAY, 7);
        if (Loader.isModLoaded((String)"TConstruct")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"TConstruct", (String)"slime.gel"), 1);
        }
    }),
    PEAT(GT_BranchDefinition.ORGANIC, "Peat", true, new Color(9462327), new Color(5779467), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("Forestry", "peat", 1L, 0), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("Forestry", "mulch", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Rural"), CLAY, 10)),
    STICKYRESIN(GT_BranchDefinition.ORGANIC, "StickyResin", true, new Color(3051355), new Color(14467721), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STICKY), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(ItemList.IC2_Resin.get(1L, new Object[0]), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SLIMEBALL, PEAT, 15);
        tMutation.requireResource("logRubber");
    }),
    COAL(GT_BranchDefinition.ORGANIC, "Coal", true, new Color(0x666666), new Color(0x525252), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.COAL), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectCreeper);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Industrious"), PEAT, 9);
        tMutation.requireResource("blockCoal");
    }),
    OIL(GT_BranchDefinition.ORGANIC, "Oil", true, new Color(0x4C4C4C), new Color(0x333333), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OIL), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "water"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> dis.registerMutation(COAL, STICKYRESIN, 4)),
    SANDWICH(GT_BranchDefinition.ORGANIC, "Sandwich", true, new Color(3329330), new Color(14329120), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Cucumber.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Onion.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Tomato.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Cheese.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(new ItemStack(Items.field_151157_am, 1, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(new ItemStack(Items.field_151083_be, 1, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectFertile);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Agrarian"), GT_BeeDefinition.getSpecies((byte)3, "TCBatty"), 10)),
    ASH(GT_BranchDefinition.ORGANIC, "Ash", true, new Color(1972760), new Color(0xC6C6C6), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ASH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(COAL, CLAY, 10);
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
    }),
    APATITE(GT_BranchDefinition.ORGANIC, "Apatite", true, new Color(12698102), new Color(6776708), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.APATITE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "rock"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ASH, COAL, 10);
        tMutation.requireResource("blockApatite");
    }),
    FERTILIZER(GT_BranchDefinition.ORGANIC, "Fertilizer", true, new Color(8376053), new Color(6636837), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Ash, 1L), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(ItemList.FR_Fertilizer.get(1L, new Object[0]), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(ItemList.IC2_Fertilizer.get(1L, new Object[0]), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> dis.registerMutation(ASH, APATITE, 8)),
    REDSTONE(GT_BranchDefinition.GEM, "Redstone", true, new Color(8195855), new Color(0xD11919), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDSTONE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.RAREEARTH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Industrious"), GT_BeeDefinition.getSpecies((byte)0, "Demonic"), 10);
        tMutation.requireResource("blockRedstone");
    }),
    LAPIS(GT_BranchDefinition.GEM, "Lapis", true, new Color(1656785), new Color(4680922), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LAPIS), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Demonic"), GT_BeeDefinition.getSpecies((byte)0, "Imperial"), 10);
        tMutation.requireResource("blockLapis");
    }),
    CERTUS(GT_BranchDefinition.GEM, "CertusQuartz", true, new Color(5754875), new Color(0xBBEEFF), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CERTUS), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Hermitic"), LAPIS, 10);
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"appliedenergistics2", (String)"tile.BlockQuartz"), 0);
        }
    }),
    FLUIX(GT_BranchDefinition.GEM, "FluixDust", true, new Color(10712575), new Color(11899391), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.FLUIX), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, LAPIS, 7);
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"appliedenergistics2", (String)"tile.BlockFluix"), 0);
        }
    }),
    DIAMOND(GT_BranchDefinition.GEM, "Diamond", false, new Color(0xCCFFFF), new Color(0xA3CCCC), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DIAMOND), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CERTUS, COAL, 3);
        tMutation.requireResource("blockDiamond");
    }),
    RUBY(GT_BranchDefinition.GEM, "Ruby", false, new Color(15073372), new Color(13369426), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.RUBY), Float.valueOf(0.15f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.REDGARNET), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, DIAMOND, 5);
        tMutation.requireResource("blockRuby");
    }),
    SAPPHIRE(GT_BranchDefinition.GEM, "Sapphire", true, new Color(13260), new Color(9359), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SAPPHIRE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CERTUS, LAPIS, 5);
        tMutation.requireResource(GregTech_API.sBlockGem2, 12);
    }),
    OLIVINE(GT_BranchDefinition.GEM, "Olivine", true, new Color(2395940), new Color(0xCCFFCC), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OLIVINE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MAGNESIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> dis.registerMutation(CERTUS, GT_BeeDefinition.getSpecies((byte)0, "Ended"), 5)),
    EMERALD(GT_BranchDefinition.GEM, "Emerald", false, new Color(2395940), new Color(3061806), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.EMERALD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ALUMINIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(OLIVINE, DIAMOND, 4);
        tMutation.requireResource("blockEmerald");
    }),
    REDGARNET(GT_BranchDefinition.GEM, "RedGarnet", false, new Color(12405836), new Color(0xECCECE), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDGARNET), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PYROPE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(DIAMOND, RUBY, 4);
        tMutation.requireResource("blockGarnetRed");
    }),
    YELLOWGARNET(GT_BranchDefinition.GEM, "YellowGarnet", false, new Color(10724161), new Color(0xEDEDCE), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.YELLOWGARNET), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.GROSSULAR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(EMERALD, REDGARNET, 3);
        tMutation.requireResource("blockGarnetYellow");
    }),
    FIRESTONE(GT_BranchDefinition.GEM, "Firestone", false, new Color(0xC00000), new Color(0xFF0000), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.FIRESTONE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, RUBY, 4);
        tMutation.requireResource("blockFirestone");
    }),
    COPPER(GT_BranchDefinition.METAL, "Copper", true, new Color(0xFF6600), new Color(15096832), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COPPER), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Majestic"), CLAY, 13);
        tMutation.requireResource("blockCopper");
    }),
    TIN(GT_BranchDefinition.METAL, "Tin", true, new Color(0xD4D4D4), new Color(0xDDDDDD), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TIN), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ZINC), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CLAY, GT_BeeDefinition.getSpecies((byte)0, "Diligent"), 13);
        tMutation.requireResource("blockTin");
    }),
    LEAD(GT_BranchDefinition.METAL, "Lead", true, new Color(0x666699), new Color(0xA3A3CC), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LEAD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SULFUR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(COAL, COPPER, 13);
        tMutation.requireResource("blockLead");
    }),
    IRON(GT_BranchDefinition.METAL, "Iron", true, new Color(14324039), new Color(14589017), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.IRON), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.TIN), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TIN, COPPER, 13);
        tMutation.requireResource("blockIron");
    }),
    STEEL(GT_BranchDefinition.METAL, "Steel", true, new Color(0x808080), new Color(0x999999), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STEEL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRON), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(IRON, COAL, 10);
        tMutation.requireResource("blockSteel");
        tMutation.restrictTemperature(EnumTemperature.HOT);
    }),
    NICKEL(GT_BranchDefinition.METAL, "Nickel", true, new Color(8750509), new Color(8750509), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NICKEL), Float.valueOf(0.15f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(IRON, COPPER, 13);
        tMutation.requireResource("blockNickel");
    }),
    ZINC(GT_BranchDefinition.METAL, "Zinc", true, new Color(15785712), new Color(15917554), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ZINC), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.GALLIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(IRON, TIN, 13);
        tMutation.requireResource("blockZinc");
    }),
    SILVER(GT_BranchDefinition.METAL, "Silver", true, new Color(12763862), new Color(0xCECEDE), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SULFUR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LEAD, TIN, 10);
        tMutation.requireResource("blockSilver");
    }),
    GOLD(GT_BranchDefinition.METAL, "Gold", true, new Color(15451699), new Color(15584327), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NICKEL), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LEAD, COPPER, 13);
        tMutation.requireResource("blockGold");
        tMutation.restrictTemperature(EnumTemperature.HOT);
    }),
    ARSENIC(GT_BranchDefinition.METAL, "Arsenic", true, new Color(7564370), new Color(2696210), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ARSENIC), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ZINC, SILVER, 10);
        tMutation.requireResource("blockArsenic");
    }),
    ALUMINIUM(GT_BranchDefinition.RAREMETAL, "Aluminium", true, new Color(0xB8B8FF), new Color(0xD6D6FF), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ALUMINIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.BAUXITE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NICKEL, ZINC, 9);
        tMutation.requireResource("blockAluminium");
    }),
    TITANIUM(GT_BranchDefinition.RAREMETAL, "Titanium", true, new Color(0xCC99FF), new Color(14399743), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TITANIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ALMANDINE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, ALUMINIUM, 5);
        tMutation.requireResource(GregTech_API.sBlockMetal7, 9);
    }),
    CHROME(GT_BranchDefinition.RAREMETAL, "Chrome", true, new Color(15442411), new Color(15909874), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MAGNESIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TITANIUM, RUBY, 5);
        tMutation.requireResource(GregTech_API.sBlockMetal2, 3);
    }),
    MANGANESE(GT_BranchDefinition.RAREMETAL, "Manganese", true, new Color(0xD5D5D5), new Color(0xAAAAAA), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MANGANESE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRON), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TITANIUM, ALUMINIUM, 5);
        tMutation.requireResource(GregTech_API.sBlockMetal4, 6);
    }),
    TUNGSTEN(GT_BranchDefinition.RAREMETAL, "Tungsten", false, new Color(6053002), new Color(8224161), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TUNGSTEN), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MOLYBDENUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Heroic"), MANGANESE, 5);
        tMutation.requireResource(GregTech_API.sBlockMetal7, 11);
    }),
    PLATINUM(GT_BranchDefinition.RAREMETAL, "Platinum", false, new Color(0xE6E6E6), new Color(0xFFFFCC), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(DIAMOND, CHROME, 5);
        tMutation.requireResource(GregTech_API.sBlockMetal5, 12);
    }),
    IRIDIUM(GT_BranchDefinition.RAREMETAL, "Iridium", false, new Color(0xDADADA), new Color(13750752), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OSMIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TUNGSTEN, PLATINUM, 5);
        tMutation.requireResource(GregTech_API.sBlockMetal3, 12);
    }),
    OSMIUM(GT_BranchDefinition.RAREMETAL, "Osmium", false, new Color(2829274), new Color(0x8B8B8B), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OSMIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TUNGSTEN, PLATINUM, 5);
        tMutation.requireResource(GregTech_API.sBlockMetal5, 9);
    }),
    SALTY(GT_BranchDefinition.RAREMETAL, "Salt", true, new Color(15780040), new Color(0xFAFAFA), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SALT), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LITHIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CLAY, ALUMINIUM, 5);
        tMutation.requireResource("blockSalt");
    }),
    LITHIUM(GT_BranchDefinition.RAREMETAL, "Lithium", false, new Color(15741580), new Color(14802175), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LITHIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SALT), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SALTY, ALUMINIUM, 5);
        tMutation.requireResource("blockLithium");
    }),
    ELECTROTINE(GT_BranchDefinition.RAREMETAL, "Electrotine", false, new Color(2003199), new Color(3978440), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ELECTROTINE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDSTONE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, GOLD, 5);
        tMutation.requireResource("blockElectrotine");
    }),
    COOLANT(GT_BranchDefinition.IC2, "Coolant", false, new Color(1331034), new Color(2397346), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 4), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.COOLANT), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectGlacial);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Icy"), GT_BeeDefinition.getSpecies((byte)0, "Glacial"), 10);
        tMutation.requireResource(Block.func_149634_a((Item)GT_ModHandler.getModItem("IC2", "fluidCoolant", 1L).func_77973_b()), 0);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    ENERGY(GT_BranchDefinition.IC2, "Energy", false, new Color(0xC11F1F), new Color(0xEBB9B9), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 12), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Demonic"), GT_BeeDefinition.getSpecies((byte)1, "volcanic"), 10);
        tMutation.requireResource(Block.func_149634_a((Item)GT_ModHandler.getModItem("IC2", "fluidHotCoolant", 1L).func_77973_b()), 0);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(128, "Boneyard Biome"));
    }),
    LAPOTRON(GT_BranchDefinition.IC2, "Lapotron", false, new Color(6584575), new Color(0x1414FF), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LAPIS), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LAPOTRON), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LAPIS, ENERGY, 6);
        tMutation.requireResource("blockLapis");
        tMutation.restrictTemperature(EnumTemperature.ICY);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(28, "Moon"));
    }),
    PYROTHEUM(GT_BranchDefinition.IC2, "Pyrotheum", false, new Color(16772036), new Color(14902272), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PYROTHEUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, ENERGY, 4);
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
    }),
    CRYOTHEUM(GT_BranchDefinition.IC2, "Cryotheum", false, new Color(2515199), new Color(5961727), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COOLANT), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CRYOTHEUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectSnowing);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, COOLANT, 4);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    REDALLOY(GT_BranchDefinition.GTALLOY, "RedAlloy", false, new Color(0xE60000), new Color(0xB80000), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(COPPER, REDSTONE, 10);
        tMutation.requireResource("blockRedAlloy");
    }),
    REDSTONEALLOY(GT_BranchDefinition.GTALLOY, "RedStoneAlloy", false, new Color(10815496), new Color(0xE80000), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDSTONEALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, REDALLOY, 8);
        tMutation.requireResource("blockRedstoneAlloy");
    }),
    CONDUCTIVEIRON(GT_BranchDefinition.GTALLOY, "ConductiveIron", false, new Color(13544867), new Color(8484465), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CONDUCTIVEIRON), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONEALLOY, IRON, 8);
        tMutation.requireResource("blockConductiveIron");
    }),
    ENERGETICALLOY(GT_BranchDefinition.GTALLOY, "EnergeticAlloy", false, new Color(0xFF9933), new Color(16756060), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENERGETICALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONEALLOY, GT_BeeDefinition.getSpecies((byte)0, "Demonic"), 9);
        tMutation.requireResource("blockEnergeticAlloy");
    }),
    VIBRANTALLOY(GT_BranchDefinition.GTALLOY, "VibrantAlloy", false, new Color(8823085), new Color(12907182), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.VIBRANTALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ENERGETICALLOY, GT_BeeDefinition.getSpecies((byte)0, "Phantasmal"), 6);
        tMutation.requireResource("blockVibrantAlloy");
        tMutation.restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH);
    }),
    ELECTRICALSTEEL(GT_BranchDefinition.GTALLOY, "ElectricalSteel", false, new Color(0x787878), new Color(0xD8D8D8), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ELECTRICALSTEEL), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(STEEL, GT_BeeDefinition.getSpecies((byte)0, "Demonic"), 9);
        tMutation.requireResource("blockElectricalSteel");
    }),
    DARKSTEEL(GT_BranchDefinition.GTALLOY, "DarkSteel", false, new Color(0x252525), new Color(0x443B44), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DARKSTEEL), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ELECTRICALSTEEL, GT_BeeDefinition.getSpecies((byte)0, "Demonic"), 7);
        tMutation.requireResource("blockDarkSteel");
    }),
    PULSATINGIRON(GT_BranchDefinition.GTALLOY, "PulsatingIron", false, new Color(7197316), new Color(26112), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PULSATINGIRON), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDALLOY, GT_BeeDefinition.getSpecies((byte)0, "Ended"), 9);
        tMutation.requireResource("blockPulsatingIron");
    }),
    STAINLESSSTEEL(GT_BranchDefinition.GTALLOY, "StainlessSteel", false, new Color(0xC8C8DC), new Color(0x778899), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STEEL), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STAINLESSSTEEL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CHROME, STEEL, 9);
        tMutation.requireResource("blockStainlessSteel");
    }),
    ENDERIUM(GT_BranchDefinition.GTALLOY, "Enderium", false, new Color(5869703), new Color(3050327), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDERIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_Bees.speedBlinding);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GT_BeeDefinition.getEffect((byte)1, "teleport"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLATINUM, GT_BeeDefinition.getSpecies((byte)0, "Phantasmal"), 3);
        tMutation.requireResource("blockEnderium");
    }),
    THAUMIUMDUST(GT_BranchDefinition.THAUMIC, "ThaumiumDust", true, new Color(0x7A007A), new Color(0x5C005C), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.THAUMIUMDUST), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectExploration);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)3, "TCFire"), GT_BeeDefinition.getSpecies((byte)0, "Edenic"), 10);
        tMutation.requireResource("blockThaumium");
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(192, "Magical Forest"));
    }),
    THAUMIUMSHARD(GT_BranchDefinition.THAUMIC, "ThaumiumShard", true, new Color(0x9966FF), new Color(11372031), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.THAUMIUMDUST), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.THAUMIUMSHARD), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectGlacial);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, GT_BeeDefinition.getSpecies((byte)3, "TCWater"), 10);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(192, "Magical Forest"));
    }),
    AMBER(GT_BranchDefinition.THAUMIC, "Amber", true, new Color(0xEE7700), new Color(7818005), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.AMBER), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, STICKYRESIN, 10);
        tMutation.requireResource("blockAmber");
    }),
    QUICKSILVER(GT_BranchDefinition.THAUMIC, "Quicksilver", true, new Color(0x7A007A), new Color(0x5C005C), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.QUICKSILVER), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectMiasmic);
    }, dis -> dis.registerMutation(THAUMIUMDUST, SILVER, 10)),
    SALISMUNDUS(GT_BranchDefinition.THAUMIC, "SalisMundus", true, new Color(16231902), new Color(5842306), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectMiasmic);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, THAUMIUMSHARD, 8);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(192, "Magical Forest"));
    }),
    TAINTED(GT_BranchDefinition.THAUMIC, "Tainted", true, new Color(9456568), new Color(15204607), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.TAINTED), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "rock"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, THAUMIUMSHARD, 7);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(193, "Tainted Land"));
    }),
    MITHRIL(GT_BranchDefinition.THAUMIC, "Mithril", true, new Color(15787660), new Color(0xFFFFD2), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MITHRIL), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "rock"));
    }, new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(IO, PLATINUM, 7);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 10);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(36, "IO"));
        }
    }),
    ASTRALSILVER(GT_BranchDefinition.THAUMIC, "AstralSilver", true, new Color(0xAFEEEE), new Color(0xE6E6FF), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ASTRALSILVER), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "rock"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SILVER, IRON, 3);
        tMutation.requireResource(GregTech_API.sBlockMetal1, 6);
    }),
    THAUMINITE(GT_BranchDefinition.THAUMIC, "Thauminite", true, new Color(3026297), new Color(7700960), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("MagicBees", "comb", 1L, 19), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.THAUMINITE), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)3, "TCOrder"), THAUMIUMDUST, 8);
        if (Loader.isModLoaded((String)"thaumicbases")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"thaumicbases", (String)"thauminiteBlock"), 0);
        }
    }),
    SHADOWMETAL(GT_BranchDefinition.THAUMIC, "ShadowMetal", true, new Color(1049378), new Color(1049410), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("MagicBees", "comb", 1L, 20), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SHADOWMETAL), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)3, "TCChaos"), GT_BeeDefinition.getSpecies((byte)3, "TCVoid"), 6);
        if (Loader.isModLoaded((String)"TaintedMagic")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"TaintedMagic", (String)"BlockShadowmetal"), 0);
        }
    }),
    DIVIDED(GT_BranchDefinition.THAUMIC, "Unstable", true, new Color(0xF0F0F0), new Color(0xDCDCDC), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 61), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DIVIDED), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(DIAMOND, IRON, 3);
        if (Loader.isModLoaded((String)"ExtraUtilities")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"ExtraUtilities", (String)"decorativeBlock1"), 5);
        }
    }),
    SPARKELING(GT_BranchDefinition.THAUMIC, "NetherStar", true, new Color(0x7A007A), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("MagicBees", "miscResources", 1L, 3), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SPARKELING), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectAggressive);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)3, "Withering"), GT_BeeDefinition.getSpecies((byte)3, "Draconic"), 1);
        tMutation.requireResource(GregTech_API.sBlockGem3, 3);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(9, "END Biome"));
    }),
    URANIUM(GT_BranchDefinition.RADIOACTIVE, "Uranium", true, new Color(1683225), new Color(1482262), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.URANIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Avenging"), PLATINUM, 2);
        tMutation.requireResource(GregTech_API.sBlockMetal7, 14);
    }),
    PLUTONIUM(GT_BranchDefinition.RADIOACTIVE, "Plutonium", true, new Color(0x570000), new Color(0x240000), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LEAD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PLUTONIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANIUM, EMERALD, 2);
        tMutation.requireResource(GregTech_API.sBlockMetal5, 13);
    }),
    NAQUADAH(GT_BranchDefinition.RADIOACTIVE, "Naquadah", false, new Color(13056), new Color(9216), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAQUADAH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTONIUM, IRIDIUM, 1);
        tMutation.requireResource(GregTech_API.sBlockMetal4, 12);
    }),
    NAQUADRIA(GT_BranchDefinition.RADIOACTIVE, "Naquadria", false, new Color(0), new Color(9216), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAQUADAH), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAQUADRIA), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTONIUM, IRIDIUM, 8, 10.0f);
        tMutation.requireResource(GregTech_API.sBlockMetal4, 15);
    }),
    DOB(GT_BranchDefinition.RADIOACTIVE, "DOB", false, new Color(13056), new Color(9216), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.DOB), Float.valueOf(0.75f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NAQUADAH, THAUMIUMSHARD, 1);
        if (Loader.isModLoaded((String)"AdvancedSolarPanel")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"AdvancedSolarPanel", (String)"BlockAdvSolarPanel"), 2);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(9, "END Biome"));
    }),
    THORIUM(GT_BranchDefinition.RADIOACTIVE, "Thorium", false, new Color(20480), new Color(7680), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.THORIUM), Float.valueOf(0.75f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(COAL, URANIUM, 2).setIsSecret();
        tMutation.requireResource(GregTech_API.sBlockMetal7, 5);
    }),
    LUTETIUM(GT_BranchDefinition.RADIOACTIVE, "Lutetium", false, new Color(0xE6FFE6), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LUTETIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(THORIUM, GT_BeeDefinition.getSpecies((byte)1, "rotten"), 1).setIsSecret();
        tMutation.requireResource(GregTech_API.sBlockMetal4, 3);
    }),
    AMERICIUM(GT_BranchDefinition.RADIOACTIVE, "Americium", false, new Color(0xE6E6FF), new Color(0xC8C8C8), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.AMERICUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(LUTETIUM, CHROME, 3, 4.0f).setIsSecret();
        tMutation.requireResource(GregTech_API.sBlockMetal1, 2);
    }),
    NEUTRONIUM(GT_BranchDefinition.RADIOACTIVE, "Neutronium", false, new Color(0xFFF0F0), new Color(0xFAFAFA), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEUTRONIUM), Float.valueOf(1.0E-4f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(NAQUADRIA, AMERICIUM, 1, 2.0f).setIsSecret();
        tMutation.requireResource(GregTech_API.sBlockMetal5, 2);
    }),
    NAGA(GT_BranchDefinition.TWILIGHT, "Naga", true, new Color(875021), new Color(2656075), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.02f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAGA), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)3, "Eldritch"), GT_BeeDefinition.getSpecies((byte)0, "Imperial"), 8);
        tMutation.restrictHumidity(EnumHumidity.DAMP);
    }),
    LICH(GT_BranchDefinition.TWILIGHT, "Lich", true, new Color(0xC5C5C5), new Color(6053982), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.04f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LICH), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)3, "Supernatural"), NAGA, 7);
        tMutation.restrictHumidity(EnumHumidity.ARID);
    }),
    HYDRA(GT_BranchDefinition.TWILIGHT, "Hydra", true, new Color(8857654), new Color(12063532), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.06f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.HYDRA), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LICH, GT_BeeDefinition.getSpecies((byte)3, "TCFire"), 6);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(138, "Undergarden"));
    }),
    URGHAST(GT_BranchDefinition.TWILIGHT, "UrGhast", true, new Color(10945564), new Color(8128024), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.08f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.URGHAST), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(HYDRA, THAUMIUMDUST, 5);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"Thaumcraft", (String)"blockCosmeticSolid"), 4);
        }
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
    }),
    SNOWQUEEN(GT_BranchDefinition.TWILIGHT, "SnowQueen", true, new Color(13639681), new Color(10223640), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SNOWQUEEN), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
        beeSpecies.setNocturnal();
    }, template -> {}, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URGHAST, SALISMUNDUS, 4);
        if (Loader.isModLoaded((String)"thaumicbases")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"thaumicbases", (String)"blockSalisMundus"), 0);
        }
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    ENDDUST(GT_BranchDefinition.HEE, "End Dust", true, new Color(13369594), new Color(14973), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDDUST), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Ended"), STAINLESSSTEEL, 8);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"end_powder_ore"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    ENDIUM(GT_BranchDefinition.HEE, "Endium", true, new Color(0xA0FFFF), new Color(3103340), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDIUM), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_Bees.propolis.getStackForType(PropolisType.Endium), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GT_Bees.drop.getStackForType(DropType.ENDERGOO), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Ended"), THAUMIUMDUST, 8);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource("blockHeeEndium");
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    STARDUST(GT_BranchDefinition.HEE, "Star Dust", true, new Color(0xFFFF00), new Color(14466579), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STARDUST), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_Bees.speedBlinding);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Ended"), ZINC, 8);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"stardust_ore"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    ECTOPLASMA(GT_BranchDefinition.HEE, "Ectoplasma", true, new Color(14463205), new Color(3677248), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ECTOPLASMA), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Ended"), ENDDUST, 5);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"spooky_log"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    ARCANESHARDS(GT_BranchDefinition.HEE, "Arcane Shards", true, new Color(9441453), new Color(3358082), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ARCANESHARD), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMSHARD, ENDDUST, 5);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"laboratory_floor"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    DRAGONESSENCE(GT_BranchDefinition.HEE, "Dragonessence", true, new Color(16752939), new Color(9510606), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DRAGONESSENCE), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectBeatific);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ECTOPLASMA, ARCANESHARDS, 4);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"essence_altar"), 1);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    FIREESSENCE(GT_BranchDefinition.HEE, "Fireessence", true, new Color(13898296), new Color(16752983), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.FIREESSENSE), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.ELONGATED);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_3);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(FIRESTONE, ARCANESHARDS, 4);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"essence_altar"), 2);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    ENDERMANHEAD(GT_BranchDefinition.HEE, "Enderman", true, new Color(0x161616), new Color(6422759), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDERMAN), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GT_BeeDefinition.getEffect((byte)1, "teleport"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ENDERIUM, STARDUST, 4);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"ender_goo"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    SILVERFISH(GT_BranchDefinition.HEE, "Silverfisch", true, new Color(15598909), new Color(0), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SILVERFISH), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GT_BeeDefinition.getEffect((byte)3, "SlowSpeed"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ECTOPLASMA, STARDUST, 5);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"ender_goo"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    RUNE(GT_BranchDefinition.HEE, "Rune", true, new Color(14880784), new Color(66777), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.RUNEI), Float.valueOf(0.0025f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.RUNEII), Float.valueOf(0.00125f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAllele)GT_Bees.superLife);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GT_BeeDefinition.getEffect((byte)3, "SlowSpeed"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(DRAGONESSENCE, STARDUST, 2).setIsSecret();
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Loader.isModLoaded((String)"EnderStorage")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"EnderStorage", (String)"enderChest"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    SPACE(GT_BranchDefinition.SPACE, "Space", true, new Color(13158), new Color(0xC0C0C0), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> {}, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GT_BeeDefinition.getSpecies((byte)0, "Industrious"), GT_BeeDefinition.getSpecies((byte)0, "Heroic"), 10);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    METEORICIRON(GT_BranchDefinition.SPACE, "MeteoricIron", true, new Color(3283240), new Color(6566480), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.04f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.METEORICIRON), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> {}, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SPACE, IRON, 9);
        tMutation.requireResource(GregTech_API.sBlockMetal4, 7);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(28, "Moon"));
    }),
    DESH(GT_BranchDefinition.SPACE, "Desh", false, new Color(0x323232), new Color(0x282828), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.06f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DESH), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition), new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(MARS, TITANIUM, 9);
            tMutation.requireResource(GregTech_API.sBlockMetal2, 12);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(29, "Mars"));
        }
    }),
    LEDOX(GT_BranchDefinition.SPACE, "Ledox", false, new Color(205), new Color(29951), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LEDOX), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GT_BeeDefinition.getEffect((byte)1, "freezing")), new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(CALLISTO, LEAD, 7);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Ledox"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(35, "Europa"));
        }
    }),
    CALLISTOICE(GT_BranchDefinition.SPACE, "CallistoIce", false, new Color(29951), new Color(2011647), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CALLISTOICE), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GT_BeeDefinition.getEffect((byte)1, "freezing")), new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(CALLISTO, GT_BeeDefinition.getSpecies((byte)1, "freezing"), 7);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.CallistoColdIce"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(45, "Callisto"));
        }
    }),
    MYTRYL(GT_BranchDefinition.SPACE, "Mytryl", false, new Color(14329120), new Color(15885316), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.16f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MYTRYL), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(IO, MITHRIL, 6);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Mytryl"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(36, "IO"));
        }
    }),
    QUANTIUM(GT_BranchDefinition.SPACE, "Quantium", false, new Color(65280), new Color(53515), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.16f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.QUANTIUM), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(VENUS, OSMIUM, 6);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Quantinum"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(39, "Venus"));
        }
    }),
    ORIHARUKON(GT_BranchDefinition.SPACE, "Oriharukon", false, new Color(0x228B22), new Color(6782312), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.26f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ORIHARUKON), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(LEAD, OBERON, 5);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"metalsblock"), 6);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(46, "Oberon"));
        }
    }),
    MYSTERIOUSCRYSTAL(GT_BranchDefinition.SPACE, "MysteriousCrystal", false, new Color(3978097), new Color(1475948), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.42f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MYSTERIOUSCRYSTAL), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(ENCELADUS, EMERALD, 3);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.MysteriousCrystal"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(41, "Enceladus"));
        }
    }),
    BLACKPLUTONIUM(GT_BranchDefinition.SPACE, "BlackPlutonium", false, new Color(0), new Color(0x323232), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.68f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.BLACKPLUTONIUM), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(PLUTO, PLUTONIUM, 2);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.BlackPlutonium"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(49, "Pluto"));
        }
    }),
    TRINIUM(GT_BranchDefinition.SPACE, "Trinium", false, new Color(11591910), new Color(13158610), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TRINIUM), Float.valueOf(0.75f));
        beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.QUANTIUM), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_Bees.speedBlinding), new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(ENCELADUS, IRIDIUM, 4);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 9);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(41, "Enceladus"));
        }
    }),
    MOON(GT_BranchDefinition.PLANET, "Moon", false, new Color(0x373735), new Color(0x7E7E78), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MOON), Float.valueOf(0.5f));
        if (Loader.isModLoaded((String)"dreamcraft")) {
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MoonStoneDust", 1L, 0), Float.valueOf(0.1f));
        }
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SPACE, CLAY, 25);
        if (Loader.isModLoaded((String)"GalacticraftCore")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalacticraftCore", (String)"tile.moonBlock"), 4);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(28, "Moon"));
    }),
    MARS(GT_BranchDefinition.PLANET, "Mars", false, new Color(2231557), new Color(3806469), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MARS), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MarsStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MOON, IRON, 20);
        if (Loader.isModLoaded((String)"GalacticraftMars")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalacticraftMars", (String)"tile.mars"), 5);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(29, "Mars"));
    }),
    PHOBOS(GT_BranchDefinition.PLANET, "Phobos", true, new Color(2231557), new Color(8017670), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MARS), Float.valueOf(0.25f));
        if (Loader.isModLoaded((String)"dreamcraft")) {
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.PhobosStoneDust", 1L, 0), Float.valueOf(0.1f));
        }
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, MOON, 20);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"phobosblocks"), 2);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(38, "Phobos"));
    }),
    DEIMOS(GT_BranchDefinition.PLANET, "Deimos", true, new Color(2231557), new Color(8008198), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MARS), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.DeimosStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, SPACE, 20);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"deimosblocks"), 1);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(40, "Deimos"));
    }),
    CERES(GT_BranchDefinition.PLANET, "Ceres", true, new Color(3974583), new Color(1995367), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CeresStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, METEORICIRON, 20);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"ceresblocks"), 1);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(42, "Ceres"));
    }),
    JUPITER(GT_BranchDefinition.PLANET, "Jupiter", false, new Color(7555886), new Color(13683652), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoIceDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.IoStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaIceDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.GanymedeStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, DESH, 15);
        if (Loader.isModLoaded((String)"dreamcraft")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Ledox"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteriods"));
    }),
    IO(GT_BranchDefinition.PLANET, "IO", true, new Color(7555886), new Color(15036443), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.IoStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, GT_BeeDefinition.getSpecies((byte)1, "volcanic"), 15);
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"ioblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(36, "IO"));
    }),
    EUROPA(GT_BranchDefinition.PLANET, "Europa", true, new Color(5866218), new Color(734883), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaIceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, IRON, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"europagrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(35, "Europa"));
    }),
    GANYMEDE(GT_BranchDefinition.PLANET, "Ganymede", true, new Color(4004624), new Color(1641479), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.GanymedeStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, TITANIUM, 15);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"ganymedeblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(43, "Ganymede"));
    }),
    CALLISTO(GT_BranchDefinition.PLANET, "Callisto", true, new Color(996157), new Color(885925), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoIceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, GT_BeeDefinition.getSpecies((byte)1, "artic"), 15);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"callistoblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(45, "Callisto"));
    }),
    SATURN(GT_BranchDefinition.PLANET, "Saturn", false, new Color(13804658), new Color(16302971), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TitanStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusIceDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, LEDOX, 25, 2.0f);
        if (Loader.isModLoaded((String)"dreamcraft")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Quantinum"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteriods"));
    }),
    ENCELADUS(GT_BranchDefinition.PLANET, "Enceladus", true, new Color(13804658), new Color(1654688), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusIceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SATURN, CHROME, 25, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"enceladusblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(41, "Enceladus"));
    }),
    TITAN(GT_BranchDefinition.PLANET, "Titan", true, new Color(10511387), new Color(8130596), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TitanStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SATURN, NICKEL, 25, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"titanblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(44, "Titan"));
    }),
    URANUS(GT_BranchDefinition.PLANET, "Uranus", false, new Color(7717065), new Color(8706284), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MirandaStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.OberonStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SATURN, TRINIUM, 10);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"metalsblock"), 6);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteroids"));
    }),
    MIRANDA(GT_BranchDefinition.PLANET, "Miranda", true, new Color(7717065), new Color(860444), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MirandaStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANUS, TIN, 10);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"mirandablocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(86, "Miranda"));
    }),
    OBERON(GT_BranchDefinition.PLANET, "Oberon", true, new Color(4866099), new Color(11903624), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.OberonStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANUS, IRIDIUM, 10);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"oberonblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(46, "Oberon"));
    }),
    NEPTUNE(GT_BranchDefinition.PLANET, "Neptune", false, new Color(3362047), new Color(5729791), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEPTUN), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.ProteusStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TritonStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANUS, ORIHARUKON, 7);
        if (Loader.isModLoaded((String)"dreamcraft")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.MysteriousCrystal"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteroids"));
    }),
    PROTEUS(GT_BranchDefinition.PLANET, "Proteus", true, new Color(3362047), new Color(5842448), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEPTUN), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.ProteusStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEPTUNE, COPPER, 7);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"proteusblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(47, "Proteus"));
    }),
    TRITON(GT_BranchDefinition.PLANET, "Triton", true, new Color(3362047), new Color(4329752), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEPTUN), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TritonStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEPTUNE, GOLD, 7);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"tritonblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(48, "Triton"));
    }),
    PLUTO(GT_BranchDefinition.PLANET, "Pluto", false, new Color(3417886), new Color(6901821), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLUTO), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.PlutoStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.PlutoIceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEPTUNE, PLUTONIUM, 5);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"plutoblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(49, "Pluto"));
    }),
    HAUMEA(GT_BranchDefinition.PLANET, "Haumea", false, new Color(1840147), new Color(3746600), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.HAUMEA), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.HaumeaStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTO, NAQUADAH, 7, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"haumeablocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(83, "Haumea"));
    }),
    MAKEMAKE(GT_BranchDefinition.PLANET, "MakeMake", false, new Color(3151889), new Color(1182215), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MAKEMAKE), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MakeMakeStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTO, NAQUADRIA, 7, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"makemakegrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(25, "MakeMake"));
    }),
    CENTAURI(GT_BranchDefinition.PLANET, "Centauri", false, new Color(3090964), new Color(11561778), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CENTAURI), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CentauriASurfaceDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, DESH, 3);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"acentauribbgrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
    }),
    ACENTAURI(GT_BranchDefinition.PLANET, "aCentauri", false, new Color(3090964), new Color(10493460), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CENTAURI), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CentauriASurfaceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), new Consumer<GT_BeeDefinition>(){

        @Override
        public void accept(GT_BeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(CENTAURI, INFINITYCATALYST, 3);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"acentauribbgrunt"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(31, "aCentauri"));
        }
    }),
    TCETI(GT_BranchDefinition.PLANET, "tCeti", false, new Color(4596762), new Color(8077615), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TCETI), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TCetiEStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, HAUMEA, 5, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"tcetieblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
    }),
    TCETIE(GT_BranchDefinition.PLANET, "tCetiE", false, new Color(2971163), new Color(790368), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TCETI), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TCetiEStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TCETI, GT_BeeDefinition.getSpecies((byte)3, "TCWater"), 5, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"tcetieblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(85, "tCeti E"));
    }),
    BARNARDA(GT_BranchDefinition.PLANET, "Barnarda", false, new Color(875021), new Color(15122829), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaEStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaFStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, THORIUM, 3, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaEgrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
    }),
    BARNARDAC(GT_BranchDefinition.PLANET, "BarnardaC", false, new Color(875021), new Color(4669194), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(BARNARDA, AMERICIUM, 3, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaEgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(32, "Barnarda C"));
        }
    }),
    BARNARDAE(GT_BranchDefinition.PLANET, "BarnardaE", false, new Color(875021), new Color(4988682), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaEStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(BARNARDA, DIVIDED, 3, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaEgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(81, "Barnard E"));
        }
    }),
    BARNARDAF(GT_BranchDefinition.PLANET, "BarnardaF", false, new Color(875021), new Color(1968969), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaFStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(BARNARDA, NEUTRONIUM, 3, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaFgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(82, "Barnard F"));
        }
    }),
    VEGA(GT_BranchDefinition.PLANET, "Vega", false, new Color(1712182), new Color(11911390), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.VEGA), Float.valueOf(0.5f));
        beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.VegaBStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, NAQUADAH, 2);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"vegabgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
        }
    }),
    VEGAB(GT_BranchDefinition.PLANET, "VegaB", false, new Color(1712182), new Color(8512097), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.VEGA), Float.valueOf(0.5f));
        if (Loader.isModLoaded((String)"dreamcraft")) {
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.VegaBStoneDust", 1L, 0), Float.valueOf(0.1f));
        }
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(VEGA, NAQUADRIA, 2);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"vegabgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(84, "VegaB"));
        }
    }),
    MERCURY(GT_BranchDefinition.PLANET, "Mercury", false, new Color(4866099), new Color(11903624), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MERCURY), Float.valueOf(0.5f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, TUNGSTEN, 25, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"mercuryblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(37, "Mercury"));
    }),
    VENUS(GT_BranchDefinition.PLANET, "Venus", false, new Color(4866099), new Color(11903624), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.VENUS), Float.valueOf(0.5f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, MITHRIL, 25, 2.0f);
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"venusblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(39, "Venus"));
    }),
    COSMICNEUTRONIUM(GT_BranchDefinition.PLANET, "CosmicNeutronium", false, new Color(0x484848), new Color(0x323232), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COSMICNEUTRONIUM), Float.valueOf(0.25f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEUTRONIUM, BARNARDAF, 7, 10.0f);
        if (Loader.isModLoaded((String)"Avaritia")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"Avaritia", (String)"Resource_Block"), 0);
        }
    }),
    INFINITYCATALYST(GT_BranchDefinition.PLANET, "InfinityCatalyst", false, new Color(0xFFFFFF), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.INFINITYCATALYST), Float.valueOf(5.0E-7f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GT_BeeDefinition.getEffect((byte)1, "blindness"));
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(DOB, COSMICNEUTRONIUM, 3, 10.0f).setIsSecret();
        if (Loader.isModLoaded((String)"Avaritia")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"Avaritia", (String)"Resource_Block"), 1);
        }
    }),
    INFINITY(GT_BranchDefinition.PLANET, "Infinity", false, new Color(0xFFFFFF), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.INFINITY), Float.valueOf(5.0E-8f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(INFINITYCATALYST, COSMICNEUTRONIUM, 1, 100.0f);
        if (Loader.isModLoaded((String)"avaritiaddons")) {
            tMutation.requireResource(GameRegistry.findBlock((String)"avaritiaddons", (String)"InfinityChest"), 0);
        }
    });

    private final GT_BranchDefinition branch;
    private final GT_AlleleBeeSpecies species;
    private final Consumer<GT_AlleleBeeSpecies> mSpeciesProperties;
    private final Consumer<IAllele[]> mAlleles;
    private final Consumer<GT_BeeDefinition> mMutations;
    private IAllele[] template;
    private IBeeGenome genome;

    private GT_BeeDefinition(GT_BranchDefinition branch, String binomial, boolean dominant, Color primary, Color secondary, Consumer<GT_AlleleBeeSpecies> aSpeciesProperties, Consumer<IAllele[]> aAlleles, Consumer<GT_BeeDefinition> aMutations) {
        this.mAlleles = aAlleles;
        this.mMutations = aMutations;
        this.mSpeciesProperties = aSpeciesProperties;
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = WordUtils.capitalize((String)lowercaseName);
        String uid = "gregtech.bee.species" + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        GT_LanguageManager.addStringLocalization("for.bees.species." + lowercaseName, species, true);
        this.branch = branch;
        this.species = new GT_AlleleBeeSpecies(uid, dominant, name, "GTNH", description, branch.getBranch(), binomial, primary, secondary);
    }

    public static void initBees() {
        for (GT_BeeDefinition bee : GT_BeeDefinition.values()) {
            bee.init();
        }
        for (GT_BeeDefinition bee : GT_BeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    protected static IAlleleBeeEffect getEffect(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.effect." + name;
                break;
            }
            case 2: {
                s = "gendustry.effect." + name;
                break;
            }
            case 3: {
                s = "magicbees.effect" + name;
                break;
            }
            case 4: {
                s = "gregtech.effect" + name;
                break;
            }
            default: {
                s = "forestry.effect" + name;
            }
        }
        return (IAlleleBeeEffect)AlleleManager.alleleRegistry.getAllele(s);
    }

    protected static IAlleleFlowers getFlowers(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.flower." + name;
                break;
            }
            case 2: {
                s = "gendustry.flower." + name;
                break;
            }
            case 3: {
                s = "magicbees.flower" + name;
                break;
            }
            case 4: {
                s = "gregtech.flower" + name;
                break;
            }
            default: {
                s = "forestry.flowers" + name;
            }
        }
        return (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(s);
    }

    protected static IAlleleBeeSpecies getSpecies(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.species." + name;
                break;
            }
            case 2: {
                s = "gendustry.bee." + name;
                break;
            }
            case 3: {
                s = "magicbees.species" + name;
                break;
            }
            case 4: {
                s = "gregtech.species" + name;
                break;
            }
            default: {
                s = "forestry.species" + name;
            }
        }
        Object ret = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(s);
        if (ret == null) {
            ret = GT_BeeDefinition.NAQUADRIA.species;
        }
        return ret;
    }

    protected final void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
        this.mSpeciesProperties.accept(beeSpecies);
    }

    protected final void setAlleles(IAllele[] template) {
        this.mAlleles.accept(template);
    }

    protected final void registerMutations() {
        this.mMutations.accept(this);
    }

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(GT_BeeDefinition parent1, IAlleleBeeSpecies parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, GT_BeeDefinition parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(GT_BeeDefinition parent1, GT_BeeDefinition parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance, float chancedivider) {
        return new GT_Bee_Mutation(parent1, parent2, this.getTemplate(), chance, chancedivider);
    }

    protected final IBeeMutationCustom registerMutation(GT_BeeDefinition parent1, IAlleleBeeSpecies parent2, int chance, float chancedivider) {
        return this.registerMutation((IAlleleBeeSpecies)parent1.species, parent2, chance, chancedivider);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, GT_BeeDefinition parent2, int chance, float chancedivider) {
        return this.registerMutation(parent1, (IAlleleBeeSpecies)parent2.species, chance, chancedivider);
    }

    protected final IBeeMutationCustom registerMutation(GT_BeeDefinition parent1, GT_BeeDefinition parent2, int chance, float chancedivider) {
        return this.registerMutation((IAlleleBeeSpecies)parent1.species, parent2, chance, chancedivider);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        return BeeManager.beeRoot.getMemberStack((IIndividual)this.getIndividual(), beeType.ordinal());
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }
}

