/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public abstract class GT_MetaTileEntity_LargeBoiler
extends GT_MetaTileEntity_MultiBlockBase {
    private boolean firstRun = true;
    private int mSuperEfficencyIncrease = 0;
    private int integratedCircuitConfig = 0;
    private int excessFuel = 0;
    private int excessProjectedEU = 0;

    public GT_MetaTileEntity_LargeBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeBoiler(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Boiler").addInfo("Controller block for the Large " + this.getCasingMaterial() + " Boiler").addInfo("Produces " + (float)(this.getEUt() * 40) * ((float)this.runtimeBoost(20) / 20.0f) + "L of Steam with 1 Coal at " + this.getEUt() * 40 + "L/s").addInfo("A programmed circuit in the main block throttles the boiler (-1000L/s per config)").addInfo(String.format("Diesel fuels have 1/4 efficiency - Takes %.2f seconds to heat up", 500.0 / (double)this.getEfficiencyIncrease())).addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(3, 5, 3, false).addController("Front bottom").addCasingInfo(this.getCasingMaterial() + " " + this.getCasingBlockType() + " Casing", 24).addOtherStructurePart(this.getCasingMaterial() + " Fire Boxes", "Bottom layer, 3 minimum").addOtherStructurePart(this.getCasingMaterial() + " Pipe Casing Blocks", "Inner 3 blocks").addMaintenanceHatch("Any firebox").addMufflerHatch("Any firebox").addInputBus("Solid fuel, Any firebox").addInputHatch("Liquid fuel, Any firebox").addStructureInfo("You can use either, or both").addInputHatch("Water, Any firebox").addOutputHatch("Steam, any casing").toolTipFinisher("Gregtech");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    public abstract String getCasingMaterial();

    public abstract Block getCasingBlock();

    public abstract String getCasingBlockType();

    public abstract byte getCasingMeta();

    public abstract byte getCasingTextureIndex();

    public abstract Block getPipeBlock();

    public abstract byte getPipeMeta();

    public abstract Block getFireboxBlock();

    public abstract byte getFireboxMeta();

    public abstract byte getFireboxTextureIndex();

    public abstract int getEUt();

    public abstract int getEfficiencyIncrease();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex()), new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex())};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeBoiler.png");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        FluidStack tFluid;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit")) {
            int circuit_config = this.mInventory[1].func_77960_j();
            if (circuit_config >= 1 && circuit_config <= 25) {
                this.integratedCircuitConfig = circuit_config;
            }
        } else {
            this.integratedCircuitConfig = 0;
        }
        this.mSuperEfficencyIncrease = 0;
        for (GT_Recipe tRecipe : GT_Recipe.GT_Recipe_Map.sDieselFuels.mRecipeList) {
            tFluid = GT_Utility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
            if (tFluid == null || tRecipe.mSpecialValue <= 1) continue;
            tFluid.amount = 1000;
            if (!this.depleteInput(tFluid)) continue;
            this.mMaxProgresstime = this.adjustBurnTimeForConfig(this.runtimeBoost(tRecipe.mSpecialValue / 2));
            this.mEUt = this.adjustEUtForConfig(this.getEUt());
            this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease() * 4;
            return true;
        }
        for (GT_Recipe tRecipe : GT_Recipe.GT_Recipe_Map.sDenseLiquidFuels.mRecipeList) {
            tFluid = GT_Utility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
            if (tFluid == null) continue;
            tFluid.amount = 1000;
            if (!this.depleteInput(tFluid)) continue;
            this.mMaxProgresstime = this.adjustBurnTimeForConfig(Math.max(1, this.runtimeBoost(tRecipe.mSpecialValue * 2)));
            this.mEUt = this.adjustEUtForConfig(this.getEUt());
            this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
            return true;
        }
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (!tInputList.isEmpty()) {
            for (ItemStack tInput : tInputList) {
                if (tInput == GT_OreDictUnificator.get(OrePrefixes.bucket, Materials.Lava, 1L) || GT_Utility.getFluidForFilledItem(tInput, true) != null || (this.mMaxProgresstime = GT_ModHandler.getFuelValue(tInput) / 80) <= 0) continue;
                this.excessFuel += GT_ModHandler.getFuelValue(tInput) % 80;
                this.mMaxProgresstime += this.excessFuel / 80;
                this.excessFuel %= 80;
                this.mMaxProgresstime = this.adjustBurnTimeForConfig(this.runtimeBoost(this.mMaxProgresstime));
                this.mEUt = this.adjustEUtForConfig(this.getEUt());
                this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
                this.mOutputItems = new ItemStack[]{GT_Utility.getContainerItem(tInput, true)};
                --tInput.field_77994_a;
                this.updateSlots();
                if (this.mEfficiencyIncrease > 5000) {
                    this.mEfficiencyIncrease = 0;
                    this.mSuperEfficencyIncrease = 20;
                }
                return true;
            }
        }
        this.mMaxProgresstime = 0;
        this.mEUt = 0;
        return false;
    }

    abstract int runtimeBoost(int var1);

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            int tGeneratedEU;
            if (this.mSuperEfficencyIncrease > 0) {
                this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mSuperEfficencyIncrease, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
            }
            if ((tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L)) > 0) {
                long amount = (tGeneratedEU + 160) / 160;
                if (this.depleteInput(Materials.Water.getFluid(amount)) || this.depleteInput(GT_ModHandler.getDistilledWater(amount))) {
                    this.addOutput(GT_ModHandler.getSteam(tGeneratedEU));
                } else {
                    GT_Log.exp.println("Boiler " + this.mName + " had no Water!");
                    this.explodeMultiblock();
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProgresstime > 0 && this.firstRun) {
            this.firstRun = false;
            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "extremepressure");
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int j;
        int i;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tCasingAmount = 0;
        int tFireboxAmount = 0;
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                int k;
                if (i != 0 || j != 0) {
                    for (k = 1; k <= 4; ++k) {
                        if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, k, zDir + j), this.getCasingTextureIndex())) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j) != this.getCasingBlock()) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, k, zDir + j) != this.getCasingMeta()) {
                            return false;
                        }
                        ++tCasingAmount;
                    }
                    continue;
                }
                for (k = 1; k <= 3; ++k) {
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j) != this.getPipeBlock()) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, k, zDir + j) == this.getPipeMeta()) continue;
                    return false;
                }
                if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 4, zDir + j), this.getCasingTextureIndex())) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 4, zDir + j) != this.getCasingBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 4, zDir + j) != this.getCasingMeta()) {
                    return false;
                }
                ++tCasingAmount;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), this.getFireboxTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getFireboxTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getFireboxTextureIndex())) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != this.getFireboxBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) != this.getFireboxMeta()) {
                    return false;
                }
                ++tFireboxAmount;
            }
        }
        return tCasingAmount >= 24 && tFireboxAmount >= 3;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        int adjustedEUOutput = Math.max(25, this.getEUt() - 25 * this.integratedCircuitConfig);
        return Math.max(1, 12 * adjustedEUOutput / this.getEUt());
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private int adjustEUtForConfig(int rawEUt) {
        int adjustedSteamOutput = rawEUt - 25 * this.integratedCircuitConfig;
        return Math.max(adjustedSteamOutput, 25);
    }

    private int adjustBurnTimeForConfig(int rawBurnTime) {
        if (this.mEfficiency < this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000) {
            return rawBurnTime;
        }
        int adjustedEUt = Math.max(25, this.getEUt() - 25 * this.integratedCircuitConfig);
        int adjustedBurnTime = rawBurnTime * this.getEUt() / adjustedEUt;
        this.excessProjectedEU += this.getEUt() * rawBurnTime - adjustedEUt * adjustedBurnTime;
        this.excessProjectedEU %= adjustedEUt;
        return adjustedBurnTime += this.excessProjectedEU / adjustedEUt;
    }
}

