/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class GT_MetaTileEntity_ElectricBlastFurnace
extends GT_MetaTileEntity_MultiBlockBase {
    private int mHeatingCapacity = 0;
    private int controllerY;
    private FluidStack[] pollutionFluidStacks = new FluidStack[]{Materials.CarbonDioxide.getGas(1000L), Materials.CarbonMonoxide.getGas(1000L), Materials.SulfurDioxide.getGas(1000L)};

    public GT_MetaTileEntity_ElectricBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ElectricBlastFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ElectricBlastFurnace(this.mName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Blast Furnace").addInfo("Controller block for the Electric Blast Furnace").addInfo("You can use some fluids to reduce recipe time. Place the circuit in the Input Bus").addInfo("Each 900K over the min. Heat required multiplies EU/t by 0.95").addInfo("Each 1800K over the min. Heat required allows for one upgraded overclock instead of normal").addInfo("Upgraded overclocks reduce recipe time to 25% (instead of 50%) and increase EU/t to 400%").addInfo("Additionally gives +100K for every tier past MV").addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(3, 4, 3, true).addController("Front bottom").addCasingInfo("Heat Proof Machine Casing", 0).addOtherStructurePart("Heating Coils (any tier)", "Two middle Layers").addEnergyHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").addMufflerHatch("Top middle").addInputBus("Any bottom layer casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("Gasses, Any top layer casing").addStructureInfo("Recovery amount scales with Muffler Hatch tier").addOutputHatch("Platline fluids, Any bottom layer casing").toolTipFinisher("Gregtech");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "ElectricBlastFurnace.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sBlastRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[tInputList.size()]);
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block2: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block2;
            }
        }
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[tFluidList.size()]);
        if (tInputList.size() > 0) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe != null && this.mHeatingCapacity >= tRecipe.mSpecialValue && tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                int tHeatCapacityDivTiers = (this.mHeatingCapacity - tRecipe.mSpecialValue) / 900;
                byte overclockCount = this.calculateOverclockednessEBF(tRecipe.mEUt, tRecipe.mDuration, tVoltage);
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                if (tHeatCapacityDivTiers > 0) {
                    this.mEUt = (int)((double)this.mEUt * Math.pow(0.95, tHeatCapacityDivTiers));
                    this.mMaxProgresstime >>= Math.min(tHeatCapacityDivTiers / 2, overclockCount);
                    if (this.mMaxProgresstime < 1) {
                        this.mMaxProgresstime = 1;
                    }
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
                this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    protected byte calculateOverclockednessEBF(int aEUt, int aDuration, long maxInputVoltage) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier(maxInputVoltage));
        byte timesOverclocked = 0;
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = xEUt < GT_Values.V[1] ? GT_Values.V[1] : xEUt;
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= GT_Values.V[mTier - 1]) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= 1;
                xEUt = this.mMaxProgresstime == 0 ? xEUt >> 1 : xEUt << 2;
                timesOverclocked = (byte)(timesOverclocked + 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = (int)xEUt;
                if (this.mEUt == 0) {
                    this.mEUt = 1;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
        return timesOverclocked;
    }

    private boolean checkMachineFunction(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int j;
        int i;
        this.controllerY = aBaseMetaTileEntity.getYCoord();
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        this.mHeatingCapacity = 0;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 1, zDir)) {
            return false;
        }
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 2, zDir)) {
            return false;
        }
        if (!this.addMufflerToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, 3, zDir), 11)) {
            return false;
        }
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        byte tUsedMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + 1, 2, zDir);
        switch (tUsedMeta) {
            case 0: {
                this.mHeatingCapacity = 1801;
                break;
            }
            case 1: {
                this.mHeatingCapacity = 2701;
                break;
            }
            case 2: {
                this.mHeatingCapacity = 3601;
                break;
            }
            case 3: {
                this.mHeatingCapacity = 4501;
                break;
            }
            case 4: {
                this.mHeatingCapacity = 5401;
                break;
            }
            case 5: {
                this.mHeatingCapacity = 7201;
                break;
            }
            case 6: {
                this.mHeatingCapacity = 9001;
                break;
            }
            case 7: {
                this.mHeatingCapacity = 9901;
                break;
            }
            case 8: {
                this.mHeatingCapacity = 10801;
                break;
            }
            default: {
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 2, zDir + j) != GregTech_API.sBlockCasings5) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 2, zDir + j) != tUsedMeta) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 1, zDir + j) != GregTech_API.sBlockCasings5) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 1, zDir + j) != tUsedMeta) {
                    return false;
                }
                if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 3, zDir + j), 11)) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 3, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 3, zDir + j) == 11) continue;
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), 11) || this.addInputToMachineList(tTileEntity, 11) || this.addOutputToMachineList(tTileEntity, 11) || this.addEnergyInputToMachineList(tTileEntity, 11)) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) == 11) continue;
                return false;
            }
        }
        this.mHeatingCapacity += 100 * (GT_Utility.getTier(this.getMaxInputVoltage()) - 2);
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean result = this.checkMachineFunction(aBaseMetaTileEntity, aStack);
        if (!result) {
            this.mHeatingCapacity = 0;
        }
        return result;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                if (xPos == tX && zPos == tZ) continue;
                for (int yPos = tY + 1; yPos <= tY + 2; ++yPos) {
                    byte tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, yPos, zPos);
                    if (tUsedMeta < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, yPos, zPos) != GregTech_API.sBlockCasings1) continue;
                    aBaseMetaTileEntity.getWorld().func_147465_d(xPos, yPos, zPos, GregTech_API.sBlockCasings5, tUsedMeta - 12, 3);
                }
            }
        }
    }

    @Override
    public boolean addOutput(FluidStack aLiquid) {
        int targetHeight;
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        boolean isOutputPollution = false;
        for (FluidStack pollutionFluidStack : this.pollutionFluidStacks) {
            if (!tLiquid.isFluidEqual(pollutionFluidStack)) continue;
            isOutputPollution = true;
            break;
        }
        if (isOutputPollution) {
            targetHeight = this.controllerY + 3;
            int pollutionReduction = 0;
            for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
                if (!GT_MetaTileEntity_ElectricBlastFurnace.isValidMetaTileEntity(tHatch)) continue;
                pollutionReduction = 100 - tHatch.calculatePollutionReduction(100);
                break;
            }
            tLiquid.amount = tLiquid.amount * (pollutionReduction + 5) / 100;
        } else {
            targetHeight = this.controllerY;
        }
        for (GT_MetaTileEntity_Hatch_Output tHatch : this.mOutputHatches) {
            if (!(GT_MetaTileEntity_ElectricBlastFurnace.isValidMetaTileEntity(tHatch) && GT_ModHandler.isSteam(aLiquid) ? tHatch.outputsSteam() : tHatch.outputsLiquids()) || tHatch.getBaseMetaTileEntity().getYCoord() != targetHeight) continue;
            int tAmount = tHatch.fill(tLiquid, false);
            if (tAmount >= tLiquid.amount) {
                return tHatch.fill(tLiquid, true) >= tLiquid.amount;
            }
            if (tAmount <= 0) continue;
            tLiquid.amount -= tHatch.fill(tLiquid, true);
        }
        return false;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_ElectricBlastFurnace.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_ElectricBlastFurnace.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + Integer.toString(-this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + Long.toString(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.EBF.heat") + ": " + EnumChatFormatting.GREEN + this.mHeatingCapacity + EnumChatFormatting.RESET + " K", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }
}

