/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class GT_MetaTileEntity_DistillationTower
extends GT_MetaTileEntity_MultiBlockBase {
    private static final int CASING_INDEX = 49;
    private short controllerY;

    public GT_MetaTileEntity_DistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_DistillationTower(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DistillationTower(this.mName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Distillery").addInfo("Controller block for the Distillation Tower").addInfo("Fluids are only put out at the correct height").addInfo("The correct height equals the slot number in the NEI recipe").addSeparator().beginVariableStructureBlock(3, 3, 3, 12, 3, 3, true).addController("Front bottom").addOtherStructurePart("Clean Stainless Steel Machine Casing", "7 x h - 5 (minimum)").addEnergyHatch("Any casing").addMaintenanceHatch("Any casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("2-11x Output Hatches (One per layer except bottom layer)").toolTipFinisher("Gregtech");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DistillationTower.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sDistillationRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        block0: for (int i = 0; i < tFluidList.size() - 1; ++i) {
            for (int j = i + 1; j < tFluidList.size(); ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    continue;
                }
                tFluidList.remove(i--);
                continue block0;
            }
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(0, GT_Utility.getTier(tVoltage));
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[tFluidList.size()]);
        if (tFluids.length > 0) {
            for (int i = 0; i < tFluids.length; ++i) {
                GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sDistillationRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], new FluidStack[]{tFluids[i]}, new ItemStack[0]);
                if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0])) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
                this.mOutputFluids = (FluidStack[])tRecipe.mFluidOutputs.clone();
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        Block block;
        IGregTechTileEntity tileEntity;
        int z;
        int x;
        this.controllerY = aBaseMetaTileEntity.getYCoord();
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int y = 0;
        int casingAmount = 0;
        boolean reachedTop = false;
        for (x = xDir - 1; x <= xDir + 1; ++x) {
            for (z = zDir - 1; z <= zDir + 1; ++z) {
                if (x == 0 && z == 0) continue;
                tileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(x, y, z);
                block = aBaseMetaTileEntity.getBlockOffset(x, y, z);
                if (this.addInputToMachineList(tileEntity, 49) || this.addOutputToMachineList(tileEntity, 49) || this.addMaintenanceToMachineList(tileEntity, 49) || this.addEnergyInputToMachineList(tileEntity, 49)) continue;
                if (block == GregTech_API.sBlockCasings4 && aBaseMetaTileEntity.getMetaIDOffset(x, y, z) == 1) {
                    ++casingAmount;
                    continue;
                }
                return false;
            }
        }
        ++y;
        while (y < 12 && !reachedTop) {
            for (x = xDir - 1; x <= xDir + 1; ++x) {
                for (z = zDir - 1; z <= zDir + 1; ++z) {
                    tileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(x, y, z);
                    block = aBaseMetaTileEntity.getBlockOffset(x, y, z);
                    if (aBaseMetaTileEntity.getAirOffset(x, y, z)) {
                        if (x == xDir && z == zDir) continue;
                        return false;
                    }
                    if (x == xDir && z == zDir) {
                        reachedTop = true;
                    }
                    if (this.addOutputToMachineList(tileEntity, 49) || this.addMaintenanceToMachineList(tileEntity, 49) || this.addEnergyInputToMachineList(tileEntity, 49)) continue;
                    if (block == GregTech_API.sBlockCasings4 && aBaseMetaTileEntity.getMetaIDOffset(x, y, z) == 1) {
                        ++casingAmount;
                        continue;
                    }
                    return false;
                }
            }
            ++y;
        }
        return casingAmount >= 7 * y - 5 && y >= 3 && y <= 12 && reachedTop;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        for (GT_MetaTileEntity_Hatch_Output tHatch : this.mOutputHatches) {
            if (!(GT_MetaTileEntity_DistillationTower.isValidMetaTileEntity(tHatch) && GT_ModHandler.isSteam(aLiquid) ? tHatch.outputsSteam() : tHatch.outputsLiquids()) || tHatch.getBaseMetaTileEntity().getYCoord() != this.controllerY + 1) continue;
            int tAmount = tHatch.fill(tLiquid, false);
            if (tAmount >= tLiquid.amount) {
                return tHatch.fill(tLiquid, true) >= tLiquid.amount;
            }
            if (tAmount <= 0) continue;
            tLiquid.amount -= tHatch.fill(tLiquid, true);
        }
        return false;
    }

    @Override
    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (int i = 0; i < mOutputFluids2.length; ++i) {
            if (this.mOutputHatches.size() <= i || this.mOutputHatches.get(i) == null || mOutputFluids2[i] == null || !GT_MetaTileEntity_DistillationTower.isValidMetaTileEntity((MetaTileEntity)this.mOutputHatches.get(i)) || ((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i)).getBaseMetaTileEntity().getYCoord() != this.controllerY + 1 + i) continue;
            ((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i)).fill(mOutputFluids2[i], true);
        }
    }
}

