/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.recipes.RecipeManagers;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.CombType;
import gregtech.common.items.DropType;
import gregtech.common.items.PropolisType;
import gregtech.loaders.materialprocessing.ProcessingModSupport;
import gregtech.loaders.misc.GT_Bees;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;

public class ItemComb
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemComb() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77627_a(true);
        this.func_77655_b("gt.comb");
        GameRegistry.registerItem((Item)this, (String)"gt.comb", (String)"gregtech");
    }

    public ItemStack getStackForType(CombType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public ItemStack getStackForType(CombType type, int count) {
        return new ItemStack((Item)this, count, type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (CombType type : CombType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("forestry:beeCombs.0");
        this.secondIcon = par1IconRegister.func_94245_a("forestry:beeCombs.1");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        int meta = Math.max(0, Math.min(CombType.values().length - 1, stack.func_77960_j()));
        int colour = CombType.values()[meta].getColours()[0];
        if (pass >= 1) {
            colour = CombType.values()[meta].getColours()[1];
        }
        return colour;
    }

    public String func_77653_i(ItemStack stack) {
        return CombType.values()[stack.func_77960_j()].getName();
    }

    public void initCombsRecipes() {
        ItemStack tComb = this.getStackForType(CombType.LIGNIE);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), 90);
        this.addProcessLV(tComb, Materials.Lignite, 100);
        tComb = this.getStackForType(CombType.COAL);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), 5, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Coal, 1L), 100);
        this.addProcessLV(tComb, Materials.Coal, 100);
        tComb = this.getStackForType(CombType.STICKY);
        this.addSpecialCentLV(tComb, ItemList.IC2_Resin.get(1L, new Object[0]), 50, ItemList.IC2_Plantball.get(1L, new Object[0]), 15);
        tComb = this.getStackForType(CombType.OIL);
        this.addSpecialCentLV(tComb, ItemList.Crop_Drop_OilBerry.get(1L, new Object[0]), 70, GT_Bees.drop.getStackForType(DropType.OIL), 100);
        this.addProcessLV(tComb, Materials.Oilsands, 100);
        tComb = this.getStackForType(CombType.APATITE);
        this.addProcessLV(tComb, Materials.Apatite, 100);
        this.addProcessLV(tComb, Materials.Phosphate, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Phosphate.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Phosphate, 4L), 10000, (int)(Materials.Phosphate.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.ASH);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Ash, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 5000, 5000}, 128, 5);
        tComb = this.getStackForType(CombType.COOLANT);
        this.addSpecialCentHV(tComb, GT_Bees.drop.getStackForType(DropType.COOLANT), 100, ItemList.FR_Wax.get(1L, new Object[0]), 100);
        tComb = this.getStackForType(CombType.ENERGY);
        this.addSpecialCentHV(tComb, GT_Bees.drop.getStackForType(DropType.HOT_COOLANT), 20, ItemList.IC2_Energium_Dust.get(1L, new Object[0]), 20, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 50);
        tComb = this.getStackForType(CombType.LAPOTRON);
        this.addSpecialCentHV(tComb, GT_Bees.drop.getStackForType(DropType.LAPIS), 20, GT_ModHandler.getModItem("dreamcraft", "item.LapotronDust", 1L, 0), 15, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 2), 40);
        tComb = this.getStackForType(CombType.PYROTHEUM);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Blizz, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Pyrotheum, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{3000, 2500, 2000, 0, 0, 0}, 384, 480);
        tComb = this.getStackForType(CombType.CRYOTHEUM);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Blaze, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Cryotheum, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{3000, 2500, 2000, 0, 0, 0}, 384, 480);
        tComb = this.getStackForType(CombType.REDALLOY);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.RedAlloy, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 10000}, 128, 5);
        this.addProcessLV(tComb, Materials.Redstone, 75);
        this.addProcessLV(tComb, Materials.Copper, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Copper.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Copper, 4L), 10000, (int)(Materials.Copper.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.REDSTONEALLOY);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.RedstoneAlloy, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 10000}, 128, 5);
        this.addProcessLV(tComb, Materials.Redstone, 90);
        this.addProcessLV(tComb, Materials.Silicon, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Silicon.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Silicon, 4L), 10000, (int)(Materials.Silicon.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Coal, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Coal.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Coal, 4L), 10000, (int)(Materials.Coal.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.CONDUCTIVEIRON);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.ConductiveIron, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 9000}, 256, 120);
        this.addProcessMV(tComb, Materials.Silver, 55);
        this.addProcessMV(tComb, Materials.Iron, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Iron.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Iron, 4L), 10000, (int)(Materials.Iron.getMass() * 128L), 768, false);
        tComb = this.getStackForType(CombType.VIBRANTALLOY);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.VibrantAlloy, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 7000}, 384, 480);
        this.addProcessHV(tComb, Materials.Chrome, 50);
        tComb = this.getStackForType(CombType.ENERGETICALLOY);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.EnergeticAlloy, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 8000}, 384, 480);
        this.addProcessHV(tComb, Materials.Gold, 60);
        tComb = this.getStackForType(CombType.ELECTRICALSTEEL);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.ElectricalSteel, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 10000}, 128, 5);
        this.addProcessLV(tComb, Materials.Silicon, 75);
        this.addProcessLV(tComb, Materials.Coal, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Coal.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Coal, 4L), 10000, (int)(Materials.Coal.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.DARKSTEEL);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkSteel, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 10000}, 256, 120);
        this.addProcessMV(tComb, Materials.Coal, 75);
        tComb = this.getStackForType(CombType.PULSATINGIRON);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.PulsatingIron, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 8000}, 384, 480);
        this.addProcessHV(tComb, Materials.Iron, 75);
        tComb = this.getStackForType(CombType.STAINLESSSTEEL);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.StainlessSteel, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 5000}, 384, 480);
        this.addProcessHV(tComb, Materials.Iron, 75);
        this.addProcessHV(tComb, Materials.Chrome, 55);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Chrome.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Chrome, 4L), 10000, (int)(Materials.Chrome.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Manganese, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Manganese.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Manganese, 4L), 10000, (int)(Materials.Manganese.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Nickel, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Nickel.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Nickel, 4L), 10000, (int)(Materials.Nickel.getMass() * 128L), 1536, false);
        tComb = this.getStackForType(CombType.ENDERIUM);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustSmall, Materials.EnderiumBase, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Enderium, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 5000}, 384, 480);
        tComb = this.getStackForType(CombType.THAUMIUMDUST);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Thaumium, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 10000}, 256, 120);
        this.addProcessMV(tComb, Materials.Iron, 75);
        tComb = this.getStackForType(CombType.THAUMIUMSHARD);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 1), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 2), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 3), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 4), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 5), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 6), new int[]{2000, 2000, 2000, 2000, 2000, 2000}, 128, 5);
        tComb = this.getStackForType(CombType.AMBER);
        this.addProcessLV(tComb, Materials.Amber, 100);
        tComb = this.getStackForType(CombType.QUICKSILVER);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_ModHandler.getModItem("Thaumcraft", "ItemNugget", 1L, 5), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 1000}, 128, 5);
        this.addProcessLV(tComb, Materials.Cinnabar, 85);
        tComb = this.getStackForType(CombType.SALISMUNDUS);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_ModHandler.getModItem("Thaumcraft", "ItemResource", 1L, 14), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 1000}, 256, 120);
        tComb = this.getStackForType(CombType.TAINTED);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("Thaumcraft", "ItemResource", 1L, 11), GT_ModHandler.getModItem("Thaumcraft", "ItemResource", 1L, 12), GT_ModHandler.getModItem("Thaumcraft", "blockTaintFibres", 1L, 0), GT_ModHandler.getModItem("Thaumcraft", "blockTaintFibres", 1L, 1), GT_ModHandler.getModItem("Thaumcraft", "blockTaintFibres", 1L, 2), GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), new int[]{1500, 1500, 1500, 1500, 1500, 5000}, 128, 5);
        tComb = this.getStackForType(CombType.MITHRIL);
        this.addProcessHV(tComb, Materials.Mithril, 75);
        this.addProcessHV(tComb, Materials.Platinum, 55);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Platinum.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Platinum, 4L), 10000, (int)(Materials.Platinum.getMass() * 128L), 1536, false);
        tComb = this.getStackForType(CombType.ASTRALSILVER);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.AstralSilver, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Silver, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 2000, 1000}, 384, 480);
        this.addProcessHV(tComb, Materials.Silver, 75);
        tComb = this.getStackForType(CombType.THAUMINITE);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_ModHandler.getModItem("thaumicbases", "resource", 1L, 0), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Thaumium, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 2000, 1000}, 384, 480);
        tComb = this.getStackForType(CombType.SHADOWMETAL);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Shadow, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.ShadowSteel, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 2000, 1000}, 384, 480);
        this.addProcessHV(tComb, Materials.Shadow, 75);
        tComb = this.getStackForType(CombType.DIVIDED);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_ModHandler.getModItem("ExtraUtilities", "unstableingot", 1L, 1), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Iron, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Diamond, 1L), GT_Values.NI, GT_Values.NI, new int[]{5000, 2000, 1000, 500}, 384, 480);
        this.addProcessHV(tComb, Materials.Iron, 75);
        this.addProcessHV(tComb, Materials.Diamond, 55);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Diamond.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Diamond, 4L), 10000, (int)(Materials.Diamond.getMass() * 128L), 1536, false);
        tComb = this.getStackForType(CombType.SPARKELING);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_ModHandler.getModItem("MagicBees", "miscResources", 1L, 5), GT_ModHandler.getModItem("MagicBees", "miscResources", 1L, 5), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.NetherStar, 1L), GT_Values.NI, GT_Values.NI, new int[]{5000, 1000, 500, 1000}, 512, 1920);
        this.addProcessEV(tComb, Materials.NetherStar, 50);
        tComb = this.getStackForType(CombType.STONE);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.GraniteBlack, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.GraniteRed, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Basalt, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Marble, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Redrock, 1L), new int[]{7000, 5000, 5000, 5000, 5000, 5000}, 128, 5);
        this.addProcessLV(tComb, Materials.Soapstone, 95);
        this.addProcessLV(tComb, Materials.Talc, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Talc.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Talc, 4L), 10000, (int)(Materials.Talc.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Apatite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Apatite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Apatite, 4L), 10000, (int)(Materials.Apatite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Phosphate, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Phosphate.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Phosphate, 4L), 10000, (int)(Materials.Phosphate.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.TricalciumPhosphate, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.TricalciumPhosphate.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.TricalciumPhosphate, 4L), 10000, (int)(Materials.TricalciumPhosphate.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.CERTUS);
        this.addProcessLV(tComb, Materials.CertusQuartz, 100);
        this.addProcessLV(tComb, Materials.Quartzite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Quartzite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Quartzite, 4L), 10000, (int)(Materials.Quartzite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Barite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Barite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Barite, 4L), 10000, (int)(Materials.Barite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.FLUIX);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Fluix, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{3000, 2500}, 128, 5);
        this.addProcessLV(tComb, Materials.Redstone, 90);
        this.addProcessLV(tComb, Materials.CertusQuartz, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.CertusQuartz.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.CertusQuartz, 4L), 10000, (int)(Materials.CertusQuartz.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.NetherQuartz, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.NetherQuartz.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.NetherQuartz, 4L), 10000, (int)(Materials.NetherQuartz.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.REDSTONE);
        this.addProcessLV(tComb, Materials.Redstone, 100);
        this.addProcessLV(tComb, Materials.Cinnabar, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Cinnabar.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Cinnabar, 4L), 10000, (int)(Materials.Cinnabar.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.RAREEARTH);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.RareEarth, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{3000, 10000}, 128, 5);
        tComb = this.getStackForType(CombType.LAPIS);
        this.addProcessLV(tComb, Materials.Lapis, 100);
        this.addProcessLV(tComb, Materials.Sodalite, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Sodalite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Sodalite, 4L), 10000, (int)(Materials.Sodalite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Lazurite, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Lazurite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Lazurite, 4L), 10000, (int)(Materials.Lazurite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Calcite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Calcite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Calcite, 4L), 10000, (int)(Materials.Calcite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.RUBY);
        this.addProcessLV(tComb, Materials.Ruby, 100);
        this.addProcessLV(tComb, Materials.Redstone, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Redstone.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Redstone, 4L), 10000, (int)(Materials.Redstone.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.REDGARNET);
        this.addProcessLV(tComb, Materials.GarnetRed, 100);
        this.addProcessLV(tComb, Materials.GarnetYellow, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.GarnetYellow.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.GarnetYellow, 4L), 10000, (int)(Materials.GarnetYellow.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.YELLOWGARNET);
        this.addProcessLV(tComb, Materials.GarnetYellow, 100);
        this.addProcessLV(tComb, Materials.GarnetRed, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.GarnetRed.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.GarnetRed, 4L), 10000, (int)(Materials.GarnetRed.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.SAPPHIRE);
        this.addProcessLV(tComb, Materials.Sapphire, 100);
        this.addProcessLV(tComb, Materials.GreenSapphire, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.GreenSapphire.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.GreenSapphire, 4L), 10000, (int)(Materials.GreenSapphire.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Almandine, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Almandine.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Almandine, 4L), 10000, (int)(Materials.Almandine.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Pyrope, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pyrope.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pyrope, 4L), 10000, (int)(Materials.Pyrope.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.DIAMOND);
        this.addProcessLV(tComb, Materials.Diamond, 100);
        this.addProcessLV(tComb, Materials.Graphite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Graphite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Graphite, 4L), 10000, (int)(Materials.Graphite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.OLIVINE);
        this.addProcessLV(tComb, Materials.Olivine, 100);
        this.addProcessLV(tComb, Materials.Bentonite, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Bentonite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Bentonite, 4L), 10000, (int)(Materials.Bentonite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Magnesite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Magnesite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Magnesite, 4L), 10000, (int)(Materials.Magnesite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Glauconite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Glauconite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Glauconite, 4L), 10000, (int)(Materials.Glauconite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.EMERALD);
        this.addProcessLV(tComb, Materials.Emerald, 100);
        this.addProcessLV(tComb, Materials.Beryllium, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Beryllium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Beryllium, 4L), 10000, (int)(Materials.Beryllium.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Thorium, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Thorium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Thorium, 4L), 10000, (int)(Materials.Thorium.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.FIRESTONE);
        this.addProcessLV(tComb, Materials.Firestone, 100);
        tComb = this.getStackForType(CombType.PYROPE);
        this.addProcessLV(tComb, Materials.Pyrope, 100);
        this.addProcessLV(tComb, Materials.Aluminium, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Aluminium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Aluminium, 4L), 10000, (int)(Materials.Aluminium.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Magnesium, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Magnesium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Magnesium, 4L), 10000, (int)(Materials.Magnesium.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Silicon, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Silicon.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Silicon, 4L), 10000, (int)(Materials.Silicon.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.GROSSULAR);
        this.addProcessLV(tComb, Materials.Grossular, 100);
        this.addProcessLV(tComb, Materials.Aluminium, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Aluminium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Aluminium, 4L), 10000, (int)(Materials.Aluminium.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Silicon, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Silicon.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Silicon, 4L), 10000, (int)(Materials.Silicon.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.SLAG);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L), 50, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.GraniteBlack, 1L), 20, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.GraniteRed, 1L), 20);
        this.addProcessLV(tComb, Materials.Salt, 100);
        this.addProcessLV(tComb, Materials.RockSalt, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.RockSalt.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.RockSalt, 4L), 10000, (int)(Materials.RockSalt.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Lepidolite, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Lepidolite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Lepidolite, 4L), 10000, (int)(Materials.Lepidolite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Spodumene, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Spodumene.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Spodumene, 4L), 10000, (int)(Materials.Spodumene.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Monazite, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Monazite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Monazite, 4L), 10000, (int)(Materials.Monazite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.COPPER);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Copper, 1L), 70);
        this.addProcessLV(tComb, Materials.Copper, 100);
        this.addProcessLV(tComb, Materials.Tetrahedrite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Tetrahedrite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Tetrahedrite, 4L), 10000, (int)(Materials.Tetrahedrite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Chalcopyrite, 95);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Chalcopyrite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Chalcopyrite, 4L), 10000, (int)(Materials.Chalcopyrite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Malachite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Malachite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Malachite, 4L), 10000, (int)(Materials.Malachite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Pyrite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pyrite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pyrite, 4L), 10000, (int)(Materials.Pyrite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Stibnite, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(6), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Stibnite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Stibnite, 4L), 10000, (int)(Materials.Stibnite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.TIN);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Tin, 1L), 60);
        this.addProcessLV(tComb, Materials.Tin, 100);
        this.addProcessLV(tComb, Materials.Cassiterite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Cassiterite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Cassiterite, 4L), 10000, (int)(Materials.Cassiterite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.CassiteriteSand, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.CassiteriteSand.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.CassiteriteSand, 4L), 10000, (int)(Materials.CassiteriteSand.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.LEAD);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Lead, 1L), 45);
        this.addProcessLV(tComb, Materials.Lead, 100);
        this.addProcessLV(tComb, Materials.Galena, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Galena.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Galena, 4L), 10000, (int)(Materials.Galena.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.IRON);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Iron, 1L), 30);
        this.addProcessLV(tComb, Materials.Iron, 100);
        this.addProcessLV(tComb, Materials.Magnetite, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Magnetite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Magnetite, 4L), 10000, (int)(Materials.Magnetite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.BrownLimonite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.BrownLimonite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.BrownLimonite, 4L), 10000, (int)(Materials.BrownLimonite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.YellowLimonite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.YellowLimonite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.YellowLimonite, 4L), 10000, (int)(Materials.YellowLimonite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.VanadiumMagnetite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.VanadiumMagnetite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.VanadiumMagnetite, 4L), 10000, (int)(Materials.VanadiumMagnetite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.BandedIron, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(6), Materials.UUMatter.getFluid(Math.max(1L, (Materials.BandedIron.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.BandedIron, 4L), 10000, (int)(Materials.BandedIron.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Pyrite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(7), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pyrite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pyrite, 4L), 10000, (int)(Materials.Pyrite.getMass() * 128L), 384, false);
        if (ProcessingModSupport.aEnableGCMarsMats) {
            this.addProcessLV(tComb, Materials.MeteoricIron, 75);
        }
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(8), Materials.UUMatter.getFluid(Math.max(1L, (Materials.MeteoricIron.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.MeteoricIron, 4L), 10000, (int)(Materials.MeteoricIron.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.STEEL);
        this.addProcessLV(tComb, Materials.Iron, Materials.Iron, 100);
        this.addProcessLV(tComb, Materials.Magnetite, Materials.Magnetite, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Magnetite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Magnetite, 4L), 10000, (int)(Materials.Magnetite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.BrownLimonite, Materials.YellowLimonite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.BrownLimonite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.BrownLimonite, 4L), 10000, (int)(Materials.BrownLimonite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.YellowLimonite, Materials.BrownLimonite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.YellowLimonite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.YellowLimonite, 4L), 10000, (int)(Materials.YellowLimonite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.VanadiumMagnetite, Materials.VanadiumMagnetite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.VanadiumMagnetite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.VanadiumMagnetite, 4L), 10000, (int)(Materials.VanadiumMagnetite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.BandedIron, Materials.BandedIron, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(6), Materials.UUMatter.getFluid(Math.max(1L, (Materials.BandedIron.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.BandedIron, 4L), 10000, (int)(Materials.BandedIron.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Pyrite, Materials.Pyrite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(7), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pyrite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pyrite, 4L), 10000, (int)(Materials.Pyrite.getMass() * 128L), 384, false);
        if (ProcessingModSupport.aEnableGCMarsMats) {
            this.addProcessLV(tComb, Materials.MeteoricIron, Materials.MeteoricIron, 75);
        }
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(8), Materials.UUMatter.getFluid(Math.max(1L, (Materials.MeteoricIron.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.MeteoricIron, 4L), 10000, (int)(Materials.MeteoricIron.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Molybdenite, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(9), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Molybdenite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Molybdenite, 4L), 10000, (int)(Materials.Molybdenite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Molybdenum, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(10), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Molybdenum.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Molybdenum, 4L), 10000, (int)(Materials.Molybdenum.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.NICKEL);
        this.addProcessLV(tComb, Materials.Nickel, 100);
        this.addProcessLV(tComb, Materials.Garnierite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Garnierite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Garnierite, 4L), 10000, (int)(Materials.Garnierite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Pentlandite, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pentlandite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pentlandite, 4L), 10000, (int)(Materials.Pentlandite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Cobaltite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Cobaltite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Cobaltite, 4L), 10000, (int)(Materials.Cobaltite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Wulfenite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Wulfenite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Wulfenite, 4L), 10000, (int)(Materials.Wulfenite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Powellite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(6), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Powellite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Powellite, 4L), 10000, (int)(Materials.Powellite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.ZINC);
        this.addProcessLV(tComb, Materials.Zinc, 100);
        this.addProcessLV(tComb, Materials.Sphalerite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Sphalerite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Sphalerite, 4L), 10000, (int)(Materials.Sphalerite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Sulfur, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Sulfur.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Sulfur, 4L), 10000, (int)(Materials.Sulfur.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.SILVER);
        this.addSpecialCentLV(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Silver, 1L), 80);
        this.addProcessLV(tComb, Materials.Silver, 100);
        this.addProcessLV(tComb, Materials.Galena, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Galena.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Galena, 4L), 10000, (int)(Materials.Galena.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.GOLD);
        this.addProcessLV(tComb, Materials.Gold, 100);
        this.addProcessLV(tComb, Materials.Magnetite, Materials.Gold, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Magnetite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Magnetite, 4L), 10000, (int)(Materials.Magnetite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.SULFUR);
        this.addProcessLV(tComb, Materials.Sulfur, 100);
        this.addProcessLV(tComb, Materials.Pyrite, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pyrite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pyrite, 4L), 10000, (int)(Materials.Pyrite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Sphalerite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Sphalerite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Sphalerite, 4L), 10000, (int)(Materials.Sphalerite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.GALLIUM);
        this.addProcessLV(tComb, Materials.Gallium, 80);
        this.addProcessLV(tComb, Materials.Niobium, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Niobium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Niobium, 4L), 10000, (int)(Materials.Niobium.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.ARSENIC);
        this.addProcessLV(tComb, Materials.Arsenic, 80);
        this.addProcessLV(tComb, Materials.Bismuth, 70);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Bismuth.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Bismuth, 4L), 10000, (int)(Materials.Bismuth.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Antimony, 70);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Antimony.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Antimony, 4L), 10000, (int)(Materials.Antimony.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.BAUXITE);
        this.addProcessLV(tComb, Materials.Bauxite, 75);
        this.addProcessLV(tComb, Materials.Aluminium, 55);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Aluminium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Aluminium, 4L), 10000, (int)(Materials.Aluminium.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.ALUMINIUM);
        this.addProcessLV(tComb, Materials.Aluminium, 60);
        this.addProcessLV(tComb, Materials.Bauxite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Bauxite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Bauxite, 4L), 10000, (int)(Materials.Bauxite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.MANGANESE);
        this.addProcessLV(tComb, Materials.Manganese, 30);
        this.addProcessLV(tComb, Materials.Grossular, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Grossular.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Grossular, 4L), 10000, (int)(Materials.Grossular.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Spessartine, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Spessartine.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Spessartine, 4L), 10000, (int)(Materials.Spessartine.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Pyrolusite, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pyrolusite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pyrolusite, 4L), 10000, (int)(Materials.Pyrolusite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Tantalite, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Tantalite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Tantalite, 4L), 10000, (int)(Materials.Tantalite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.TITANIUM);
        this.addProcessEV(tComb, Materials.Titanium, 90);
        this.addProcessEV(tComb, Materials.Ilmenite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Ilmenite.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Ilmenite, 4L), 10000, (int)(Materials.Ilmenite.getMass() * 128L), 3072, true);
        this.addProcessEV(tComb, Materials.Bauxite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Bauxite.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Bauxite, 4L), 10000, (int)(Materials.Bauxite.getMass() * 128L), 3072, true);
        this.addProcessEV(tComb, Materials.Rutile, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Rutile.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Rutile, 4L), 10000, (int)(Materials.Rutile.getMass() * 128L), 3072, true);
        tComb = this.getStackForType(CombType.MAGNESIUM);
        this.addProcessLV(tComb, Materials.Magnesium, 100);
        this.addProcessLV(tComb, Materials.Magnesite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Magnesite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Magnesite, 4L), 10000, (int)(Materials.Magnesite.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.CHROME);
        this.addProcessHV(tComb, Materials.Chrome, 50);
        this.addProcessHV(tComb, Materials.Ruby, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Ruby.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Ruby, 4L), 10000, (int)(Materials.Ruby.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Chromite, 50);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Chromite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Chromite, 4L), 10000, (int)(Materials.Chromite.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Redstone, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Redstone.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Redstone, 4L), 10000, (int)(Materials.Redstone.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Neodymium, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Neodymium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Neodymium, 4L), 10000, (int)(Materials.Neodymium.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Bastnasite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(6), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Bastnasite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Bastnasite, 4L), 10000, (int)(Materials.Bastnasite.getMass() * 128L), 1536, false);
        tComb = this.getStackForType(CombType.TUNGSTEN);
        this.addProcessIV(tComb, Materials.Tungstate, 80);
        this.addProcessIV(tComb, Materials.Scheelite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Scheelite.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Scheelite, 4L), 10000, (int)(Materials.Scheelite.getMass() * 128L), 6144, true);
        this.addProcessIV(tComb, Materials.Lithium, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Lithium.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Lithium, 4L), 10000, (int)(Materials.Lithium.getMass() * 128L), 6144, true);
        this.addProcessIV(tComb, Materials.Tungsten, 50);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Tungsten.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Tungsten, 4L), 10000, (int)(Materials.Tungsten.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.PLATINUM);
        this.addProcessHV(tComb, Materials.Platinum, 40);
        this.addProcessHV(tComb, Materials.Cooperite, 40);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Cooperite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Cooperite, 4L), 10000, (int)(Materials.Cooperite.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Palladium, 40);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Palladium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Palladium, 4L), 10000, (int)(Materials.Palladium.getMass() * 128L), 1536, false);
        tComb = this.getStackForType(CombType.MOLYBDENUM);
        this.addProcessLV(tComb, Materials.Molybdenum, 100);
        this.addProcessLV(tComb, Materials.Molybdenite, 90);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Molybdenite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Molybdenite, 4L), 10000, (int)(Materials.Molybdenite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Powellite, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Powellite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Powellite, 4L), 10000, (int)(Materials.Powellite.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Wulfenite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Wulfenite.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Wulfenite, 4L), 10000, (int)(Materials.Wulfenite.getMass() * 128L), 384, false);
        this.addProcessIV(tComb, Materials.Osmium, 15);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(5), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Osmium.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Osmium, 4L), 10000, (int)(Materials.Osmium.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.IRIDIUM);
        this.addProcessIV(tComb, Materials.Iridium, 20);
        this.addProcessIV(tComb, Materials.Osmium, 15);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Osmium.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Osmium, 4L), 10000, (int)(Materials.Osmium.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.OSMIUM);
        this.addProcessIV(tComb, Materials.Osmium, 25);
        this.addProcessIV(tComb, Materials.Iridium, 15);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Iridium.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Iridium, 4L), 10000, (int)(Materials.Iridium.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.LITHIUM);
        this.addProcessMV(tComb, Materials.Lithium, 85);
        this.addProcessMV(tComb, Materials.Aluminium, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Aluminium.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Aluminium, 4L), 10000, (int)(Materials.Aluminium.getMass() * 128L), 768, false);
        tComb = this.getStackForType(CombType.SALT);
        this.addProcessMV(tComb, Materials.Salt, 100);
        this.addSpecialCentMV(tComb, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Salt, 1L), 100, GT_ModHandler.getModItem("dreamcraft", "item.EdibleSalt", 1L, 0), 50);
        this.addProcessMV(tComb, Materials.RockSalt, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.RockSalt.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.RockSalt, 4L), 10000, (int)(Materials.RockSalt.getMass() * 128L), 768, false);
        this.addProcessMV(tComb, Materials.Saltpeter, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Saltpeter.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Saltpeter, 4L), 10000, (int)(Materials.Saltpeter.getMass() * 128L), 768, false);
        tComb = this.getStackForType(CombType.ELECTROTINE);
        this.addProcessHV(tComb, Materials.Electrotine, 80);
        this.addProcessHV(tComb, Materials.Electrum, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Electrum.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Electrum, 4L), 10000, (int)(Materials.Electrum.getMass() * 128L), 1536, false);
        this.addProcessHV(tComb, Materials.Redstone, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Redstone.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Redstone, 4L), 10000, (int)(Materials.Redstone.getMass() * 128L), 1536, false);
        tComb = this.getStackForType(CombType.ALMANDINE);
        this.addProcessLV(tComb, Materials.Almandine, 90);
        this.addProcessLV(tComb, Materials.Pyrope, 80);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pyrope.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pyrope, 4L), 10000, (int)(Materials.Pyrope.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.Sapphire, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Sapphire.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Sapphire, 4L), 10000, (int)(Materials.Sapphire.getMass() * 128L), 384, false);
        this.addProcessLV(tComb, Materials.GreenSapphire, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.GreenSapphire.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.GreenSapphire, 4L), 10000, (int)(Materials.GreenSapphire.getMass() * 128L), 384, false);
        tComb = this.getStackForType(CombType.URANIUM);
        this.addProcessEV(tComb, Materials.Uranium, 50);
        this.addProcessEV(tComb, Materials.Pitchblende, 65);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Pitchblende.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Pitchblende, 4L), 10000, (int)(Materials.Pitchblende.getMass() * 128L), 3072, true);
        this.addProcessEV(tComb, Materials.Uraninite, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Uraninite.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Uraninite, 4L), 10000, (int)(Materials.Uraninite.getMass() * 128L), 3072, true);
        this.addProcessEV(tComb, Materials.Uranium235, 50);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(4), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Uranium235.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Uranium235, 4L), 10000, (int)(Materials.Uranium235.getMass() * 128L), 3072, true);
        tComb = this.getStackForType(CombType.PLUTONIUM);
        this.addProcessEV(tComb, Materials.Plutonium, 10);
        this.addProcessEV(tComb, Materials.Uranium235, Materials.Plutonium, 5);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Uranium235.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Uranium235, 4L), 10000, (int)(Materials.Uranium235.getMass() * 128L), 3072, true);
        tComb = this.getStackForType(CombType.NAQUADAH);
        this.addProcessIV(tComb, Materials.Naquadah, 10);
        this.addProcessIV(tComb, Materials.NaquadahEnriched, 5);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.NaquadahEnriched.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.NaquadahEnriched, 4L), 10000, (int)(Materials.NaquadahEnriched.getMass() * 128L), 6144, true);
        this.addProcessIV(tComb, Materials.Naquadria, 5);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Naquadria.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Naquadria, 4L), 10000, (int)(Materials.NaquadahEnriched.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.NAQUADRIA);
        this.addProcessLUV(tComb, Materials.Naquadria, 10);
        this.addProcessLUV(tComb, Materials.NaquadahEnriched, 10);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.NaquadahEnriched.getMass() + 36L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.NaquadahEnriched, 4L), 10000, (int)(Materials.NaquadahEnriched.getMass() * 128L), 24576, true);
        this.addProcessLUV(tComb, Materials.Naquadah, 15);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Naquadah.getMass() + 36L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Naquadah, 4L), 10000, (int)(Materials.Naquadah.getMass() * 128L), 24576, true);
        tComb = this.getStackForType(CombType.THORIUM);
        this.addProcessEV(tComb, Materials.Thorium, 75);
        this.addProcessEV(tComb, Materials.Uranium, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Uranium.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Uranium, 4L), 10000, (int)(Materials.Uranium.getMass() * 128L), 3072, true);
        this.addProcessEV(tComb, Materials.Coal, 95);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Coal.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Coal, 4L), 10000, (int)(Materials.Coal.getMass() * 128L), 3072, true);
        tComb = this.getStackForType(CombType.LUTETIUM);
        this.addProcessIV(tComb, Materials.Lutetium, 35);
        this.addProcessIV(tComb, Materials.Thorium, 55);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Thorium.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Thorium, 4L), 10000, (int)(Materials.Thorium.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.AMERICUM);
        this.addProcessLUV(tComb, Materials.Americium, 25);
        this.addProcessLUV(tComb, Materials.Lutetium, 45);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Lutetium.getMass() + 36L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Lutetium, 4L), 10000, (int)(Materials.Lutetium.getMass() * 128L), 24576, true);
        tComb = this.getStackForType(CombType.NEUTRONIUM);
        this.addProcessUV(tComb, Materials.Neutronium, 15);
        this.addProcessUV(tComb, Materials.Americium, 35);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Americium.getMass() + 54L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Americium, 4L), 10000, (int)(Materials.Americium.getMass() * 128L), 100000, true);
        tComb = this.getStackForType(CombType.NAGA);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 4), GT_ModHandler.getModItem("dreamcraft", "item.NagaScaleChip", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.NagaScaleFragment", 1L, 0), GT_Values.NI, GT_Values.NI, new int[]{3000, 500, 3300, 800, 0, 0}, 256, 120);
        tComb = this.getStackForType(CombType.LICH);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 5), GT_ModHandler.getModItem("dreamcraft", "item.LichBoneChip", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.LichBoneFragment", 1L, 0), GT_Values.NI, GT_Values.NI, new int[]{3000, 500, 3300, 800, 0, 0}, 384, 480);
        tComb = this.getStackForType(CombType.HYDRA);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 1), GT_ModHandler.getModItem("dreamcraft", "item.FieryBloodDrop", 1L, 0), GT_Bees.drop.getStackForType(DropType.HYDRA), GT_Values.NI, GT_Values.NI, new int[]{3000, 500, 3300, 1000, 0, 0}, 384, 480);
        tComb = this.getStackForType(CombType.URGHAST);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 2), GT_ModHandler.getModItem("dreamcraft", "item..CarminiteChip", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.CarminiteFragment", 1L, 0), GT_Values.NI, GT_Values.NI, new int[]{3000, 500, 3300, 800, 0, 0}, 512, 1920);
        tComb = this.getStackForType(CombType.SNOWQUEEN);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("MagicBees", "propolis", 1L, 3), GT_ModHandler.getModItem("dreamcraft", "item.SnowQueenBloodDrop", 1L, 0), GT_Bees.drop.getStackForType(DropType.SNOW_QUEEN), GT_Values.NI, GT_Values.NI, new int[]{3000, 500, 3300, 1000, 0, 0}, 512, 1920);
        tComb = this.getStackForType(CombType.ENDDUST);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.End), GT_Bees.drop.getStackForType(DropType.ENDERGOO), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{2000, 1500, 1000}, 384, 480);
        tComb = this.getStackForType(CombType.STARDUST);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Stardust), GT_Bees.drop.getStackForType(DropType.ENDERGOO), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{2000, 1500, 1000}, 384, 480);
        tComb = this.getStackForType(CombType.ECTOPLASMA);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Ectoplasma), GT_Bees.drop.getStackForType(DropType.ENDERGOO), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{2500, 1000, 1500}, 512, 1920);
        tComb = this.getStackForType(CombType.ARCANESHARD);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Arcaneshard), GT_Bees.drop.getStackForType(DropType.ENDERGOO), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{2500, 1000, 1500}, 512, 1920);
        tComb = this.getStackForType(CombType.DRAGONESSENCE);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Dragonessence), GT_Bees.drop.getStackForType(DropType.ENDERGOO), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{3000, 750, 2000}, 640, 7680);
        tComb = this.getStackForType(CombType.ENDERMAN);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Enderman), GT_Bees.drop.getStackForType(DropType.ENDERGOO), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{3000, 750, 2000}, 640, 7680);
        tComb = this.getStackForType(CombType.SILVERFISH);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Silverfish), GT_Bees.drop.getStackForType(DropType.ENDERGOO), new ItemStack(Items.field_151063_bx, 1, 60), GT_Values.NI, GT_Values.NI, new int[]{2500, 1000, 2000, 1500}, 512, 1920);
        tComb = this.getStackForType(CombType.ENDIUM);
        this.addProcessHV(tComb, Materials.HeeEndium, 50);
        tComb = this.getStackForType(CombType.RUNEI);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.RuneOfPowerFragment", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.RuneOfAgilityFragment", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.RuneOfVigorFragment", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.RuneOfDefenseFragment", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.RuneOfMagicFragment", 1L, 0), new int[]{2500, 500, 500, 500, 500, 500}, 640, 7680);
        tComb = this.getStackForType(CombType.RUNEII);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.RuneOfVoidFragment", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 250}, 640, 7680);
        tComb = this.getStackForType(CombType.FIREESSENSE);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("MagicBees", "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Fireessence), GT_Bees.drop.getStackForType(DropType.ENDERGOO), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{3000, 750, 2000}, 640, 7680);
        tComb = this.getStackForType(CombType.SPACE);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_Bees.drop.getStackForType(DropType.OXYGEN), GT_ModHandler.getModItem("dreamcraft", "item.CoinSpace", 1L, 0), GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 1500, 500, 0, 0}, 384, 480);
        tComb = this.getStackForType(CombType.METEORICIRON);
        this.addProcessHV(tComb, Materials.MeteoricIron, 85);
        this.addProcessHV(tComb, Materials.Iron, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Iron.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Iron, 4L), 10000, (int)(Materials.Iron.getMass() * 128L), 1536, false);
        tComb = this.getStackForType(CombType.DESH);
        this.addProcessEV(tComb, Materials.Desh, 75);
        this.addProcessEV(tComb, Materials.Titanium, 50);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Titanium.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Titanium, 4L), 10000, (int)(Materials.Titanium.getMass() * 128L), 3072, true);
        tComb = this.getStackForType(CombType.LEDOX);
        this.addProcessEV(tComb, Materials.Ledox, 65);
        this.addProcessEV(tComb, Materials.CallistoIce, 55);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.CallistoIce.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.CallistoIce, 4L), 10000, (int)(Materials.CallistoIce.getMass() * 128L), 3072, true);
        this.addProcessEV(tComb, Materials.Lead, 85);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Lead.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Lead, 4L), 10000, (int)(Materials.Lead.getMass() * 128L), 3072, true);
        tComb = this.getStackForType(CombType.CALLISTOICE);
        this.addProcessIV(tComb, Materials.CallistoIce, 65);
        this.addProcessIV(tComb, Materials.Ledox, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Ledox.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Ledox, 4L), 10000, (int)(Materials.Ledox.getMass() * 128L), 6144, true);
        this.addProcessIV(tComb, Materials.Lead, 100);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(3), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Lead.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Lead, 4L), 10000, (int)(Materials.Lead.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.MYTRYL);
        this.addProcessIV(tComb, Materials.Mytryl, 55);
        this.addProcessIV(tComb, Materials.Mithril, 50);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Mithril.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Mithril, 4L), 10000, (int)(Materials.Mithril.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.QUANTIUM);
        this.addProcessIV(tComb, Materials.Quantium, 50);
        this.addProcessIV(tComb, Materials.Osmium, 60);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Osmium.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Osmium, 4L), 10000, (int)(Materials.Osmium.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.ORIHARUKON);
        this.addProcessIV(tComb, Materials.Oriharukon, 50);
        this.addProcessIV(tComb, Materials.Lead, 75);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Lead.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Lead, 4L), 10000, (int)(Materials.Lead.getMass() * 128L), 6144, true);
        tComb = this.getStackForType(CombType.MYSTERIOUSCRYSTAL);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.MysteriousCrystal, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Emerald, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 1000, 1500, 0, 0, 0}, 512, 30720);
        this.addProcessLUV(tComb, Materials.Emerald, 50);
        this.addProcessLUV(tComb, Materials.MysteriousCrystal, 40);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.MysteriousCrystal.getMass() + 36L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.MysteriousCrystal, 4L), 10000, (int)(Materials.MysteriousCrystal.getMass() * 128L), 24576, true);
        tComb = this.getStackForType(CombType.BLACKPLUTONIUM);
        this.addProcessLUV(tComb, Materials.BlackPlutonium, 25);
        this.addProcessLUV(tComb, Materials.Plutonium, 50);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Plutonium.getMass() + 36L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Plutonium, 4L), 10000, (int)(Materials.Plutonium.getMass() * 128L), 24576, true);
        tComb = this.getStackForType(CombType.TRINIUM);
        this.addProcessZPM(tComb, Materials.Trinium, 35);
        this.addProcessZPM(tComb, Materials.Iridium, 45);
        GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(2), Materials.UUMatter.getFluid(Math.max(1L, (Materials.Iridium.getMass() + 45L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, Materials.Iridium, 4L), 10000, (int)(Materials.Iridium.getMass() * 128L), 100000, true);
        tComb = this.getStackForType(CombType.MOON);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.MoonStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 0, 0, 0, 0}, 300, 120);
        tComb = this.getStackForType(CombType.MARS);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.MarsStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 0, 0, 0, 0}, 300, 480);
        tComb = this.getStackForType(CombType.JUPITER);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_ModHandler.getModItem("dreamcraft", "item.IoStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.EuropaIceDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.EuropaStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.GanymedeStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.CallistoStoneDust", 1L, 0), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.CallistoIce, 1L), new int[]{3000, 3000, 3000, 3000, 3000, 500}, 300, 480);
        tComb = this.getStackForType(CombType.MERCURY);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.MercuryCoreDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.MercuryStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 3000, 0, 0, 0}, 300, 1920);
        tComb = this.getStackForType(CombType.VENUS);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.VenusStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 0, 0, 0, 0}, 300, 1920);
        tComb = this.getStackForType(CombType.SATURN);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.EnceladusStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.TitanStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 3000, 0, 0, 0}, 300, 7680);
        tComb = this.getStackForType(CombType.URANUS);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.MirandaStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.OberonStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 3000, 0, 0, 0}, 300, 7680);
        tComb = this.getStackForType(CombType.NEPTUN);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.ProteusStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.TritonStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 3000, 0, 0, 0}, 300, 7680);
        tComb = this.getStackForType(CombType.PLUTO);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.PlutoStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.PlutoIceDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 3000, 0, 0, 0}, 300, 30720);
        tComb = this.getStackForType(CombType.HAUMEA);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.HaumeaStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 0, 0, 0, 0}, 300, 30720);
        tComb = this.getStackForType(CombType.MAKEMAKE);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.MakeMakeStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 0, 0, 0, 0}, 300, 30720);
        tComb = this.getStackForType(CombType.CENTAURI);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.CentauriASurfaceDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.CentauriAStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 3000, 0, 0, 0}, 300, 122880);
        tComb = this.getStackForType(CombType.TCETI);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.TCetiEStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 0, 0, 0, 0}, 300, 122880);
        tComb = this.getStackForType(CombType.BARNARDA);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.BarnardaEStoneDust", 1L, 0), GT_ModHandler.getModItem("dreamcraft", "item.BarnardaFStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 3000, 0, 0, 0}, 300, 122880);
        tComb = this.getStackForType(CombType.VEGA);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem("dreamcraft", "item.VegaBStoneDust", 1L, 0), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 3000, 0, 0, 0, 0}, 300, 122880);
        tComb = this.getStackForType(CombType.COSMICNEUTRONIUM);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.CosmicNeutronium, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Neutronium, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 50, 100, 0, 0, 0}, 12000, 2000000);
        tComb = this.getStackForType(CombType.INFINITYCATALYST);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.InfinityCatalyst, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Neutronium, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 5, 100, 0, 0, 0}, 48000, 8000000);
        tComb = this.getStackForType(CombType.INFINITY);
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Infinity, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.InfinityCatalyst, 1L), GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{5000, 1, 5, 0, 0, 0}, 96000, 24000000);
    }

    public void addSpecialCentLV(ItemStack tComb, ItemStack aOutput, int chance) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 5000}, 128, 5);
        RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)aOutput, (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f)));
    }

    public void addSpecialCentLV(ItemStack tComb, ItemStack aOutput, int chance, ItemStack aOutput2, int chance2) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, ItemList.FR_Wax.get(1L, new Object[0]), aOutput2, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 5000, chance2 * 100}, 128, 5);
        RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)aOutput, (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f), (Object)aOutput2, (Object)Float.valueOf((float)chance2 * 0.01f)));
    }

    public void addSpecialCentLV(ItemStack tComb, ItemStack aOutput, int chance, ItemStack aOutput2, int chance2, ItemStack aOutput3, int chance3) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, ItemList.FR_Wax.get(1L, new Object[0]), aOutput2, aOutput3, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 5000, chance2 * 100, chance3 * 100}, 128, 5);
        RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)aOutput, (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f), (Object)aOutput2, (Object)Float.valueOf((float)chance2 * 0.01f), (Object)aOutput3, (Object)Float.valueOf((float)chance3 * 0.01f)));
    }

    public void addSpecialCentMV(ItemStack tComb, ItemStack aOutput, int chance) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 7000}, 160, 120);
    }

    public void addSpecialCentMV(ItemStack tComb, ItemStack aOutput, int chance, ItemStack aOutput2, int chance2) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, aOutput2, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, chance2 * 100}, 160, 120);
    }

    public void addSpecialCentHV(ItemStack tComb, ItemStack aOutput, int chance) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 7000}, 196, 480);
    }

    public void addSpecialCentHV(ItemStack tComb, ItemStack aOutput, int chance, ItemStack aOutput2, int chance2) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, aOutput2, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, chance2 * 100}, 196, 480);
    }

    public void addSpecialCentHV(ItemStack tComb, ItemStack aOutput, int chance, ItemStack aOutput2, int chance2, ItemStack aOutput3, int chance3) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, aOutput2, aOutput3, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, chance2 * 100, chance3 * 100}, 196, 480);
    }

    public void addProcessLV(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), Materials.Water.getFluid(1000L), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 96, 24);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 384, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 128, 5);
            RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f)));
        }
    }

    public void addProcessMV(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), GT_ModHandler.getDistilledWater(1000L), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 128, 96);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 768, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 160, 120);
        }
    }

    public void addProcessHV(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), Materials.Mercury.getFluid(144L), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 160, 384);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 1536, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 192, 480);
        }
    }

    public void addProcessEV(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), Materials.Mercury.getFluid(288L), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 192, 1536);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 3072, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 224, 1920);
        }
    }

    public void addProcessIV(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), Materials.Mercury.getFluid(576L), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 224, 6144);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 6144, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 256, 7680);
        }
    }

    public void addProcessLUV(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), FluidRegistry.getFluidStack((String)"mutagen", (int)144), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 256, 24576, true);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 36L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 24576, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 288, 30720);
        }
    }

    public void addProcessZPM(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), FluidRegistry.getFluidStack((String)"mutagen", (int)288), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 288, 100000, true);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 45L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 100000, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 320, 122880);
        }
    }

    public void addProcessUV(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), FluidRegistry.getFluidStack((String)"mutagen", (int)576), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), GT_Values.NI, 320, 400000, true);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 54L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 10000, (int)(aMaterial.getMass() * 128L), 100000, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 352, 500000);
        }
    }

    public void addProcessLV(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aInMaterial, 1L), Materials.Water.getFluid(1000L), aInMaterial.mOreByProducts.isEmpty() ? null : aInMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), GT_Values.NI, 96, 24);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 384, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 128, 5);
            RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f)));
        }
    }

    public void addProcessMV(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aInMaterial, 1L), GT_ModHandler.getDistilledWater(1000L), aInMaterial.mOreByProducts.isEmpty() ? null : aInMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), GT_Values.NI, 128, 96);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 768, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 160, 120);
        }
    }

    public void addProcessHV(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aInMaterial, 1L), Materials.Mercury.getFluid(144L), aInMaterial.mOreByProducts.isEmpty() ? null : aInMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), GT_Values.NI, 160, 384);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 1536, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 192, 480);
        }
    }

    public void addProcessEV(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 18L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 3072, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 224, 1920, true);
        }
    }

    public void addProcessIV(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 27L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 6144, false);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 256, 7680, true);
        }
    }

    public void addProcessLUV(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aInMaterial, 1L), FluidRegistry.getFluidStack((String)"mutagen", (int)144), aInMaterial.mOreByProducts.isEmpty() ? null : aInMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), GT_Values.NI, 256, 12288, true);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 36L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 24576, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 288, 30720, true);
        }
    }

    public void addProcessZPM(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aInMaterial, 1L), FluidRegistry.getFluidStack((String)"mutagen", (int)288), aInMaterial.mOreByProducts.isEmpty() ? null : aInMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), GT_Values.NI, 288, 500000, true);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 45L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 100000, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 320, 122880, true);
        }
    }

    public void addProcessUV(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aInMaterial, 1L), FluidRegistry.getFluidStack((String)"mutagen", (int)576), aInMaterial.mOreByProducts.isEmpty() ? null : aInMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), GT_Values.NI, 320, 2000000, true);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(9L, tComb), GT_Utility.getIntegratedCircuit(1), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 54L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 10000, (int)(aOutMaterial.getMass() * 128L), 100000, true);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 352, 500000, true);
        }
    }
}

