/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_NeedMaintainance
extends GT_CoverBehavior {
    private boolean isRotor(ItemStack aRotor) {
        return aRotor != null && aRotor.func_77973_b() instanceof GT_MetaGenerated_Tool && aRotor.func_77960_j() >= 170 && aRotor.func_77960_j() <= 176;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        IGregTechTileEntity tTileEntity;
        IMetaTileEntity mTileEntity;
        boolean needsRepair = false;
        if (aTileEntity instanceof IGregTechTileEntity && (mTileEntity = (tTileEntity = (IGregTechTileEntity)aTileEntity).getMetaTileEntity()) instanceof GT_MetaTileEntity_MultiBlockBase) {
            GT_MetaTileEntity_MultiBlockBase multi = (GT_MetaTileEntity_MultiBlockBase)mTileEntity;
            int ideal = multi.getIdealStatus();
            int real = multi.getRepairStatus();
            ItemStack tRotor = multi.getRealInventory()[1];
            int coverVar = aCoverVariable >>> 1;
            if (coverVar < 5) {
                if (ideal - real > coverVar) {
                    needsRepair = true;
                }
            } else if (coverVar == 5 || coverVar == 6) {
                if (this.isRotor(tRotor)) {
                    long mExpectedDamage;
                    long tMax = GT_MetaGenerated_Tool.getToolMaxDamage(tRotor);
                    long tCur = GT_MetaGenerated_Tool.getToolDamage(tRotor);
                    needsRepair = coverVar == 5 ? tCur >= tMax * 8L / 10L : tCur + (mExpectedDamage = Math.round(Math.min((double)(multi.mEUt / multi.damageFactorLow), Math.pow(multi.mEUt, multi.damageFactorHigh)))) * 2L >= tMax;
                } else {
                    needsRepair = true;
                }
            }
        }
        if (aCoverVariable % 2 == 0) {
            needsRepair = !needsRepair;
        }
        aTileEntity.setOutputRedstoneSignal(aSide, (byte)(needsRepair ? 0 : 15));
        aTileEntity.setOutputRedstoneSignal(GT_Utility.getOppositeSide(aSide), (byte)(needsRepair ? 0 : 15));
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 14) < 0) {
            aCoverVariable = 13;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("056", "Emit if 1 Maintenance Needed"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("057", "Emit if 1 Maintenance Needed(inverted)"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("058", "Emit if 2 Maintenance Needed"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("059", "Emit if 2 Maintenance Needed(inverted)"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("060", "Emit if 3 Maintenance Needed"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("061", "Emit if 3 Maintenance Needed(inverted)"));
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("062", "Emit if 4 Maintenance Needed"));
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("063", "Emit if 4 Maintenance Needed(inverted)"));
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("064", "Emit if 5 Maintenance Needed"));
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("065", "Emit if 5 Maintenance Needed(inverted)"));
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("066", "Emit if rotor needs maintenance low accuracy mod"));
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("067", "Emit if rotor needs maintenance low accuracy mod(inverted)"));
                break;
            }
            case 12: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("068", "Emit if rotor needs maintenance high accuracy mod"));
                break;
            }
            case 13: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("069", "Emit if rotor needs maintenance high accuracy mod(inverted)"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 60;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private final String[] tooltiptext;
        private final String[] buttontext;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.tooltiptext = new String[]{GT_Cover_NeedMaintainance.this.trans("056", "Emit if 1 Maintenance Needed"), GT_Cover_NeedMaintainance.this.trans("058", "Emit if 2 Maintenance Needed"), GT_Cover_NeedMaintainance.this.trans("060", "Emit if 3 Maintenance Needed"), GT_Cover_NeedMaintainance.this.trans("062", "Emit if 4 Maintenance Needed"), GT_Cover_NeedMaintainance.this.trans("064", "Emit if 5 Maintenance Needed"), GT_Cover_NeedMaintainance.this.trans("066", "Emit if rotor needs maintenance low accuracy mod"), GT_Cover_NeedMaintainance.this.trans("068", "Emit if rotor needs maintenance high accuracy mod")};
            this.buttontext = new String[]{GT_Cover_NeedMaintainance.this.trans("247", "1 Issue"), GT_Cover_NeedMaintainance.this.trans("248", "2 Issues"), GT_Cover_NeedMaintainance.this.trans("249", "3 Issues"), GT_Cover_NeedMaintainance.this.trans("250", "4 Issues"), GT_Cover_NeedMaintainance.this.trans("251", "5 Issues"), GT_Cover_NeedMaintainance.this.trans("252", "Rotor < 80%"), GT_Cover_NeedMaintainance.this.trans("253", "Rotor < 100%"), GT_Cover_NeedMaintainance.this.trans("INVERTED", "Inverted"), GT_Cover_NeedMaintainance.this.trans("NORMAL", "Normal")};
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.CHECKMARK, null).setTooltipText(this.tooltiptext[0]);
            b = new GT_GuiIconCheckButton(this, 1, 10, 43, GT_GuiIcon.CHECKMARK, null).setTooltipText(this.tooltiptext[1]);
            b = new GT_GuiIconCheckButton(this, 2, 10, 61, GT_GuiIcon.CHECKMARK, null).setTooltipText(this.tooltiptext[2]);
            b = new GT_GuiIconCheckButton(this, 3, 10, 79, GT_GuiIcon.CHECKMARK, null).setTooltipText(this.tooltiptext[3]);
            b = new GT_GuiIconCheckButton(this, 4, 86, 25, GT_GuiIcon.CHECKMARK, null).setTooltipText(this.tooltiptext[4]);
            b = new GT_GuiIconCheckButton(this, 5, 86, 43, GT_GuiIcon.CHECKMARK, null).setTooltipText(this.tooltiptext[5]);
            b = new GT_GuiIconCheckButton(this, 6, 86, 61, GT_GuiIcon.CHECKMARK, null).setTooltipText(this.tooltiptext[6]);
            b = new GT_GuiIconCheckButton(this, 7, 86, 79, GT_GuiIcon.REDSTONE_ON, GT_GuiIcon.REDSTONE_OFF);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b(this.buttontext[0], 28, 29, -11184811);
            this.field_146289_q.func_78276_b(this.buttontext[1], 28, 47, -11184811);
            this.field_146289_q.func_78276_b(this.buttontext[2], 28, 65, -11184811);
            this.field_146289_q.func_78276_b(this.buttontext[3], 28, 83, -11184811);
            this.field_146289_q.func_78276_b(this.buttontext[4], 104, 29, -11184811);
            this.field_146289_q.func_78276_b(this.buttontext[5], 104, 47, -11184811);
            this.field_146289_q.func_78276_b(this.buttontext[6], 104, 65, -11184811);
            String s2 = (this.coverVariable & 1) > 0 ? this.buttontext[7] : this.buttontext[8];
            this.field_146289_q.func_78276_b(s2, 104, 83, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (btn.field_146127_k == 7 || !this.isEnabled(btn.field_146127_k)) {
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k, ((GT_GuiIconCheckButton)btn).isChecked());
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                ((GT_GuiIconCheckButton)o).setChecked(this.isEnabled(((GT_GuiIconCheckButton)o).field_146127_k));
            }
        }

        private int getNewCoverVariable(int id, boolean checked) {
            if (id == 7) {
                if (checked) {
                    return this.coverVariable & 0xFFFFFFFE;
                }
                return this.coverVariable | 1;
            }
            return this.coverVariable & 1 | id << 1;
        }

        private boolean isEnabled(int id) {
            if (id == 7) {
                return (this.coverVariable & 1) > 0;
            }
            return this.coverVariable >>> 1 == id;
        }
    }
}

