/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class GT_Cover_Fluidfilter
extends GT_CoverBehavior {
    private final int FILTER_INPUT_DENY_OUTPUT = 0;
    private final int INVERT_INPUT_DENY_OUTPUT = 1;
    private final int FILTER_INPUT_ANY_OUTPUT = 2;
    private final int INVERT_INPUT_ANY_OUTPUT = 3;
    private final int DENY_INPUT_FILTER_OUTPUT = 4;
    private final int DENY_INPUT_INVERT_OUTPUT = 5;
    private final int ANY_INPUT_FILTER_OUTPUT = 6;
    private final int ANY_INPUT_INVERT_OUTPUT = 7;

    @Override
    public String getDescription(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        int aFilterMode = aCoverVariable & 7;
        int aFilterFluid = aCoverVariable >>> 3;
        Fluid fluid = FluidRegistry.getFluid((int)aFilterFluid);
        if (fluid == null) {
            return "";
        }
        FluidStack sFluid = new FluidStack(fluid, 1000);
        return String.format("Filtering Fluid: %s  Mode: %s", sFluid.getLocalizedName(), this.getFilterMode(aFilterMode));
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable;
    }

    public String getFilterMode(int aFilterMode) {
        switch (aFilterMode) {
            case 0: {
                return this.trans("043", "Filter input, Deny output");
            }
            case 1: {
                return this.trans("044", "Invert input, Deny output");
            }
            case 2: {
                return this.trans("045", "Filter input, Permit any output");
            }
            case 3: {
                return this.trans("046", "Invert input, Permit any output");
            }
            case 4: {
                return this.trans("219", "Deny input, Filter output");
            }
            case 5: {
                return this.trans("220", "Deny input, Invert output");
            }
            case 6: {
                return this.trans("221", "Permit any input, Filter output");
            }
            case 7: {
                return this.trans("222", "Permit any input, Invert output");
            }
        }
        return "UNKNOWN";
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int aFilterMode = aCoverVariable & 7;
        aCoverVariable ^= aFilterMode;
        if ((aFilterMode = (aFilterMode + (aPlayer.func_70093_af() ? -1 : 1)) % 8) < 0) {
            aFilterMode = 7;
        }
        GT_Utility.sendChatToPlayer(aPlayer, this.getFilterMode(aFilterMode));
        return aCoverVariable |= aFilterMode;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || aSide > 3 && (double)aY > 0.375 && (double)aY < 0.625 || aSide < 2 && (double)aZ > 0.375 && (double)aZ < 0.625 || aSide == 2 || aSide == 3) {
            IFluidContainerItem tContainer;
            ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
            if (tStack == null) {
                return true;
            }
            FluidStack tFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)tStack);
            if (tFluid != null) {
                int aFluid = tFluid.getFluidID();
                aCoverVariable = aCoverVariable & 7 | aFluid << 3;
                aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
                FluidStack sFluid = new FluidStack(FluidRegistry.getFluid((int)aFluid), 1000);
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("047", "Filter Fluid: ") + sFluid.getLocalizedName());
            } else if (tStack.func_77973_b() instanceof IFluidContainerItem && (tContainer = (IFluidContainerItem)tStack.func_77973_b()).getFluid(tStack) != null) {
                int aFluid = tContainer.getFluid(tStack).getFluidID();
                aCoverVariable = aCoverVariable & 7 | aFluid << 3;
                aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
                FluidStack sFluid = new FluidStack(FluidRegistry.getFluid((int)aFluid), 1000);
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("047", "Filter Fluid: ") + sFluid.getLocalizedName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = aCoverVariable & 7;
        int aFilterFluid = aCoverVariable >>> 3;
        if (aFilterMode == 4 || aFilterMode == 5) {
            return false;
        }
        if (aFilterMode == 6 || aFilterMode == 7) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 0 || aFilterMode == 2;
        }
        return aFilterMode == 1 || aFilterMode == 3;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = aCoverVariable & 7;
        int aFilterFluid = aCoverVariable >>> 3;
        if (aFilterMode == 0 || aFilterMode == 1) {
            return false;
        }
        if (aFilterMode == 2 || aFilterMode == 3) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 4 || aFilterMode == 6;
        }
        return aFilterMode == 5 || aFilterMode == 7;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GT_FluidFilterGUICover(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GT_FluidFilterGUICover
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private final GT_GuiFakeItemButton fluidFilterButton;
        protected String fluidFilterName;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GT_FluidFilterGUICover(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Cover_Fluidfilter.this.trans("232", "Filter Input"));
            b = new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Cover_Fluidfilter.this.trans("233", "Filter Output"));
            b = new GT_GuiIconButton(this, 2, 10, 61, GT_GuiIcon.BLOCK_INPUT).setTooltipText(GT_Cover_Fluidfilter.this.trans("234", "Block Output"));
            b = new GT_GuiIconButton(this, 3, 28, 61, GT_GuiIcon.ALLOW_INPUT).setTooltipText(GT_Cover_Fluidfilter.this.trans("235", "Allow Output"));
            b = new GT_GuiIconButton(this, 4, 10, 43, GT_GuiIcon.WHITELIST).setTooltipText(GT_Cover_Fluidfilter.this.trans("236", "Whitelist Fluid"));
            b = new GT_GuiIconButton(this, 5, 28, 43, GT_GuiIcon.BLACKLIST).setTooltipText(GT_Cover_Fluidfilter.this.trans("237", "Blacklist Fluid"));
            this.fluidFilterButton = new GT_GuiFakeItemButton(this, 10, 81, GT_GuiIcon.SLOT_DARKGRAY);
        }

        private int getNewCoverVariable(int id) {
            switch (id) {
                case 0: {
                    return this.coverVariable & 0xFFFFFFF8 | this.coverVariable & 3;
                }
                case 1: {
                    return this.coverVariable & 0xFFFFFFF8 | (this.coverVariable | 4);
                }
                case 2: {
                    return this.coverVariable & 0xFFFFFFF8 | this.coverVariable & 5;
                }
                case 3: {
                    return this.coverVariable & 0xFFFFFFF8 | (this.coverVariable | 2);
                }
                case 4: {
                    return this.coverVariable & 0xFFFFFFF8 | this.coverVariable & 6;
                }
                case 5: {
                    return this.coverVariable & 0xFFFFFFF8 | (this.coverVariable | 1);
                }
            }
            return this.coverVariable;
        }

        private boolean getClickable(int id) {
            switch (id) {
                case 0: 
                case 1: {
                    return (this.coverVariable >> 2 & 1) != (id & 1);
                }
                case 2: 
                case 3: {
                    return (this.coverVariable >> 1 & 1) != (id & 1);
                }
                case 4: 
                case 5: {
                    return (this.coverVariable & 1) != (id & 1);
                }
            }
            return false;
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b(GT_Cover_Fluidfilter.this.trans("238", "Filter Direction"), 46, 28, -11184811);
            this.field_146289_q.func_78276_b(GT_Cover_Fluidfilter.this.trans("239", "Filter Type"), 46, 46, -11184811);
            this.field_146289_q.func_78276_b(GT_Cover_Fluidfilter.this.trans("240", "Block Flow"), 46, 64, -11184811);
            this.field_146289_q.func_78279_b(this.fluidFilterName, 31, 83, this.gui_width - 40, -14540254);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.field_146127_k)) {
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            ItemStack item;
            for (Object o : this.field_146292_n) {
                if (!(o instanceof GT_GuiIconButton)) continue;
                GT_GuiIconButton b = (GT_GuiIconButton)o;
                b.field_146124_l = this.getClickable(b.field_146127_k);
                if (this.getClickable(1)) {
                    if (b.field_146127_k == 2) {
                        b.setTooltipText(GT_Cover_Fluidfilter.this.trans("219", "Block Output"));
                        continue;
                    }
                    if (b.field_146127_k != 3) continue;
                    b.setTooltipText(GT_Cover_Fluidfilter.this.trans("220", "Allow Output"));
                    continue;
                }
                if (b.field_146127_k == 2) {
                    b.setTooltipText(GT_Cover_Fluidfilter.this.trans("221", "Block Input"));
                    continue;
                }
                if (b.field_146127_k != 3) continue;
                b.setTooltipText(GT_Cover_Fluidfilter.this.trans("222", "Allow Input"));
            }
            Fluid f = FluidRegistry.getFluid((int)(this.coverVariable >>> 3));
            if (f != null && (item = GT_Utility.getFluidDisplayStack(f)) != null) {
                this.fluidFilterButton.setItem(item);
                this.fluidFilterName = item.func_82833_r();
                return;
            }
            this.fluidFilterButton.setItem(null);
            this.fluidFilterName = GT_Cover_Fluidfilter.this.trans("224", "Filter Empty");
        }
    }
}

