/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_Pollution;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkWatchEvent;

public class GT_Pollution {
    private List<ChunkCoordIntPair> pollutionList = new ArrayList<ChunkCoordIntPair>();
    private HashMap<ChunkCoordIntPair, int[]> chunkData;
    private int operationsPerTick = 0;
    private static final short cycleLen = 1200;
    private final World aWorld;
    public static int mPlayerPollution;
    private static int POLLUTIONPACKET_MINVALUE;
    private static GT_PollutionEventHandler EVENT_HANDLER;

    public GT_Pollution(World world) {
        this.aWorld = world;
        this.chunkData = GT_Proxy.dimensionWiseChunkData.get(this.aWorld.field_73011_w.field_76574_g);
        if (this.chunkData == null) {
            this.chunkData = new HashMap(1024);
            GT_Proxy.dimensionWiseChunkData.put(world.field_73011_w.field_76574_g, this.chunkData);
        }
        GT_Proxy.dimensionWisePollution.put(this.aWorld.field_73011_w.field_76574_g, this);
        if (EVENT_HANDLER == null) {
            EVENT_HANDLER = new GT_PollutionEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)EVENT_HANDLER);
        }
    }

    public static void onWorldTick(TickEvent.WorldTickEvent aEvent) {
        if (!GT_Mod.gregtechproxy.mPollution) {
            return;
        }
        GT_Pollution pollutionInstance = GT_Proxy.dimensionWisePollution.get(aEvent.world.field_73011_w.field_76574_g);
        if (pollutionInstance == null) {
            return;
        }
        pollutionInstance.tickPollutionInWorld((int)(aEvent.world.func_82737_E() % 1200L));
    }

    private void tickPollutionInWorld(int aTickID) {
        if (aTickID == 0) {
            this.pollutionList = new ArrayList<ChunkCoordIntPair>(this.chunkData.keySet());
            this.operationsPerTick = this.pollutionList.size() > 0 ? this.pollutionList.size() / 1200 : 0;
        }
        for (int chunksProcessed = 0; chunksProcessed <= this.operationsPerTick && this.pollutionList.size() != 0; ++chunksProcessed) {
            ChunkCoordIntPair actualPos = this.pollutionList.remove(this.pollutionList.size() - 1);
            if (!this.chunkData.containsKey(actualPos)) {
                this.chunkData.put(actualPos, GT_Proxy.getDefaultChunkDataOnCreation());
            }
            int tPollution = this.chunkData.get(actualPos)[1];
            if ((tPollution = (int)(0.9945f * (float)tPollution)) <= 0) {
                tPollution = 0;
            } else if (tPollution > 400000) {
                ChunkCoordIntPair[] tNeighbors = new ChunkCoordIntPair[]{new ChunkCoordIntPair(actualPos.field_77276_a + 1, actualPos.field_77275_b), new ChunkCoordIntPair(actualPos.field_77276_a - 1, actualPos.field_77275_b), new ChunkCoordIntPair(actualPos.field_77276_a, actualPos.field_77275_b + 1), new ChunkCoordIntPair(actualPos.field_77276_a, actualPos.field_77275_b - 1)};
                for (ChunkCoordIntPair neighborPosition : tNeighbors) {
                    int neighborPollution;
                    if (!this.chunkData.containsKey(neighborPosition)) {
                        this.chunkData.put(neighborPosition, GT_Proxy.getDefaultChunkDataOnCreation());
                    }
                    if ((neighborPollution = this.chunkData.get(neighborPosition)[1]) * 6 >= tPollution * 5) continue;
                    int tDiff = tPollution - neighborPollution;
                    neighborPollution = GT_Utility.safeInt((long)neighborPollution + (long)(tDiff /= 20));
                    tPollution -= tDiff;
                    this.chunkData.get((Object)neighborPosition)[1] = neighborPollution;
                }
                if (tPollution > GT_Mod.gregtechproxy.mPollutionSmogLimit) {
                    AxisAlignedBB chunk = AxisAlignedBB.func_72330_a((double)(actualPos.field_77276_a << 4), (double)0.0, (double)(actualPos.field_77275_b << 4), (double)((actualPos.field_77276_a << 4) + 16), (double)256.0, (double)((actualPos.field_77275_b << 4) + 16));
                    List tEntitys = this.aWorld.func_72872_a(EntityLivingBase.class, chunk);
                    for (EntityLivingBase tEnt : tEntitys) {
                        if (tEnt instanceof EntityPlayerMP && ((EntityPlayerMP)tEnt).field_71075_bZ.field_75098_d || GT_Utility.isWearingFullGasHazmat(tEnt)) continue;
                        switch (XSTR.XSTR_INSTANCE.nextInt(3)) {
                            default: {
                                tEnt.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                            }
                            case 1: {
                                tEnt.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                            }
                            case 2: 
                        }
                        tEnt.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                    }
                    if (tPollution > GT_Mod.gregtechproxy.mPollutionPoisonLimit) {
                        for (EntityLivingBase tEnt : tEntitys) {
                            if (tEnt instanceof EntityPlayerMP && ((EntityPlayerMP)tEnt).field_71075_bZ.field_75098_d || GT_Utility.isWearingFullGasHazmat(tEnt)) continue;
                            switch (XSTR.XSTR_INSTANCE.nextInt(4)) {
                                default: {
                                    tEnt.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, tPollution / 500000));
                                }
                                case 1: {
                                    tEnt.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, Math.min(tPollution / 2000, 1000), 1));
                                }
                                case 2: {
                                    tEnt.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, Math.min(tPollution / 4000, 1000), tPollution / 500000));
                                }
                                case 3: 
                            }
                            tEnt.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, Math.min(tPollution / 2000, 1000), 1));
                        }
                        if (tPollution > GT_Mod.gregtechproxy.mPollutionVegetationLimit) {
                            for (int f = 20; f < tPollution / 25000; ++f) {
                                int x = (actualPos.field_77276_a << 4) + XSTR.XSTR_INSTANCE.nextInt(16);
                                int y = 60 + (-f + XSTR.XSTR_INSTANCE.nextInt(f * 2 + 1));
                                int z = (actualPos.field_77275_b << 4) + XSTR.XSTR_INSTANCE.nextInt(16);
                                GT_Pollution.damageBlock(this.aWorld, x, y, z, tPollution > GT_Mod.gregtechproxy.mPollutionSourRainLimit);
                            }
                        }
                    }
                }
            }
            this.chunkData.get((Object)actualPos)[1] = tPollution;
            if (tPollution <= POLLUTIONPACKET_MINVALUE) continue;
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.aWorld.field_73011_w.field_76574_g, (double)(actualPos.field_77276_a << 4), 64.0, (double)(actualPos.field_77275_b << 4), 256.0);
            GT_Values.NW.sendToAllAround(new GT_Packet_Pollution(actualPos, tPollution), point);
        }
    }

    private static void damageBlock(World world, int x, int y, int z, boolean sourRain) {
        if (world.field_72995_K) {
            return;
        }
        Block tBlock = world.func_147439_a(x, y, z);
        int tMeta = world.func_72805_g(x, y, z);
        if (tBlock == Blocks.field_150350_a || tBlock == Blocks.field_150348_b || tBlock == Blocks.field_150354_m || tBlock == Blocks.field_150330_I) {
            return;
        }
        if (tBlock == Blocks.field_150362_t || tBlock == Blocks.field_150361_u || tBlock.func_149688_o() == Material.field_151584_j) {
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150436_aH) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150329_H) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
        }
        if (tBlock == Blocks.field_150395_bd) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150392_bi || tBlock == Blocks.field_150464_aj || tBlock == Blocks.field_150434_aF || tBlock.func_149688_o() == Material.field_151570_A || tBlock == Blocks.field_150440_ba || tBlock == Blocks.field_150394_bc) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150328_O || tBlock == Blocks.field_150327_N || tBlock == Blocks.field_150459_bM || tBlock == Blocks.field_150469_bN || tBlock == Blocks.field_150423_aK || tBlock == Blocks.field_150393_bb) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150345_g || tBlock.func_149688_o() == Material.field_151585_k) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
        }
        if (tBlock == Blocks.field_150375_by) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150341_Y) {
            world.func_147449_b(x, y, z, Blocks.field_150347_e);
        }
        if (tBlock == Blocks.field_150349_c || tBlock.func_149688_o() == Material.field_151577_b) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
        if (tBlock == Blocks.field_150458_ak || tBlock == Blocks.field_150346_d) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150354_m);
        }
        if (sourRain && world.func_72896_J() && (tBlock == Blocks.field_150348_b || tBlock == Blocks.field_150351_n || tBlock == Blocks.field_150347_e) && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a && world.func_72937_j(x, y, z)) {
            if (tBlock == Blocks.field_150348_b) {
                world.func_147449_b(x, y, z, Blocks.field_150347_e);
            } else if (tBlock == Blocks.field_150347_e) {
                world.func_147449_b(x, y, z, Blocks.field_150351_n);
            } else if (tBlock == Blocks.field_150351_n) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150354_m);
            }
        }
    }

    public static void addPollution(IGregTechTileEntity te, int aPollution) {
        GT_Pollution.addPollution(te.getWorld().func_72938_d(te.getXCoord(), te.getZCoord()), aPollution);
    }

    public static void addPollution(Chunk ch, int aPollution) {
        int[] dataArr;
        if (!GT_Mod.gregtechproxy.mPollution) {
            return;
        }
        HashMap<Object, Object> dataMap = GT_Proxy.dimensionWiseChunkData.get(ch.field_76637_e.field_73011_w.field_76574_g);
        if (dataMap == null) {
            dataMap = new HashMap(1024);
            GT_Proxy.dimensionWiseChunkData.put(ch.field_76637_e.field_73011_w.field_76574_g, dataMap);
        }
        if ((dataArr = dataMap.get(ch.func_76632_l())) == null) {
            dataArr = GT_Proxy.getDefaultChunkDataOnCreation();
            dataMap.put(ch.func_76632_l(), dataArr);
        }
        dataArr[1] = dataArr[1] + aPollution;
        if (dataArr[1] < 0) {
            dataArr[1] = 0;
        }
    }

    public static int getPollution(IGregTechTileEntity te) {
        return GT_Pollution.getPollution(te.getWorld().func_72938_d(te.getXCoord(), te.getZCoord()));
    }

    public static int getPollution(Chunk ch) {
        if (!GT_Mod.gregtechproxy.mPollution) {
            return 0;
        }
        HashMap<ChunkCoordIntPair, int[]> dataMap = GT_Proxy.dimensionWiseChunkData.get(ch.field_76637_e.field_73011_w.field_76574_g);
        if (dataMap == null || dataMap.get(ch.func_76632_l()) == null) {
            return 0;
        }
        return dataMap.get(ch.func_76632_l())[1];
    }

    public static int getPollution(ChunkCoordIntPair aCh, int aDim) {
        if (!GT_Mod.gregtechproxy.mPollution) {
            return 0;
        }
        HashMap<ChunkCoordIntPair, int[]> dataMap = GT_Proxy.dimensionWiseChunkData.get(aDim);
        if (dataMap == null || dataMap.get(aCh) == null) {
            return 0;
        }
        return dataMap.get(aCh)[1];
    }

    @Deprecated
    public static void addPollution(World aWorld, ChunkPosition aPos, int aPollution) {
        GT_Pollution.addPollution(aWorld.func_72938_d(aPos.field_151329_a, aPos.field_151328_c), aPollution);
    }

    static {
        POLLUTIONPACKET_MINVALUE = 1000;
    }

    public class GT_PollutionEventHandler {
        @SubscribeEvent
        public void chunkWatch(ChunkWatchEvent.Watch event) {
            int pollution;
            if (GT_Pollution.this.chunkData.containsKey(event.chunk) && (pollution = ((int[])GT_Pollution.this.chunkData.get(event.chunk))[1]) > POLLUTIONPACKET_MINVALUE) {
                GT_Values.NW.sendToPlayer(new GT_Packet_Pollution(event.chunk, pollution), event.player);
            }
        }
    }
}

