/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_BasicMachine;
import gregtech.api.gui.GT_GUIContainer_BasicMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMachineCallback;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_Cleanroom;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class GT_MetaTileEntity_BasicMachine
extends GT_MetaTileEntity_BasicTank
implements IMachineCallback<GT_MetaTileEntity_Cleanroom> {
    protected static final int DID_NOT_FIND_RECIPE = 0;
    protected static final int FOUND_RECIPE_BUT_DID_NOT_MEET_REQUIREMENTS = 1;
    protected static final int FOUND_AND_SUCCESSFULLY_USED_RECIPE = 2;
    public static final int OTHER_SLOT_COUNT = 4;
    public final ItemStack[] mOutputItems;
    public final int mInputSlotCount;
    public final int mAmperage;
    public boolean mAllowInputFromOutputSide = false;
    public boolean mFluidTransfer = false;
    public boolean mItemTransfer = false;
    public boolean mHasBeenUpdated = false;
    public boolean mStuttering = false;
    public boolean mCharge = false;
    public boolean mDecharge = false;
    public int mMainFacing = -1;
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;
    public int mEUt = 0;
    public int mOutputBlocked = 0;
    public FluidStack mOutputFluid;
    public String mGUIName;
    public String mNEIName;
    @Deprecated
    public GT_MetaTileEntity_Cleanroom mCleanroom;
    protected GT_Recipe mLastRecipe = null;
    private FluidStack mFluidOut;

    public GT_MetaTileEntity_BasicMachine(int aID, String aName, String aNameRegional, int aTier, int aAmperage, String aDescription, int aInputSlotCount, int aOutputSlotCount, String aGUIName, String aNEIName, ITexture ... aOverlays) {
        super(aID, aName, aNameRegional, aTier, 4 + aInputSlotCount + aOutputSlotCount + 1, aDescription, aOverlays);
        this.mInputSlotCount = Math.max(0, aInputSlotCount);
        this.mOutputItems = new ItemStack[Math.max(0, aOutputSlotCount)];
        this.mAmperage = aAmperage;
        this.mGUIName = aGUIName;
        this.mNEIName = aNEIName;
    }

    public GT_MetaTileEntity_BasicMachine(int aID, String aName, String aNameRegional, int aTier, int aAmperage, String[] aDescription, int aInputSlotCount, int aOutputSlotCount, String aGUIName, String aNEIName, ITexture ... aOverlays) {
        super(aID, aName, aNameRegional, aTier, 4 + aInputSlotCount + aOutputSlotCount + 1, aDescription, aOverlays);
        this.mInputSlotCount = Math.max(0, aInputSlotCount);
        this.mOutputItems = new ItemStack[Math.max(0, aOutputSlotCount)];
        this.mAmperage = aAmperage;
        this.mGUIName = aGUIName;
        this.mNEIName = aNEIName;
    }

    public GT_MetaTileEntity_BasicMachine(String aName, int aTier, int aAmperage, String aDescription, ITexture[][][] aTextures, int aInputSlotCount, int aOutputSlotCount, String aGUIName, String aNEIName) {
        super(aName, aTier, 4 + aInputSlotCount + aOutputSlotCount + 1, aDescription, aTextures);
        this.mInputSlotCount = Math.max(0, aInputSlotCount);
        this.mOutputItems = new ItemStack[Math.max(0, aOutputSlotCount)];
        this.mAmperage = aAmperage;
        this.mGUIName = aGUIName;
        this.mNEIName = aNEIName;
    }

    public GT_MetaTileEntity_BasicMachine(String aName, int aTier, int aAmperage, String[] aDescription, ITexture[][][] aTextures, int aInputSlotCount, int aOutputSlotCount, String aGUIName, String aNEIName) {
        super(aName, aTier, 4 + aInputSlotCount + aOutputSlotCount + 1, aDescription, aTextures);
        this.mInputSlotCount = Math.max(0, aInputSlotCount);
        this.mOutputItems = new ItemStack[Math.max(0, aOutputSlotCount)];
        this.mAmperage = aAmperage;
        this.mGUIName = aGUIName;
        this.mNEIName = aNEIName;
    }

    protected boolean isValidMainFacing(byte aSide) {
        return aSide > 1;
    }

    public boolean setMainFacing(byte aSide) {
        if (!this.isValidMainFacing(aSide)) {
            return false;
        }
        this.mMainFacing = aSide;
        if (this.getBaseMetaTileEntity().getFrontFacing() == this.mMainFacing) {
            this.getBaseMetaTileEntity().setFrontFacing(GT_Utility.getOppositeSide(aSide));
        }
        this.onFacingChange();
        this.onMachineBlockUpdate();
        return true;
    }

    @Override
    public GT_MetaTileEntity_Cleanroom getCallbackBase() {
        return this.mCleanroom;
    }

    @Override
    public void setCallbackBase(GT_MetaTileEntity_Cleanroom callback) {
        this.mCleanroom = callback;
    }

    @Override
    public Class<GT_MetaTileEntity_Cleanroom> getType() {
        return GT_MetaTileEntity_Cleanroom.class;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[14][17][];
        aTextures = Arrays.copyOf(aTextures, 14);
        for (int i = 0; i < aTextures.length; ++i) {
            if (aTextures[i] == null) continue;
            for (int c = -1; c < 16; c = (int)((byte)(c + 1))) {
                if (rTextures[i][c + 1] != null) continue;
                rTextures[i][c + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][c + 1], aTextures[i]};
            }
        }
        for (byte c = -1; c < 16; c = (byte)(c + 1)) {
            if (rTextures[0][c + 1] == null) {
                rTextures[0][c + 1] = this.getSideFacingActive(c);
            }
            if (rTextures[1][c + 1] == null) {
                rTextures[1][c + 1] = this.getSideFacingInactive(c);
            }
            if (rTextures[2][c + 1] == null) {
                rTextures[2][c + 1] = this.getFrontFacingActive(c);
            }
            if (rTextures[3][c + 1] == null) {
                rTextures[3][c + 1] = this.getFrontFacingInactive(c);
            }
            if (rTextures[4][c + 1] == null) {
                rTextures[4][c + 1] = this.getTopFacingActive(c);
            }
            if (rTextures[5][c + 1] == null) {
                rTextures[5][c + 1] = this.getTopFacingInactive(c);
            }
            if (rTextures[6][c + 1] == null) {
                rTextures[6][c + 1] = this.getBottomFacingActive(c);
            }
            if (rTextures[7][c + 1] == null) {
                rTextures[7][c + 1] = this.getBottomFacingInactive(c);
            }
            if (rTextures[8][c + 1] == null) {
                rTextures[8][c + 1] = this.getBottomFacingPipeActive(c);
            }
            if (rTextures[9][c + 1] == null) {
                rTextures[9][c + 1] = this.getBottomFacingPipeInactive(c);
            }
            if (rTextures[10][c + 1] == null) {
                rTextures[10][c + 1] = this.getTopFacingPipeActive(c);
            }
            if (rTextures[11][c + 1] == null) {
                rTextures[11][c + 1] = this.getTopFacingPipeInactive(c);
            }
            if (rTextures[12][c + 1] == null) {
                rTextures[12][c + 1] = this.getSideFacingPipeActive(c);
            }
            if (rTextures[13][c + 1] != null) continue;
            rTextures[13][c + 1] = this.getSideFacingPipeInactive(c);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[this.mMainFacing < 2 ? (aSide == aFacing ? (aActive ? 2 : 3) : (aSide == 0 ? (aActive ? 6 : 7) : (aSide == 1 ? (aActive ? 4 : 5) : (aActive ? 0 : 1)))) : (aSide == this.mMainFacing ? (aActive ? 2 : 3) : (this.showPipeFacing() && aSide == aFacing ? (aSide == 0 ? (aActive ? 8 : 9) : (aSide == 1 ? (aActive ? 10 : 11) : (aActive ? 12 : 13))) : (aSide == 0 ? (aActive ? 6 : 7) : (aSide == 1 ? (aActive ? 4 : 5) : (aActive ? 0 : 1)))))][aColorIndex + 1];
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex > 0 && super.isValidSlot(aIndex) && aIndex != 4 + this.mInputSlotCount + this.mOutputItems.length;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return this.mMainFacing > 1 || aFacing > 1;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return aSide != this.mMainFacing;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return aSide != this.mMainFacing && (this.mAllowInputFromOutputSide || aSide != this.getBaseMetaTileEntity().getFrontFacing());
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        return aSide != this.mMainFacing;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public long maxAmperesIn() {
        return (long)this.mEUt * 2L / GT_Values.V[this.mTier] + 1L;
    }

    @Override
    public int getInputSlot() {
        return 4;
    }

    @Override
    public int getOutputSlot() {
        return 4 + this.mInputSlotCount;
    }

    @Override
    public int getStackDisplaySlot() {
        return 2;
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 1;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 1;
    }

    @Override
    public int rechargerSlotCount() {
        return this.mCharge ? 1 : 0;
    }

    @Override
    public int dechargerSlotCount() {
        return this.mDecharge ? 1 : 0;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.getFillableStack() != null || this.getRecipeList() != null && this.getRecipeList().containsInput(aFluid);
    }

    @Override
    public boolean isFluidChangingAllowed() {
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return true;
    }

    @Override
    public FluidStack getDisplayedFluid() {
        return this.displaysOutputFluid() ? this.getDrainableStack() : null;
    }

    @Override
    public FluidStack getDrainableStack() {
        return this.mFluidOut;
    }

    @Override
    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluidOut = aFluid;
        return this.mFluidOut;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (!GT_Mod.gregtechproxy.mForceFreeFace) {
            aBaseMetaTileEntity.openGUI(aPlayer);
            return true;
        }
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (!aBaseMetaTileEntity.getAirAtSide(i)) continue;
            aBaseMetaTileEntity.openGUI(aPlayer);
            return true;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "No free Side!");
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), this.mGUIName, GT_Utility.isStringValid(this.mNEIName) ? this.mNEIName : (this.getRecipeList() != null ? this.getRecipeList().mUnlocalizedName : ""));
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        this.mMainFacing = -1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mFluidTransfer", this.mFluidTransfer);
        aNBT.func_74757_a("mItemTransfer", this.mItemTransfer);
        aNBT.func_74757_a("mHasBeenUpdated", this.mHasBeenUpdated);
        aNBT.func_74757_a("mAllowInputFromOutputSide", this.mAllowInputFromOutputSide);
        aNBT.func_74768_a("mEUt", this.mEUt);
        aNBT.func_74768_a("mMainFacing", this.mMainFacing);
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        if (this.mOutputFluid != null) {
            aNBT.func_74782_a("mOutputFluid", (NBTBase)this.mOutputFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.mFluidOut != null) {
            aNBT.func_74782_a("mFluidOut", (NBTBase)this.mFluidOut.writeToNBT(new NBTTagCompound()));
        }
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            if (this.mOutputItems[i] == null) continue;
            aNBT.func_74782_a("mOutputItem" + i, (NBTBase)this.mOutputItems[i].func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mFluidTransfer = aNBT.func_74767_n("mFluidTransfer");
        this.mItemTransfer = aNBT.func_74767_n("mItemTransfer");
        this.mHasBeenUpdated = aNBT.func_74767_n("mHasBeenUpdated");
        this.mAllowInputFromOutputSide = aNBT.func_74767_n("mAllowInputFromOutputSide");
        this.mEUt = aNBT.func_74762_e("mEUt");
        this.mMainFacing = aNBT.func_74762_e("mMainFacing");
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        this.mOutputFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mOutputFluid"));
        this.mFluidOut = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluidOut"));
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            this.mOutputItems[i] = GT_Utility.loadItem(aNBT, "mOutputItem" + i);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.doDisplayThings();
            boolean tSucceeded = false;
            if (this.mMaxProgresstime > 0 && (this.mProgresstime >= 0 || aBaseMetaTileEntity.isAllowedToWork())) {
                aBaseMetaTileEntity.setActive(true);
                if (this.mProgresstime < 0 || this.drainEnergyForProcess(this.mEUt)) {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        for (int i = 0; i < this.mOutputItems.length; ++i) {
                            for (int j = 0; j < this.mOutputItems.length && !aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot() + (j + i) % this.mOutputItems.length, this.mOutputItems[i]); ++j) {
                            }
                        }
                        if (this.mOutputFluid != null) {
                            if (this.getDrainableStack() == null) {
                                this.setDrainableStack(this.mOutputFluid.copy());
                            } else if (this.mOutputFluid.isFluidEqual(this.getDrainableStack())) {
                                this.getDrainableStack().amount += this.mOutputFluid.amount;
                            }
                        }
                        Arrays.fill(this.mOutputItems, null);
                        this.mOutputFluid = null;
                        this.mEUt = 0;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        this.mStuttering = false;
                        tSucceeded = true;
                        this.endProcess();
                    }
                    if (this.mProgresstime > 5) {
                        this.mStuttering = false;
                    }
                } else if (!this.mStuttering) {
                    this.stutterProcess();
                    if (this.canHaveInsufficientEnergy()) {
                        this.mProgresstime = -100;
                    }
                    this.mStuttering = true;
                }
            } else {
                aBaseMetaTileEntity.setActive(false);
            }
            boolean tRemovedOutputFluid = false;
            if (this.doesAutoOutputFluids() && this.getDrainableStack() != null && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing && (tSucceeded || aTick % 20L == 0L)) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTank = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing());
                if (tTank != null && (tDrained = this.drain(1000, false)) != null && (tFilledAmount = tTank.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), tDrained, false)) > 0) {
                    tTank.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), this.drain(tFilledAmount, true), true);
                }
                if (this.getDrainableStack() == null) {
                    tRemovedOutputFluid = true;
                }
            }
            if (this.doesAutoOutput() && !this.isOutputEmpty() && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing && (tSucceeded || this.mOutputBlocked % 300 == 1 || aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L)) {
                TileEntity tTileEntity2 = aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getFrontFacing());
                long tStoredEnergy = aBaseMetaTileEntity.getUniversalEnergyStored();
                int tMaxStacks = (int)(tStoredEnergy / 64L);
                if (tMaxStacks > this.mOutputItems.length) {
                    tMaxStacks = this.mOutputItems.length;
                }
                int tCost = GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, tTileEntity2, aBaseMetaTileEntity.getFrontFacing(), aBaseMetaTileEntity.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, tMaxStacks);
                aBaseMetaTileEntity.decreaseStoredEnergyUnits(tCost, true);
            }
            if (this.mOutputBlocked != 0) {
                this.mOutputBlocked = this.isOutputEmpty() ? 0 : ++this.mOutputBlocked;
            }
            if (this.allowToCheckRecipe()) {
                if (this.mMaxProgresstime <= 0 && aBaseMetaTileEntity.isAllowedToWork() && (tRemovedOutputFluid || tSucceeded || aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) && this.hasEnoughEnergyToCheckRecipe()) {
                    if (this.checkRecipe() == 2) {
                        int i;
                        if (this.mInventory[3] != null && this.mInventory[3].field_77994_a <= 0) {
                            this.mInventory[3] = null;
                        }
                        int j = i + this.mInputSlotCount;
                        for (i = this.getInputSlot(); i < j; ++i) {
                            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
                            this.mInventory[i] = null;
                        }
                        for (i = 0; i < this.mOutputItems.length; ++i) {
                            this.mOutputItems[i] = GT_Utility.copy(this.mOutputItems[i]);
                            if (this.mOutputItems[i] != null && this.mOutputItems[i].field_77994_a > 64) {
                                this.mOutputItems[i].field_77994_a = 64;
                            }
                            this.mOutputItems[i] = GT_OreDictUnificator.get(true, this.mOutputItems[i]);
                        }
                        if (this.mFluid != null && this.mFluid.amount <= 0) {
                            this.mFluid = null;
                        }
                        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                        if (GT_Utility.isDebugItem(this.mInventory[this.dechargerSlotStartIndex()])) {
                            this.mMaxProgresstime = 1;
                            this.mEUt = 1;
                        }
                        this.startProcess();
                    } else {
                        this.mMaxProgresstime = 0;
                        Arrays.fill(this.mOutputItems, null);
                        this.mOutputFluid = null;
                    }
                }
            } else if (!this.mStuttering) {
                this.stutterProcess();
                this.mStuttering = true;
            }
        }
    }

    protected void doDisplayThings() {
        if (this.mMainFacing < 2 && this.getBaseMetaTileEntity().getFrontFacing() > 1) {
            this.mMainFacing = this.getBaseMetaTileEntity().getFrontFacing();
        }
        if (this.mMainFacing >= 2 && !this.mHasBeenUpdated) {
            this.mHasBeenUpdated = true;
            this.getBaseMetaTileEntity().setFrontFacing(this.getBaseMetaTileEntity().getBackFacing());
        }
        if (this.displaysInputFluid()) {
            int tDisplayStackSlot = 4 + this.mInputSlotCount + this.mOutputItems.length;
            if (this.getFillableStack() == null) {
                if (ItemList.Display_Fluid.isStackEqual(this.mInventory[tDisplayStackSlot], true, true)) {
                    this.mInventory[tDisplayStackSlot] = null;
                }
            } else {
                this.mInventory[tDisplayStackSlot] = GT_Utility.getFluidDisplayStack(this.getFillableStack(), this.displaysStackSize());
            }
        }
    }

    protected boolean hasEnoughEnergyToCheckRecipe() {
        return this.getBaseMetaTileEntity().isUniversalEnergyStored(this.getMinimumStoredEU() / 2L);
    }

    protected boolean drainEnergyForProcess(long aEUt) {
        return this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEUt, false);
    }

    protected void calculateOverclockedNess(GT_Recipe aRecipe) {
        this.calculateOverclockedNess(aRecipe.mEUt, aRecipe.mDuration);
    }

    protected void calculateOverclockedNess(int aEUt, int aDuration) {
        if (this.mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= GT_Values.V[this.mTier - 1] * (long)this.mAmperage) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= 1;
                xEUt = this.mMaxProgresstime == 0 ? xEUt >> 1 : xEUt << 2;
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = (int)xEUt;
                if (this.mEUt == 0) {
                    this.mEUt = 1;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
    }

    protected ItemStack getSpecialSlot() {
        return this.mInventory[3];
    }

    protected ItemStack getOutputAt(int aIndex) {
        return this.mInventory[this.getOutputSlot() + aIndex];
    }

    protected ItemStack[] getAllOutputs() {
        ItemStack[] rOutputs = new ItemStack[this.mOutputItems.length];
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            rOutputs[i] = this.getOutputAt(i);
        }
        return rOutputs;
    }

    protected boolean canOutput(GT_Recipe aRecipe) {
        return aRecipe != null && (aRecipe.mNeedsEmptyOutput ? this.isOutputEmpty() && this.getDrainableStack() == null : this.canOutput(aRecipe.getFluidOutput(0)) && this.canOutput(aRecipe.mOutputs));
    }

    protected boolean canOutput(ItemStack ... aOutputs) {
        if (aOutputs == null) {
            return true;
        }
        ItemStack[] tOutputSlots = this.getAllOutputs();
        for (int i = 0; i < tOutputSlots.length && i < aOutputs.length; ++i) {
            if (tOutputSlots[i] == null || aOutputs[i] == null || GT_Utility.areStacksEqual(tOutputSlots[i], aOutputs[i], false) && tOutputSlots[i].field_77994_a + aOutputs[i].field_77994_a <= tOutputSlots[i].func_77976_d()) continue;
            ++this.mOutputBlocked;
            return false;
        }
        return true;
    }

    protected boolean canOutput(FluidStack aOutput) {
        return this.getDrainableStack() == null || aOutput == null || this.getDrainableStack().isFluidEqual(aOutput) && (this.getDrainableStack().amount <= 0 || this.getDrainableStack().amount + aOutput.amount <= this.getCapacity());
    }

    protected ItemStack getInputAt(int aIndex) {
        return this.mInventory[this.getInputSlot() + aIndex];
    }

    protected ItemStack[] getAllInputs() {
        ItemStack[] rInputs = new ItemStack[this.mInputSlotCount];
        for (int i = 0; i < this.mInputSlotCount; ++i) {
            rInputs[i] = this.getInputAt(i);
        }
        return rInputs;
    }

    protected boolean isOutputEmpty() {
        boolean rIsEmpty = true;
        for (ItemStack tOutputSlotContent : this.getAllOutputs()) {
            if (tOutputSlotContent == null) continue;
            rIsEmpty = false;
            break;
        }
        return rIsEmpty;
    }

    protected boolean displaysInputFluid() {
        return true;
    }

    protected boolean displaysOutputFluid() {
        return true;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mMainFacing = aValue;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.mMainFacing;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        super.doSound(aIndex, aX, aY, aZ);
        if (aIndex == 8) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(210), 100, 1.0f, aX, aY, aZ);
        }
    }

    public boolean doesAutoOutput() {
        return this.mItemTransfer;
    }

    public boolean doesAutoOutputFluids() {
        return this.mFluidTransfer;
    }

    public boolean allowToCheckRecipe() {
        return true;
    }

    public boolean showPipeFacing() {
        return true;
    }

    public void startProcess() {
    }

    public void endProcess() {
    }

    public void abortProcess() {
    }

    public void stutterProcess() {
        if (this.useStandardStutterSound()) {
            this.sendSound((byte)8);
        }
    }

    public boolean canHaveInsufficientEnergy() {
        return true;
    }

    public boolean useStandardStutterSound() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.BLUE + this.mNEIName + EnumChatFormatting.RESET, "Progress:", EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", "Stored Energy:", EnumChatFormatting.GREEN + Long.toString(this.getBaseMetaTileEntity().getStoredEU()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(this.getBaseMetaTileEntity().getEUCapacity()) + EnumChatFormatting.RESET + " EU", "Probably uses: " + EnumChatFormatting.RED + Integer.toString(this.mEUt) + EnumChatFormatting.RESET + " EU/t at " + EnumChatFormatting.RED + Integer.toString(this.mEUt == 0 ? 0 : this.mAmperage) + EnumChatFormatting.RESET + " A"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing() || aSide == this.mMainFacing) {
            this.mAllowInputFromOutputSide = !this.mAllowInputFromOutputSide;
            GT_Utility.sendChatToPlayer(aPlayer, this.mAllowInputFromOutputSide ? this.trans("095", "Input from Output Side allowed") : this.trans("096", "Input from Output Side forbidden"));
        }
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return aSide != this.mMainFacing || GregTech_API.getCoverBehavior(aCoverID.toStack()).isGUIClickable(aSide, GT_Utility.stackToInt(aCoverID.toStack()), 0, this.getBaseMetaTileEntity());
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide != this.mMainFacing && aIndex >= this.getOutputSlot() && aIndex < this.getOutputSlot() + this.mOutputItems.length;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        int i;
        if (aSide == this.mMainFacing || aIndex < this.getInputSlot() || aIndex >= this.getInputSlot() + this.mInputSlotCount || !this.mAllowInputFromOutputSide && aSide == aBaseMetaTileEntity.getFrontFacing()) {
            return false;
        }
        int j = i + this.mInputSlotCount;
        for (i = this.getInputSlot(); i < j; ++i) {
            if (!GT_Utility.areStacksEqual(GT_OreDictUnificator.get(aStack), this.mInventory[i])) continue;
            return i == aIndex;
        }
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return null;
    }

    public int checkRecipe() {
        return this.checkRecipe(false);
    }

    public static boolean isValidForLowGravity(GT_Recipe tRecipe, int dimId) {
        return DimensionManager.getProvider((int)dimId).getClass().getName().contains("Orbit") || DimensionManager.getProvider((int)dimId).getClass().getName().endsWith("Space") || DimensionManager.getProvider((int)dimId).getClass().getName().endsWith("Asteroids") || DimensionManager.getProvider((int)dimId).getClass().getName().endsWith("SS") || DimensionManager.getProvider((int)dimId).getClass().getName().contains("SpaceStation");
    }

    public int checkRecipe(boolean skipOC) {
        int i;
        GT_Recipe.GT_Recipe_Map tMap = this.getRecipeList();
        if (tMap == null) {
            return 0;
        }
        GT_Recipe tRecipe = tMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[this.mTier], new FluidStack[]{this.getFillableStack()}, this.getSpecialSlot(), this.getAllInputs());
        if (tRecipe == null) {
            return 0;
        }
        if (GT_Mod.gregtechproxy.mLowGravProcessing && (tRecipe.mSpecialValue == -100 || tRecipe.mSpecialValue == -300) && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(tRecipe, this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
            return 1;
        }
        if (tRecipe.mCanBeBuffered) {
            this.mLastRecipe = tRecipe;
        }
        if (!this.canOutput(tRecipe)) {
            ++this.mOutputBlocked;
            return 1;
        }
        if (tRecipe.mSpecialValue == -200 && (this.getCallbackBase() == null || this.getCallbackBase().mEfficiency == 0)) {
            return 1;
        }
        if (!tRecipe.isRecipeInputEqual(true, new FluidStack[]{this.getFillableStack()}, this.getAllInputs())) {
            return 1;
        }
        for (i = 0; i < this.mOutputItems.length; ++i) {
            if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= tRecipe.getOutputChance(i)) continue;
            this.mOutputItems[i] = tRecipe.getOutput(i);
        }
        if (tRecipe.mSpecialValue == -200 || tRecipe.mSpecialValue == -300) {
            for (i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null || this.getBaseMetaTileEntity().getRandomNumber(10000) <= this.getCallbackBase().mEfficiency) continue;
                if (GT_Values.debugCleanroom) {
                    GT_Log.out.println("BasicMachine: Voiding output due to efficiency failure. mEfficiency = " + this.getCallbackBase().mEfficiency);
                }
                this.mOutputItems[i] = null;
            }
        }
        this.mOutputFluid = tRecipe.getFluidOutput(0);
        if (!skipOC) {
            this.calculateOverclockedNess(tRecipe);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
        }
        return 2;
    }

    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottomFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getBottomFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }
}

