/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.loaders.oreprocessing.ProcessingLog;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GT_MetaTileEntity_PyrolyseOven
extends GT_MetaTileEntity_MultiBlockBase {
    private int coilMetaID;
    private final int CASING_INDEX = 1090;

    public GT_MetaTileEntity_PyrolyseOven(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_PyrolyseOven(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Pyrolyse Oven", "Industrial Charcoal producer and Oil from Plants", "Size(WxHxD): 5x4x5, Controller (Bottom center)", "3x1x3 of Heating Coils (At the center of the bottom layer)", "1x Input Hatch/Bus (Centered 3x1x3 area in Top layer)", "1x Output Hatch/Bus (Any bottom layer casing)", "1x Maintenance Hatch (Any bottom layer casing)", "1x Muffler Hatch (Centered 3x1x3 area in Top layer)", "1x Energy Hatch (Any bottom layer casing)", "Pyrolyse Oven Casings for the rest (60 at least!)", "Processing speed scales linearly with Coil tier:", "CuNi: 50%, FeAlCr: 100%, Ni4Cr: 150%, Fe50CW: 200%, etc.", "EU/t is not affected by Coil tier", "Causes " + 20 * this.getPollutionPerTick(null) + " Pollution per second"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "PyrolyseOven.png");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        ItemStack[] tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[tInputList.size()]), 0, 2);
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block2: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block2;
            }
        }
        FluidStack[] tFluids = Arrays.copyOfRange(tFluidList.toArray(new FluidStack[tInputList.size()]), 0, 1);
        if (tInputList.size() > 0) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe == null) {
                for (ItemStack is : tInputs) {
                    for (int id : OreDictionary.getOreIDs((ItemStack)is)) {
                        if (!OreDictionary.getOreName((int)id).equals("logWood")) continue;
                        ProcessingLog.addPyrolyeOvenRecipes(is);
                    }
                }
                tRecipe = GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            }
            if (tRecipe != null && tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(this.mMaxProgresstime * 2 / (1 + this.coilMetaID), 1);
                if (tRecipe.mOutputs.length > 0) {
                    this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
                }
                if (tRecipe.mFluidOutputs.length > 0) {
                    this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
                }
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 2;
        Block CasingBlock = Loader.isModLoaded((String)"dreamcraft") ? GameRegistry.findBlock((String)"dreamcraft", (String)"gt.blockcasingsNH") : GregTech_API.sBlockCasings1;
        byte CasingMeta = Loader.isModLoaded((String)"dreamcraft") ? (byte)2 : 0;
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        boolean firstCoil = true;
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int h = 0; h < 4; ++h) {
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j);
                    if (i != -2 && i != 2 && j != -2 && j != 2) {
                        if (h == 0) {
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != GregTech_API.sBlockCasings5) {
                                return false;
                            }
                            byte metaID = aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j);
                            if (metaID > 8) {
                                return false;
                            }
                            if (firstCoil) {
                                this.coilMetaID = metaID;
                                firstCoil = false;
                                continue;
                            }
                            if (metaID == this.coilMetaID) continue;
                            return false;
                        }
                        if (h == 3) {
                            if (this.addInputToMachineList(tTileEntity, 1090) || this.addMufflerToMachineList(tTileEntity, 1090)) continue;
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != CasingBlock) {
                                return false;
                            }
                            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) == CasingMeta) continue;
                            return false;
                        }
                        if (aBaseMetaTileEntity.getAirOffset(xDir + i, h, zDir + j)) continue;
                        return false;
                    }
                    if (h == 0) {
                        if (this.addMaintenanceToMachineList(tTileEntity, 1090) || this.addOutputToMachineList(tTileEntity, 1090) || this.addEnergyInputToMachineList(tTileEntity, 1090) || xDir + i == 0 && zDir + j == 0) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != CasingBlock) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) == CasingMeta) continue;
                        return false;
                    }
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != CasingBlock) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) == CasingMeta) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 30;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PyrolyseOven(this.mName);
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir * 2;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir * 2;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                if (aBaseMetaTileEntity.getBlock(xPos, tY, zPos) != GregTech_API.sBlockCasings1 || aBaseMetaTileEntity.getMetaID(xPos, tY, zPos) != 13) continue;
                aBaseMetaTileEntity.getWorld().func_147465_d(xPos, (int)tY, zPos, GregTech_API.sBlockCasings5, 1, 3);
            }
        }
    }
}

