/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_HPSteam
extends GT_MetaTileEntity_LargeTurbine {
    public boolean achievement = false;
    private boolean looseFit = false;

    public GT_MetaTileEntity_LargeTurbine_HPSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_HPSteam(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1];
        iTextureArray[1] = aFacing == aSide ? (aActive ? new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_TI_ACTIVE5) : new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_TI5)) : Textures.BlockIcons.casingTexturePages[0][59];
        return iTextureArray;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large High Pressure Steam Turbine", "Size(WxHxD): 3x3x4 (Hollow), Controller (Front centered)", "1x Superheated Steam Input Hatch (Side centered)", "1x Maintenance Hatch (Side centered)", "1x Dynamo Hatch (Back centered)", "1x Output Hatch for Steam (Side centered)", "Titanium Turbine Casings for the rest (24 at least!)", "Needs a Turbine Item (Inside controller GUI)", "Output depending on Rotor and fitting", "Use screwdriver to adjust fitting of turbine"};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_HPSteam(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 11;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 59;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        if (this.looseFit) {
            aOptFlow *= 4;
            if (aBaseEff > 10000) {
                aOptFlow = (int)((double)aOptFlow * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                aBaseEff = 7500;
            } else if (aBaseEff > 7500) {
                aOptFlow = (int)((double)aOptFlow * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            } else {
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            }
        }
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        int remainingFlow = GT_Utility.safeInt((long)((float)aOptFlow * 1.25f));
        this.realOptFlow = aOptFlow;
        this.storedFluid = 0;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            String fluidName = aFluids.get(i).getFluid().getUnlocalizedName(aFluids.get(i));
            if (fluidName.equals("ic2.fluidSuperheatedSteam")) {
                flow = Math.min(aFluids.get((int)i).amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluids.get(i), flow));
                this.storedFluid += aFluids.get((int)i).amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                try {
                    GT_Mod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "efficientsteam");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.achievement = true;
                continue;
            }
            if (!fluidName.equals("fluid.steam") && !fluidName.equals("ic2.fluidSteam") && !fluidName.equals("fluid.mfr.steam.still.name")) continue;
            this.depleteInput(new FluidStack(aFluids.get(i), aFluids.get((int)i).amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        this.addOutput(GT_ModHandler.getSteam(totalFlow));
        if (totalFlow != aOptFlow) {
            float efficiency = 1.0f - Math.abs((float)(totalFlow - aOptFlow) / (float)aOptFlow);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, GT_Utility.safeInt((long)tEU * (long)aBaseEff / 10000L));
        } else {
            tEU = GT_Utility.safeInt((long)tEU * (long)aBaseEff / 10000L);
        }
        return tEU;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit ^= true;
            GT_Utility.sendChatToPlayer(aPlayer, this.looseFit ? this.trans("500", "Fitting: Loose - More Flow") : this.trans("501", "Fitting: Tight - More Efficiency"));
        }
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && XSTR.XSTR_INSTANCE.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public String[] getInfoData() {
        ((GT_MetaTileEntity_LargeTurbine)this).looseFit = this.looseFit;
        return super.getInfoData();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }
}

