/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.GT_Mod;
import gregtech.api.util.GT_LanguageManager;
import gregtech.common.items.armor.ArmorCalculation;
import gregtech.common.items.armor.ModularArmor_Item;
import gregtech.common.items.armor.components.ArmorComponent;
import gregtech.common.items.armor.components.StatType;
import gregtech.common.items.armor.gui.ContainerBasicArmor;
import gregtech.common.items.armor.gui.InventoryArmor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class ArmorData {
    public int type;
    public int armorTier;
    public List info;
    public boolean isTopItem;
    public int tooltipUpdate;
    public boolean openGui;
    public ArmorData helmet;
    public ArmorData chestplate;
    public ArmorData leggings;
    public ArmorData boots;
    public Map<StatType, Float> mStat = new HashMap<StatType, Float>();
    public Map<StatType, Boolean> mBStat = new HashMap<StatType, Boolean>();
    static ArrayList<StatType> updateArmorStatTypeList;
    public int maxCharge;
    public int charge;
    public FluidStack fluid;
    public float maxWeight;

    public ArmorData(EntityPlayer player, ItemStack stack, int type, int tier) {
        if (updateArmorStatTypeList == null) {
            updateArmorStatTypeList = new ArrayList();
            updateArmorStatTypeList.add(StatType.MAGNET);
            updateArmorStatTypeList.add(StatType.THORNS);
            updateArmorStatTypeList.add(StatType.PROCESSINGPOWER);
            updateArmorStatTypeList.add(StatType.PROCESSINGPOWERUSED);
        }
        this.type = type;
        this.armorTier = tier;
        ContainerBasicArmor tmp = new ContainerBasicArmor(player, new InventoryArmor(ModularArmor_Item.class, stack));
        this.calculateArmor(tmp.mInvArmor.parts);
        switch (tier) {
            case 0: {
                this.maxCharge = 0;
                break;
            }
            case 1: {
                this.maxCharge = 250000;
                break;
            }
            case 2: {
                this.maxCharge = 1000000;
            }
        }
        this.readNBT(stack.func_77978_p());
    }

    private void readNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("Charge")) {
            this.charge = nbt.func_74762_e("Charge");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        nbt.func_74768_a("Charge", this.charge);
    }

    public ArmorData calculateArmor(ItemStack[] parts) {
        this.mStat.clear();
        this.mBStat.clear();
        for (ItemStack itemStack : parts) {
            if (itemStack == null || !ArmorComponent.mStacks.containsKey(itemStack.func_77977_a())) continue;
            ArmorComponent.mStacks.get(itemStack.func_77977_a()).calculateArmor(this);
        }
        for (StatType statType : StatType.values()) {
            if (this.mStat.containsKey((Object)statType)) continue;
            this.mStat.put(statType, Float.valueOf(0.0f));
        }
        for (StatType statType : StatType.values()) {
            if (this.mBStat.containsKey((Object)statType)) continue;
            this.mBStat.put(statType, false);
        }
        this.updateTooltip();
        return this;
    }

    public void updateTooltip() {
        ArrayList<String> tagList = new ArrayList<String>();
        String tmp2 = "";
        if (this.maxWeight > 4000.0f) {
            tmp2 = " " + GT_LanguageManager.getTranslation("Too Heavy");
        }
        if (this.maxCharge != 0) {
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
            symbols.setGroupingSeparator(' ');
            if (this.type == 0) {
                if (this.mBStat.get((Object)StatType.THAUMICGOGGLES).booleanValue()) {
                    tagList.add(GT_LanguageManager.getTranslation("Thaumic Goggles installed"));
                }
                if (this.mBStat.get((Object)StatType.NIGHTVISION).booleanValue()) {
                    tagList.add(GT_LanguageManager.getTranslation("Nightvision installed"));
                }
            }
            tagList.add("EU: " + formatter.format((float)this.charge + this.mStat.get((Object)StatType.PARTSCHARGE).floatValue()));
            if (this.type == 2) {
                tagList.add(GT_LanguageManager.getTranslation("Jumpboost") + ": " + this.mStat.get((Object)StatType.PISTONJUMPBOOST).floatValue() / 3.0f + "m");
            }
            if (this.type == 2 && this.mStat.get((Object)StatType.PISTONJUMPBOOST).floatValue() > 0.0f) {
                tagList.add(GT_LanguageManager.getTranslation("Uphill step assist active"));
            }
            if (this.type == 2 && this.mStat.get((Object)StatType.MOTPRPOWER).floatValue() > 0.0f) {
                tagList.add(GT_LanguageManager.getTranslation("Speedup") + ": " + this.mStat.get((Object)StatType.MOTPRPOWER));
                tagList.add(GT_LanguageManager.getTranslation("Motor energy usage") + ": " + this.mStat.get((Object)StatType.MOTOREUUSAGE) + " EU");
                if (this.maxWeight > 4000.0f) {
                    tagList.add(GT_LanguageManager.getTranslation("Too Heavy!!!"));
                }
            }
            tagList.add(GT_LanguageManager.getTranslation("Processing power ") + " " + this.mStat.get((Object)StatType.PARTPROCESSING) + " " + GT_LanguageManager.getTranslation(""));
            tagList.add(GT_LanguageManager.getTranslation("Processing power used") + ": " + this.mStat.get((Object)StatType.PARTPROCESSINGUSED) + " " + GT_LanguageManager.getTranslation(""));
            if (this.type == 0 && this.mStat.get((Object)StatType.ELECTROLYZERPROD).floatValue() > 0.0f) {
                tagList.add(GT_LanguageManager.getTranslation("Electrolyzer produces ") + " " + this.mStat.get((Object)StatType.ELECTROLYZERPROD).floatValue() / 2.0f + GT_LanguageManager.getTranslation("per second"));
            }
            if (this.mStat.get((Object)StatType.TANKCAP).floatValue() > 0.0f) {
                if (this.fluid != null) {
                    tagList.add(GT_LanguageManager.getTranslation("Tank Capacity") + ": " + this.fluid.getLocalizedName() + " " + this.fluid.amount + "L (" + this.mStat.get((Object)StatType.TANKCAP) + ")");
                } else {
                    tagList.add(GT_LanguageManager.getTranslation("tankcap") + ": " + this.mStat.get((Object)StatType.TANKCAP));
                }
            }
        }
        tagList.add(GT_LanguageManager.getTranslation("Weight") + ": " + this.mStat.get((Object)StatType.WEIGHT) + tmp2);
        tagList.add(GT_LanguageManager.getTranslation("Physical Defence") + ": " + (double)Math.round(this.mStat.get((Object)StatType.PHYSICALDEFENCE).floatValue() * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("Projectile Defence") + ": " + (double)Math.round(this.mStat.get((Object)StatType.PROJECTILEDEFENCE).floatValue() * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("Fire Defence") + ": " + (double)Math.round(this.mStat.get((Object)StatType.FIREDEFENCE).floatValue() * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("Magic Defence") + ": " + (double)Math.round(this.mStat.get((Object)StatType.MAGICDEFENCE).floatValue() * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("Explosive Defence") + ": " + (double)Math.round(this.mStat.get((Object)StatType.EXPLOSIONDEFENCE).floatValue() * 1000.0f) / 10.0 + "%");
        if (this.mStat.get((Object)StatType.FALLDEFENCE).floatValue() > 0.0f && this.type == 3) {
            tagList.add(GT_LanguageManager.getTranslation("Absorbs") + " " + this.mStat.get((Object)StatType.FALLDEFENCE) + GT_LanguageManager.getTranslation(" m of Fall Defence"));
        }
        if (this.mStat.get((Object)StatType.THORNS).floatValue() > 0.0f) {
            tagList.add(GT_LanguageManager.getTranslation("Thorns") + ": " + this.mStat.get((Object)StatType.THORNS));
        }
        if (this.mStat.get((Object)StatType.MAGNET).floatValue() > 0.0f) {
            tagList.add(GT_LanguageManager.getTranslation("Magnet") + ": " + this.mStat.get((Object)StatType.MAGNET) + "m");
        }
        if (this.mBStat.get((Object)StatType.FULLRADIATIONARMOR).booleanValue()) {
            tagList.add(GT_LanguageManager.getTranslation("Is Full Radiation Defence"));
        } else if ((double)this.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.01) {
            tagList.add(GT_LanguageManager.getTranslation("Radiation Defence") + ": " + (double)Math.round(this.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() * 1000.0f) / 10.0 + "%");
        }
        this.info = tagList;
    }

    public void armorPartsEquipped(EntityPlayer aPlayer) {
        this.helmet = null;
        this.chestplate = null;
        this.leggings = null;
        this.boots = null;
        for (int i = 1; i < 5; ++i) {
            ItemStack stack = aPlayer.func_71124_b(i);
            if (stack == null || !(stack.func_77973_b() instanceof ModularArmor_Item)) continue;
            ModularArmor_Item tmp = (ModularArmor_Item)stack.func_77973_b();
            ContainerBasicArmor tmp2 = new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, stack));
            if (this.type + i == 4) {
                this.fluid = ArmorCalculation.getFluid(tmp2.mInvArmor.parts, Math.round(this.mStat.get((Object)StatType.TANKCAP).floatValue()));
            }
            if (this.maxCharge > 0 && this.charge < this.maxCharge) {
                int loaded = ArmorCalculation.deChargeBatterys(tmp2.mInvArmor.parts, this.maxCharge - this.charge);
                this.charge += loaded;
                this.change(this.mStat, StatType.PARTSCHARGE, -loaded);
            }
            switch (tmp.field_77881_a) {
                case 0: {
                    this.helmet = tmp.data;
                    break;
                }
                case 1: {
                    this.chestplate = tmp.data;
                    break;
                }
                case 2: {
                    this.leggings = tmp.data;
                    break;
                }
                case 3: {
                    this.boots = tmp.data;
                    break;
                }
            }
            this.writeToNBT(stack.func_77978_p());
        }
        if (this.helmet != null && this.chestplate != null && this.leggings != null && this.boots != null) {
            this.set(this.mBStat, StatType.FULLARMOR, true);
            boolean helmHasFullRadiationDefence = false;
            boolean chestplateHasFullRadiationDefence = false;
            boolean leggingsHasFullRadiationDefence = false;
            boolean bootsHasFullRadiationDefence = false;
            boolean helmHasFullElectricalDefenceDefence = false;
            boolean chestplateHasFullElectricalDefenceDefence = false;
            boolean leggingsHasFullElectricalDefenceDefence = false;
            boolean bootsHasFullElectricalDefenceDefence = false;
            if (this.helmet.mStat != null) {
                if (this.helmet.mStat.containsKey((Object)StatType.RADIATIONDEFENCE)) {
                    boolean bl = helmHasFullRadiationDefence = this.helmet.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
                if (this.helmet.mStat.containsKey((Object)StatType.ELECTRICALDEFENCE)) {
                    boolean bl = helmHasFullElectricalDefenceDefence = this.helmet.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
            }
            if (this.chestplate.mStat != null) {
                if (this.chestplate.mStat.containsKey((Object)StatType.RADIATIONDEFENCE)) {
                    boolean bl = chestplateHasFullRadiationDefence = this.chestplate.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
                if (this.chestplate.mStat.containsKey((Object)StatType.ELECTRICALDEFENCE)) {
                    boolean bl = chestplateHasFullElectricalDefenceDefence = this.chestplate.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
            }
            if (this.leggings.mStat != null) {
                if (this.leggings.mStat.containsKey((Object)StatType.RADIATIONDEFENCE)) {
                    boolean bl = leggingsHasFullRadiationDefence = this.leggings.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
                if (this.leggings.mStat.containsKey((Object)StatType.ELECTRICALDEFENCE)) {
                    boolean bl = leggingsHasFullElectricalDefenceDefence = this.leggings.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
            }
            if (this.boots.mStat != null) {
                if (this.boots.mStat.containsKey((Object)StatType.RADIATIONDEFENCE)) {
                    boolean bl = bootsHasFullRadiationDefence = this.boots.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
                if (this.boots.mStat.containsKey((Object)StatType.ELECTRICALDEFENCE)) {
                    bootsHasFullElectricalDefenceDefence = this.boots.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() > 0.9f;
                }
            }
            this.set(this.mBStat, StatType.FULLRADIATIONARMOR, helmHasFullRadiationDefence && chestplateHasFullRadiationDefence && leggingsHasFullRadiationDefence && bootsHasFullRadiationDefence);
            this.set(this.mBStat, StatType.FULLELECTRICARMOR, helmHasFullElectricalDefenceDefence && chestplateHasFullElectricalDefenceDefence && leggingsHasFullElectricalDefenceDefence && bootsHasFullElectricalDefenceDefence);
        } else {
            this.set(this.mBStat, StatType.FULLARMOR, false);
            this.set(this.mBStat, StatType.FULLRADIATIONARMOR, false);
            this.set(this.mBStat, StatType.FULLELECTRICARMOR, false);
        }
        this.set(this.mBStat, StatType.MAGNET, 0.0f);
        this.set(this.mBStat, StatType.THORNS, 0.0f);
        this.set(this.mBStat, StatType.PROCESSINGPOWER, 0.0f);
        this.set(this.mBStat, StatType.PROCESSINGPOWERUSED, 0.0f);
        if (this.helmet != null) {
            this.updateArmorStats(this.helmet, updateArmorStatTypeList);
        }
        if (this.chestplate != null) {
            this.updateArmorStats(this.chestplate, updateArmorStatTypeList);
        }
        if (this.leggings != null) {
            this.updateArmorStats(this.leggings, updateArmorStatTypeList);
        }
        if (this.boots != null) {
            this.updateArmorStats(this.boots, updateArmorStatTypeList);
        }
        this.isTopItem = false;
        if (this.type == 0) {
            this.isTopItem = true;
        } else if (this.helmet == null && this.type == 1) {
            this.isTopItem = true;
        } else if (this.helmet == null && this.chestplate == null && this.type == 2) {
            this.isTopItem = true;
        } else if (this.helmet == null && this.chestplate == null && this.leggings == null && this.type == 3) {
            this.isTopItem = true;
        }
        if (this.helmet != null) {
            this.maxWeight = this.helmet.mStat.get((Object)StatType.WEIGHT).floatValue();
        }
        if (this.chestplate != null) {
            this.maxWeight += this.chestplate.mStat.get((Object)StatType.WEIGHT).floatValue();
        }
        if (this.leggings != null) {
            this.maxWeight += this.leggings.mStat.get((Object)StatType.WEIGHT).floatValue();
        }
        if (this.boots != null) {
            this.maxWeight += this.boots.mStat.get((Object)StatType.WEIGHT).floatValue();
        }
    }

    private void updateArmorStats(ArmorData armorData, ArrayList<StatType> statTypes) {
        for (StatType statType : statTypes) {
            if (armorData == null || armorData.mStat == null || !armorData.mStat.containsKey((Object)statType)) continue;
            this.set(this.mStat, statType, armorData.mStat.get((Object)statType).floatValue());
        }
    }

    public void set(Map aMap, StatType aType, boolean aSet) {
        if (aMap.containsKey((Object)aType)) {
            aMap.remove((Object)aType);
        }
        aMap.put(aType, aSet);
    }

    public void set(Map aMap, StatType aType, float aSet) {
        if (aMap.containsKey((Object)aType)) {
            aMap.remove((Object)aType);
        }
        aMap.put(aType, Float.valueOf(aSet));
    }

    public void change(Map aMap, StatType aType, float aChange) {
        float tChange = 0.0f;
        if (aMap == null) {
            GT_Mod.GT_FML_LOGGER.info("changeMapnull");
        }
        if (aMap.containsKey((Object)aType)) {
            Object value = aMap.get((Object)aType);
            tChange = value != null ? ((Float)aMap.get((Object)aType)).floatValue() : 0.0f;
            aMap.remove((Object)aType);
        }
        aMap.put(aType, Float.valueOf(tChange + aChange));
    }

    public void dechargeComponents(int aCharge) {
    }

    public double getBaseAbsorptionRatio() {
        switch (this.type) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }
}

