/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.bees;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.apiculture.flowers.FlowerProvider;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AlleleInteger;
import forestry.core.genetics.alleles.AlleleTolerance;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import forestry.core.utils.vect.IVect;
import forestry.plugins.PluginManager;
import gregtech.GT_Mod;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_AlleleHelper
extends AlleleHelper {
    private static final String modId = "forestry";
    private Map<Class, Map<?, ? extends IAllele>> alleleMaps = new HashMap();

    public void init() {
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            this.createAlleles(EnumAllele.Fertility.class, new IChromosomeType[]{EnumBeeChromosome.FERTILITY});
            this.createAlleles(EnumAllele.Flowering.class, new IChromosomeType[]{EnumBeeChromosome.FLOWERING});
        }
        if (PluginManager.Module.APICULTURE.isEnabled() || PluginManager.Module.ARBORICULTURE.isEnabled()) {
            this.createAlleles(EnumAllele.Territory.class, new IChromosomeType[]{EnumBeeChromosome.TERRITORY, EnumTreeChromosome.TERRITORY});
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.territoryDefault", this.get(EnumAllele.Territory.AVERAGE));
        }
        if (PluginManager.Module.APICULTURE.isEnabled() || PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            this.createAlleles(EnumAllele.Speed.class, new IChromosomeType[]{EnumBeeChromosome.SPEED, EnumButterflyChromosome.SPEED});
            this.createAlleles(EnumAllele.Lifespan.class, new IChromosomeType[]{EnumBeeChromosome.LIFESPAN, EnumButterflyChromosome.LIFESPAN});
            this.createAlleles(EnumAllele.Tolerance.class, new IChromosomeType[]{EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumButterflyChromosome.HUMIDITY_TOLERANCE});
            this.createAlleles(EnumAllele.Flowers.class, new IChromosomeType[]{EnumBeeChromosome.FLOWER_PROVIDER, EnumButterflyChromosome.FLOWER_PROVIDER});
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.speedNorm", this.get(EnumAllele.Speed.NORMAL));
        }
        if (PluginManager.Module.ARBORICULTURE.isEnabled()) {
            this.createAlleles(EnumAllele.Height.class, new IChromosomeType[]{EnumTreeChromosome.HEIGHT});
            this.createAlleles(EnumAllele.Saplings.class, new IChromosomeType[]{EnumTreeChromosome.FERTILITY});
            this.createAlleles(EnumAllele.Yield.class, new IChromosomeType[]{EnumTreeChromosome.YIELD});
            this.createAlleles(EnumAllele.Fireproof.class, new IChromosomeType[]{EnumTreeChromosome.FIREPROOF});
            this.createAlleles(EnumAllele.Maturation.class, new IChromosomeType[]{EnumTreeChromosome.MATURATION});
            this.createAlleles(EnumAllele.Sappiness.class, new IChromosomeType[]{EnumTreeChromosome.SAPPINESS});
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.heightMax10", this.get(EnumAllele.Height.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.saplingsDefault", this.get(EnumAllele.Saplings.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.saplingsDouble", this.get(EnumAllele.Saplings.HIGH));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.saplingsTriple", this.get(EnumAllele.Saplings.HIGHER));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.yieldDefault", this.get(EnumAllele.Yield.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturitySlowest", this.get(EnumAllele.Maturation.SLOWEST));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturitySlower", this.get(EnumAllele.Maturation.SLOWER));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturitySlow", this.get(EnumAllele.Maturation.SLOW));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityAverage", this.get(EnumAllele.Maturation.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityFast", this.get(EnumAllele.Maturation.FAST));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityFaster", this.get(EnumAllele.Maturation.FASTER));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityFastest", this.get(EnumAllele.Maturation.FASTEST));
        }
        if (PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            this.createAlleles(EnumAllele.Size.class, new IChromosomeType[]{EnumButterflyChromosome.SIZE});
        }
        HashMap<Integer, AlleleInteger> integers = new HashMap<Integer, AlleleInteger>();
        for (int i = 1; i <= 10; ++i) {
            AlleleInteger alleleInteger = new AlleleInteger(modId, "i", i + "d", i, true);
            AlleleManager.alleleRegistry.registerAllele((IAllele)alleleInteger, new IChromosomeType[]{EnumTreeChromosome.GIRTH, EnumButterflyChromosome.METABOLISM, EnumButterflyChromosome.FERTILITY});
            integers.put(i, alleleInteger);
        }
        this.alleleMaps.put(Integer.class, integers);
        HashMap<Boolean, AlleleBoolean> booleans = new HashMap<Boolean, AlleleBoolean>();
        booleans.put(true, new AlleleBoolean(modId, "bool", true, false));
        booleans.put(false, new AlleleBoolean(modId, "bool", false, false));
        for (IAlleleBoolean alleleBoolean : booleans.values()) {
            AlleleManager.alleleRegistry.registerAllele((IAllele)alleleBoolean, new IChromosomeType[]{EnumBeeChromosome.NOCTURNAL, EnumBeeChromosome.TOLERANT_FLYER, EnumBeeChromosome.CAVE_DWELLING, EnumButterflyChromosome.NOCTURNAL, EnumButterflyChromosome.TOLERANT_FLYER, EnumButterflyChromosome.FIRE_RESIST});
        }
        this.alleleMaps.put(Boolean.class, booleans);
    }

    public static void initialisation() {
        GT_AlleleHelper helper = new GT_AlleleHelper();
        try {
            helper.alleleMaps = (Map)FieldUtils.readField((Field)FieldUtils.getField(AlleleHelper.class, (String)"alleleMaps", (boolean)true), (Object)AlleleHelper.instance, (boolean)true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        AlleleHelper.instance = helper;
    }

    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, IAllele allele) {
        if (allele == null) {
            GT_Mod.GT_FML_LOGGER.info("Allele is null!");
            return;
        }
        if (!((IChromosomeType)chromosomeType).getAlleleClass().isInstance(allele)) {
            GT_Mod.GT_FML_LOGGER.info("chromosomeType is not an instance of allele!" + allele.getName());
            return;
        }
        alleles[chromosomeType.ordinal()] = allele;
    }

    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, IAlleleValue value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, boolean value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, int value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    private IAllele get(Object value) {
        Class<?> valueClass = value.getClass();
        Map<?, IAllele> map = this.alleleMaps.get(valueClass);
        if (map == null) {
            throw new IllegalArgumentException("There is no IAllele type for: " + valueClass + ' ' + value);
        }
        IAllele allele = map.get(value);
        if (allele == null) {
            allele = new IAllele(){

                public String getUID() {
                    return "NOT_FOUND";
                }

                public boolean isDominant() {
                    return false;
                }

                public String getName() {
                    return "NOT_FOUND";
                }

                public String getUnlocalizedName() {
                    return "NOT_FOUND";
                }
            };
        }
        return allele;
    }

    private <K extends Enum<K>, V> void createAlleles(Class<K> enumClass, IChromosomeType ... types) {
        String category = enumClass.getSimpleName().toLowerCase(Locale.ENGLISH);
        EnumMap<Enum, IAllele> map = new EnumMap<Enum, IAllele>(enumClass);
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            IAllele allele = GT_AlleleHelper.createAllele(category, (IAlleleValue)enumValue, types);
            map.put(enumValue, allele);
        }
        this.alleleMaps.put(enumClass, map);
    }

    private static <K extends IAlleleValue<V>, V> IAllele createAllele(String category, K enumValue, IChromosomeType ... types) {
        Object value = enumValue.getValue();
        boolean isDominant = enumValue.isDominant();
        String name = enumValue.toString().toLowerCase(Locale.ENGLISH);
        Class<?> valueClass = value.getClass();
        if (Float.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createFloat(modId, category, name, ((Float)value).floatValue(), isDominant, types);
        }
        if (Integer.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createInteger(modId, category, name, ((Integer)value).intValue(), isDominant, types);
        }
        if (IVect.class.isAssignableFrom(valueClass)) {
            IVect area = (IVect)value;
            return AlleleManager.alleleFactory.createArea(modId, category, name, area.getX(), area.getY(), area.getZ(), isDominant, types);
        }
        if (Boolean.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createBoolean(modId, category, ((Boolean)value).booleanValue(), isDominant, types);
        }
        if (EnumTolerance.class.isAssignableFrom(valueClass)) {
            AlleleTolerance alleleTolerance = new AlleleTolerance(modId, category, name, (EnumTolerance)value, isDominant);
            AlleleManager.alleleRegistry.registerAllele((IAllele)alleleTolerance, types);
            return alleleTolerance;
        }
        if (FlowerProvider.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createFlowers(modId, category, name, (IFlowerProvider)((FlowerProvider)value), isDominant, types);
        }
        throw new RuntimeException("could not create allele for category: " + category + " and value " + valueClass);
    }
}

