/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.internal.IGT_CraftingRecipe;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class GT_Shaped_Recipe
extends ShapedOreRecipe
implements IGT_CraftingRecipe {
    public final boolean mDismantleable;
    public final boolean mRemovableByGT;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public GT_Shaped_Recipe(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        this.mDismantleable = aDismantleAble;
    }

    public boolean func_77569_a(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                if (aGrid.func_70301_a(i) == null) continue;
                if (tStack != null && (tStack.func_77942_o() != aGrid.func_70301_a(i).func_77942_o() || tStack.func_77942_o() && !tStack.func_77978_p().equals((Object)aGrid.func_70301_a(i).func_77978_p()))) {
                    return false;
                }
                tStack = aGrid.func_70301_a(i);
            }
        }
        return super.func_77569_a(aGrid, aWorld);
    }

    public ItemStack func_77572_b(InventoryCrafting aGrid) {
        ItemStack rStack = super.func_77572_b(aGrid);
        if (rStack != null) {
            GT_Utility.updateItemStack(rStack);
            if (this.mKeepingNBT) {
                for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                    if (aGrid.func_70301_a(i) == null || !aGrid.func_70301_a(i).func_77942_o()) continue;
                    rStack.func_77982_d((NBTTagCompound)aGrid.func_70301_a(i).func_77978_p().func_74737_b());
                    break;
                }
            }
            if (GT_ModHandler.isElectricItem(rStack)) {
                GT_ModHandler.dischargeElectricItem(rStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
                int tCharge = 0;
                for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                    tCharge += GT_ModHandler.dischargeElectricItem(aGrid.func_70301_a(i), Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true);
                }
                if (tCharge > 0) {
                    GT_ModHandler.chargeElectricItem(rStack, tCharge, Integer.MAX_VALUE, true, false);
                }
            }
            if (this.mDismantleable) {
                NBTTagCompound rNBT = rStack.func_77978_p();
                NBTTagCompound tNBT = new NBTTagCompound();
                if (rNBT == null) {
                    rNBT = new NBTTagCompound();
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack tStack = aGrid.func_70301_a(i);
                    if (tStack == null || GT_Utility.getContainerItem(tStack, true) != null || tStack.func_77973_b() instanceof GT_MetaGenerated_Tool || !GT_Utility.isStackValid(tStack = GT_Utility.copyAmount(1L, tStack))) continue;
                    GT_ModHandler.dischargeElectricItem(tStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
                    tNBT.func_74782_a("Ingredient." + i, (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                }
                rNBT.func_74782_a("GT.CraftingComponents", (NBTBase)tNBT);
                rStack.func_77982_d(rNBT);
            }
            for (int i = 0; i < this.mEnchantmentsAdded.length; ++i) {
                GT_Utility.ItemNBT.addEnchantment(rStack, this.mEnchantmentsAdded[i], EnchantmentHelper.func_77506_a((int)this.mEnchantmentsAdded[i].field_77352_x, (ItemStack)rStack) + this.mEnchantmentLevelsAdded[i]);
            }
            GT_Utility.updateItemStack(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovable() {
        return this.mRemovableByGT;
    }
}

