/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.threads;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IMachineBlockUpdateable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class GT_Runnable_MachineBlockUpdate
implements Runnable {
    private final int x;
    private final int y;
    private final int z;
    private final World world;
    private final Set<ChunkPosition> visited = new HashSet<ChunkPosition>(80);
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread thread = new Thread(r);
        thread.setName("GT_MachineBlockUpdate");
        return thread;
    };
    private static ExecutorService EXECUTOR_SERVICE;
    private static boolean isEnabled;

    private GT_Runnable_MachineBlockUpdate(World aWorld, int aX, int aY, int aZ) {
        this.world = aWorld;
        this.x = aX;
        this.y = aY;
        this.z = aZ;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled() {
        isEnabled = true;
    }

    public static void setDisabled() {
        isEnabled = false;
    }

    public static void setEnabled(boolean isEnabled) {
        GT_Runnable_MachineBlockUpdate.isEnabled = isEnabled;
    }

    public static void setMachineUpdateValues(World aWorld, int aX, int aY, int aZ) {
        if (isEnabled) {
            EXECUTOR_SERVICE.submit(new GT_Runnable_MachineBlockUpdate(aWorld, aX, aY, aZ));
        }
    }

    public static void initExecutorService() {
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), THREAD_FACTORY);
    }

    public static void shutdownExecutorService() {
        try {
            GT_Mod.GT_FML_LOGGER.info("Shutting down Machine block update executor service");
            EXECUTOR_SERVICE.shutdown();
            if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                EXECUTOR_SERVICE.shutdownNow();
                if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                    GT_Mod.GT_FML_LOGGER.error("Well this didn't terminated well... GT_Runnable_MachineBlockUpdate.shutdownExecutorService");
                }
            }
        }
        catch (InterruptedException ie) {
            GT_Mod.GT_FML_LOGGER.error("Well this interruption got interrupted...", (Throwable)ie);
            EXECUTOR_SERVICE.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            GT_Mod.GT_FML_LOGGER.error("Well this didn't terminated well...", (Throwable)e);
            EXECUTOR_SERVICE.shutdownNow();
        }
        finally {
            GT_Mod.GT_FML_LOGGER.info("Leaving... GT_Runnable_MachineBlockUpdate.shutdownExecutorService");
        }
    }

    private boolean shouldRecurse(TileEntity aTileEntity, int aX, int aY, int aZ) {
        return aTileEntity instanceof IMachineBlockUpdateable && ((IMachineBlockUpdateable)aTileEntity).isMachineBlockUpdateRecursive() || GregTech_API.isMachineBlock(this.world.func_147439_a(aX, aY, aZ), this.world.func_72805_g(aX, aY, aZ));
    }

    private void causeUpdate(TileEntity tileEntity) {
        if (tileEntity instanceof IMachineBlockUpdateable) {
            ((IMachineBlockUpdateable)tileEntity).onMachineBlockUpdate();
        }
    }

    private void stepToUpdateMachine(int aX, int aY, int aZ) {
        if (!this.visited.add(new ChunkPosition(aX, aY, aZ))) {
            return;
        }
        TileEntity tTileEntity = this.world.func_147438_o(aX, aY, aZ);
        this.causeUpdate(tTileEntity);
        if (this.visited.size() < 5 || this.shouldRecurse(tTileEntity, aX, aY, aZ)) {
            this.stepToUpdateMachine(aX + 1, aY, aZ);
            this.stepToUpdateMachine(aX - 1, aY, aZ);
            this.stepToUpdateMachine(aX, aY + 1, aZ);
            this.stepToUpdateMachine(aX, aY - 1, aZ);
            this.stepToUpdateMachine(aX, aY, aZ + 1);
            this.stepToUpdateMachine(aX, aY, aZ - 1);
        }
    }

    @Override
    public void run() {
        try {
            this.stepToUpdateMachine(this.x, this.y, this.z);
        }
        catch (Exception e) {
            GT_Mod.GT_FML_LOGGER.error("Well this update was broken... " + new Coordinates(this.x, this.y, this.z, this.world), (Throwable)e);
        }
    }

    static {
        isEnabled = true;
    }

    public static class Coordinates {
        public final int mX;
        public final int mY;
        public final int mZ;
        public final World mWorld;

        public Coordinates(int mX, int mY, int mZ, World mWorld) {
            this.mX = mX;
            this.mY = mY;
            this.mZ = mZ;
            this.mWorld = mWorld;
        }

        public String toString() {
            return "Coordinates{mX=" + this.mX + ", mY=" + this.mY + ", mZ=" + this.mZ + ", mWorld=" + this.mWorld.func_72827_u() + " @dimId " + this.mWorld.field_73011_w.field_76574_g + '}';
        }
    }
}

