/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GT_Packet_TileEntityCoverGUI
extends GT_Packet {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected byte side;
    protected int coverID;
    protected int coverData;
    protected int dimID;
    protected int playerID;

    public GT_Packet_TileEntityCoverGUI() {
        super(true);
    }

    public GT_Packet_TileEntityCoverGUI(int mX, short mY, int mZ, byte coverSide, int coverID, int coverData, int dimID, int playerID) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = dimID;
        this.playerID = playerID;
    }

    public GT_Packet_TileEntityCoverGUI(byte side, int coverID, int coverData, ICoverable tile, EntityPlayerMP aPlayer) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = side;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = tile.getWorld().field_73011_w.field_76574_g;
        this.playerID = aPlayer.func_145782_y();
    }

    public GT_Packet_TileEntityCoverGUI(byte coverSide, int coverID, int coverData, IGregTechTileEntity tile) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = tile.getWorld().field_73011_w.field_76574_g;
    }

    @Override
    public byte getPacketID() {
        return 7;
    }

    @Override
    public byte[] encode() {
        ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)27);
        tOut.writeInt(this.mX);
        tOut.writeShort((int)this.mY);
        tOut.writeInt(this.mZ);
        tOut.writeByte((int)this.side);
        tOut.writeInt(this.coverID);
        tOut.writeInt(this.coverData);
        tOut.writeInt(this.dimID);
        tOut.writeInt(this.playerID);
        return tOut.toByteArray();
    }

    @Override
    public GT_Packet decode(ByteArrayDataInput aData) {
        return new GT_Packet_TileEntityCoverGUI(aData.readInt(), aData.readShort(), aData.readInt(), aData.readByte(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (aWorld instanceof World) {
            EntityClientPlayerMP a = Minecraft.func_71410_x().field_71439_g;
            TileEntity tile = aWorld.func_147438_o(this.mX, (int)this.mY, this.mZ);
            if (tile instanceof IGregTechTileEntity && !((IGregTechTileEntity)tile).isDead()) {
                ((IGregTechTileEntity)tile).setCoverDataAtSide(this.side, this.coverData);
                a.openGui((Object)GT_Values.GT, 10 + this.side, a.field_70170_p, this.mX, (int)this.mY, this.mZ);
            }
        }
    }
}

