/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_HeatExchanger
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_HeatExchanger>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 50;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_HeatExchanger> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cCc", "ccc"}, {"ccc", "cPc", "ccc"}, {"ccc", "cPc", "ccc"}, {"c~c", "cHc", "ccc"}})).addElement('P', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)14)).addElement('C', GT_HatchElement.OutputHatch.withAdder(GT_MetaTileEntity_HeatExchanger::addColdFluidOutputToMachineList).withCount(t -> GT_MetaTileEntity_HeatExchanger.isValidMetaTileEntity(t.mOutputColdFluidHatch) ? 1L : 0L).newAny(50, 3)).addElement('H', GT_HatchElement.OutputHatch.withAdder(GT_MetaTileEntity_HeatExchanger::addHotFluidInputToMachineList).withCount(t -> GT_MetaTileEntity_HeatExchanger.isValidMetaTileEntity(t.mInputHotFluidHatch) ? 1L : 0L).newAny(50, 3)).addElement('c', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_HeatExchanger.class).atLeast(GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance).casingIndex(50).dot(1).buildAndChain(StructureUtility.onElementPass(GT_MetaTileEntity_HeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)2)))).build();
    public static float penalty_per_config = 0.015f;
    private GT_MetaTileEntity_Hatch_Input mInputHotFluidHatch;
    private GT_MetaTileEntity_Hatch_Output mOutputColdFluidHatch;
    private boolean superheated = false;
    private int superheated_threshold = 0;
    private int steamBudget;
    private int mCasingAmount;

    public GT_MetaTileEntity_HeatExchanger(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_HeatExchanger(String aName) {
        super(aName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Heat Exchanger").addInfo("Controller Block for the Large Heat Exchanger").addInfo("More complicated than a Fusion Reactor. Seriously").addInfo("Inputs are Hot Coolant or Lava").addInfo("Outputs Coolant or Pahoehoe Lava and SH Steam/Steam").addInfo("Read the wiki article to understand how it works").addInfo("Then go to the Discord to understand the wiki").addSeparator().beginStructureBlock(3, 4, 3, false).addController("Front bottom").addCasingInfo("Stable Titanium Machine Casing", 20).addOtherStructurePart("Titanium Pipe Casing", "Center 2 blocks").addMaintenanceHatch("Any casing", 1).addInputHatch("Hot fluid, bottom center", 2).addInputHatch("Distilled water, any casing", 1).addOutputHatch("Cold fluid, top center", 3).addOutputHatch("Steam/SH Steam, any casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.superheated = aNBT.func_74767_n("superheated");
        this.steamBudget = aNBT.func_74762_e("steamBudget");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("superheated", this.superheated);
        aNBT.func_74768_a("steamBudget", this.steamBudget);
        super.saveNBTData(aNBT);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeHeatExchanger.png");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !r.isUpsideDown() && !f.isVerticallyFliped();
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        int circuit_config;
        if (this.mInputHotFluidHatch.getFluid() == null) {
            return true;
        }
        int fluidAmountToConsume = this.mInputHotFluidHatch.getFluidAmount();
        this.superheated_threshold = 4000;
        float efficiency = 1.0f;
        int shs_reduction_per_config = 150;
        float steam_output_multiplier = 20.0f;
        float penalty = 0.0f;
        boolean do_lava = false;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") && (circuit_config = this.mInventory[1].func_77960_j()) >= 1 && circuit_config <= 25) {
            penalty = (float)(circuit_config - 1) * penalty_per_config;
            this.superheated_threshold -= shs_reduction_per_config * (circuit_config - 1);
        }
        efficiency -= penalty;
        if (GT_ModHandler.isLava(this.mInputHotFluidHatch.getFluid())) {
            steam_output_multiplier /= 5.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 4.0f);
            do_lava = true;
        } else if (this.mInputHotFluidHatch.getFluid().isFluidEqual(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)1))) {
            steam_output_multiplier /= 2.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 5.0f);
        } else {
            this.superheated_threshold = 0;
            return false;
        }
        this.superheated = fluidAmountToConsume >= this.superheated_threshold;
        fluidAmountToConsume = Math.min(fluidAmountToConsume, this.superheated_threshold * 2);
        this.mInputHotFluidHatch.drain(fluidAmountToConsume, true);
        this.mMaxProgresstime = 20;
        this.mEUt = (int)((float)fluidAmountToConsume * steam_output_multiplier * efficiency);
        if (do_lava) {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2pahoehoelava", (int)fluidAmountToConsume), true);
        } else {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2coolant", (int)fluidAmountToConsume), true);
        }
        this.mEfficiencyIncrease = 80;
        return true;
    }

    private int useWater(int steam) {
        this.steamBudget -= steam;
        int usage = -Math.min(0, Math.floorDiv(this.steamBudget, 160));
        this.steamBudget += usage * 160;
        return usage;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            int tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L);
            if (tGeneratedEU > 0) {
                int distilledConsumed;
                FluidStack distilledStack;
                if (this.superheated) {
                    tGeneratedEU /= 2;
                }
                if (this.depleteInput(distilledStack = GT_ModHandler.getDistilledWater(distilledConsumed = this.useWater(tGeneratedEU)))) {
                    if (this.superheated) {
                        this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)tGeneratedEU));
                    } else {
                        this.addOutput(GT_ModHandler.getSteam(tGeneratedEU));
                    }
                } else {
                    GT_Log.exp.println(this.mName + " had no more Distilled water!");
                    this.explodeMultiblock();
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_HeatExchanger> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputColdFluidHatch = null;
        this.mInputHotFluidHatch = null;
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 3, 0) && this.mCasingAmount >= 20 && this.mMaintenanceHatches.size() == 1;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mOutputColdFluidHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            this.mInputHotFluidHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_HeatExchanger(this.mName);
    }

    @Override
    public boolean isGivingInformation() {
        return super.isGivingInformation();
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.steam") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + GT_Utility.formatNumbers(this.superheated ? (long)(-2 * this.mEUt) : (long)(-this.mEUt)) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.BLUE) + this.superheated + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.threshold") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.superheated_threshold) + EnumChatFormatting.RESET};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }
}

