/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public abstract class GT_MetaTileEntity_ConcreteBackfillerBase
extends GT_MetaTileEntity_DrillerBase {
    private int mLastXOff = 0;
    private int mLastZOff = 0;

    public GT_MetaTileEntity_ConcreteBackfillerBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ConcreteBackfillerBase(String aName) {
        super(aName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip(String aStructureName) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Concrete Backfiller").addInfo("Controller Block for the " + aStructureName).addInfo("Will fill in areas below it with light concrete. This goes through walls").addInfo("Use it to remove any spawning locations beneath your base to reduce lag").addInfo("Will pull back the pipes after it finishes that layer").addInfo("Radius is " + this.getRadius() + " blocks").addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GT_Values.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes, optional, any base casing", 1).addInputHatch("GT Concrete, any base casing", 1).addOutputBus("Mining Pipes, optional, any base casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DrillingRig.png");
    }

    protected abstract int getRadius();

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mInputHatches.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    protected List<IHatchElement<? super GT_MetaTileEntity_DrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)GT_HatchElement.InputHatch, (Object)GT_HatchElement.InputBus, (Object)GT_HatchElement.Maintenance, (Object)GT_HatchElement.Energy);
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -6 * (1 << (tier << 1));
        this.mMaxProgresstime = (this.workState == 2 ? 240 : 80) / (1 << tier);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.isRefillableBlock(xPipe, yHead - 1, zPipe)) {
            return this.tryRefillBlock(xPipe, yHead - 1, zPipe);
        }
        int radius = this.getRadius();
        if (this.mLastXOff == 0 && this.mLastZOff == 0) {
            this.mLastXOff = -radius;
            this.mLastZOff = -radius;
        }
        if (yHead != yDrill) {
            for (int i = this.mLastXOff; i <= radius; ++i) {
                int j;
                int n = j = i == this.mLastXOff ? this.mLastZOff : -radius;
                while (j <= radius) {
                    if (this.isRefillableBlock(xPipe + i, yHead, zPipe + j)) {
                        this.mLastXOff = i;
                        this.mLastZOff = j;
                        return this.tryRefillBlock(xPipe + i, yHead, zPipe + j);
                    }
                    ++j;
                }
            }
        }
        if (this.tryPickPipe()) {
            this.mLastXOff = 0;
            this.mLastZOff = 0;
            return true;
        }
        this.workState = 0;
        this.stopMachine();
        return false;
    }

    private boolean isRefillableBlock(int aX, int aY, int aZ) {
        IGregTechTileEntity aBaseTile = this.getBaseMetaTileEntity();
        if (!aBaseTile.getBlock(aX, aY, aZ).isAir((IBlockAccess)aBaseTile.getWorld(), aX, aY, aZ) || aBaseTile.getBlock(aX, aY, aZ).func_149688_o().func_76220_a()) {
            return false;
        }
        return GT_Utility.setBlockByFakePlayer(this.getFakePlayer(aBaseTile), aX, aY, aZ, GregTech_API.sBlockConcretes, 8, true);
    }

    private boolean tryRefillBlock(int aX, int aY, int aZ) {
        if (!this.tryConsumeFluid()) {
            return false;
        }
        this.getBaseMetaTileEntity().getWorld().func_147465_d(aX, aY, aZ, GregTech_API.sBlockConcretes, 8, 3);
        return true;
    }

    private boolean tryConsumeFluid() {
        if (!this.depleteInput(Materials.Concrete.getMolten(144L))) {
            this.mMaxProgresstime = 0;
            return false;
        }
        return true;
    }
}

