/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.core.errors.EnumErrorCode;
import forestry.plugins.PluginApiculture;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ApiaryUpgrade;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import gregtech.common.gui.GT_Container_IndustrialApiary;
import gregtech.common.gui.GT_GUIContainer_IndustrialApiary;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.bdew.gendustry.api.ApiaryModifiers;
import net.bdew.gendustry.api.items.IApiaryUpgrade;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class GT_MetaTileEntity_IndustrialApiary
extends GT_MetaTileEntity_BasicMachine
implements IBeeHousing,
IBeeHousingInventory,
IErrorLogic,
IBeeModifier,
IBeeListener {
    public static final int baseEUtUsage = 37;
    static final int queen = 5;
    static final int drone = 6;
    IBeeRoot beeRoot = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    public int mSpeed = 0;
    public boolean mLockedSpeed = true;
    private ItemStack usedQueen = null;
    private IBee usedQueenBee = null;
    private IEffectData[] effectData = new IEffectData[2];
    boolean retrievingPollenInThisOperation = false;
    IIndividual retrievedpollen = null;
    int pollinationDelay = 100;
    GameProfile owner = null;
    public HashSet<IErrorState> mErrorStates = new HashSet();
    private String flowerType = "";
    private ChunkCoordinates flowercoords = null;
    private Block flowerBlock;
    private int flowerBlockMeta;
    private float terrorityMod = 1.0f;
    private float mutationMod = 1.0f;
    private float lifespanMod = 1.0f;
    private float productionMod = 1.0f;
    private float floweringMod = 1.0f;
    private float geneticDecayMod = 1.0f;
    private float energyMod = 1.0f;
    private boolean sealedMod = false;
    private boolean selfLightedMod = false;
    private boolean sunlightSimulatedMod = false;
    private BiomeGenBase biomeOverride = null;
    private float humidityMod = 0.0f;
    private float temperatureMod = 0.0f;
    private boolean isAutomated = false;
    private boolean isRetrievingPollen = false;
    private int maxspeed = 0;
    static final IBeekeepingLogic dummylogic = new IBeekeepingLogic(){

        public boolean canWork() {
            return true;
        }

        public void doWork() {
        }

        public void syncToClient() {
        }

        public void syncToClient(EntityPlayerMP entityPlayerMP) {
        }

        public int getBeeProgressPercent() {
            return 0;
        }

        public boolean canDoBeeFX() {
            return false;
        }

        public void doBeeFX() {
        }

        public void readFromNBT(NBTTagCompound nbtTagCompound) {
        }

        public void writeToNBT(NBTTagCompound nbtTagCompound) {
        }
    };

    public GT_MetaTileEntity_IndustrialApiary(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 4, new String[]{"BEES GOES BRRRR", EnumChatFormatting.GRAY + "Added by " + EnumChatFormatting.GOLD + "kuba6000"}, 6, 9, "IndustrialApiary.png", "", TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY_GLOW).glow().build()));
    }

    public GT_MetaTileEntity_IndustrialApiary(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 4, aDescription, aTextures, 6, 9, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_IndustrialApiary(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 4, aDescription, aTextures, 6, 9, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_IndustrialApiary(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_IndustrialApiary(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_IndustrialApiary(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mSpeed", this.mSpeed);
        aNBT.func_74757_a("mLockedSpeed", this.mLockedSpeed);
        if (this.usedQueen != null) {
            aNBT.func_74782_a("usedQueen", (NBTBase)this.usedQueen.func_77955_b(new NBTTagCompound()));
        }
        aNBT.func_74757_a("retrievingPollenInThisOperation", this.retrievingPollenInThisOperation);
        aNBT.func_74768_a("pollinationDelay", this.pollinationDelay);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSpeed = aNBT.func_74762_e("mSpeed");
        this.mLockedSpeed = aNBT.func_74767_n("mLockedSpeed");
        if (aNBT.func_74764_b("usedQueen")) {
            this.usedQueen = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("usedQueen"));
        }
        this.retrievingPollenInThisOperation = aNBT.func_74767_n("retrievingPollenInThisOperation");
        this.pollinationDelay = aNBT.func_74762_e("pollinationDelay");
    }

    @Override
    public int checkRecipe() {
        this.updateModifiers();
        if (this.canWork()) {
            ItemStack queen = this.getQueen();
            this.usedQueen = queen.func_77946_l();
            if (this.beeRoot.getType(queen) == EnumBeeType.QUEEN) {
                int n;
                GT_Utility.ItemId id;
                IBee bee;
                this.usedQueenBee = bee = this.beeRoot.getMember(queen);
                float mod = this.getLifespanModifier(null, null, 1.0f);
                IBeekeepingMode mode = this.beeRoot.getBeekeepingMode(this.getWorld());
                IBeeModifier beemodifier = mode.getBeeModifier();
                mod *= beemodifier.getLifespanModifier(null, null, 1.0f);
                int h = bee.getHealth();
                mod = 1.0f / mod;
                float cycles = (float)h / mod;
                HashMap<GT_Utility.ItemId, ItemStack> pollen = new HashMap<GT_Utility.ItemId, ItemStack>();
                if (this.isRetrievingPollen && this.floweringMod > 0.0f) {
                    int icycles = (int)cycles + (this.getWorld().field_73012_v.nextFloat() < cycles - (float)((int)cycles) ? 1 : 0);
                    for (int z = 0; z < icycles; ++z) {
                        ItemStack s;
                        IIndividual p = bee.retrievePollen((IBeeHousing)this);
                        if (p == null || (s = p.getGenome().getSpeciesRoot().getMemberStack(p, EnumGermlingType.POLLEN.ordinal())) == null) continue;
                        GT_Utility.ItemId id2 = GT_Utility.ItemId.createNoCopy(s);
                        pollen.computeIfAbsent(id2, k -> {
                            ItemStack ns = s.func_77946_l();
                            ns.field_77994_a = 0;
                            return ns;
                        });
                        ((ItemStack)pollen.get((Object)id2)).field_77994_a += s.field_77994_a;
                    }
                }
                this.retrievedpollen = null;
                this.retrievingPollenInThisOperation = this.isRetrievingPollen;
                IBeeGenome genome = bee.getGenome();
                IAlleleBeeSpecies primary = genome.getPrimary();
                IAlleleBeeSpecies secondary = genome.getSecondary();
                float speed = genome.getSpeed() * this.getProductionModifier(null, 1.0f) * beemodifier.getProductionModifier(null, 1.0f);
                HashMap<GT_Utility.ItemId, Float> drops = new HashMap<GT_Utility.ItemId, Float>();
                HashMap<GT_Utility.ItemId, ItemStack> dropstacks = new HashMap<GT_Utility.ItemId, ItemStack>();
                for (Map.Entry entry : primary.getProductChances().entrySet()) {
                    id = GT_Utility.ItemId.createNoCopy((ItemStack)entry.getKey());
                    drops.merge(id, Float.valueOf(Math.min(1.0f, ((Float)entry.getValue()).floatValue() * speed) * (float)((ItemStack)entry.getKey()).field_77994_a * cycles), Float::sum);
                    dropstacks.computeIfAbsent(id, k -> (ItemStack)entry.getKey());
                }
                for (Map.Entry entry : secondary.getProductChances().entrySet()) {
                    id = GT_Utility.ItemId.createNoCopy((ItemStack)entry.getKey());
                    drops.merge(id, Float.valueOf(Math.min(1.0f, (float)Math.round(((Float)entry.getValue()).floatValue() / 2.0f) * speed) * (float)((ItemStack)entry.getKey()).field_77994_a * cycles), Float::sum);
                    dropstacks.computeIfAbsent(id, k -> (ItemStack)entry.getKey());
                }
                if (primary.isJubilant(genome, (IBeeHousing)this) && secondary.isJubilant(genome, (IBeeHousing)this)) {
                    for (Map.Entry entry : primary.getSpecialtyChances().entrySet()) {
                        id = GT_Utility.ItemId.createNoCopy((ItemStack)entry.getKey());
                        drops.merge(id, Float.valueOf(Math.min(1.0f, ((Float)entry.getValue()).floatValue() * speed) * (float)((ItemStack)entry.getKey()).field_77994_a * cycles), Float::sum);
                        dropstacks.computeIfAbsent(id, k -> (ItemStack)entry.getKey());
                    }
                }
                int i = 0;
                int imax = this.mOutputItems.length;
                IApiaristTracker breedingTracker = this.beeRoot.getBreedingTracker(this.getWorld(), this.getOwner());
                if (!bee.canSpawn()) {
                    ItemStack convert = new ItemStack((Item)PluginApiculture.items.beePrincessGE);
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    queen.func_77955_b(nbttagcompound);
                    convert.func_77982_d(nbttagcompound);
                    this.mOutputItems[i++] = convert;
                } else {
                    Object d;
                    IBee b = bee.spawnPrincess((IBeeHousing)this);
                    if (b != null) {
                        ItemStack princess = this.beeRoot.getMemberStack((IIndividual)b, EnumBeeType.PRINCESS.ordinal());
                        breedingTracker.registerPrincess((IIndividual)b);
                        this.mOutputItems[i++] = princess;
                    }
                    if ((d = bee.spawnDrones((IBeeHousing)this)) != null && ((IBee[])d).length > 0) {
                        HashMap<GT_Utility.ItemId, ItemStack> hashMap = new HashMap<GT_Utility.ItemId, ItemStack>(((IBee[])d).length);
                        for (Object dr : d) {
                            ItemStack drone = this.beeRoot.getMemberStack((IIndividual)dr, EnumBeeType.DRONE.ordinal());
                            breedingTracker.registerDrone((IIndividual)dr);
                            GT_Utility.ItemId drid = GT_Utility.ItemId.createNoCopy(drone);
                            if (hashMap.containsKey(drid)) {
                                ((ItemStack)hashMap.get((Object)drid)).field_77994_a += drone.field_77994_a;
                                continue;
                            }
                            this.mOutputItems[i++] = drone;
                            hashMap.put(drid, drone);
                        }
                    }
                }
                int imin = i;
                this.setQueen(null);
                block5: for (Map.Entry entry : drops.entrySet()) {
                    ItemStack s = ((ItemStack)dropstacks.get(entry.getKey())).func_77946_l();
                    s.field_77994_a = ((Float)entry.getValue()).intValue() + (this.getWorld().field_73012_v.nextFloat() < ((Float)entry.getValue()).floatValue() - (float)((Float)entry.getValue()).intValue() ? 1 : 0);
                    if (s.field_77994_a <= 0 || i >= imax) continue;
                    do {
                        if (s.field_77994_a <= s.func_77976_d()) {
                            this.mOutputItems[i++] = s;
                            continue block5;
                        }
                        this.mOutputItems[i++] = s.func_77979_a(s.func_77976_d());
                    } while (i < imax);
                }
                for (ItemStack itemStack : pollen.values()) {
                    if (i >= imax) break;
                    this.mOutputItems[i++] = itemStack;
                }
                this.mMaxProgresstime = (int)(cycles * 550.0f);
                int timemaxdivider = this.mMaxProgresstime / 100;
                int actualdivider = n = 1 << this.mSpeed;
                this.mMaxProgresstime /= Math.min(actualdivider, timemaxdivider);
                actualdivider /= Math.min(actualdivider, timemaxdivider);
                --i;
                while (i >= imin) {
                    this.mOutputItems[i].field_77994_a *= actualdivider;
                    --i;
                }
                this.pollinationDelay = Math.max((int)((float)this.mMaxProgresstime / cycles), 20);
                this.mProgresstime = 0;
                this.mEUt = (int)(37.0f * this.energyMod * (float)n);
                if (n == 2) {
                    this.mEUt += 32;
                } else if (n > 2) {
                    this.mEUt += 32 * (n << this.mSpeed - 2);
                }
            } else {
                IBee princess;
                this.retrievingPollenInThisOperation = true;
                this.mMaxProgresstime = 100;
                this.mProgresstime = 0;
                int useddivider = Math.min(100, 1 << this.mSpeed);
                this.mMaxProgresstime /= useddivider;
                this.mEUt = (int)(37.0f * this.energyMod * (float)useddivider);
                if (useddivider == 2) {
                    this.mEUt += 32;
                } else if (useddivider > 2) {
                    this.mEUt += 32 * (useddivider << this.mSpeed - 2);
                }
                this.usedQueenBee = princess = this.beeRoot.getMember(this.getQueen());
                IBee drone = this.beeRoot.getMember(this.getDrone());
                princess.mate((IIndividual)drone);
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                princess.writeToNBT(nbttagcompound);
                this.mOutputItems[0] = new ItemStack((Item)PluginApiculture.items.beeQueenGE);
                this.mOutputItems[0].func_77982_d(nbttagcompound);
                this.beeRoot.getBreedingTracker(this.getWorld(), this.getOwner()).registerQueen((IIndividual)princess);
                this.setQueen(null);
                --this.getDrone().field_77994_a;
                if (this.getDrone().field_77994_a == 0) {
                    this.setDrone(null);
                }
            }
            return 2;
        }
        return 0;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.updateModifiers();
    }

    @Override
    protected boolean hasEnoughEnergyToCheckRecipe() {
        return this.getBaseMetaTileEntity().isUniversalEnergyStored(GT_Values.V[this.mSpeed] * 8L);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isClientSide()) {
            if (GT_Client.changeDetected == 4) {
                aBaseMetaTileEntity.issueTextureUpdate();
            }
            if (aBaseMetaTileEntity.isActive() && this.usedQueen != null && aTick % 2L == 0L) {
                IBee bee = this.beeRoot.getMember(this.usedQueen);
                this.effectData = bee.doFX(this.effectData, (IBeeHousing)this);
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.doDisplayThings();
            if (!aBaseMetaTileEntity.isActive()) {
                int check;
                if (aBaseMetaTileEntity.isAllowedToWork() && (aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) && this.hasEnoughEnergyToCheckRecipe() && (check = this.checkRecipe()) == 2) {
                    aBaseMetaTileEntity.setActive(true);
                }
            } else {
                if (this.mProgresstime < 0) {
                    ++this.mProgresstime;
                    return;
                }
                if (this.mStuttering) {
                    if (!aBaseMetaTileEntity.isAllowedToWork()) {
                        return;
                    }
                    if (aTick % 100L == 0L) {
                        this.mStuttering = false;
                    }
                    return;
                }
                if (this.hasErrors()) {
                    if (!aBaseMetaTileEntity.isAllowedToWork()) {
                        return;
                    }
                    if (aTick % 100L == 0L && !this.canWork(this.usedQueen)) {
                        this.stutterProcess();
                    }
                    return;
                }
                if (!this.drainEnergyForProcess(this.mEUt)) {
                    this.mStuttering = true;
                    this.stutterProcess();
                    return;
                }
                ++this.mProgresstime;
                if (this.usedQueen != null) {
                    if (this.usedQueenBee == null) {
                        this.usedQueenBee = this.beeRoot.getMember(this.usedQueen);
                    }
                    this.effectData = this.usedQueenBee.doEffect(this.effectData, (IBeeHousing)this);
                    if (!this.retrievingPollenInThisOperation && this.floweringMod > 0.0f && this.mProgresstime % this.pollinationDelay == 0) {
                        if (this.retrievedpollen == null) {
                            this.retrievedpollen = this.usedQueenBee.retrievePollen((IBeeHousing)this);
                        }
                        if (this.retrievedpollen != null && (this.usedQueenBee.pollinateRandom((IBeeHousing)this, this.retrievedpollen) || this.mProgresstime % (this.pollinationDelay * 5) == 0)) {
                            this.retrievedpollen = null;
                        }
                    }
                }
                if (this.mProgresstime % 100 == 0 && !this.canWork(this.usedQueen)) {
                    this.stutterProcess();
                    return;
                }
                if (this.mProgresstime >= this.mMaxProgresstime) {
                    this.updateModifiers();
                    for (int i = 0; i < this.mOutputItems.length; ++i) {
                        if (this.mOutputItems[i] == null) continue;
                        for (int j = 0; j < this.mOutputItems.length && !(j != 0 || !this.isAutomated ? i == 0 && j == 0 && this.beeRoot.isMember(this.mOutputItems[0], EnumBeeType.QUEEN.ordinal()) && aBaseMetaTileEntity.addStackToSlot(5, this.mOutputItems[0]) : (this.beeRoot.isMember(this.mOutputItems[i], EnumBeeType.QUEEN.ordinal()) || this.beeRoot.isMember(this.mOutputItems[i], EnumBeeType.PRINCESS.ordinal()) ? aBaseMetaTileEntity.addStackToSlot(5, this.mOutputItems[i]) : this.beeRoot.isMember(this.mOutputItems[i], EnumBeeType.DRONE.ordinal()) && aBaseMetaTileEntity.addStackToSlot(6, this.mOutputItems[i]))) && !aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot() + (j + i) % this.mOutputItems.length, this.mOutputItems[i]); ++j) {
                        }
                    }
                    Arrays.fill(this.mOutputItems, null);
                    this.mEUt = 0;
                    this.mProgresstime = 0;
                    this.mMaxProgresstime = 0;
                    this.mStuttering = false;
                    aBaseMetaTileEntity.setActive(false);
                    if (this.doesAutoOutput() && !this.isOutputEmpty() && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing) {
                        TileEntity tTileEntity2 = aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getFrontFacing());
                        long tStoredEnergy = aBaseMetaTileEntity.getUniversalEnergyStored();
                        int tMaxStacks = (int)(tStoredEnergy / 64L);
                        if (tMaxStacks > this.mOutputItems.length) {
                            tMaxStacks = this.mOutputItems.length;
                        }
                        GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, tTileEntity2, aBaseMetaTileEntity.getFrontFacing(), aBaseMetaTileEntity.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, tMaxStacks);
                    }
                    if (aBaseMetaTileEntity.isAllowedToWork() && this.checkRecipe() == 2) {
                        aBaseMetaTileEntity.setActive(true);
                    }
                }
            }
        }
    }

    public void cancelProcess() {
        if (this.getBaseMetaTileEntity().isActive() && this.getBaseMetaTileEntity().isServerSide() && this.usedQueen != null && this.beeRoot.isMember(this.usedQueen, EnumBeeType.QUEEN.ordinal())) {
            Arrays.fill(this.mOutputItems, null);
            this.mEUt = 0;
            this.mProgresstime = 0;
            this.mMaxProgresstime = 0;
            this.mStuttering = false;
            this.getBaseMetaTileEntity().setActive(false);
            this.setQueen(this.usedQueen);
            this.getBaseMetaTileEntity().disableWorking();
        }
    }

    @Override
    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        if (aIndex < this.getInputSlot()) {
            return true;
        }
        if (aIndex == 5) {
            return this.beeRoot.isMember(aStack, EnumBeeType.QUEEN.ordinal()) || this.beeRoot.isMember(aStack, EnumBeeType.PRINCESS.ordinal());
        }
        if (aIndex == 6) {
            return this.beeRoot.isMember(aStack, EnumBeeType.DRONE.ordinal());
        }
        if (aIndex < this.getOutputSlot()) {
            if (!(aStack.func_77973_b() instanceof IApiaryUpgrade) && !GT_ApiaryUpgrade.isUpgrade(aStack)) {
                return false;
            }
            for (int i = 7; i < 11; ++i) {
                ItemStack s;
                if (aIndex == i || (s = this.func_70301_a(i)) == null) continue;
                if (GT_Utility.areStacksEqual(this.func_70301_a(i), aStack)) {
                    return false;
                }
                if (!(GT_ApiaryUpgrade.isUpgrade(aStack) ? !GT_ApiaryUpgrade.getUpgrade(aStack).isAllowedToWorkWith(this.func_70301_a(i)) : GT_ApiaryUpgrade.isUpgrade(s) && !GT_ApiaryUpgrade.getUpgrade(s).isAllowedToWorkWith(aStack))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex == 5 && aStack != null && this.getBaseMetaTileEntity().isClientSide()) {
            this.usedQueen = aStack.func_77946_l();
        }
        super.func_70299_a(aIndex, aStack);
    }

    public void onInventoryUpdate(int aIndex) {
        if (aIndex > 6 && aIndex < this.getOutputSlot()) {
            this.updateModifiers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getUsedQueen() {
        return this.usedQueen;
    }

    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singletonList(this);
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singletonList(this);
    }

    public IBeeHousingInventory getBeeInventory() {
        return this;
    }

    public IBeekeepingLogic getBeekeepingLogic() {
        return dummylogic;
    }

    public int getBlockLightValue() {
        return this.getBaseMetaTileEntity().getLightLevelAtSide((byte)1);
    }

    public boolean canBlockSeeTheSky() {
        return this.getBaseMetaTileEntity().getSkyAtSide((byte)1);
    }

    public World getWorld() {
        return this.getBaseMetaTileEntity().getWorld();
    }

    public GameProfile getOwner() {
        if (this.owner == null) {
            this.owner = new GameProfile(this.getBaseMetaTileEntity().getOwnerUuid(), this.getBaseMetaTileEntity().getOwnerName());
        }
        return this.owner;
    }

    public Vec3 getBeeFXCoordinates() {
        return Vec3.func_72443_a((double)((double)this.getBaseMetaTileEntity().getXCoord() + 0.5), (double)((double)this.getBaseMetaTileEntity().getYCoord() + 0.5), (double)((double)this.getBaseMetaTileEntity().getZCoord() + 0.5));
    }

    public BiomeGenBase getBiome() {
        if (this.biomeOverride == null) {
            return this.getBaseMetaTileEntity().getBiome();
        }
        return this.biomeOverride;
    }

    public EnumTemperature getTemperature() {
        if (BiomeHelper.isBiomeHellish((BiomeGenBase)this.getBiome())) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue((float)(this.getBiome().field_76750_F + this.temperatureMod));
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)(this.getBiome().field_76751_G + this.humidityMod));
    }

    public IErrorLogic getErrorLogic() {
        return this;
    }

    public ChunkCoordinates getCoordinates() {
        return this.getBaseMetaTileEntity().getCoords();
    }

    public ItemStack getQueen() {
        return this.func_70301_a(5);
    }

    public ItemStack getDrone() {
        return this.func_70301_a(6);
    }

    public void setQueen(ItemStack itemStack) {
        this.func_70299_a(5, itemStack);
    }

    public void setDrone(ItemStack itemStack) {
        this.func_70299_a(6, itemStack);
    }

    public boolean addProduct(ItemStack itemStack, boolean b) {
        throw new RuntimeException("Should not happen :F");
    }

    public boolean setCondition(boolean b, IErrorState iErrorState) {
        if (b) {
            this.mErrorStates.add(iErrorState);
        } else {
            this.mErrorStates.remove(iErrorState);
        }
        return b;
    }

    public boolean contains(IErrorState iErrorState) {
        return this.mErrorStates.contains(iErrorState);
    }

    public boolean hasErrors() {
        return !this.mErrorStates.isEmpty();
    }

    public void clearErrors() {
        this.mErrorStates.clear();
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.mErrorStates.size());
        for (IErrorState s : this.mErrorStates) {
            dataOutputStream.writeUTF(s.getUniqueName());
        }
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            this.mErrorStates.add(ForestryAPI.errorStateRegistry.getErrorState(dataInputStream.readUTF()));
        }
    }

    public ImmutableSet<IErrorState> getErrorStates() {
        return ImmutableSet.copyOf(this.mErrorStates);
    }

    private boolean checkFlower(IBee bee) {
        String flowerType = bee.getGenome().getFlowerProvider().getFlowerType();
        if (!this.flowerType.equals(flowerType)) {
            this.flowercoords = null;
        }
        if (this.flowercoords != null && (this.getWorld().func_147439_a(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c) != this.flowerBlock || this.getWorld().func_72805_g(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c) != this.flowerBlockMeta)) {
            if (!FlowerManager.flowerRegistry.isAcceptedFlower(flowerType, this.getWorld(), this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c)) {
                this.flowercoords = null;
            } else {
                this.flowerBlock = this.getWorld().func_147439_a(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
                this.flowerBlockMeta = this.getWorld().func_72805_g(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
            }
        }
        if (this.flowercoords == null) {
            this.flowercoords = FlowerManager.flowerRegistry.getAcceptedFlowerCoordinates((IBeeHousing)this, bee, flowerType);
            if (this.flowercoords != null) {
                this.flowerBlock = this.getWorld().func_147439_a(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
                this.flowerBlockMeta = this.getWorld().func_72805_g(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
                this.flowerType = flowerType;
            }
        }
        return this.flowercoords != null;
    }

    private boolean canWork(ItemStack queen) {
        this.clearErrors();
        if (queen == null) {
            return true;
        }
        if (this.beeRoot.isMember(queen, EnumBeeType.PRINCESS.ordinal())) {
            return true;
        }
        IBee bee = this.beeRoot.getMember(queen);
        for (IErrorState err : bee.getCanWork((IBeeHousing)this)) {
            this.setCondition(true, err);
        }
        this.setCondition(!this.checkFlower(bee), (IErrorState)EnumErrorCode.NO_FLOWER);
        return !this.hasErrors();
    }

    private boolean canWork() {
        this.clearErrors();
        EnumBeeType beeType = this.beeRoot.getType(this.getQueen());
        if (beeType == EnumBeeType.PRINCESS) {
            this.setCondition(!this.beeRoot.isDrone(this.getDrone()), (IErrorState)EnumErrorCode.NO_DRONE);
            return !this.hasErrors();
        }
        if (beeType == EnumBeeType.QUEEN) {
            IBee bee = this.beeRoot.getMember(this.getQueen());
            for (IErrorState err : bee.getCanWork((IBeeHousing)this)) {
                this.setCondition(true, err);
            }
            this.setCondition(!this.checkFlower(bee), (IErrorState)EnumErrorCode.NO_FLOWER);
            return !this.hasErrors();
        }
        this.setCondition(true, (IErrorState)EnumErrorCode.NO_QUEEN);
        return false;
    }

    public void updateModifiers() {
        this.maxspeed = 0;
        ApiaryModifiers mods = new ApiaryModifiers();
        for (int i = 2; i < 6; ++i) {
            GT_ApiaryUpgrade upgrade;
            ItemStack s = this.getInputAt(i);
            if (s == null) continue;
            if (s.func_77973_b() instanceof IApiaryUpgrade) {
                IApiaryUpgrade up = (IApiaryUpgrade)s.func_77973_b();
                up.applyModifiers(mods, s);
                continue;
            }
            if (!GT_ApiaryUpgrade.isUpgrade(s) || (upgrade = GT_ApiaryUpgrade.getUpgrade(s)) == null) continue;
            this.maxspeed = upgrade.applyMaxSpeedModifier(this.maxspeed);
            upgrade.applyModifiers(mods, s);
        }
        this.terrorityMod = mods.territory;
        this.mutationMod = mods.mutation;
        this.lifespanMod = mods.lifespan;
        this.productionMod = mods.production;
        this.floweringMod = mods.flowering;
        this.geneticDecayMod = mods.geneticDecay;
        this.energyMod = mods.energy;
        this.sealedMod = mods.isSealed;
        this.selfLightedMod = mods.isSelfLighted;
        this.sunlightSimulatedMod = mods.isSunlightSimulated;
        this.biomeOverride = mods.biomeOverride;
        this.humidityMod = mods.humidity;
        this.temperatureMod = mods.temperature;
        this.isAutomated = mods.isAutomated;
        this.isRetrievingPollen = mods.isCollectingPollen;
        this.mSpeed = this.mLockedSpeed ? this.maxspeed : Math.min(this.mSpeed, this.maxspeed);
    }

    public float getTerritoryModifier(IBeeGenome iBeeGenome, float v) {
        return Math.min(5.0f, this.terrorityMod);
    }

    public float getMutationModifier(IBeeGenome iBeeGenome, IBeeGenome iBeeGenome1, float v) {
        return this.mutationMod;
    }

    public float getLifespanModifier(IBeeGenome iBeeGenome, IBeeGenome iBeeGenome1, float v) {
        return this.lifespanMod;
    }

    public float getProductionModifier(IBeeGenome iBeeGenome, float v) {
        return this.productionMod;
    }

    public float getFloweringModifier(IBeeGenome iBeeGenome, float v) {
        return this.floweringMod;
    }

    public float getGeneticDecay(IBeeGenome iBeeGenome, float v) {
        return this.geneticDecayMod;
    }

    public float getEnergyModifier() {
        return this.energyMod;
    }

    public boolean isSealed() {
        return this.sealedMod;
    }

    public boolean isSelfLighted() {
        return this.selfLightedMod;
    }

    public boolean isSunlightSimulated() {
        return this.sunlightSimulatedMod;
    }

    public boolean isHellish() {
        return this.getBiome() == BiomeGenBase.field_76778_j;
    }

    public int getMaxSpeed() {
        return this.maxspeed;
    }

    public void wearOutEquipment(int i) {
    }

    public void onQueenDeath() {
    }

    public boolean onPollenRetrieved(IIndividual iIndividual) {
        return false;
    }
}

