/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IConfigurationCircuitSupport;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.render.TextureFactory;
import gregtech.common.gui.GT_Container_InputBus_ME;
import gregtech.common.gui.GT_GUIContainer_InputBus_ME;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_InputBus_ME
extends GT_MetaTileEntity_Hatch_InputBus
implements IConfigurationCircuitSupport {
    private static final int SLOT_COUNT = 16;
    private BaseActionSource requestSource = null;
    private AENetworkProxy gridProxy = null;
    private final ItemStack[] shadowInventory = new ItemStack[16];
    private final int[] savedStackSizes = new int[16];
    private boolean processingRecipe = false;

    public GT_MetaTileEntity_Hatch_InputBus_ME(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 1, 33, new String[]{"Advanced item input for Multiblocks", "Retrieves directly from ME", "Keeps 16 item types in stock"});
        this.disableSort = true;
    }

    public GT_MetaTileEntity_Hatch_InputBus_ME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 33, aDescription, aTextures);
        this.disableSort = true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_InputBus_ME(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_HATCH)};
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_InputBus_ME(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_InputBus_ME(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing((byte)forgeDirection.ordinal()) ? AECableType.SMART : AECableType.NONE;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", ItemList.Hatch_Output_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void gridChanged() {
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        int[] sizes = new int[16];
        for (int i = 0; i < 16; ++i) {
            sizes[i] = this.mInventory[i + 16] == null ? 0 : this.mInventory[i + 16].field_77994_a;
        }
        aNBT.func_74783_a("sizes", sizes);
        if (GregTech_API.mAE2) {
            this.gridProxy.writeToNBT(aNBT);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int[] sizes;
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("sizes") && (sizes = aNBT.func_74759_k("sizes")).length == 16) {
            for (int i = 0; i < 16; ++i) {
                if (sizes[i] == 0 || this.mInventory[i] == null) continue;
                ItemStack s = this.mInventory[i].func_77946_l();
                s.field_77994_a = sizes[i];
                this.mInventory[i + 16] = s;
            }
        }
        if (GregTech_API.mAE2) {
            this.getProxy().readFromNBT(aNBT);
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (GregTech_API.mAE2) {
            return new String[]{"The bus is " + (this.getProxy() != null && this.getProxy().isActive() ? EnumChatFormatting.GREEN + "online" : EnumChatFormatting.RED + "offline" + this.getAEDiagnostics()) + EnumChatFormatting.RESET};
        }
        return new String[0];
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public void updateSlots() {
    }

    @Override
    public int getCircuitSlot() {
        return 32;
    }

    @Override
    public int getCircuitSlotX() {
        return 80;
    }

    @Override
    public int getCircuitSlotY() {
        return 63;
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        if (!this.processingRecipe) {
            return super.func_70301_a(aIndex);
        }
        if (aIndex < 0 || aIndex > this.mInventory.length) {
            return null;
        }
        if (aIndex >= 16 && aIndex < 32) {
            return null;
        }
        if (aIndex == this.getCircuitSlot()) {
            return this.mInventory[aIndex];
        }
        if (GregTech_API.mAE2 && this.mInventory[aIndex] != null) {
            AENetworkProxy proxy = this.getProxy();
            if (proxy == null) {
                return null;
            }
            try {
                IMEMonitor sg = proxy.getStorage().getItemInventory();
                AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[aIndex]);
                request.setStackSize(Integer.MAX_VALUE);
                IAEItemStack result = (IAEItemStack)sg.extractItems((IAEStack)request, Actionable.SIMULATE, this.getRequestSource());
                if (result != null) {
                    this.shadowInventory[aIndex] = result.getItemStack();
                    this.savedStackSizes[aIndex] = this.shadowInventory[aIndex].field_77994_a;
                    this.func_70299_a(aIndex + 16, this.shadowInventory[aIndex]);
                    return this.shadowInventory[aIndex];
                }
                this.func_70299_a(aIndex + 16, null);
                return null;
            }
            catch (GridAccessException gridAccessException) {
                return null;
            }
        }
        this.func_70299_a(aIndex + 16, null);
        return this.mInventory[aIndex];
    }

    @Optional.Method(modid="appliedenergistics2")
    private BaseActionSource getRequestSource() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    public void onExplosion() {
        for (int i = 0; i < 16; ++i) {
            this.mInventory[i] = null;
        }
    }

    @Override
    public void startRecipeProcessing() {
        this.processingRecipe = true;
    }

    @Override
    public void endRecipeProcessing() {
        if (GregTech_API.mAE2) {
            for (int i = 0; i < 16; ++i) {
                if (this.savedStackSizes[i] == 0) continue;
                ItemStack oldStack = this.shadowInventory[i];
                if (oldStack == null || oldStack.field_77994_a < this.savedStackSizes[i]) {
                    AENetworkProxy proxy = this.getProxy();
                    try {
                        IMEMonitor sg = proxy.getStorage().getItemInventory();
                        AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[i]);
                        request.setStackSize((long)(this.savedStackSizes[i] - (oldStack == null ? 0 : oldStack.field_77994_a)));
                        sg.extractItems((IAEStack)request, Actionable.MODULATE, this.getRequestSource());
                        proxy.getEnergy().extractAEPower((double)request.getStackSize(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                        this.func_70299_a(i + 16, oldStack);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                this.savedStackSizes[i] = 0;
                this.shadowInventory[i] = null;
            }
        }
        this.processingRecipe = false;
    }

    public ItemStack updateInformationSlot(int aIndex, ItemStack aStack) {
        if (GregTech_API.mAE2 && aIndex >= 0 && aIndex < 16) {
            if (aStack == null) {
                super.func_70299_a(aIndex + 16, null);
            } else {
                AENetworkProxy proxy = this.getProxy();
                if (!proxy.isActive()) {
                    super.func_70299_a(aIndex + 16, null);
                    return null;
                }
                try {
                    IMEMonitor sg = proxy.getStorage().getItemInventory();
                    AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[aIndex]);
                    request.setStackSize(Integer.MAX_VALUE);
                    IAEItemStack result = (IAEItemStack)sg.extractItems((IAEStack)request, Actionable.SIMULATE, this.getRequestSource());
                    ItemStack s = result != null ? result.getItemStack() : null;
                    this.func_70299_a(aIndex + 16, s);
                    return s;
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }
}

