/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.debug;

import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.common.gui.GT_Container_AdvDebugStructureWriter;
import gregtech.common.gui.GT_GUIContainer_AdvDebugStructureWriter;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GT_MetaTileEntity_AdvDebugStructureWriter
extends GT_MetaTileEntity_TieredMachineBlock {
    private static final HashMap<GT_MetaTileEntity_AdvDebugStructureWriter, BoundHighlighter> bondingBoxes = new HashMap(1);
    private final BoundHighlighter boundingBox = new BoundHighlighter();
    public short[] numbers = new short[6];
    public boolean transpose = false;
    public boolean showHighlightBox = true;
    public String[] result = new String[]{"Undefined"};

    public GT_MetaTileEntity_AdvDebugStructureWriter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
    }

    public GT_MetaTileEntity_AdvDebugStructureWriter(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AdvDebugStructureWriter(this.mName, this.mTier, "", this.mTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide != aFacing ? TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE).glow().build()) : TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.STRUCTURE_MARK).glow().build())};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_AdvDebugStructureWriter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_AdvDebugStructureWriter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.numbers.length; ++i) {
            aNBT.func_74777_a("eData" + i, this.numbers[i]);
        }
        aNBT.func_74757_a("Transpose", this.transpose);
        aNBT.func_74757_a("HighlightBox", this.showHighlightBox);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.numbers.length; ++i) {
            this.numbers[i] = aNBT.func_74765_d("eData" + i);
        }
        this.transpose = aNBT.func_74767_n("Transpose");
        this.showHighlightBox = aNBT.func_74767_n("HighlightBox");
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        bondingBoxes.put(this, this.boundingBox);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ExtendedFacing writerFacing = ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()));
            double[] abc = new double[3];
            double[] xyz = new double[3];
            this.boundingBox.dim = aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
            this.boundingBox.showHighlightBox = this.showHighlightBox;
            abc[0] = (double)(-this.numbers[0]) - 0.5;
            abc[1] = (double)(-this.numbers[1]) - 0.5;
            abc[2] = (double)(-this.numbers[2]) - 0.5;
            writerFacing.getWorldOffset(abc, xyz);
            this.boundingBox.pos1 = new Vec3Impl(aBaseMetaTileEntity.getXCoord() + (int)(xyz[0] + 0.5), aBaseMetaTileEntity.getYCoord() + (int)(xyz[1] + 0.5), aBaseMetaTileEntity.getZCoord() + (int)(xyz[2] + 0.5));
            abc[0] = (double)(-this.numbers[0] + this.numbers[3]) - 0.5;
            abc[1] = (double)(-this.numbers[1] + this.numbers[4]) - 0.5;
            abc[2] = (double)(-this.numbers[2] + this.numbers[5]) - 0.5;
            writerFacing.getWorldOffset(abc, xyz);
            this.boundingBox.pos2 = new Vec3Impl(aBaseMetaTileEntity.getXCoord() + (int)(xyz[0] + 0.5), aBaseMetaTileEntity.getYCoord() + (int)(xyz[1] + 0.5), aBaseMetaTileEntity.getZCoord() + (int)(xyz[2] + 0.5));
        }
    }

    @Override
    public void onRemoval() {
        bondingBoxes.remove(this);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        this.printStructure(aPlayer);
        aBaseMetaTileEntity.disableWorking();
    }

    public void printStructure(EntityPlayer aPlayer) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        String pseudoJavaCode = StructureUtility.getPseudoJavaCode((World)aBaseMetaTileEntity.getWorld(), (ExtendedFacing)ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing())), (int)aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), (int)aBaseMetaTileEntity.getZCoord(), (int)this.numbers[0], (int)this.numbers[1], (int)this.numbers[2], te -> te.getClass().getCanonicalName(), (int)this.numbers[3], (int)this.numbers[4], (int)this.numbers[5], (boolean)this.transpose);
        GT_Mod.GT_FML_LOGGER.info(pseudoJavaCode);
        this.result = pseudoJavaCode.split("\\n");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.printed"), new Object[0]));
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.tooltip"), StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.tooltip.1"), StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.tooltip.2")};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return this.result;
    }

    private static class BoundHighlighter {
        public Vec3Impl pos1;
        public Vec3Impl pos2;
        public boolean showHighlightBox;
        public int dim;

        private BoundHighlighter() {
        }

        @SideOnly(value=Side.CLIENT)
        private void renderHighlightedBlock(RenderWorldLastEvent event) {
            if (this.pos1 == null || this.pos2 == null || !this.showHighlightBox) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int dimension = mc.field_71441_e.field_73011_w.field_76574_g;
            if (dimension != this.dim) {
                this.pos1 = null;
                this.pos2 = null;
                return;
            }
            EntityClientPlayerMP p = mc.field_71439_g;
            double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)event.partialTicks;
            double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)event.partialTicks;
            double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)event.partialTicks;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glLineWidth((float)3.0f);
            GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            BoundHighlighter.renderHighLightedArenaOutline(this.pos1.get0(), this.pos1.get1(), this.pos1.get2(), this.pos2.get0(), this.pos2.get1(), this.pos2.get2());
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }

        @SideOnly(value=Side.CLIENT)
        static void renderHighLightedArenaOutline(double x1, double y1, double z1, double x2, double y2, double z2) {
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y1, (double)z2);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y2, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z2);
            GL11.glEnd();
        }
    }

    public static class ForgeEventHandler {
        public ForgeEventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onRenderWorldLast(RenderWorldLastEvent e) {
            for (BoundHighlighter boundingBox : bondingBoxes.values()) {
                boundingBox.renderHighlightedBlock(e);
            }
        }
    }
}

