/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import codechicken.lib.render.TextureUtils;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.GT_RenderUtil;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_GeneratedMaterial_Renderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        IIcon fluidIcon;
        short aMetaData = (short)aStack.func_77960_j();
        GT_MetaGenerated_Item aItem = (GT_MetaGenerated_Item)aStack.func_77973_b();
        IIconContainer aIconContainer = aItem.getIconContainer(aMetaData);
        if (aIconContainer == null) {
            return;
        }
        IIcon tIcon = aIconContainer.getIcon();
        IIcon tOverlay = aIconContainer.getOverlayIcon();
        FluidStack aFluid = GT_Utility.getFluidForFilledItem(aStack, true);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        if (tIcon != null) {
            this.renderRegularItem(type, aStack, tIcon, aFluid == null);
        }
        if (tOverlay != null && aFluid != null && aFluid.getFluid() != null && (fluidIcon = aFluid.getFluid().getIcon(aFluid)) != null) {
            this.renderContainedFluid(type, aFluid, fluidIcon);
        }
        if (tOverlay != null) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            TextureUtils.bindAtlas((int)aItem.func_94901_k());
            if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                GT_RenderUtil.renderItemIcon(tOverlay, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
            } else {
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)tOverlay.func_94212_f(), (float)tOverlay.func_94206_g(), (float)tOverlay.func_94209_e(), (float)tOverlay.func_94210_h(), (int)tOverlay.func_94211_a(), (int)tOverlay.func_94216_b(), (float)0.0625f);
            }
        }
        GL11.glDisable((int)3042);
    }

    public void renderRegularItem(IItemRenderer.ItemRenderType type, ItemStack aStack, IIcon icon, boolean shouldModulateColor) {
        GT_MetaGenerated_Item aItem = (GT_MetaGenerated_Item)aStack.func_77973_b();
        if (shouldModulateColor) {
            short[] tModulation = aItem.getRGBa(aStack);
            GL11.glColor3f((float)((float)tModulation[0] / 255.0f), (float)((float)tModulation[1] / 255.0f), (float)((float)tModulation[2] / 255.0f));
        }
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GT_RenderUtil.renderItemIcon(icon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
        } else {
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
    }

    public void renderContainedFluid(IItemRenderer.ItemRenderType type, FluidStack aFluidStack, IIcon fluidIcon) {
        Fluid aFluid = aFluidStack.getFluid();
        int tColor = aFluid.getColor(aFluidStack);
        GL11.glColor3f((float)((float)(tColor >> 16 & 0xFF) / 255.0f), (float)((float)(tColor >> 8 & 0xFF) / 255.0f), (float)((float)(tColor & 0xFF) / 255.0f));
        TextureUtils.bindAtlas((int)aFluid.getSpriteNumber());
        GL11.glDepthFunc((int)514);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GT_RenderUtil.renderItemIcon(fluidIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
        } else {
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)fluidIcon.func_94212_f(), (float)fluidIcon.func_94206_g(), (float)fluidIcon.func_94209_e(), (float)fluidIcon.func_94210_h(), (int)fluidIcon.func_94211_a(), (int)fluidIcon.func_94216_b(), (float)0.0625f);
        }
        GL11.glDepthFunc((int)515);
    }
}

