/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;
import java.util.Arrays;

public enum CombType {
    LIGNIE(0, "lignite", true, Materials.Lignite, 100, 5779467, 9462327),
    COAL(1, "coal", true, Materials.Coal, 100, 0x525252, 0x666666),
    STICKY(2, "stickyresin", true, Materials._NULL, 50, 3051355, 14467721),
    OIL(3, "oil", true, Materials._NULL, 100, 0x333333, 0x4C4C4C),
    APATITE(4, "apatite", true, Materials.Apatite, 100, 12698102, 6776708),
    ASH(5, "ash", true, Materials.Ash, 100, 1972760, 0xC6C6C6),
    COOLANT(6, "coolant", true, Materials._NULL, 100, 1331034, 2397346),
    ENERGY(7, "energy", true, Materials._NULL, 80, 0xC11F1F, 0xEBB9B9),
    LAPOTRON(8, "lapotron", true, Materials._NULL, 60, 0x1414FF, 6584575),
    PYROTHEUM(9, "pyrotheum", true, Materials.Pyrotheum, 50, 16772036, 14902272),
    CRYOTHEUM(10, "cryotheum", true, Materials.Pyrotheum, 50, 2515199, 5961727),
    REDALLOY(11, "redalloy", true, Materials.RedAlloy, 100, 0xE60000, 0xB80000),
    REDSTONEALLOY(12, "redstonealloy", true, Materials.RedstoneAlloy, 90, 0xB80000, 10815496),
    CONDUCTIVEIRON(13, "conductiveiron", true, Materials.ConductiveIron, 80, 8484465, 13544867),
    VIBRANTALLOY(14, "vibrantalloy", true, Materials.VibrantAlloy, 50, 8823085, 12907182),
    ENERGETICALLOY(15, "energeticalloy", true, Materials.EnergeticAlloy, 70, 0xFF9933, 16756060),
    ELECTRICALSTEEL(16, "electricalsteel", true, Materials.ElectricalSteel, 90, 0x787878, 0xD8D8D8),
    DARKSTEEL(17, "darksteel", true, Materials.DarkSteel, 80, 0x252525, 0x443B44),
    PULSATINGIRON(18, "pulsatingiron", true, Materials.PulsatingIron, 80, 26112, 7197316),
    STAINLESSSTEEL(19, "stainlesssteel", true, Materials.StainlessSteel, 75, 0x778899, 0xC8C8DC),
    ENDERIUM(20, "enderium", true, Materials.Enderium, 40, 3050327, 5869703),
    THAUMIUMDUST(21, "thaumiumdust", true, Materials.Thaumium, 100, 0x7A007A, 0x5C005C),
    THAUMIUMSHARD(22, "thaumiumshard", true, Materials._NULL, 85, 0x9966FF, 11372031),
    AMBER(23, "amber", true, Materials.Amber, 90, 7818005, 0xEE7700),
    QUICKSILVER(24, "quicksilver", true, Materials.Mercury, 90, 13092842, 11908063),
    SALISMUNDUS(25, "salismundus", true, Materials._NULL, 75, 16231902, 5842306),
    TAINTED(26, "tainted", true, Materials._NULL, 80, 9456568, 15204607),
    MITHRIL(27, "mithril", true, Materials.Mithril, 70, 15787660, 0xFFFFD2),
    ASTRALSILVER(28, "astralsilver", true, Materials.AstralSilver, 70, 0xAFEEEE, 0xE6E6FF),
    THAUMINITE(29, "thauminite", true, Materials._NULL, 50, 3026297, 7700960),
    SHADOWMETAL(30, "shadowmetal", true, Materials.Shadow, 50, 1049378, 1049410),
    DIVIDED(31, "divided", true, Materials.Unstable, 40, 0xF0F0F0, 0xDCDCDC),
    SPARKELING(32, "sparkling", true, Materials.NetherStar, 40, 0x7A007A, 0xFFFFFF),
    STONE(33, "stone", true, Materials._NULL, 70, 0x808080, 0x999999),
    CERTUS(34, "certus", true, Materials.CertusQuartz, 100, 5754875, 0xBBEEFF),
    FLUIX(35, "fluix", true, Materials.Fluix, 100, 10712575, 11899391),
    REDSTONE(36, "redstone", true, Materials.Redstone, 100, 8195855, 0xD11919),
    RAREEARTH(37, "rareearth", true, Materials.RareEarth, 100, 5592643, 3421224),
    LAPIS(38, "lapis", true, Materials.Lapis, 100, 1656785, 4680922),
    RUBY(39, "ruby", true, Materials.Ruby, 100, 15073372, 13369426),
    REDGARNET(40, "redgarnet", true, Materials.GarnetRed, 100, 12405836, 0xECCECE),
    YELLOWGARNET(41, "yellowgarnet", true, Materials.GarnetYellow, 100, 10724161, 0xEDEDCE),
    SAPPHIRE(42, "sapphire", true, Materials.Sapphire, 100, 13260, 9359),
    DIAMOND(43, "diamond", true, Materials.Diamond, 100, 0xCCFFFF, 0xA3CCCC),
    OLIVINE(44, "olivine", true, Materials.Olivine, 100, 2395940, 0xCCFFCC),
    EMERALD(45, "emerald", true, Materials.Emerald, 100, 2395940, 3061806),
    PYROPE(46, "pyrope", true, Materials.Pyrope, 100, 7745890, 0x8B8B8B),
    GROSSULAR(47, "grossular", true, Materials.Grossular, 100, 10178048, 0x8B8B8B),
    FIRESTONE(48, "firestone", true, Materials.Firestone, 100, 0xC00000, 0xFF0000),
    SLAG(49, "slag", true, Materials._NULL, 50, 0xD4D4D4, 5779467),
    COPPER(50, "copper", true, Materials.Copper, 100, 0xFF6600, 15096832),
    TIN(51, "tin", true, Materials.Tin, 100, 0xD4D4D4, 0xDDDDDD),
    LEAD(52, "lead", true, Materials.Lead, 100, 0x666699, 0xA3A3CC),
    IRON(53, "iron", true, Materials.Iron, 100, 14324039, 14589017),
    STEEL(54, "steel", true, Materials.Steel, 95, 0x808080, 0x999999),
    NICKEL(55, "nickel", true, Materials.Nickel, 100, 8750509, 0x9D9DBD),
    ZINC(56, "zinc", true, Materials.Zinc, 100, 15785712, 15917554),
    SILVER(57, "silver", true, Materials.Silver, 100, 12763862, 0xCECEDE),
    GOLD(58, "gold", true, Materials.Gold, 100, 15120384, 13608448),
    SULFUR(59, "sulfur", true, Materials.Sulfur, 100, 7302913, 0x8B8B8B),
    GALLIUM(60, "gallium", true, Materials.Gallium, 75, 0x8B8B8B, 12961252),
    ARSENIC(61, "arsenic", true, Materials.Arsenic, 75, 7564370, 2696210),
    BAUXITE(62, "bauxite", true, Materials.Bauxite, 85, 7026176, 0x8B8B8B),
    ALUMINIUM(63, "aluminium", true, Materials.Aluminium, 60, 35512, 0xD6D6FF),
    MANGANESE(64, "manganese", true, Materials.Manganese, 30, 0xD5D5D5, 0xAAAAAA),
    MAGNESIUM(65, "magnesium", true, Materials.Magnesium, 75, 15849945, 0x8B8B8B),
    TITANIUM(66, "titanium", true, Materials.Ilmenite, 100, 0xCC99FF, 14399743),
    CHROME(67, "chromium", true, Materials.Chrome, 50, 15442411, 15909874),
    TUNGSTEN(68, "tungsten", true, Materials.Tungstate, 100, 0x62626D, 1447456),
    PLATINUM(69, "platinum", true, Materials.Platinum, 40, 0xE6E6E6, 0xFFFFCC),
    IRIDIUM(70, "iridium", true, Materials.Iridium, 20, 0xDADADA, 13750752),
    MOLYBDENUM(71, "molybdenum", true, Materials.Molybdenum, 20, 11448020, 0x8B8B8B),
    OSMIUM(72, "osmium", true, Materials.Osmium, 15, 2829274, 0x8B8B8B),
    LITHIUM(73, "lithium", true, Materials.Lithium, 75, 15741580, 14802175),
    SALT(74, "salt", true, Materials.Salt, 90, 15780040, 0xFAFAFA),
    ELECTROTINE(75, "electrotine", true, Materials.Electrotine, 75, 2003199, 3978440),
    ALMANDINE(76, "almandine", true, Materials.Almandine, 85, 0xC60000, 0x8B8B8B),
    URANIUM(77, "uranium", true, Materials.Uranium, 50, 1683225, 1482262),
    PLUTONIUM(78, "plutonium", true, Materials.Plutonium, 10, 0x240000, 0x570000),
    NAQUADAH(79, "naquadah", true, Materials.Naquadah, 10, 0, 17408),
    NAQUADRIA(80, "naquadria", true, Materials.Naquadria, 5, 0, 9216),
    DOB(81, "d-o-b", true, Materials._NULL, 50, 30464, 9216),
    THORIUM(82, "thorium", true, Materials.Thorium, 75, 7680, 20480),
    LUTETIUM(83, "lutetium", true, Materials.Lutetium, 10, 0xE6FFE6, 0xFFFFFF),
    AMERICIUM(84, "americium", true, Materials.Americium, 5, 0xE6E6FF, 0xC8C8C8),
    NEUTRONIUM(85, "neutronium", true, Materials.Neutronium, 2, 0xFFF0F0, 0xFAFAFA),
    NAGA(86, "naga", true, Materials._NULL, 100, 875021, 2656075),
    LICH(87, "lich", true, Materials._NULL, 90, 6053982, 0xC5C5C5),
    HYDRA(88, "hydra", true, Materials._NULL, 80, 8857654, 12063532),
    URGHAST(89, "urghast", true, Materials._NULL, 70, 8128024, 10945564),
    SNOWQUEEN(90, "snowqueen", true, Materials._NULL, 60, 10223640, 13639681),
    SPACE(91, "space", true, Materials._NULL, 100, 13158, 0xC0C0C0),
    METEORICIRON(92, "meteoriciron", true, Materials.MeteoricIron, 100, 3283240, 6566480),
    DESH(93, "desh", true, Materials.Desh, 90, 0x282828, 0x323232),
    LEDOX(94, "ledox", true, Materials.Ledox, 75, 205, 29951),
    CALLISTOICE(95, "callistoice", true, Materials.CallistoIce, 75, 29951, 2011647),
    MYTRYL(96, "mytryl", true, Materials.Mytryl, 65, 14329120, 15885316),
    QUANTIUM(97, "quantium", true, Materials.Quantium, 50, 65280, 53515),
    ORIHARUKON(98, "oriharukon", true, Materials.Oriharukon, 50, 0x228B22, 6782312),
    MYSTERIOUSCRYSTAL(99, "mysteriouscrystal", true, Materials.MysteriousCrystal, 45, 3978097, 1475948),
    BLACKPLUTONIUM(100, "blackplutonium", true, Materials.Quantium, 25, 0, 0x323232),
    TRINIUM(101, "trinium", true, Materials.Trinium, 25, 11591910, 13158610),
    MERCURY(102, "mercury", true, Materials._NULL, 65, 4866099, 11903624),
    VENUS(103, "venus", true, Materials._NULL, 65, 1183239, 2564112),
    MOON(104, "moon", true, Materials._NULL, 90, 0x373735, 0x7E7E78),
    MARS(105, "mars", true, Materials._NULL, 80, 2231557, 3806469),
    JUPITER(106, "jupiter", true, Materials._NULL, 75, 7555886, 13683652),
    SATURN(107, "saturn", true, Materials._NULL, 55, 13804658, 16302971),
    URANUS(108, "uranus", true, Materials._NULL, 45, 7717065, 8706284),
    NEPTUN(109, "neptun", true, Materials._NULL, 35, 3362047, 5729791),
    PLUTO(110, "pluto", true, Materials._NULL, 25, 3417886, 6901821),
    HAUMEA(111, "haumea", true, Materials._NULL, 20, 1840147, 3746600),
    MAKEMAKE(112, "makemake", true, Materials._NULL, 20, 3151889, 1182215),
    CENTAURI(113, "centauri", true, Materials._NULL, 15, 3090964, 11561778),
    TCETI(114, "tceti", true, Materials._NULL, 10, 4596762, 8077615),
    BARNARDA(115, "barnarda", true, Materials._NULL, 10, 875021, 15122829),
    VEGA(116, "vega", true, Materials._NULL, 10, 1712182, 11911390),
    COSMICNEUTRONIUM(117, "cosmicneutronium", true, Materials._NULL, 5, 0x484848, 0x323232),
    INFINITYCATALYST(118, "infinitycatalyst", true, Materials._NULL, 2, 0xFFFFFF, 0xFFFFFF),
    INFINITY(119, "infinity", true, Materials._NULL, 1, 0xFFFFFF, 0xFFFFFF),
    ENDDUST(120, "enddust", true, Materials._NULL, 50, 14973, 13369594),
    ECTOPLASMA(121, "ectoplasma", true, Materials._NULL, 35, 3677248, 14463205),
    ARCANESHARD(122, "arcaneshard", true, Materials._NULL, 35, 3358082, 9441453),
    STARDUST(123, "stardust", true, Materials._NULL, 60, 14466579, 0xFFFF00),
    DRAGONESSENCE(124, "dragonessence", true, Materials._NULL, 30, 9510606, 16752939),
    ENDERMAN(125, "enderman", true, Materials._NULL, 25, 6422759, 0x161616),
    SILVERFISH(126, "silverfish", true, Materials._NULL, 25, 0, 15598909),
    ENDIUM(127, "endium", true, Materials.HeeEndium, 50, 3103340, 0xA0FFFF),
    RUNEI(128, "rune1", true, Materials._NULL, 10, 66777, 14880784),
    RUNEII(129, "rune2", true, Materials._NULL, 10, 14880784, 66777),
    FIREESSENSE(130, "fireessence", true, Materials._NULL, 30, 16752983, 13898296),
    CRYOLITE(131, "cryolite", true, Materials.Cryolite, 90, 0xBFEFFF, 7584208),
    HELIUM(132, "helium", true, Materials.Helium, 90, 0xFFA9FF, 0xFFFFC3),
    ARGON(133, "argon", true, Materials.Argon, 95, 9034209, 1443874),
    XENON(134, "xenon", true, Materials._NULL, 85, 1443874, 9082800),
    NEON(135, "neon", true, Materials._NULL, 90, 16740864, 16762918),
    KRYPTON(136, "krypton", true, Materials._NULL, 85, 1443874, 9082800),
    NITROGEN(137, "nitrogen", true, Materials.Nitrogen, 100, 0xA52A2A, 16762930),
    OXYGEN(138, "oxygen", true, Materials.Oxygen, 100, 0x8F8FFF, 0xFFFFFF),
    HYDROGEN(139, "hydrogen", true, Materials.Hydrogen, 100, 16716947, 0xFFFFFF),
    PHOSPHORUS(140, "phosphorus", true, Materials.Phosphorus, 100, 12698102, 16762918),
    MICA(141, "mica", true, Materials.Mica, 100, 9082800, 3094081),
    SEAWEED(142, "seaweed", true, Materials._NULL, 90, 0x83FF83, 0xCBCBCB),
    WALRUS(143, "walrus", true, Materials._NULL, 100, 11915209, 14079360),
    INFUSEDAER(144, "infusedair", true, Materials._NULL, 100, 6316079, 0xFFFF7E),
    INFUSEDTERRA(145, "infusedterra", true, Materials._NULL, 100, 13056, 34304),
    INFUSEDIGNIS(146, "infusedignis", true, Materials._NULL, 100, 3870208, 15546369),
    INFUSEDAQUA(147, "infusedaqua", true, Materials._NULL, 100, 9538, 37119),
    INFUSEDORDO(148, "infusedordo", true, Materials._NULL, 100, 6053730, 9082800),
    INFUSEDPERDITIO(149, "infusedperditio", true, Materials._NULL, 100, 2302249, 3026497),
    FLUORINE(150, "fluorine", true, Materials.Fluorine, 100, 16739584, 8826864),
    BEDROCKIUM(151, "bedrockium", true, Materials.Bedrockium, 100, 0xC6C6C6, 789516),
    NETHERSHARD(152, "nethershard", true, Materials.Netherrack, 100, 3473937, 12452149),
    ENDSHARD(153, "endshard", true, Materials.EnderEye, 100, 2302249, 3026497),
    CAELESTISRED(154, "caelestisred", true, Materials._NULL, 100, 0xFF0000, 0xFF00FF),
    CAELESTISGREEN(155, "caelestisgreen", true, Materials._NULL, 100, 65280, 11678719),
    CAELESTISBLUE(156, "caelestisblue", true, Materials._NULL, 100, 255, 16751013),
    UNKNOWNWATER(157, "unknownwater", true, Materials._NULL, 100, 3582975, 4404133),
    ESSENTIA(158, "essentia", true, Materials._NULL, 100, 15545857, 16739664),
    INDIUM(159, "indium", true, Materials.Indium, 100, 9395609, 0xFFA9FF),
    _NULL(-1, "INVALIDCOMB", false, Materials._NULL, 0, 0, 0);

    public boolean showInList;
    public Materials material;
    public int chance;
    private final int id;
    private final String name;
    private final int[] color;

    private CombType(String pName, boolean show, Materials material, int chance, int ... color) {
        this.id = this.ordinal();
        this.name = pName;
        this.material = material;
        this.chance = chance;
        this.showInList = show;
        this.color = color;
    }

    private CombType(int id, String pName, boolean show, Materials material, int chance, int ... color) {
        if (id < 0 && !"INVALIDCOMB".equals(pName)) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = pName;
        this.material = material;
        this.chance = chance;
        this.showInList = show;
        this.color = color;
    }

    public void setHidden() {
        this.showInList = false;
    }

    public String getName() {
        return GT_LanguageManager.addStringLocalization("comb." + this.name, this.name.substring(0, 1).toUpperCase() + this.name.substring(1) + " Comb");
    }

    public int[] getColours() {
        int[] nArray;
        if (this.color == null || this.color.length != 2) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            nArray = this.color;
        }
        return nArray;
    }

    public int getId() {
        return this.id;
    }

    public static CombType valueOf(int id) {
        return id < 0 || id >= Companion.VALUES.length ? _NULL : Companion.VALUES[id];
    }

    private static final class Companion {
        private static final CombType[] VALUES;

        private Companion() {
        }

        static {
            int biggestId = Arrays.stream(CombType.values()).mapToInt(CombType::getId).max().getAsInt();
            VALUES = new CombType[biggestId + 1];
            Arrays.fill((Object[])VALUES, (Object)_NULL);
            for (CombType type : CombType.values()) {
                if (type == _NULL) continue;
                Companion.VALUES[type.getId()] = type;
            }
        }
    }
}

