/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.gui.widgets.GT_GuiSlotTooltip;
import gregtech.api.gui.widgets.GT_GuiTooltip;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_TooltipDataCache;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_IndustrialApiary;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_IndustrialApiary;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.StatCollector;

public class GT_GUIContainer_IndustrialApiary
extends GT_GUIContainerMetaTile_Machine {
    private static final String BATTERY_SLOT_TOOLTIP = "GT5U.machines.battery_slot.tooltip";
    private static final String UNUSED_SLOT_TOOLTIP = "GT5U.machines.unused_slot.tooltip";
    private static final String STALLED_STUTTERING_TOOLTIP = "GT5U.machines.stalled_stuttering.tooltip";
    private static final String ITEM_TRANSFER_TOOLTIP = "GT5U.machines.item_transfer.tooltip";
    private static final String POWER_SOURCE_POWER = "GT5U.machines.powersource.power";
    private static final String CANCEL_PROCESS_TOOLTIP = "GT5U.machines.industrialapiary.cancel.tooltip";
    private static final String SPEED_TOOLTIP = "GT5U.machines.industrialapiary.speed.tooltip";
    private static final String SPEED_LOCKED_TOOLTIP = "GT5U.machines.industrialapiary.speedlocked.tooltip";
    private static final String INFO_TOOLTIP = "GT5U.machines.industrialapiary.info.tooltip";
    private static final String INFO_WITH_BEE_TOOLTIP = "GT5U.machines.industrialapiary.infoextended.tooltip";
    private static final String UPGRADE_TOOLTIP = "GT5U.machines.industrialapiary.upgradeslot.tooltip";
    private final int textColor = this.getTextColorOrDefault("text", 0x404040);
    private final int textColorTitle = this.getTextColorOrDefault("title", 0x404040);
    private final int textColorValue = this.getTextColorOrDefault("value", 0x404040);
    GT_GuiTooltip mErrorStatesTooltip;
    GT_GuiTooltip mSpeedToggleTooltip;
    GT_GuiTooltip mInfoTooltip;

    public GT_GUIContainer_IndustrialApiary(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity) {
        super(new GT_Container_IndustrialApiary(aInventoryPlayer, aTileEntity), "gregtech:textures/gui/basicmachines/IndustrialApiary.png");
    }

    @Override
    protected void setupTooltips() {
        Rectangle tBeeProblemArea = new Rectangle(this.field_147003_i + 100, this.field_147009_r + 63, 18, 18);
        this.mErrorStatesTooltip = new GT_GuiTooltip(tBeeProblemArea, new String[]{""}){

            @Override
            protected void onTick() {
                boolean e = this.enabled;
                super.onTick();
                this.enabled = e;
            }
        };
        this.addToolTip(this.mErrorStatesTooltip);
        this.mSpeedToggleTooltip = new GT_GuiSlotTooltip(this.getContainer().slotSpeedToggle, new GT_TooltipDataCache.TooltipData(null, null));
        this.addToolTip(this.mSpeedToggleTooltip);
        this.mErrorStatesTooltip.enabled = false;
        this.mInfoTooltip = new GT_GuiTooltip(new Rectangle(this.field_147003_i + 163, this.field_147009_r + 5, 6, 17), new String[0]);
        this.addToolTip(this.mInfoTooltip);
        this.addToolTip(new GT_GuiSlotTooltip(this.getContainer().slotCancelProcess, this.mTooltipCache.getData(CANCEL_PROCESS_TOOLTIP, new Object[0])));
        this.getContainer().slotUpgrade.forEach(s -> this.addToolTip(new GT_GuiSlotTooltip((Slot)s, this.mTooltipCache.getData(UPGRADE_TOOLTIP, new Object[0]))));
        this.addToolTip(new GT_GuiSlotTooltip(this.getContainer().slotItemTransferToggle, this.mTooltipCache.getData(ITEM_TRANSFER_TOOLTIP, new Object[0])));
        this.addToolTip(new GT_GuiSlotTooltip(this.getContainer().slotBattery, this.mTooltipCache.getData(BATTERY_SLOT_TOOLTIP, this.powerTierName(this.getContainer().getMachine().mTier), this.powerTierName((byte)(this.getContainer().getMachine().mTier + 1)))));
        this.addToolTip(new GT_GuiSlotTooltip(this.getContainer().slotSpecial, this.mTooltipCache.getData(UNUSED_SLOT_TOOLTIP, new Object[0])));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float parTicks) {
        IBee bee;
        boolean bl = this.mErrorStatesTooltip.enabled = !this.getContainer().mErrorStates.isEmpty();
        if (this.mErrorStatesTooltip.enabled) {
            this.mErrorStatesTooltip.setToolTipText(new GT_TooltipDataCache.TooltipData(this.getContainer().mErrorStates, this.getContainer().mErrorStates));
        } else if (this.getContainer().mStuttering) {
            this.mErrorStatesTooltip.enabled = true;
            this.mErrorStatesTooltip.setToolTipText(this.mTooltipCache.getData(STALLED_STUTTERING_TOOLTIP, StatCollector.func_74838_a((String)POWER_SOURCE_POWER)));
        }
        int accelerated = 1 << this.getContainer().mSpeed;
        int energyusage = 0;
        if (accelerated == 2) {
            energyusage = 32;
        } else if (accelerated > 2) {
            energyusage = 32 * accelerated << this.getContainer().mSpeed - 2;
        }
        this.mSpeedToggleTooltip.setToolTipText(this.mTooltipCache.getUncachedTooltipData(this.getContainer().mLockedSpeed ? SPEED_LOCKED_TOOLTIP : SPEED_TOOLTIP, accelerated, GT_Utility.formatNumbers(energyusage)));
        ArrayList s = new ArrayList();
        GT_MetaTileEntity_IndustrialApiary IA = this.getContainer().getMachine();
        String energyreq = GT_Utility.formatNumbers((int)(37.0f * IA.getEnergyModifier() * (float)accelerated) + energyusage);
        String Temp = StatCollector.func_74838_a((String)IA.getTemperature().getName());
        String Hum = StatCollector.func_74838_a((String)IA.getHumidity().getName());
        boolean moreinformationgiven = false;
        if (IA.getUsedQueen() != null && BeeManager.beeRoot.isMember(IA.getUsedQueen(), EnumBeeType.QUEEN.ordinal()) && (bee = BeeManager.beeRoot.getMember(IA.getUsedQueen())).isAnalyzed()) {
            moreinformationgiven = true;
            IBeeGenome genome = bee.getGenome();
            IBeeModifier mod = BeeManager.beeRoot.getBeekeepingMode(IA.getWorld()).getBeeModifier();
            float tmod = IA.getTerritoryModifier(null, 1.0f) * mod.getTerritoryModifier(null, 1.0f);
            int[] t = Arrays.stream(genome.getTerritory()).map(i -> (int)((float)i * tmod)).toArray();
            this.mInfoTooltip.setToolTipText(this.mTooltipCache.getUncachedTooltipData(INFO_WITH_BEE_TOOLTIP, energyreq, Temp, Hum, Math.round(100.0f * IA.getProductionModifier(null, 1.0f) * genome.getSpeed() * mod.getProductionModifier(null, 1.0f)), Math.round(IA.getFloweringModifier(null, 1.0f) * (float)genome.getFlowering() * mod.getFloweringModifier(null, 1.0f)), Math.round(IA.getLifespanModifier(null, null, 1.0f) * (float)genome.getLifespan() * mod.getLifespanModifier(null, null, 1.0f)), t[0], t[1], t[2]));
        }
        if (!moreinformationgiven) {
            this.mInfoTooltip.setToolTipText(this.mTooltipCache.getUncachedTooltipData(INFO_TOOLTIP, energyreq, Temp, Hum));
        }
        super.func_73863_a(mouseX, mouseY, parTicks);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b("Ind. Apiary", 8, 4, this.textColorTitle);
        this.field_146289_q.func_78276_b("x", 30, 63, this.textColor);
        this.field_146289_q.func_78276_b((1 << this.getContainer().mSpeed) + "", 26, 72, this.textColorValue);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.mContainer != null) {
            if (this.getContainer().mItemTransfer) {
                this.func_73729_b(x + 7, y + 62, 176, 18, 18, 18);
            }
            if (this.getContainer().mMaxProgressTime > 0) {
                double p = (double)this.getContainer().mProgressTime / (double)this.getContainer().mMaxProgressTime;
                this.func_73729_b(x + 70, y + 3, 176, 0, (int)(p * 20.0), 18);
            }
            if (this.mErrorStatesTooltip.enabled) {
                this.func_73729_b(x + 100, y + 63, 176, 36, this.getContainer().mStuttering ? 18 : 9, 18);
            }
        }
    }

    private GT_Container_IndustrialApiary getContainer() {
        return (GT_Container_IndustrialApiary)this.mContainer;
    }

    private String powerTierName(byte machineTier) {
        return GT_Values.TIER_COLORS[machineTier] + GT_Values.VN[machineTier];
    }
}

