/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.fluid;

import gregtech.api.GregTech_API;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.fluid.IGT_Fluid;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.fluid.GT_FluidBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_Fluid
extends Fluid
implements IGT_Fluid,
Runnable {
    private final String localizedName;
    private final ResourceLocation stillIconResourceLocation;
    private final ResourceLocation flowingIconResourceLocation;
    private final short[] colorRGBA;
    private final FluidState fluidState;
    private Fluid registeredFluid;

    protected GT_Fluid(GT_FluidBuilder builder) {
        super(builder.fluidName);
        this.localizedName = builder.localizedName;
        this.stillIconResourceLocation = builder.stillIconResourceLocation;
        this.flowingIconResourceLocation = builder.flowingIconResourceLocation;
        this.block = builder.fluidBlock;
        this.colorRGBA = builder.colorRGBA;
        this.fluidState = builder.fluidState;
        this.temperature = builder.temperature;
        this.configureFromStateTemperature();
    }

    public int getColor() {
        return Math.max(0, Math.min(255, this.colorRGBA[0])) << 16 | Math.max(0, Math.min(255, this.colorRGBA[1])) << 8 | Math.max(0, Math.min(255, this.colorRGBA[2]));
    }

    @Override
    public void run() {
        IIcon stillIcon = GregTech_API.sBlockIcons.func_94245_a(this.stillIconResourceLocation.toString());
        if (this.flowingIconResourceLocation == null) {
            this.setIcons(stillIcon);
        } else {
            IIcon flowingIcon = GregTech_API.sBlockIcons.func_94245_a(this.flowingIconResourceLocation.toString());
            this.setIcons(stillIcon, flowingIcon);
        }
    }

    @Override
    public IGT_Fluid addFluid() {
        if (FluidRegistry.registerFluid((Fluid)this)) {
            GregTech_API.sGTBlockIconload.add(this);
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName(), this.localizedName);
            this.registeredFluid = this;
        } else {
            this.registeredFluid = FluidRegistry.getFluid((String)this.fluidName);
            if (this.registeredFluid.getTemperature() == new Fluid("test").getTemperature()) {
                this.registeredFluid.setTemperature(this.temperature);
            }
        }
        return this;
    }

    @Override
    public IGT_Fluid registerContainers(ItemStack fullContainer, ItemStack emptyContainer, int containerSize) {
        if (fullContainer == null || emptyContainer == null) {
            return this;
        }
        if (this.registeredFluid == null) {
            throw new IllegalStateException("Cannot register containers for an unregistered fluid");
        }
        FluidStack fluidStack = new FluidStack(this.registeredFluid, containerSize);
        if (!FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)fullContainer, (ItemStack)emptyContainer)) {
            GT_Values.RA.addFluidCannerRecipe(fullContainer, GT_Utility.getContainerItem(fullContainer, false), null, fluidStack);
        }
        return this;
    }

    @Override
    public IGT_Fluid registerBContainers(ItemStack fullContainer, ItemStack emptyContainer) {
        return this.registerContainers(fullContainer, emptyContainer, 1000);
    }

    @Override
    public IGT_Fluid registerPContainers(ItemStack fullContainer, ItemStack emptyContainer) {
        return this.registerContainers(fullContainer, emptyContainer, 250);
    }

    @Override
    public ResourceLocation getStillIconResourceLocation() {
        return this.stillIconResourceLocation;
    }

    @Override
    public ResourceLocation getFlowingIconResourceLocation() {
        return this.flowingIconResourceLocation;
    }

    @Override
    public IGT_Fluid configureMaterials(Materials material) {
        if (this.registeredFluid == null) {
            throw new IllegalStateException("Cannot configure Materials with an unregistered fluid");
        }
        switch (this.fluidState) {
            case SLURRY: {
                material.mSolid = this.registeredFluid;
                break;
            }
            case LIQUID: {
                material.mFluid = this.registeredFluid;
                break;
            }
            case GAS: {
                material.mGas = this.registeredFluid;
                break;
            }
            case PLASMA: {
                material.mPlasma = this.registeredFluid;
                break;
            }
            case MOLTEN: {
                material.mStandardMoltenFluid = this.registeredFluid;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected FluidState: " + (Object)((Object)this.fluidState));
            }
        }
        return this;
    }

    @Override
    public Fluid asFluid() {
        return this.registeredFluid == null ? this : this.registeredFluid;
    }

    protected void configureFromStateTemperature() {
        switch (this.fluidState) {
            case SLURRY: {
                this.setGaseous(false).setViscosity(10000);
                break;
            }
            case LIQUID: 
            case MOLTEN: {
                int luminosity = this.temperature >= 3500 ? 15 : (this.temperature < 1000 ? 0 : 14 * (this.temperature - 1000) / 2500 + 1);
                this.setGaseous(false).setViscosity(1000).setLuminosity(luminosity);
                break;
            }
            case GAS: {
                this.setGaseous(true).setDensity(-100).setViscosity(200);
                break;
            }
            case PLASMA: {
                this.setGaseous(true).setDensity(55536).setViscosity(10).setLuminosity(15);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected FluidState: " + (Object)((Object)this.fluidState));
            }
        }
    }
}

