/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_OutputBus_ME;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_DigitalChestBase;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_ItemMeter
extends GT_CoverBehaviorBase<ItemMeterData> {
    private static final int SLOT_MASK = 0x3FFFFFFF;
    private static final int CONVERTED_BIT = Integer.MIN_VALUE;
    private static final int INVERT_BIT = 0x40000000;

    @Deprecated
    public GT_Cover_ItemMeter() {
        this((ITexture)null);
    }

    public GT_Cover_ItemMeter(ITexture coverTexture) {
        super(ItemMeterData.class, coverTexture);
    }

    @Override
    public ItemMeterData createDataObject(int aLegacyData) {
        if ((Integer.MIN_VALUE & aLegacyData) == 0) {
            if (aLegacyData == 0) {
                aLegacyData = Integer.MIN_VALUE;
            } else if (aLegacyData == 1) {
                aLegacyData = -1073741824;
            } else if (aLegacyData > 1) {
                aLegacyData = Integer.MIN_VALUE | Math.min(aLegacyData - 2, 0x3FFFFFFF);
            }
        }
        boolean invert = (aLegacyData & 0x40000000) == 0x40000000;
        int slot = (aLegacyData & 0x3FFFFFFF) - 1;
        return new ItemMeterData(invert, slot, 0);
    }

    @Override
    public ItemMeterData createDataObject() {
        return new ItemMeterData();
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected ItemMeterData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        long tMax = 0L;
        long tUsed = 0L;
        IMetaTileEntity mte = ((IGregTechTileEntity)aTileEntity).getMetaTileEntity();
        if (mte instanceof GT_MetaTileEntity_DigitalChestBase) {
            GT_MetaTileEntity_DigitalChestBase dc = (GT_MetaTileEntity_DigitalChestBase)mte;
            tMax = dc.getMaxItemCount();
            ItemStack[] inv = dc.getStoredItemData();
            if (inv != null && inv.length > 1 && inv[1] != null) {
                tUsed = inv[1].field_77994_a;
            }
        } else if (GregTech_API.mAE2 && mte instanceof GT_MetaTileEntity_Hatch_OutputBus_ME) {
            if (((GT_MetaTileEntity_Hatch_OutputBus_ME)mte).isLastOutputFailed()) {
                tMax = 64L;
                tUsed = 64L;
            }
        } else {
            int[] tSlots;
            int[] nArray;
            if (aCoverVariable.slot >= 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = aCoverVariable.slot;
            } else {
                nArray = aTileEntity.func_94128_d(aSide);
            }
            for (int i : tSlots = nArray) {
                if (i < 0 || i >= aTileEntity.func_70302_i_()) continue;
                tMax += 64L;
                ItemStack tStack = aTileEntity.func_70301_a(i);
                if (tStack == null) continue;
                tUsed += (long)((tStack.field_77994_a << 6) / tStack.func_77976_d());
            }
        }
        long redstoneSignal = tUsed == 0L ? 0L : (tUsed >= tMax ? 15L : 1L + 14L * tUsed / tMax);
        if (aCoverVariable.inverted) {
            redstoneSignal = 15L - redstoneSignal;
        }
        if (aCoverVariable.threshold > 0) {
            if (aCoverVariable.inverted && tUsed >= (long)aCoverVariable.threshold) {
                redstoneSignal = 0L;
            } else if (!aCoverVariable.inverted && tUsed < (long)aCoverVariable.threshold) {
                redstoneSignal = 0L;
            }
        }
        aTileEntity.setOutputRedstoneSignal(aSide, (byte)redstoneSignal);
        return aCoverVariable;
    }

    @Override
    protected ItemMeterData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            if (aCoverVariable.inverted) {
                aCoverVariable.inverted = false;
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("055", "Normal"));
            } else {
                aCoverVariable.inverted = true;
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("054", "Inverted"));
            }
        } else {
            aCoverVariable.slot++;
            if (aCoverVariable.slot > aTileEntity.func_70302_i_()) {
                aCoverVariable.slot = -1;
            }
            if (aCoverVariable.slot == -1) {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("053", "Slot: ") + GT_Utility.trans("ALL", "All"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("053", "Slot: ") + aCoverVariable.slot);
            }
        }
        return aCoverVariable;
    }

    @Override
    protected boolean letsEnergyInImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsInImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(byte aSide, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    protected Object getClientGUIImpl(byte aSide, int aCoverID, ItemMeterData coverData, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private final GT_GuiIconCheckButton invertedButton;
        private final GT_GuiIntegerTextBox intSlot;
        private final GT_GuiFakeItemButton intSlotIcon;
        private final GT_GuiIntegerTextBox thresholdSlot;
        private final ItemMeterData coverVariable;
        private final int maxSlot;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final String ALL;
        private final String INVERTED;
        private final String NORMAL;
        private final int textColor;

        public GUI(byte aSide, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.ALL = GT_Utility.trans("ALL", "All");
            this.INVERTED = GT_Utility.trans("INVERTED", "Inverted");
            this.NORMAL = GT_Utility.trans("NORMAL", "Normal");
            this.textColor = this.getTextColorOrDefault("text", -11184811);
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.invertedButton = new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.REDSTONE_ON, GT_GuiIcon.REDSTONE_OFF, this.INVERTED, this.NORMAL);
            this.intSlot = new GT_GuiIntegerTextBox(this, 1, 10, 45, 41, 12);
            this.intSlot.func_146203_f(6);
            this.intSlotIcon = new GT_GuiFakeItemButton(this, 150, 43, GT_GuiIcon.SLOT_GRAY);
            this.intSlotIcon.setMimicSlot(true);
            this.maxSlot = this.tile instanceof TileEntity && !this.tile.isDead() && this.tile instanceof IGregTechTileEntity && !(((IGregTechTileEntity)this.tile).getMetaTileEntity() instanceof GT_MetaTileEntity_DigitalChestBase) ? Math.min(this.tile.func_70302_i_() - 1, 0x3FFFFFFE) : -1;
            this.intSlot.func_146184_c(this.maxSlot >= 0);
            this.thresholdSlot = new GT_GuiIntegerTextBox(this, 2, 10, 63, 41, 12);
            this.thresholdSlot.func_146203_f(6);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().func_78276_b(this.coverVariable.inverted ? this.INVERTED : this.NORMAL, 64, 29, this.textColor);
            this.getFontRenderer().func_78276_b(GT_Utility.trans("254", "Detect slot#"), 64, 47, this.textColor);
            this.getFontRenderer().func_78276_b(GT_Utility.trans("221", "Item threshold"), 64, 65, this.textColor);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.update();
            if (this.intSlot.isEnabled()) {
                this.intSlot.func_146195_b(true);
            }
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            this.coverVariable.inverted = !this.coverVariable.inverted;
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            if (this.intSlot.func_146206_l()) {
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.func_146272_n() ? 50 : (GUI.func_146271_m() ? 5 : 1)) * (delta > 0 ? step : -step);
                int val = this.parseTextBox(this.intSlot);
                if (val < 0) {
                    val = -1;
                }
                if ((val += step) < 0) {
                    val = -1;
                } else if (val > this.maxSlot) {
                    val = this.maxSlot;
                }
                this.intSlot.func_146180_a(val < 0 ? this.ALL : Integer.toString(val));
            } else if (this.thresholdSlot.func_146206_l()) {
                int val = this.parseTextBox(this.thresholdSlot);
                int step = 1;
                if (GUI.func_146272_n()) {
                    step *= 64;
                }
                if (GUI.func_146271_m()) {
                    step *= 10;
                }
                val += step * Integer.signum(delta);
                val = GT_Utility.clamp(val, 0, this.getUpperBound());
                this.thresholdSlot.func_146180_a(Integer.toString(val));
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.intSlot) {
                this.coverVariable.slot = this.parseTextBox(box);
            } else if (box == this.thresholdSlot) {
                this.coverVariable.threshold = this.parseTextBox(this.thresholdSlot);
            }
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.intSlot) {
                this.intSlot.func_146180_a(this.coverVariable.slot < 0 ? this.ALL : Integer.toString(this.coverVariable.slot));
            } else if (box == this.thresholdSlot) {
                this.thresholdSlot.func_146180_a(Integer.toString(this.coverVariable.threshold));
            }
        }

        private void update() {
            this.invertedButton.setChecked(this.coverVariable.inverted);
            this.resetTextBox(this.intSlot);
            this.resetTextBox(this.thresholdSlot);
            if (this.coverVariable.slot < 0) {
                this.intSlotIcon.setItem(null);
                return;
            }
            if (this.tile instanceof TileEntity && !this.tile.isDead() && this.tile.func_70302_i_() >= this.coverVariable.slot) {
                ItemStack item = this.tile.func_70301_a(this.coverVariable.slot);
                this.intSlotIcon.setItem(item);
                return;
            }
            this.intSlotIcon.setItem(null);
        }

        private int parseTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.intSlot) {
                int val;
                String text = box.func_146179_b();
                if (text == null) {
                    return -1;
                }
                if ((text = text.trim()).startsWith(this.ALL)) {
                    text = text.substring(this.ALL.length());
                }
                if (text.isEmpty()) {
                    return -1;
                }
                try {
                    val = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                if (val < 0) {
                    return -1;
                }
                if (this.maxSlot < val) {
                    return this.maxSlot;
                }
                return val;
            }
            if (box == this.thresholdSlot) {
                int val;
                String text = box.func_146179_b();
                if (text == null) {
                    return 0;
                }
                try {
                    val = Integer.parseInt(text.trim());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
                return GT_Utility.clamp(val, 0, this.getUpperBound());
            }
            throw new UnsupportedOperationException("Unknown text box: " + box);
        }

        private int getUpperBound() {
            return this.maxSlot > 0 ? this.maxSlot * 64 : 999999;
        }
    }

    public static class ItemMeterData
    implements ISerializableObject {
        private boolean inverted;
        private int slot;
        private int threshold;

        public ItemMeterData() {
            this.inverted = false;
            this.slot = -1;
            this.threshold = 0;
        }

        public ItemMeterData(boolean inverted, int slot, int threshold) {
            this.inverted = inverted;
            this.slot = slot;
            this.threshold = threshold;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new ItemMeterData(this.inverted, this.slot, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("invert", this.inverted);
            tag.func_74768_a("slot", this.slot);
            tag.func_74768_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeBoolean(this.inverted);
            aBuf.writeInt(this.slot);
            aBuf.writeInt(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.inverted = tag.func_74767_n("invert");
            this.slot = tag.func_74762_e("slot");
            this.threshold = tag.func_74762_e("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.inverted = aBuf.readBoolean();
            this.slot = aBuf.readInt();
            this.threshold = aBuf.readInt();
            return this;
        }
    }
}

