/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_ItemFilter
extends GT_CoverBehaviorBase<ItemFilterData> {
    private final boolean mExport;

    @Deprecated
    public GT_Cover_ItemFilter(boolean isExport) {
        this(isExport, null);
    }

    public GT_Cover_ItemFilter(boolean isExport, ITexture coverTexture) {
        super(ItemFilterData.class, coverTexture);
        this.mExport = isExport;
    }

    @Override
    public ItemFilterData createDataObject(int aLegacyData) {
        return new ItemFilterData((aLegacyData & 1) == 0, GT_Utility.intToStack(aLegacyData >>> 1));
    }

    @Override
    public ItemFilterData createDataObject() {
        return new ItemFilterData();
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected ItemFilterData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        TileEntity tTileEntity = aTileEntity.getTileEntityAtSide(aSide);
        ICoverable fromEntity = this.mExport ? aTileEntity : tTileEntity;
        ICoverable toEntity = !this.mExport ? aTileEntity : tTileEntity;
        byte fromSide = !this.mExport ? GT_Utility.getOppositeSide(aSide) : aSide;
        byte toSide = this.mExport ? GT_Utility.getOppositeSide(aSide) : aSide;
        List<ItemStack> Filter2 = Collections.singletonList(aCoverVariable.mFilter);
        GT_Utility.moveMultipleItemStacks(fromEntity, toEntity, fromSide, toSide, Filter2, aCoverVariable.mWhitelist, (byte)64, (byte)1, (byte)64, (byte)1, 64);
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
        if (tStack != null) {
            aCoverVariable.mFilter = tStack;
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("299", "Item Filter: ") + tStack.func_82833_r());
        } else {
            aCoverVariable.mFilter = null;
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("300", "Filter Cleared!"));
        }
        return true;
    }

    @Override
    protected ItemFilterData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable.mWhitelist = !aCoverVariable.mWhitelist;
        GT_Utility.sendChatToPlayer(aPlayer, aCoverVariable.mWhitelist ? GT_Utility.trans("125", "Whitelist Mode") : GT_Utility.trans("124", "Blacklist Mode"));
        return aCoverVariable;
    }

    @Override
    protected boolean letsRedstoneGoInImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsRedstoneGoOutImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyInImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    protected boolean letsItemsInImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean alwaysLookConnectedImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    protected Object getClientGUIImpl(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GUI(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private final GT_GuiIconCheckButton btnMode;
        private final ItemFilterData coverVariable;
        private final GT_GuiFakeItemButton itemFilterButtons;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final int textColor;

        public GUI(byte aSide, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.textColor = this.getTextColorOrDefault("text", -11184811);
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.btnMode = new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.WHITELIST, GT_GuiIcon.BLACKLIST, GT_Utility.trans("125", "Whitelist Mode"), GT_Utility.trans("124", "Blacklist Mode"));
            this.itemFilterButtons = new GT_GuiFakeItemButton(this, 10, 61, GT_GuiIcon.SLOT_GRAY);
            this.itemFilterButtons.setMimicSlot(true);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b(GT_Utility.trans("317", "Filter: "), 10, 46, this.textColor);
            this.field_146289_q.func_78276_b(GT_Utility.trans("318", "Check Mode"), 46, 28, this.textColor);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (btn == this.btnMode) {
                this.coverVariable.mWhitelist = !this.coverVariable.mWhitelist;
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            this.btnMode.setChecked(this.coverVariable.mWhitelist);
            this.itemFilterButtons.setItem(this.coverVariable.mFilter);
        }
    }

    public static class ItemFilterData
    implements ISerializableObject {
        private boolean mWhitelist;
        private ItemStack mFilter;

        public ItemFilterData() {
        }

        public ItemFilterData(boolean mWhitelist, ItemStack mFilter) {
            this.mWhitelist = mWhitelist;
            this.mFilter = mFilter;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new ItemFilterData(this.mWhitelist, this.mFilter);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("mWhitelist", this.mWhitelist);
            if (this.mFilter != null) {
                tag.func_74782_a("mFilter", (NBTBase)this.mFilter.func_77955_b(new NBTTagCompound()));
            }
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeBoolean(this.mWhitelist);
            ByteBufUtils.writeItemStack((ByteBuf)aBuf, (ItemStack)this.mFilter);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.mWhitelist = tag.func_74767_n("mWhitelist");
            this.mFilter = tag.func_150297_b("mFilter", 10) ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("mFilter")) : null;
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.mWhitelist = aBuf.readBoolean();
            this.mFilter = ISerializableObject.readItemStackFromGreggyByteBuf(aBuf);
            return this;
        }
    }
}

