/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidRegulator
extends GT_CoverBehaviorBase<FluidRegulatorData> {
    private static final int SPEED_LENGTH = 20;
    private static final int TICK_RATE_LENGTH = 11;
    private static final int TICK_RATE_MIN = 1;
    private static final int TICK_RATE_MAX = 2048;
    private static final int TICK_RATE_BITMASK = 0x7FF00000;
    public final int mTransferRate;
    private boolean allowFluid = false;

    @Deprecated
    public GT_Cover_FluidRegulator(int aTransferRate) {
        this(aTransferRate, null);
    }

    public GT_Cover_FluidRegulator(int aTransferRate, ITexture coverTexture) {
        super(FluidRegulatorData.class, coverTexture);
        if (aTransferRate > 1048575) {
            throw new IllegalArgumentException("aTransferRate too big: " + aTransferRate);
        }
        this.mTransferRate = aTransferRate;
    }

    @Override
    public FluidRegulatorData createDataObject(int aLegacyData) {
        return new FluidRegulatorData(aLegacyData);
    }

    @Override
    public FluidRegulatorData createDataObject() {
        return new FluidRegulatorData();
    }

    private static int generateNewCoverVariable(int aFlowRate, int aTickRate) {
        int tToStoreRaw = aTickRate - 1;
        int tToStore = aFlowRate >= 0 ? tToStoreRaw : ~tToStoreRaw;
        return aFlowRate & 0x800FFFFF | tToStore << 20;
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable.condition.isRedstoneSensitive();
    }

    @Override
    protected FluidRegulatorData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable.speed == 0 || !aCoverVariable.condition.isAllowedToWork(aSide, aCoverID, aTileEntity)) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler) {
            ForgeDirection directionTo;
            ForgeDirection directionFrom;
            IFluidHandler tTank1;
            IFluidHandler tTank2;
            if (aCoverVariable.speed > 0) {
                tTank2 = aTileEntity.getITankContainerAtSide(aSide);
                tTank1 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.getOrientation((int)aSide);
                directionTo = ForgeDirection.getOrientation((int)aSide).getOpposite();
            } else {
                tTank1 = aTileEntity.getITankContainerAtSide(aSide);
                tTank2 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.getOrientation((int)aSide).getOpposite();
                directionTo = ForgeDirection.getOrientation((int)aSide);
            }
            if (tTank1 != null && tTank2 != null) {
                this.allowFluid = true;
                FluidStack tLiquid = tTank1.drain(directionFrom, Math.abs(aCoverVariable.speed), false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank2.fill(directionTo, tLiquid, false);
                    if (tLiquid.amount > 0) {
                        tTank2.fill(directionTo, tTank1.drain(directionFrom, tLiquid.amount, true), true);
                    }
                }
                this.allowFluid = false;
            }
        }
        return aCoverVariable;
    }

    private void adjustSpeed(EntityPlayer aPlayer, FluidRegulatorData aCoverVariable, int scale) {
        int tSpeed = aCoverVariable.speed;
        int tTickRate = aCoverVariable.tickRate;
        if (Math.abs(tSpeed += scale) > this.mTransferRate * tTickRate) {
            tSpeed = this.mTransferRate * tTickRate * (tSpeed > 0 ? 1 : -1);
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("316", "Pump speed limit reached!"));
        }
        if (tTickRate == 1) {
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("048", "Pump speed: ") + tSpeed + GT_Utility.trans("049", "L/tick ") + tSpeed * 20 + GT_Utility.trans("050", "L/sec"));
        } else {
            GT_Utility.sendChatToPlayer(aPlayer, String.format(GT_Utility.trans("207", "Pump speed: %dL every %d ticks, %.2f L/sec on average"), tSpeed, tTickRate, (double)tSpeed * 20.0 / (double)tTickRate));
        }
    }

    @Override
    public FluidRegulatorData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f) {
            this.adjustSpeed(aPlayer, aCoverVariable, aPlayer.func_70093_af() ? 256 : 16);
        } else {
            this.adjustSpeed(aPlayer, aCoverVariable, aPlayer.func_70093_af() ? -256 : -16);
        }
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f) {
            this.adjustSpeed(aPlayer, aCoverVariable, 1);
        } else {
            this.adjustSpeed(aPlayer, aCoverVariable, -1);
        }
        return true;
    }

    @Override
    public boolean letsRedstoneGoInImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOutImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyInImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOutImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsInImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOutImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidInImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowFluid;
    }

    @Override
    public boolean letsFluidOutImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowFluid;
    }

    @Override
    protected boolean alwaysLookConnectedImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return aCoverVariable.tickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUIImpl(byte aSide, int aCoverID, FluidRegulatorData coverData, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private GT_GuiIntegerTextBox tBox;
        private GT_GuiIntegerTextBox lBox;
        private FluidRegulatorData coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private boolean warn;
        private final int textColor;
        private final int textColorValue;

        public GUI(byte aSide, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.warn = false;
            this.textColor = this.getTextColorOrDefault("text", -11184811);
            this.textColorValue = this.getTextColorOrDefault("value", -65536);
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Utility.trans("006", "Export"));
            new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Utility.trans("007", "Import"));
            new GT_GuiIconButton(this, 2, 10, 43, GT_GuiIcon.CHECKMARK).setTooltipText(GT_Utility.trans("224", "Always On"));
            new GT_GuiIconButton(this, 3, 28, 43, GT_GuiIcon.REDSTONE_ON).setTooltipText(GT_Utility.trans("225", "Active with Redstone Signal"));
            new GT_GuiIconButton(this, 4, 46, 43, GT_GuiIcon.REDSTONE_OFF).setTooltipText(GT_Utility.trans("226", "Inactive with Redstone Signal"));
            this.tBox = new GT_GuiIntegerTextBox(this, 2, 10, 63, 69, 12){

                @Override
                public boolean validChar(char c, int key) {
                    return super.validChar(c, key) || c == '-';
                }
            };
            this.tBox.func_146180_a(String.valueOf(this.coverVariable.speed));
            this.tBox.func_146203_f(10);
            this.lBox = new GT_GuiIntegerTextBox(this, 3, 100, 63, 33, 12){

                @Override
                public boolean validChar(char c, int key) {
                    return super.validChar(c, key) || c == '-';
                }
            };
            this.lBox.func_146180_a(String.valueOf(this.coverVariable.tickRate));
            this.lBox.func_146203_f(4);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().func_78276_b(GT_Utility.trans("229", "Import/Export"), 82, 29, this.textColor);
            this.getFontRenderer().func_78276_b(GT_Utility.trans("229", "Conditional"), 82, 47, this.textColor);
            this.getFontRenderer().func_78276_b(GT_Utility.trans("208", " L"), 82, 65, this.textColor);
            this.getFontRenderer().func_78276_b(GT_Utility.trans("209", " ticks"), 136, 65, this.textColor);
            this.getFontRenderer().func_78276_b(String.format(GT_Utility.trans("210", "Average: %.2f L/sec"), this.coverVariable.tickRate == 0 ? 0.0 : (double)this.coverVariable.speed * 20.0 / (double)this.coverVariable.tickRate), 10, 83, this.warn ? this.textColorValue : this.textColor);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
            this.tBox.func_146195_b(true);
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (!btn.field_146124_l) {
                return;
            }
            switch (btn.field_146127_k) {
                case 0: 
                case 1: {
                    FluidRegulatorData fluidRegulatorData = this.coverVariable;
                    fluidRegulatorData.speed = fluidRegulatorData.speed * -1;
                    for (GT_GuiIntegerTextBox box : this.textBoxes) {
                        if (box.id != 2) continue;
                        box.func_146180_a(String.valueOf(this.coverVariable.speed));
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.coverVariable.condition = Conditional.VALUES[btn.field_146127_k - 2];
                    break;
                }
                default: {
                    return;
                }
            }
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            this.updateButtons();
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                long i;
                if (!box.func_146206_l()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.func_146272_n() ? 50 : (GUI.func_146271_m() ? 5 : 1)) * (delta > 0 ? step : -step);
                try {
                    i = Long.parseLong(box.func_146179_b());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (i > 9223372036854774807L) break;
                if ((i += (long)step) <= 0L) {
                    i = 0L;
                }
                box.func_146180_a(String.valueOf(i));
                break;
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            long i;
            String s = box.func_146179_b().trim();
            try {
                i = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                this.resetTextBox(box);
                return;
            }
            this.warn = false;
            if (box.id == 2) {
                long maxFlow = (long)GT_Cover_FluidRegulator.this.mTransferRate * (long)GT_Utility.clamp(this.coverVariable.tickRate, 1, 2048);
                if (i > maxFlow) {
                    i = maxFlow;
                    this.warn = true;
                } else if (i < -maxFlow) {
                    i = -maxFlow;
                    this.warn = true;
                }
                if (!this.warn && (long)this.coverVariable.speed == i) {
                    return;
                }
                this.coverVariable.speed = (int)i;
            } else if (box.id == 3) {
                if (i > 2048L) {
                    i = 2048L;
                    this.warn = true;
                } else if ((long)Math.abs(this.coverVariable.speed) > (long)GT_Cover_FluidRegulator.this.mTransferRate * i) {
                    i = Math.min(2048, (Math.abs(this.coverVariable.speed) + GT_Cover_FluidRegulator.this.mTransferRate - 1) / GT_Cover_FluidRegulator.this.mTransferRate);
                    this.warn = true;
                } else if (i < 1L) {
                    i = 1L;
                }
                if (!this.warn && (long)this.coverVariable.tickRate == i) {
                    return;
                }
                this.coverVariable.tickRate = (int)i;
            }
            box.func_146180_a(String.valueOf(i));
            this.updateButtons();
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            if (box.id == 2) {
                box.func_146180_a(String.valueOf(this.coverVariable.speed));
            } else if (box.id == 3) {
                box.func_146180_a(String.valueOf(this.coverVariable.tickRate));
            }
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GuiButton b = (GuiButton)o;
                b.field_146124_l = this.getClickable(b.field_146127_k);
            }
        }

        private boolean getClickable(int id) {
            switch (id) {
                case 0: {
                    return this.coverVariable.speed < 0;
                }
                case 1: {
                    return this.coverVariable.speed > 0;
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.coverVariable.condition != Conditional.VALUES[id - 2];
                }
            }
            return false;
        }
    }

    public static class FluidRegulatorData
    implements ISerializableObject {
        private int tickRate;
        private int speed;
        private Conditional condition;

        private static int getSpeed(int aCoverVariable) {
            return aCoverVariable >= 0 ? aCoverVariable & 0x800FFFFF : aCoverVariable | 0x7FF00000;
        }

        private static int getTickRate(int aCoverVariable) {
            return ((Math.abs(aCoverVariable) & 0x7FF00000) >>> 20) + 1;
        }

        public FluidRegulatorData() {
            this(0);
        }

        public FluidRegulatorData(int legacy) {
            this(FluidRegulatorData.getTickRate(legacy), FluidRegulatorData.getSpeed(legacy), Conditional.Always);
        }

        public FluidRegulatorData(int tickRate, int speed, Conditional condition) {
            this.tickRate = tickRate;
            this.speed = speed;
            this.condition = condition;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidRegulatorData(this.tickRate, this.speed, this.condition);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("mSpeed", this.speed);
            tag.func_74768_a("mTickRate", this.tickRate);
            tag.func_74774_a("mCondition", (byte)this.condition.ordinal());
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeInt(this.tickRate).writeInt(this.speed).writeByte(this.condition.ordinal());
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (!(aNBT instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.speed = tag.func_74762_e("mSpeed");
            this.tickRate = tag.func_74762_e("mTickRate");
            this.condition = Conditional.VALUES[tag.func_74771_c("mCondition")];
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            return new FluidRegulatorData(aBuf.readInt(), aBuf.readInt(), Conditional.VALUES[aBuf.readUnsignedByte()]);
        }

        public int getTickRate() {
            return this.tickRate;
        }

        public void setTickRate(int tickRate) {
            this.tickRate = tickRate;
        }

        public int getSpeed() {
            return this.speed;
        }

        public void setSpeed(int speed) {
            this.speed = speed;
        }

        public Conditional getCondition() {
            return this.condition;
        }

        public void setCondition(Conditional condition) {
            this.condition = condition;
        }
    }

    public static enum Conditional {
        Always(false){

            @Override
            boolean isAllowedToWork(byte aSide, int aCoverID, ICoverable aTileEntity) {
                return true;
            }
        }
        ,
        Conditional(true){

            @Override
            boolean isAllowedToWork(byte aSide, int aCoverID, ICoverable aTileEntity) {
                return !(aTileEntity instanceof IMachineProgress) || ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork();
            }
        }
        ,
        Inverted(true){

            @Override
            boolean isAllowedToWork(byte aSide, int aCoverID, ICoverable aTileEntity) {
                return !(aTileEntity instanceof IMachineProgress) || !((IMachineProgress)((Object)aTileEntity)).isAllowedToWork();
            }
        };

        static final Conditional[] VALUES;
        private final boolean redstoneSensitive;

        private Conditional(boolean redstoneSensitive) {
            this.redstoneSensitive = redstoneSensitive;
        }

        abstract boolean isAllowedToWork(byte var1, int var2, ICoverable var3);

        boolean isRedstoneSensitive() {
            return this.redstoneSensitive;
        }

        static {
            VALUES = gregtech.common.covers.GT_Cover_FluidRegulator$Conditional.values();
        }
    }
}

