/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicBatteryBuffer;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_EUMeter
extends GT_CoverBehaviorBase<EUMeterData> {
    @Deprecated
    public GT_Cover_EUMeter() {
        this((ITexture)null);
    }

    public GT_Cover_EUMeter(ITexture coverTexture) {
        super(EUMeterData.class, coverTexture);
    }

    @Override
    public EUMeterData createDataObject(int aLegacyData) {
        return new EUMeterData(aLegacyData, 0L);
    }

    @Override
    public EUMeterData createDataObject() {
        return new EUMeterData();
    }

    @Override
    protected EUMeterData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        long stored = aCoverVariable.type.getTileEntityStoredEnergy(aTileEntity);
        long capacity = aCoverVariable.type.getTileEntityEnergyCapacity(aTileEntity);
        byte redstoneSignal = stored == 0L ? (byte)0 : (stored >= capacity ? (byte)15 : (byte)((byte)(1L + 14L * stored / capacity)));
        if (aCoverVariable.inverted) {
            redstoneSignal = (byte)(15 - redstoneSignal);
        }
        if (aCoverVariable.threshold > 0L) {
            if (aCoverVariable.inverted && stored >= aCoverVariable.threshold) {
                redstoneSignal = 0;
            } else if (!aCoverVariable.inverted && stored < aCoverVariable.threshold) {
                redstoneSignal = 0;
            }
        }
        aTileEntity.setOutputRedstoneSignal(aSide, redstoneSignal);
        return aCoverVariable;
    }

    @Override
    protected EUMeterData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int num = (aCoverVariable.getNum() + (aPlayer.func_70093_af() ? -1 : 1) + EnergyType.values().length * 2) % (EnergyType.values().length * 2);
        switch (num) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("031", "Normal Universal Storage"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("032", "Inverted Universal Storage"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("033", "Normal Electricity Storage"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("034", "Inverted Electricity Storage"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("035", "Normal Steam Storage"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("036", "Inverted Steam Storage"));
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("037", "Normal Average Electric Input"));
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("038", "Inverted Average Electric Input"));
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("039", "Normal Average Electric Output"));
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("040", "Inverted Average Electric Output"));
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("041", "Normal Electricity Storage(Including Batteries)"));
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("042", "Inverted Electricity Storage(Including Batteries)"));
            }
        }
        aCoverVariable.setNum(num);
        return aCoverVariable;
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected boolean letsEnergyInImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsInImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(byte aSide, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUIImpl(byte aSide, int aCoverID, EUMeterData coverData, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private final GT_GuiIconButton typeButton;
        private final GT_GuiIconCheckButton invertedButton;
        private final GT_GuiIntegerTextBox thresholdSlot;
        private final EUMeterData coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final String INVERTED;
        private final String NORMAL;
        private final int textColor;

        public GUI(byte aSide, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.INVERTED = GT_Utility.trans("INVERTED", "Inverted");
            this.NORMAL = GT_Utility.trans("NORMAL", "Normal");
            this.textColor = this.getTextColorOrDefault("text", -11184811);
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.typeButton = new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.CYCLIC);
            this.invertedButton = new GT_GuiIconCheckButton(this, 2, 10, 43, GT_GuiIcon.REDSTONE_ON, GT_GuiIcon.REDSTONE_OFF, this.INVERTED, this.NORMAL);
            this.thresholdSlot = new GT_GuiIntegerTextBox(this, 4, 10, 63, 144, 12);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().func_78276_b(this.coverVariable.type.getTitle(), 28, 29, this.textColor);
            this.getFontRenderer().func_78276_b(this.coverVariable.inverted ? this.INVERTED : this.NORMAL, 28, 47, this.textColor);
            this.getFontRenderer().func_78276_b(GT_Utility.trans("222.1", "Energy threshold"), 10, 83, this.textColor);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.update();
            this.thresholdSlot.func_146195_b(true);
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (btn == this.typeButton) {
                this.coverVariable.type = this.coverVariable.type.getNext();
            }
            if (btn == this.invertedButton) {
                this.coverVariable.inverted = !this.coverVariable.inverted;
            }
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            if (this.thresholdSlot.func_146206_l()) {
                long val = this.parseTextBox(this.thresholdSlot);
                long step = 1000L;
                if (GUI.func_146272_n()) {
                    step *= 100L;
                }
                if (GUI.func_146271_m()) {
                    step /= 10L;
                }
                try {
                    val = Math.addExact(val, (long)delta * step);
                }
                catch (ArithmeticException e) {
                    val = Long.MAX_VALUE;
                }
                val = Math.max(0L, val);
                this.thresholdSlot.func_146180_a(Long.toString(val));
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.thresholdSlot) {
                this.coverVariable.threshold = this.parseTextBox(this.thresholdSlot);
            }
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.thresholdSlot) {
                this.thresholdSlot.func_146180_a(Long.toString(this.coverVariable.threshold));
            }
        }

        private void update() {
            this.invertedButton.setChecked(this.coverVariable.inverted);
            this.typeButton.setTooltipText(this.coverVariable.type.getTooltip());
            this.resetTextBox(this.thresholdSlot);
        }

        private long parseTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.thresholdSlot) {
                long val;
                String text = box.func_146179_b();
                if (text == null) {
                    return 0L;
                }
                try {
                    val = Long.parseLong(text.trim());
                }
                catch (NumberFormatException e) {
                    return 0L;
                }
                return Math.max(0L, val);
            }
            throw new UnsupportedOperationException("Unknown text box: " + box);
        }
    }

    private static enum EnergyType {
        UNIVERSAL_STORAGE(GT_Utility.trans("301", "Universal"), GT_Utility.trans("256", "Universal Storage"), IBasicEnergyContainer::getUniversalEnergyStored, IBasicEnergyContainer::getUniversalEnergyCapacity),
        ELECTRICITY_STORAGE(GT_Utility.trans("302", "Int. EU"), GT_Utility.trans("257", "Electricity Storage"), IBasicEnergyContainer::getStoredEU, IBasicEnergyContainer::getEUCapacity),
        STEAM_STORAGE(GT_Utility.trans("303", "Steam"), GT_Utility.trans("258", "Steam Storage"), IBasicEnergyContainer::getStoredSteam, IBasicEnergyContainer::getSteamCapacity),
        AVERAGE_ELECTRIC_INPUT(GT_Utility.trans("304", "Avg. Input"), GT_Utility.trans("259", "Average Electric Input"), IBasicEnergyContainer::getAverageElectricInput, te -> te.getInputVoltage() * te.getInputAmperage()),
        AVERAGE_ELECTRIC_OUTPUT(GT_Utility.trans("305", "Avg. Output"), GT_Utility.trans("260", "Average Electric Output"), IBasicEnergyContainer::getAverageElectricOutput, te -> te.getOutputVoltage() * te.getOutputAmperage()),
        ELECTRICITY_STORAGE_INCLUDING_BATTERIES(GT_Utility.trans("306", "EU stored"), GT_Utility.trans("261", "Electricity Storage(Including Batteries)"), te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof GT_MetaTileEntity_BasicBatteryBuffer) {
                GT_MetaTileEntity_BasicBatteryBuffer buffer = (GT_MetaTileEntity_BasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[0];
            }
            return te.getStoredEU();
        }, te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof GT_MetaTileEntity_BasicBatteryBuffer) {
                GT_MetaTileEntity_BasicBatteryBuffer buffer = (GT_MetaTileEntity_BasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[1];
            }
            return te.getEUCapacity();
        });

        private final String title;
        private final String tooltip;
        private final Function<ICoverable, Long> getTileEntityStoredEnergyFunc;
        private final Function<ICoverable, Long> getTileEntityEnergyCapacityFunc;

        private EnergyType(String title, String tooltip, Function<ICoverable, Long> getTileEntityStoredEnergyFunc, Function<ICoverable, Long> getTileEntityEnergyCapacityFunc) {
            this.title = title;
            this.tooltip = tooltip;
            this.getTileEntityStoredEnergyFunc = getTileEntityStoredEnergyFunc;
            this.getTileEntityEnergyCapacityFunc = getTileEntityEnergyCapacityFunc;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public long getTileEntityStoredEnergy(ICoverable aTileEntity) {
            return this.getTileEntityStoredEnergyFunc.apply(aTileEntity);
        }

        public long getTileEntityEnergyCapacity(ICoverable aTileEntity) {
            return this.getTileEntityEnergyCapacityFunc.apply(aTileEntity);
        }

        public EnergyType getNext() {
            return EnergyType.values()[(this.ordinal() + 1) % EnergyType.values().length];
        }

        public static EnergyType getEnergyType(int ordinal) {
            if (ordinal < 0 || EnergyType.values().length <= ordinal) {
                ordinal = 0;
            }
            return EnergyType.values()[ordinal];
        }
    }

    public static class EUMeterData
    implements ISerializableObject {
        private EnergyType type;
        private boolean inverted;
        private long threshold;

        public EUMeterData() {
            this.type = EnergyType.UNIVERSAL_STORAGE;
            this.inverted = false;
            this.threshold = 0L;
        }

        public EUMeterData(EnergyType type, boolean inverted, long threshold) {
            this.type = type;
            this.inverted = inverted;
            this.threshold = threshold;
        }

        public EUMeterData(int num, long threshold) {
            this();
            this.setNum(num);
            this.threshold = threshold;
        }

        public int getNum() {
            return this.type.ordinal() * 2 + (this.inverted ? 1 : 0);
        }

        public void setNum(int num) {
            this.type = EnergyType.getEnergyType(num / 2);
            this.inverted = num % 2 == 1;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new EUMeterData(this.type, this.inverted, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("typeOrdinal", this.type.ordinal());
            tag.func_74757_a("inverted", this.inverted);
            tag.func_74772_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeInt(this.type.ordinal());
            aBuf.writeBoolean(this.inverted);
            aBuf.writeLong(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            int typeOrdinal = tag.func_74762_e("typeOrdinal");
            this.type = EnergyType.getEnergyType(typeOrdinal);
            this.inverted = tag.func_74767_n("inverted");
            this.threshold = tag.func_74763_f("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            int typeOrdinal = aBuf.readInt();
            this.type = EnergyType.getEnergyType(typeOrdinal);
            this.inverted = aBuf.readBoolean();
            this.threshold = aBuf.readLong();
            return this;
        }
    }
}

