/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.net.GT_Packet_TileEntityCoverGUI;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GT_Packet_GtTileEntityGuiRequest
extends GT_Packet_New {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected int guiId;
    protected int dimId;
    protected int playerId;
    protected int parentGuiId;

    public GT_Packet_GtTileEntityGuiRequest() {
        super(true);
    }

    public GT_Packet_GtTileEntityGuiRequest(int mX, short mY, int mZ, int guiId, int dimID, int playerID, int parentGuiId) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.guiId = guiId;
        this.dimId = dimID;
        this.playerId = playerID;
        this.parentGuiId = parentGuiId;
    }

    public GT_Packet_GtTileEntityGuiRequest(int mX, short mY, int mZ, int guiId, int dimID, int playerID) {
        this(mX, mY, mZ, guiId, dimID, playerID, -1);
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeInt(this.guiId);
        aOut.writeInt(this.dimId);
        aOut.writeInt(this.playerId);
        aOut.writeInt(this.parentGuiId);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new GT_Packet_GtTileEntityGuiRequest(aData.readInt(), aData.readShort(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public byte getPacketID() {
        return 15;
    }

    @Override
    public void process(IBlockAccess aWorld) {
        WorldServer world = DimensionManager.getWorld((int)this.dimId);
        if (world == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(this.mX, (int)this.mY, this.mZ);
        if (!(tile instanceof IGregTechTileEntity) || ((IGregTechTileEntity)tile).isDead()) {
            return;
        }
        IGregTechTileEntity gtTile = (IGregTechTileEntity)tile;
        EntityPlayerMP player = (EntityPlayerMP)world.func_73045_a(this.playerId);
        if (10 <= this.guiId && this.guiId < 16) {
            byte coverSide = (byte)(this.guiId - 10);
            GT_Packet_TileEntityCoverGUI packet = new GT_Packet_TileEntityCoverGUI(this.mX, this.mY, this.mZ, coverSide, gtTile.getCoverIDAtSide(coverSide), gtTile.getComplexCoverDataAtSide(coverSide), this.dimId, this.playerId, this.parentGuiId);
            GT_Values.NW.sendToPlayer(packet, player);
        } else if (this.guiId == 0) {
            gtTile.openGUI((EntityPlayer)player);
        }
    }
}

