/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.google.common.math.LongMath;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.base.BaseNontickableMultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.apache.commons.lang3.ObjectUtils;

public class MultiBlockPart
extends BaseNontickableMultiTileEntity
implements IMultiTileEntity.IMTE_BreakBlock {
    public static final int NOTHING = 0;
    public static final int ENERGY_IN = GT_Values.B[0];
    public static final int ENERGY_OUT = GT_Values.B[1];
    public static final int FLUID_IN = GT_Values.B[2];
    public static final int FLUID_OUT = GT_Values.B[3];
    public static final int ITEM_IN = GT_Values.B[4];
    public static final int ITEM_OUT = GT_Values.B[5];
    protected final List<Integer> BASIC_MODES = new ArrayList<Integer>(Arrays.asList(0, ENERGY_IN, ENERGY_OUT, FLUID_IN, FLUID_OUT, ITEM_IN, ITEM_OUT));
    protected ChunkCoordinates mTargetPos = null;
    protected IMultiBlockController mTarget = null;
    protected int mAllowedModes = 0;
    protected byte mMode = 0;

    public int getPartTier() {
        return 1;
    }

    public int getLockedInventory() {
        return -1;
    }

    public void setTarget(IMultiBlockController aTarget, int aAllowedModes) {
        this.mTarget = aTarget;
        this.mTargetPos = this.mTarget == null ? null : this.mTarget.getCoords();
        this.mAllowedModes = aAllowedModes;
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller != null) {
            tList.add("Has controller");
        } else {
            tList.add("No Controller");
        }
        tList.add("Casing Mode: " + this.getModeName(this.mMode));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add(String.format("Mode: %s", this.getModeName(this.mMode)));
    }

    public IMultiBlockController getTarget(boolean aCheckValidity) {
        if (this.mTargetPos == null) {
            return null;
        }
        if ((this.mTarget == null || this.mTarget.isDead()) && this.field_145850_b.func_72899_e(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c)) {
            TileEntity te = this.field_145850_b.func_147438_o(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c);
            if (te instanceof IMultiBlockController) {
                this.mTarget = (IMultiBlockController)te;
            } else {
                this.mTargetPos = null;
            }
        }
        if (aCheckValidity) {
            return this.mTarget != null && this.mTarget.checkStructure(false) ? this.mTarget : null;
        }
        return this.mTarget;
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("gt.amode")) {
            this.mAllowedModes = aNBT.func_74762_e("gt.amode");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.target")) {
            this.mTargetPos = new ChunkCoordinates(aNBT.func_74762_e("gt.target.x"), (int)aNBT.func_74765_d("gt.target.y"), aNBT.func_74762_e("gt.target.z"));
        }
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound aNBT) {
        if (this.mAllowedModes != 0) {
            aNBT.func_74768_a("gt.amode", this.mAllowedModes);
        }
        if (this.mMode != 0) {
            aNBT.func_74768_a("gt.mode", (int)this.mMode);
        }
        if (this.mTargetPos != null) {
            aNBT.func_74757_a("gt.target", true);
            aNBT.func_74768_a("gt.target.x", this.mTargetPos.field_71574_a);
            aNBT.func_74777_a("gt.target.y", (short)this.mTargetPos.field_71572_b);
            aNBT.func_74768_a("gt.target.z", this.mTargetPos.field_71573_c);
        }
    }

    public boolean hasMode(int aMode) {
        return (this.mAllowedModes & aMode) != 0;
    }

    public boolean modeSelected(int ... aModes) {
        for (int aMode : aModes) {
            if (!this.hasMode(aMode) || this.mMode != this.getModeOrdinal(aMode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean breakBlock() {
        IMultiBlockController tTarget = this.getTarget(false);
        if (tTarget != null) {
            tTarget.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (byte tSide : GT_Values.ALL_VALID_SIDES) {
            TileEntity te = this.getTileEntityAtSide(tSide);
            if (te instanceof MultiBlockPart) {
                IMultiBlockController tController = ((MultiBlockPart)te).getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(te instanceof IMultiBlockController)) continue;
            ((IMultiBlockController)te).onStructureChange();
        }
    }

    @Override
    public byte getTextureData() {
        return this.mMode;
    }

    @Override
    public void setTextureData(byte aData) {
        this.mMode = aData;
    }

    @Override
    public void loadTextureNBT(NBTTagCompound aNBT) {
        String textureName = aNBT.func_74779_i("gt.texture");
        this.mTextures = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("multitileentity/multiblockparts/" + textureName + "/bottom"), new Textures.BlockIcons.CustomIcon("multitileentity/multiblockparts/" + textureName + "/top"), new Textures.BlockIcons.CustomIcon("multitileentity/multiblockparts/" + textureName + "/side"), new Textures.BlockIcons.CustomIcon("multitileentity/multiblockparts/" + textureName + "/overlay/bottom"), new Textures.BlockIcons.CustomIcon("multitileentity/multiblockparts/" + textureName + "/overlay/top"), new Textures.BlockIcons.CustomIcon("multitileentity/multiblockparts/" + textureName + "/overlay/side")};
    }

    @Override
    public void copyTextures() {
        TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID());
        if (tCanonicalTileEntity instanceof MultiBlockPart) {
            this.mTextures = ((MultiBlockPart)tCanonicalTileEntity).mTextures;
        }
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide, boolean isActive, int aRenderPass) {
        ITexture baseTexture = TextureFactory.of(super.getTexture(aBlock, aSide, isActive, aRenderPass));
        if (this.mMode != 0 && aSide == this.mFacing) {
            if (this.mMode == this.getModeOrdinal(ITEM_IN)) {
                return new ITexture[]{baseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN)};
            }
            if (this.mMode == this.getModeOrdinal(ITEM_OUT)) {
                return new ITexture[]{baseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN)};
            }
            if (this.mMode == this.getModeOrdinal(FLUID_IN)) {
                return new ITexture[]{baseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN)};
            }
            if (this.mMode == this.getModeOrdinal(FLUID_OUT)) {
                return new ITexture[]{baseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.FLUID_OUT_SIGN)};
            }
            if (this.mMode == this.getModeOrdinal(ENERGY_IN)) {
                return new ITexture[]{baseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_IN_MULTI)};
            }
            if (this.mMode == this.getModeOrdinal(ENERGY_OUT)) {
                return new ITexture[]{baseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_OUT_MULTI)};
            }
        }
        return new ITexture[]{baseTexture};
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return false;
    }

    protected String getModeName(int aMode) {
        if (aMode == 0) {
            return "Nothing";
        }
        if (aMode == this.getModeOrdinal(ITEM_IN)) {
            return "Item Input";
        }
        if (aMode == this.getModeOrdinal(ITEM_OUT)) {
            return "Item Output";
        }
        if (aMode == this.getModeOrdinal(FLUID_IN)) {
            return "Fluid Input";
        }
        if (aMode == this.getModeOrdinal(FLUID_OUT)) {
            return "Fluid Output";
        }
        if (aMode == this.getModeOrdinal(ENERGY_IN)) {
            return "Energy Input";
        }
        if (aMode == this.getModeOrdinal(ENERGY_OUT)) {
            return "Energy Output";
        }
        return "Unknown";
    }

    protected byte getModeOrdinal(int aMode) {
        return (byte)(LongMath.log2((long)aMode, (RoundingMode)RoundingMode.UNNECESSARY) + 1);
    }

    protected byte getNextAllowedMode(List<Integer> allowedModes) {
        if (this.mAllowedModes == 0) {
            return 0;
        }
        int numModes = allowedModes.size();
        for (int i = 1; i <= numModes; i = (int)((byte)(i + 1))) {
            byte curMode = (byte)((this.mMode + i) % numModes);
            if (curMode != 0 && !this.hasMode(1 << curMode - 1)) continue;
            return curMode;
        }
        return 0;
    }

    @Override
    public boolean onMalletRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        if (this.mAllowedModes == 0) {
            return true;
        }
        this.mMode = this.getNextAllowedMode(this.BASIC_MODES);
        GT_Utility.sendChatToPlayer(aPlayer, "Mode set to `" + this.getModeName(this.mMode) + "' (" + this.mMode + ")");
        this.sendClientData((EntityPlayerMP)aPlayer);
        return true;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.part";
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluidStack, boolean aDoFill) {
        if (!this.modeSelected(FLUID_IN)) {
            return 0;
        }
        byte aSide = (byte)aDirection.ordinal();
        if (!(aDirection == ForgeDirection.UNKNOWN || aSide == this.mFacing && this.coverLetsFluidIn(aSide, aFluidStack == null ? null : aFluidStack.getFluid()))) {
            return 0;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller == null ? 0 : controller.fill(this, aDirection, aFluidStack, aDoFill);
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluidStack, boolean aDoDrain) {
        if (!this.modeSelected(FLUID_OUT)) {
            return null;
        }
        byte aSide = (byte)aDirection.ordinal();
        if (!(aDirection == ForgeDirection.UNKNOWN || aSide == this.mFacing && this.coverLetsFluidOut(aSide, aFluidStack == null ? null : aFluidStack.getFluid()))) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller == null ? null : controller.drain(this, aDirection, aFluidStack, aDoDrain);
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (!this.modeSelected(FLUID_OUT)) {
            return null;
        }
        byte aSide = (byte)aDirection.ordinal();
        IMultiBlockController controller = this.getTarget(true);
        if (controller == null) {
            return null;
        }
        FluidStack aFluidStack = controller.getDrainableFluid(aSide);
        if (!(aDirection == ForgeDirection.UNKNOWN || aSide == this.mFacing && this.coverLetsFluidOut(aSide, aFluidStack == null ? null : aFluidStack.getFluid()))) {
            return null;
        }
        return controller.drain(this, aDirection, aAmountToDrain, aDoDrain);
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if (!this.modeSelected(FLUID_IN)) {
            return false;
        }
        byte aSide = (byte)aDirection.ordinal();
        if (!(aDirection == ForgeDirection.UNKNOWN || aSide == this.mFacing && this.coverLetsFluidIn(aSide, aFluid))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canFill(this, aDirection, aFluid);
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if (!this.modeSelected(FLUID_OUT)) {
            return false;
        }
        byte aSide = (byte)aDirection.ordinal();
        if (!(aDirection == ForgeDirection.UNKNOWN || aSide == this.mFacing && this.coverLetsFluidOut(aSide, aFluid))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canDrain(this, aDirection, aFluid);
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        byte aSide = (byte)aDirection.ordinal();
        if (!this.modeSelected(FLUID_IN, FLUID_OUT) || aSide != 6 && aSide != this.mFacing) {
            return GT_Values.emptyFluidTankInfo;
        }
        IMultiBlockController controller = this.getTarget(true);
        if (controller == null) {
            return GT_Values.emptyFluidTankInfo;
        }
        GT_CoverBehaviorBase<?> tCover = this.getCoverBehaviorAtSideNew(aSide);
        int coverId = this.getCoverIDAtSide(aSide);
        ISerializableObject complexCoverData = this.getComplexCoverDataAtSide(aSide);
        if (controller.isLiquidInput(aSide) && tCover.letsFluidIn(aSide, coverId, complexCoverData, null, controller) || controller.isLiquidOutput(aSide) && tCover.letsFluidOut(aSide, coverId, complexCoverData, null, controller)) {
            return controller.getTankInfo(this, aDirection);
        }
        return GT_Values.emptyFluidTankInfo;
    }

    @Override
    public boolean isEnetInput() {
        return this.modeSelected(ENERGY_IN);
    }

    @Override
    public boolean isEnetOutput() {
        return this.modeSelected(ENERGY_OUT);
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        if (!this.modeSelected(ENERGY_OUT, ENERGY_IN)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.isUniversalEnergyStored(this, aEnergyAmount);
    }

    @Override
    public long getUniversalEnergyStored() {
        if (!this.modeSelected(ENERGY_OUT, ENERGY_IN)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getUniversalEnergyStored(this) : 0L;
    }

    @Override
    public long getUniversalEnergyCapacity() {
        if (!this.modeSelected(ENERGY_OUT, ENERGY_IN)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getUniversalEnergyCapacity(this) : 0L;
    }

    @Override
    public long getOutputAmperage() {
        if (!this.modeSelected(ENERGY_OUT)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getOutputAmperage(this) : 0L;
    }

    @Override
    public long getOutputVoltage() {
        if (!this.modeSelected(ENERGY_OUT)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getOutputVoltage(this) : 0L;
    }

    @Override
    public long getInputAmperage() {
        if (!this.modeSelected(ENERGY_IN)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && this.hasMode(ENERGY_IN) ? controller.getInputAmperage(this) : 0L;
    }

    @Override
    public long getInputVoltage() {
        if (!this.modeSelected(ENERGY_IN)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && this.hasMode(ENERGY_IN) ? controller.getInputVoltage(this) : 0L;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLittleEnergy) {
        if (!this.modeSelected(ENERGY_IN)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && this.hasMode(ENERGY_OUT) && controller.decreaseStoredEnergyUnits(this, aEnergy, aIgnoreTooLittleEnergy);
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.modeSelected(ENERGY_IN)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && this.hasMode(ENERGY_IN) && controller.increaseStoredEnergyUnits(this, aEnergy, aIgnoreTooMuchEnergy);
    }

    @Override
    public boolean drainEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!this.modeSelected(ENERGY_OUT) || this.mFacing != 6 && (this.mFacing != aSide || !this.coverLetsEnergyOut(aSide))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.drainEnergyUnits(this, aSide, aVoltage, aAmperage);
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!this.modeSelected(ENERGY_IN) || this.mFacing != 6 && (this.mFacing != aSide || !this.coverLetsEnergyIn(aSide))) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.injectEnergyUnits(this, aSide, aVoltage, aAmperage) : 0L;
    }

    @Override
    public long getAverageElectricInput() {
        if (!this.modeSelected(ENERGY_IN)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getAverageElectricInput(this) : 0L;
    }

    @Override
    public long getAverageElectricOutput() {
        if (!this.modeSelected(ENERGY_OUT)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getAverageElectricOutput(this) : 0L;
    }

    @Override
    public long getStoredEU() {
        if (!this.modeSelected(ENERGY_OUT, ENERGY_IN)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getStoredEU(this) : 0L;
    }

    @Override
    public long getEUCapacity() {
        if (!this.modeSelected(ENERGY_OUT, ENERGY_IN)) {
            return 0L;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getEUCapacity(this) : 0L;
    }

    @Override
    public boolean inputEnergyFrom(byte aSide) {
        if (!this.modeSelected(ENERGY_IN) || this.mFacing != 6 && (this.mFacing != aSide || !this.coverLetsEnergyIn(aSide))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.inputEnergyFrom(this, aSide);
    }

    @Override
    public boolean outputsEnergyTo(byte aSide) {
        if (!this.modeSelected(ENERGY_OUT) || this.mFacing != 6 && (this.mFacing != aSide || !this.coverLetsEnergyOut(aSide))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.outputsEnergyTo(this, aSide);
    }

    @Override
    public boolean hasInventoryBeenModified() {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.hasInventoryBeenModified(this);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.isValidSlot(this, aIndex);
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (!this.modeSelected(ITEM_IN)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.addStackToSlot(this, aIndex, aStack);
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        if (!this.modeSelected(ITEM_IN)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.addStackToSlot(this, aIndex, aStack, aAmount);
    }

    @Override
    public int[] func_94128_d(int aSide) {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT) || this.mFacing != 6 && this.mFacing != aSide) {
            return GT_Values.emptyIntArray;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getAccessibleSlotsFromSide(this, (byte)aSide) : GT_Values.emptyIntArray;
    }

    @Override
    public boolean func_102007_a(int aSlot, ItemStack aStack, int aSide) {
        if (!this.modeSelected(ITEM_IN) || this.mFacing != 6 && (this.mFacing != aSide || !this.coverLetsItemsIn((byte)aSide, aSlot))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canInsertItem(this, aSlot, aStack, (byte)aSide);
    }

    @Override
    public boolean func_102008_b(int aSlot, ItemStack aStack, int aSide) {
        if (!this.modeSelected(ITEM_OUT) || this.mFacing != 6 && (this.mFacing != aSide || !this.coverLetsItemsOut((byte)aSide, aSlot))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canExtractItem(this, aSlot, aStack, (byte)aSide);
    }

    @Override
    public int func_70302_i_() {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return 0;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getSizeInventory(this) : 0;
    }

    @Override
    public ItemStack func_70301_a(int aSlot) {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getStackInSlot(this, aSlot) : null;
    }

    @Override
    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        if (!this.modeSelected(ITEM_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.decrStackSize(this, aSlot, aDecrement) : null;
    }

    @Override
    public ItemStack func_70304_b(int aSlot) {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getStackInSlotOnClosing(this, aSlot) : null;
    }

    @Override
    public void func_70299_a(int aSlot, ItemStack aStack) {
        IMultiBlockController controller = this.getTarget(true);
        if (controller != null) {
            controller.setInventorySlotContents(this, aSlot, aStack);
        }
    }

    public String func_145825_b() {
        IMultiBlockController controller = this.getTarget(true);
        if (controller != null) {
            return controller.getInventoryName(this);
        }
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getCustomName(), this.getTileEntityName()});
    }

    @Override
    public int func_70297_j_() {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getInventoryStackLimit(this) : 0;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.isItemValidForSlot(this, aSlot, aStack);
    }
}

