/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregtechWailaProvider;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.multitileentity.MultiTileEntityBlockInternal;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.net.GT_Packet_TileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Util;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.render.GT_MultiTexture;
import gregtech.common.render.IRenderedBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class BaseMultiTileEntity
extends CoverableTileEntity
implements IMultiTileEntity,
IHasWorldObjectAndCoords,
IRenderedBlock,
IGregtechWailaProvider {
    public IIconContainer[] mTextures = GT_Values.emptyIconContainerArray;
    protected static final float[] PX_BOX = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public Materials mMaterial = Materials._NULL;
    protected final boolean mIsTicking;
    protected boolean mShouldRefresh = true;
    protected boolean mDoesBlockUpdate = false;
    protected boolean mForceFullSelectionBoxes = false;
    protected boolean mNeedsUpdate = false;
    protected boolean mInventoryChanged = false;
    protected boolean mIsPainted = false;
    protected byte mFacing = (byte)4;
    protected byte mColor;
    protected int mRGBa = 0xFFFFFF;
    private short mMTEID = Short.MAX_VALUE;
    private short mMTERegistry = Short.MAX_VALUE;
    private String mCustomName = null;
    private String mOwnerName = "";
    private UUID mOwnerUuid = GT_Utility.defaultUuid;
    private boolean mLockUpgrade = false;

    public BaseMultiTileEntity(boolean mIsTicking) {
        this.mIsTicking = mIsTicking;
    }

    @Override
    public short getMultiTileEntityID() {
        return this.mMTEID;
    }

    @Override
    public short getMultiTileEntityRegistryID() {
        return this.mMTERegistry;
    }

    @Override
    public void onRegistrationFirst(MultiTileEntityRegistry aRegistry, short aID) {
        GameRegistry.registerTileEntity(this.getClass(), (String)this.getTileEntityName());
    }

    @Override
    public void initFromNBT(NBTTagCompound aNBT, short aMTEID, short aMTERegistry) {
        this.mMTEID = aMTEID;
        this.mMTERegistry = aMTERegistry;
        if (aNBT != null) {
            this.func_145839_a(aNBT);
        }
    }

    @Override
    public void loadTextureNBT(NBTTagCompound aNBT) {
        String textureName = aNBT.func_74779_i("gt.texture");
        this.mTextures = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("multitileentity/base/" + textureName + "/bottom"), new Textures.BlockIcons.CustomIcon("multitileentity/base/" + textureName + "/top"), new Textures.BlockIcons.CustomIcon("multitileentity/base/" + textureName + "/side")};
    }

    @Override
    public void copyTextures() {
        TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID());
        if (tCanonicalTileEntity instanceof BaseMultiTileEntity) {
            this.mTextures = ((BaseMultiTileEntity)tCanonicalTileEntity).mTextures;
        }
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        if (this.mMTEID == Short.MAX_VALUE || this.mMTERegistry == Short.MAX_VALUE) {
            MultiTileEntityClassContainer tClass;
            this.mMTEID = aNBT.func_74765_d("gt.mte.id");
            this.mMTERegistry = aNBT.func_74765_d("gt.mte.reg");
            MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mMTERegistry);
            if (tRegistry != null && (tClass = tRegistry.getClassContainer(this.mMTEID)) != null) {
                aNBT = GT_Util.fuseNBT(aNBT, tClass.mParameters);
            }
        }
        if (aNBT.func_74764_b("x")) {
            this.field_145851_c = aNBT.func_74762_e("x");
        }
        if (aNBT.func_74764_b("y")) {
            this.field_145848_d = aNBT.func_74762_e("y");
        }
        if (aNBT.func_74764_b("z")) {
            this.field_145849_e = aNBT.func_74762_e("z");
        }
        if (aNBT.func_74764_b("gt.display")) {
            this.mCustomName = aNBT.func_74775_l("gt.display").func_74779_i("name");
        }
        try {
            if (aNBT.func_74764_b("gt.material")) {
                this.mMaterial = Materials.get(aNBT.func_74779_i("gt.material"));
            }
            if (aNBT.func_74764_b("gt.color")) {
                this.mRGBa = aNBT.func_74762_e("gt.color");
            }
            this.mOwnerName = aNBT.func_74779_i("gt.owner");
            try {
                this.mOwnerUuid = UUID.fromString(aNBT.func_74779_i("gt.ownerUuid"));
            }
            catch (IllegalArgumentException e) {
                this.mOwnerUuid = null;
            }
            if (aNBT.func_74764_b("gt.locked")) {
                this.mLockUpgrade = aNBT.func_74767_n("gt.locked");
            }
            if (aNBT.func_74764_b("gt.facing")) {
                this.mFacing = aNBT.func_74771_c("gt.facing");
            }
            this.readCoverNBT(aNBT);
            this.readMultiTileNBT(aNBT);
            if (GregTech_API.sBlockIcons == null && aNBT.func_74764_b("gt.texture")) {
                this.loadTextureNBT(aNBT);
            } else {
                this.copyTextures();
            }
            if (this.mCoverData == null || this.mCoverData.length != 6) {
                this.mCoverData = new ISerializableObject[6];
            }
            if (this.mCoverSides.length != 6) {
                this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (this.mSidedRedstone.length != 6) {
                this.mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
            }
            this.updateCoverBehavior();
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("readFromNBT", e);
        }
    }

    public void readMultiTileNBT(NBTTagCompound aNBT) {
    }

    @Override
    public final void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
        aNBT.func_74777_a("gt.mte.id", this.mMTEID);
        aNBT.func_74777_a("gt.mte.reg", this.mMTERegistry);
        if (GT_Utility.isStringValid(this.mCustomName)) {
            NBTTagCompound displayNBT;
            if (aNBT.func_74764_b("gt.display")) {
                displayNBT = aNBT.func_74775_l("gt.display");
            } else {
                displayNBT = new NBTTagCompound();
                aNBT.func_74782_a("gt.display", (NBTBase)displayNBT);
            }
            displayNBT.func_74778_a("name", this.mCustomName);
        }
        try {
            aNBT.func_74778_a("gt.owner", this.mOwnerName);
            aNBT.func_74778_a("gt.ownerUuid", this.mOwnerUuid == null ? "" : this.mOwnerUuid.toString());
            aNBT.func_74757_a("gt.locked", this.mLockUpgrade);
            aNBT.func_74774_a("gt.facing", this.mFacing);
            this.writeCoverNBT(aNBT, false);
            this.writeMultiTileNBT(aNBT);
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("writeToNBT", e);
        }
    }

    public void writeMultiTileNBT(NBTTagCompound aNBT) {
    }

    @Override
    public NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        this.writeCoverNBT(aNBT, true);
        return aNBT;
    }

    @Override
    public long getTimer() {
        return 0L;
    }

    @Override
    public int getRandomNumber(int aRange) {
        return XSTR.XSTR_INSTANCE.nextInt(aRange);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        if (this.field_145850_b == null || this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return null;
        }
        return GT_Util.getTileEntity(this.field_145850_b, aX, aY, aZ, true);
    }

    public boolean canUpdate() {
        return this.mIsTicking && this.mShouldRefresh;
    }

    public boolean shouldRefresh(Block aOldBlock, Block aNewBlock, int aOldMeta, int aNewMeta, World aWorld, int aX, int aY, int aZ) {
        return this.mShouldRefresh || aOldBlock != aNewBlock;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.mDoesBlockUpdate) {
            this.doBlockUpdate();
        }
    }

    public void doBlockUpdate() {
        Block tBlock = this.getBlock(this.getCoords());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, tBlock);
        if (this instanceof IMultiTileEntity.IMTE_IsProvidingStrongPower) {
            for (byte tSide : GT_Values.ALL_VALID_SIDES) {
                if (!this.getBlockAtSide(tSide).isNormalCube((IBlockAccess)this.field_145850_b, this.field_145851_c + GT_Values.OFFX[tSide], this.field_145848_d + GT_Values.OFFY[tSide], this.field_145849_e + GT_Values.OFFZ[tSide])) continue;
                this.field_145850_b.func_147441_b(this.field_145851_c + GT_Values.OFFX[tSide], this.field_145848_d + GT_Values.OFFY[tSide], this.field_145849_e + GT_Values.OFFZ[tSide], tBlock, (int)GT_Values.OPOS[tSide]);
            }
        }
        this.mDoesBlockUpdate = false;
    }

    @Override
    public boolean shouldSideBeRendered(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, 1);
        return tTileEntity instanceof IMultiTileEntity ? !((IMultiTileEntity)tTileEntity).isSurfaceOpaque(GT_Values.OPOS[aSide]) : !this.getBlockAtSide(aSide).func_149662_c();
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final IRenderedBlock passRenderingToObject(ItemStack aStack) {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final IRenderedBlock passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this;
    }

    @Override
    public int getRenderPasses(Block aBlock) {
        return 1;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass) {
        return true;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass) {
        return false;
    }

    @Override
    public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide) {
        return this.getTexture(aBlock, aSide, 1, GT_Values.VALID_SIDES);
    }

    @Override
    public final ITexture[] getTexture(Block aBlock, byte aSide, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        ITexture coverTexture = this.getCoverTexture(aSide);
        ITexture[] textureUncovered = this.getTexture(aBlock, aSide, true, aRenderPass);
        if (coverTexture != null) {
            return new ITexture[]{GT_MultiTexture.get(textureUncovered), coverTexture};
        }
        return textureUncovered;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide, boolean isActive, int aRenderPass) {
        aSide = (byte)Math.min(aSide, 2);
        return new ITexture[]{TextureFactory.of(this.mTextures[aSide], GT_Util.getRGBaArray(this.mRGBa))};
    }

    @Override
    public void setCustomName(String aName) {
        this.mCustomName = aName;
    }

    @Override
    public String getCustomName() {
        return GT_Utility.isStringValid(this.mCustomName) ? this.mCustomName : null;
    }

    @Override
    public byte getColorization() {
        return 0;
    }

    @Override
    public boolean unpaint() {
        return false;
    }

    @Override
    public byte setColorization(byte aColor) {
        return 0;
    }

    @Override
    public boolean isPainted() {
        return false;
    }

    @Override
    public boolean paint(int aRGB) {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public byte getFrontFacing() {
        return this.mFacing;
    }

    @Override
    public boolean setMainFacing(byte aSide) {
        if (!this.isValidFacing(aSide)) {
            return false;
        }
        this.mFacing = aSide;
        this.issueClientUpdate();
        this.issueBlockUpdate();
        this.onFacingChange();
        this.checkDropCover();
        this.doEnetUpdate();
        if (this.shouldTriggerBlockUpdate()) {
            GregTech_API.causeMachineUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.onMachineBlockUpdate();
        }
        return true;
    }

    @Override
    public int getPaint() {
        return this.mRGBa;
    }

    @Override
    public byte getBackFacing() {
        return GT_Utility.getOppositeSide(this.mFacing);
    }

    @Override
    public boolean isValidFacing(byte aSide) {
        return aSide >= 0 && aSide <= 6 && this.getValidFacings()[aSide];
    }

    @Override
    public boolean[] getValidFacings() {
        return GT_Values.VALID_SIDES;
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        super.issueCoverUpdate(aSide);
        this.issueClientUpdate();
    }

    public AxisAlignedBB box(double[] aBox) {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + aBox[0]), (double)((double)this.field_145848_d + aBox[1]), (double)((double)this.field_145849_e + aBox[2]), (double)((double)this.field_145851_c + aBox[3]), (double)((double)this.field_145848_d + aBox[4]), (double)((double)this.field_145849_e + aBox[5]));
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        AxisAlignedBB tBox = this.box(aMinX, aMinY, aMinZ, aMaxX, aMaxY, aMaxZ);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    @Override
    public void onFacingChange() {
    }

    public AxisAlignedBB box(double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + aMinX), (double)((double)this.field_145848_d + aMinY), (double)((double)this.field_145849_e + aMinZ), (double)((double)this.field_145851_c + aMaxX), (double)((double)this.field_145848_d + aMaxY), (double)((double)this.field_145849_e + aMaxZ));
    }

    @Override
    public boolean shouldTriggerBlockUpdate() {
        return false;
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    @Override
    public void onMachineBlockUpdate() {
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, float[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        AxisAlignedBB tBox = this.box(PX_BOX);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public AxisAlignedBB box(float[] aBox) {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + aBox[0]), (double)((float)this.field_145848_d + aBox[1]), (double)((float)this.field_145849_e + aBox[2]), (double)((float)this.field_145851_c + aBox[3]), (double)((float)this.field_145848_d + aBox[4]), (double)((float)this.field_145849_e + aBox[5]));
    }

    public boolean box(Block aBlock) {
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    @Override
    public void issueTextureUpdate() {
        if (!this.mIsTicking) {
            this.markBlockForUpdate();
        } else {
            this.mNeedsUpdate = true;
        }
    }

    public boolean box(Block aBlock, double[] aBox) {
        aBlock.func_149676_a((float)aBox[0], (float)aBox[1], (float)aBox[2], (float)aBox[3], (float)aBox[4], (float)aBox[5]);
        return true;
    }

    protected void markBlockForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.mNeedsUpdate = false;
    }

    public boolean box(Block aBlock, float[] aBox) {
        aBlock.func_149676_a(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return true;
    }

    @Override
    public void onTileEntityPlaced() {
    }

    public boolean box(Block aBlock, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        aBlock.func_149676_a((float)aMinX, (float)aMinY, (float)aMinZ, (float)aMaxX, (float)aMaxY, (float)aMaxZ);
        return true;
    }

    @Override
    public void setShouldRefresh(boolean aShouldRefresh) {
        this.mShouldRefresh = aShouldRefresh;
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    @Override
    public final void addCollisionBoxesToList(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        this.box(this.getCollisionBoundingBoxFromPool(), aAABB, aList);
    }

    @Override
    public final void issueBlockUpdate() {
        if (this.mIsTicking) {
            this.mDoesBlockUpdate = true;
        } else {
            this.doBlockUpdate();
        }
    }

    @Override
    public boolean isStillValid() {
        return !this.func_145837_r();
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return true;
    }

    public AxisAlignedBB box() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public boolean box(AxisAlignedBB aBox, AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        return aBox != null && aBox.func_72326_a(aAABB) && aList.add(aBox);
    }

    public float[] shrunkBox() {
        return PX_BOX;
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        if (this.mForceFullSelectionBoxes) {
            return this.box();
        }
        return this.box(this.shrunkBox());
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition aTarget) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mMTERegistry);
        return tRegistry == null ? null : tRegistry.getItem((int)this.mMTEID, this.writeItemNBT(new NBTTagCompound()));
    }

    @Override
    public void onBlockAdded() {
    }

    @Override
    public String getOwnerName() {
        if (GT_Utility.isStringInvalid(this.mOwnerName)) {
            return "Player";
        }
        return this.mOwnerName;
    }

    @Override
    public String setOwnerName(String aName) {
        if (GT_Utility.isStringInvalid(aName)) {
            this.mOwnerName = "Player";
            return "Player";
        }
        this.mOwnerName = aName;
        return this.mOwnerName;
    }

    @Override
    public UUID getOwnerUuid() {
        return this.mOwnerUuid;
    }

    @Override
    public void setOwnerUuid(UUID uuid) {
        this.mOwnerUuid = uuid;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mFacing = BaseMultiTileEntity.getSideForPlayerPlacing((Entity)aPlayer, this.mFacing, this.getValidFacings());
        this.onFacingChange();
        return true;
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        return true;
    }

    public boolean allowRightclick(Entity aEntity) {
        return this.allowInteraction(aEntity);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        try {
            return this.allowRightclick((Entity)aPlayer) && this.onRightClick(aPlayer, aSide, aX, aY, aZ);
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
            return true;
        }
    }

    @Override
    public boolean onRightClick(EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (this.isClientSide()) {
            if (aPlayer.func_70093_af()) {
                byte tSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverBehaviorAtSideNew(tSide).hasCoverGUI();
            }
            if (this.getCoverBehaviorAtSideNew(aSide).onCoverRightclickClient(aSide, this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverBehaviorAtSideNew(aSide).isGUIClickable(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this)) {
                return false;
            }
        }
        if (this.isServerSide() && (!this.privateAccess() || aPlayer.getDisplayName().equalsIgnoreCase(this.getOwnerName()))) {
            ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
            byte wrenchSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
            if (tCurrentItem != null) {
                byte coverSide;
                if (this.getColorization() < 0 || GT_Utility.areStacksEqual(new ItemStack(Items.field_151131_as, 1), tCurrentItem)) {
                    // empty if block
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList)) {
                    return this.onWrenchRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList)) {
                    return this.onScrewdriverRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList)) {
                    return this.onHammerRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
                    return this.onMalletRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList)) {
                    return this.onSolderingRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList)) {
                    return this.onWireCutterRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                byte by = coverSide = this.getCoverIDAtSide(aSide) == 0 ? wrenchSide : aSide;
                if (this.getCoverIDAtSide(coverSide) == 0) {
                    if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCovers.keySet())) {
                        if (GregTech_API.getCoverBehaviorNew(tCurrentItem).isCoverPlaceable(coverSide, tCurrentItem, (ICoverable)this) && this.allowCoverOnSide(coverSide, new GT_ItemStack(tCurrentItem))) {
                            this.setCoverItemAtSide(coverSide, tCurrentItem);
                            if (!aPlayer.field_71075_bZ.field_75098_d) {
                                --tCurrentItem.field_77994_a;
                            }
                            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            this.issueClientUpdate();
                        }
                        this.sendCoverDataIfNeeded();
                        return true;
                    }
                } else if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.RANDOM_BREAK, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.dropCover(coverSide, aSide, false);
                    }
                    this.sendCoverDataIfNeeded();
                    return true;
                }
            } else if (aPlayer.func_70093_af()) {
                aSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverIDAtSide(aSide) > 0 && this.getCoverBehaviorAtSideNew(aSide).onCoverShiftRightClick(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this, aPlayer);
            }
            if (this.getCoverBehaviorAtSideNew(aSide).onCoverRightClick(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverBehaviorAtSideNew(aSide).isGUIClickable(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this)) {
                return false;
            }
        }
        return false;
    }

    public boolean onWrenchRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        if (this.setMainFacing(wrenchSide)) {
            GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public boolean onScrewdriverRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
            this.setCoverDataAtSide(wrenchSide, (ISerializableObject)this.getCoverBehaviorAtSideNew(wrenchSide).onCoverScrewdriverClick(wrenchSide, this.getCoverIDAtSide(wrenchSide), this.getComplexCoverDataAtSide(wrenchSide), this, aPlayer, aX, aY, aZ));
            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public boolean onHammerRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    public boolean onMalletRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    public boolean onSolderingRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    public boolean onWireCutterRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return this.getExplosionResistance();
    }

    @Override
    public float getExplosionResistance() {
        return 10.0f;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
    }

    @Override
    public boolean isSideSolid(byte aSide) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        if (tRegistry != null) {
            rList.add(tRegistry.getItem((int)this.getMultiTileEntityID(), this.writeItemNBT(new NBTTagCompound())));
        }
        return rList;
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List<ItemStack> aList, short aID) {
        return true;
    }

    @Override
    public boolean recolourBlock(byte aSide, byte aColor) {
        return false;
    }

    @Override
    public boolean playerOwnsThis(EntityPlayer aPlayer, boolean aCheckPrecicely) {
        if (aCheckPrecicely || this.privateAccess() || this.mOwnerName.length() == 0) {
            if (this.mOwnerName.length() == 0 && this.isServerSide()) {
                this.setOwnerName(aPlayer.getDisplayName());
                this.setOwnerUuid(aPlayer.func_110124_au());
            } else {
                return !this.privateAccess() || aPlayer.getDisplayName().equals("Player") || this.mOwnerName.equals("Player") || this.mOwnerName.equals(aPlayer.getDisplayName());
            }
        }
        return true;
    }

    @Override
    public boolean privateAccess() {
        return this.mLockUpgrade;
    }

    public byte getTextureData() {
        return 0;
    }

    public GT_Packet_New getClientDataPacket() {
        return new GT_Packet_TileEntity(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), this.mCoverSides[0], this.mCoverSides[1], this.mCoverSides[2], this.mCoverSides[3], this.mCoverSides[4], this.mCoverSides[5], (byte)(this.mFacing & 7 | (this.mRedstone ? 16 : 0)), this.getTextureData(), 0, (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0)), this.mColor);
    }

    public Packet func_145844_m() {
        this.issueClientUpdate();
        return null;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add(String.format("Facing: %s", ForgeDirection.getOrientation((int)this.getFrontFacing()).name()));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    @Override
    public void sendClientData(EntityPlayerMP aPlayer) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        GT_Packet_New tPacket = this.getClientDataPacket();
        if (aPlayer == null) {
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, tPacket, this.getXCoord(), this.getZCoord());
        } else {
            GT_Values.NW.sendToPlayer(tPacket, aPlayer);
        }
        this.sendCoverDataIfNeeded();
    }

    public void setTextureData(byte aValue) {
    }

    public boolean func_145842_c(int aEventID, int aValue) {
        super.func_145842_c(aEventID, aValue);
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    this.mFacing = (byte)(aValue & 7);
                    this.mRedstone = (aValue & 0x10) != 0;
                    break;
                }
                case 1: {
                    if ((aValue & 0x80) == 0) break;
                    this.setTextureData((byte)(aValue & 0x7F));
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.mColor = (byte)aValue;
                    break;
                }
                case 3: {
                    this.mSidedRedstone[0] = (byte)((aValue & 1) == 1 ? 15 : 0);
                    this.mSidedRedstone[1] = (byte)((aValue & 2) == 2 ? 15 : 0);
                    this.mSidedRedstone[2] = (byte)((aValue & 4) == 4 ? 15 : 0);
                    this.mSidedRedstone[3] = (byte)((aValue & 8) == 8 ? 15 : 0);
                    this.mSidedRedstone[4] = (byte)((aValue & 0x10) == 16 ? 15 : 0);
                    this.mSidedRedstone[5] = (byte)((aValue & 0x20) == 32 ? 15 : 0);
                }
            }
        }
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 2) {
            tList.add("MultiTileRegistry-ID: " + EnumChatFormatting.BLUE + this.mMTERegistry + EnumChatFormatting.RESET + " MultiTile-ID: " + EnumChatFormatting.BLUE + this.mMTEID + EnumChatFormatting.RESET);
        }
        if (this.joinedIc2Enet) {
            tList.add("Joined IC2 ENet");
        }
        this.addDebugInfo(aPlayer, aLogLevel, tList);
        return tList;
    }

    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
    }

    protected IFluidTank getFluidTankFillable(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    protected IFluidTank getFluidTankDrainable(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    protected IFluidTank[] getFluidTanks(byte aSide) {
        return GT_Values.emptyFluidTank;
    }

    public boolean isLiquidInput(byte aSide) {
        return true;
    }

    public boolean isLiquidOutput(byte aSide) {
        return true;
    }

    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable((byte)aDirection.ordinal(), aFluid);
        return tTank == null ? 0 : tTank.fill(aFluid, aDoFill);
    }

    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable((byte)aDirection.ordinal(), aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        return tTank.drain(aFluid.amount, aDoDrain);
    }

    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable((byte)aDirection.ordinal(), null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        return tTank.drain(aAmountToDrain, aDoDrain);
    }

    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable((byte)aDirection.ordinal(), new FluidStack(aFluid, 0));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable((byte)aDirection.ordinal(), new FluidStack(aFluid, 0));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks((byte)aDirection.ordinal());
        if (tTanks == null || tTanks.length <= 0) {
            return GT_Values.emptyFluidTankInfo;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return false;
    }

    @Override
    public long getUniversalEnergyStored() {
        return 0L;
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return 0L;
    }

    @Override
    public long getOutputAmperage() {
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return false;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    @Override
    public boolean drainEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        return false;
    }

    @Override
    public long getAverageElectricInput() {
        return 0L;
    }

    @Override
    public long getAverageElectricOutput() {
        return 0L;
    }

    @Override
    public long getStoredEU() {
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        return 0L;
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        return 0L;
    }

    @Override
    public boolean inputEnergyFrom(byte aSide) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(byte aSide) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return false;
    }

    public int[] func_94128_d(int aSide) {
        return GT_Values.emptyIntArray;
    }

    public boolean func_102007_a(int aSlot, ItemStack aStack, int aSide) {
        return false;
    }

    public boolean func_102008_b(int aSlot, ItemStack aStack, int aSide) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int aSlot) {
        return null;
    }

    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        return null;
    }

    public ItemStack func_70304_b(int aSlot) {
        return null;
    }

    public void func_70299_a(int aSlot, ItemStack aStack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        return false;
    }

    @Override
    public void markInventoryBeenModified() {
        this.mInventoryChanged = true;
    }

    public boolean coverLetsFluidIn(byte aSide, Fluid aFluid) {
        return this.getCoverBehaviorAtSideNew(aSide).letsFluidIn(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), aFluid, this);
    }

    public boolean coverLetsFluidOut(byte aSide, Fluid aFluid) {
        return this.getCoverBehaviorAtSideNew(aSide).letsFluidOut(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), aFluid, this);
    }

    public boolean coverLetsEnergyIn(byte aSide) {
        return this.getCoverBehaviorAtSideNew(aSide).letsEnergyIn(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this);
    }

    public boolean coverLetsEnergyOut(byte aSide) {
        return this.getCoverBehaviorAtSideNew(aSide).letsEnergyOut(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this);
    }

    public boolean coverLetsItemsIn(byte aSide, int aSlot) {
        return this.getCoverBehaviorAtSideNew(aSide).letsItemsIn(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), aSlot, this);
    }

    public boolean coverLetsItemsOut(byte aSide, int aSlot) {
        return this.getCoverBehaviorAtSideNew(aSide).letsItemsOut(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), aSlot, this);
    }
}

