/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyStorage;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.power.IPowerContainer;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_Utility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Transformer
extends GT_MetaTileEntity_TieredMachineBlock {
    public GT_MetaTileEntity_Transformer(int aID, String aName, String aNameRegional, int aTier, String aDescription) {
        super(aID, aName, aNameRegional, aTier, 0, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Transformer(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Transformer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[12][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[2][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[3][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[4][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[5][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[6][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[7][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[8][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[9][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[10][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[11][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[Math.min(2, aSide) + (aSide == aFacing ? 3 : 0) + (aBaseMetaTileEntity.isAllowedToWork() ? 0 : 6)][aColorIndex + 1];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Transformer(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? aSide == this.getBaseMetaTileEntity().getFrontFacing() : aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return !this.isInputFacing(aSide);
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier + 1];
    }

    @Override
    public long maxEUStore() {
        return Math.max(512L, 1L << this.mTier + 2) + GT_Values.V[this.mTier + 1] * 4L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.getBaseMetaTileEntity().isAllowedToWork() ? this.mTier + 1 : this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return GT_Values.V[this.getBaseMetaTileEntity().isAllowedToWork() ? this.mTier : this.mTier + 1];
    }

    @Override
    public long maxAmperesOut() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? 4L : 1L;
    }

    @Override
    public long maxAmperesIn() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? 1L : 4L;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && GregTech_API.mInputRF) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork());
            for (byte i = 0; i < 6 && aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity(); i = (byte)(i + 1)) {
                if (!aBaseMetaTileEntity.inputEnergyFrom(i)) continue;
                TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(i);
                if (tTileEntity instanceof IEnergyProvider && ((IEnergyProvider)tTileEntity).extractEnergy(ForgeDirection.getOrientation((int)GT_Utility.getOppositeSide(i)), 1, true) == 1) {
                    long tEU = ((IEnergyProvider)tTileEntity).extractEnergy(ForgeDirection.getOrientation((int)GT_Utility.getOppositeSide(i)), GT_Utility.safeInt(this.maxEUInput() * 100L / (long)GregTech_API.mRFtoEU), false);
                    tEU = tEU * (long)GregTech_API.mRFtoEU / 100L;
                    aBaseMetaTileEntity.injectEnergyUnits((byte)6, Math.min(tEU, this.maxEUInput()), 1L);
                    continue;
                }
                if (tTileEntity instanceof IEnergyStorage && ((IEnergyStorage)tTileEntity).extractEnergy(1, true) == 1) {
                    long tEU = ((IEnergyStorage)tTileEntity).extractEnergy(GT_Utility.safeInt(this.maxEUInput() * 100L / (long)GregTech_API.mRFtoEU), false);
                    tEU = tEU * (long)GregTech_API.mRFtoEU / 100L;
                    aBaseMetaTileEntity.injectEnergyUnits((byte)6, Math.min(tEU, this.maxEUInput()), 1L);
                    continue;
                }
                if (!GregTech_API.meIOLoaded || !(tTileEntity instanceof IPowerContainer) || ((IPowerContainer)tTileEntity).getEnergyStored() <= 0) continue;
                int storedRF = ((IPowerContainer)tTileEntity).getEnergyStored();
                int extractRF = GT_Utility.safeInt(this.maxEUInput() * 100L / (long)GregTech_API.mRFtoEU);
                long tEU = 0L;
                if (tTileEntity instanceof TileCapBank) {
                    ICapBankNetwork network = ((TileCapBank)tTileEntity).getNetwork();
                    if (network != null && network.getEnergyStoredL() > 0L) {
                        tEU = Math.min(Math.min(Math.min(network.getEnergyStoredL(), (long)(storedRF - extractRF)), (long)network.getMaxOutput()) * (long)GregTech_API.mRFtoEU / 100L, this.maxEUInput());
                        network.addEnergy(GT_Utility.safeInt(-(tEU * 100L / (long)GregTech_API.mRFtoEU)));
                    }
                } else if (storedRF > extractRF) {
                    ((IPowerContainer)tTileEntity).setEnergyStored(storedRF - extractRF);
                    tEU = this.maxEUInput();
                } else {
                    ((IPowerContainer)tTileEntity).setEnergyStored(0);
                    tEU = (long)storedRF * (long)GregTech_API.mRFtoEU / 100L;
                }
                aBaseMetaTileEntity.injectEnergyUnits((byte)6, Math.min(tEU, this.maxEUInput()), 1L);
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean hasAlternativeModeText() {
        return true;
    }

    @Override
    public String getAlternativeModeText() {
        return (this.getBaseMetaTileEntity().isAllowedToWork() ? GT_Utility.trans("145", "Step Down, In: ") : GT_Utility.trans("146", "Step Up, In: ")) + this.maxEUInput() + GT_Utility.trans("148", "V ") + this.maxAmperesIn() + GT_Utility.trans("147", "A, Out: ") + this.maxEUOutput() + GT_Utility.trans("148", "V ") + this.maxAmperesOut() + GT_Utility.trans("149", "A");
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return true;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        byte facing = this.getBaseMetaTileEntity().getFrontFacing();
        NBTTagCompound tag = accessor.getNBTData();
        byte side = (byte)accessor.getSide().ordinal();
        boolean allowedToWork = tag.func_74767_n("isAllowedToWork");
        byte inputTier = GT_Utility.getTier(tag.func_74763_f("maxEUInput"));
        byte outputTier = GT_Utility.getTier(tag.func_74763_f("maxEUOutput"));
        currenttip.add(String.format("%s %s(%dA) -> %s(%dA)", (allowedToWork ? SpecialChars.GREEN + "Step Down" : SpecialChars.RED + "Step Up") + SpecialChars.RESET, GT_Mod.gregtechproxy.mWailaTransformerVoltageTier ? GT_Values.TIER_COLORS[inputTier] + GT_Values.VN[inputTier] + SpecialChars.RESET : Long.valueOf(tag.func_74763_f("maxEUInput")), tag.func_74763_f("maxAmperesIn"), GT_Mod.gregtechproxy.mWailaTransformerVoltageTier ? GT_Values.TIER_COLORS[outputTier] + GT_Values.VN[outputTier] + SpecialChars.RESET : Long.valueOf(tag.func_74763_f("maxEUOutput")), tag.func_74763_f("maxAmperesOut")));
        if (side == facing && allowedToWork || side != facing && !allowedToWork) {
            currenttip.add(String.format(SpecialChars.GOLD + "Input:" + SpecialChars.RESET + " %s(%dA)", GT_Mod.gregtechproxy.mWailaTransformerVoltageTier ? GT_Values.TIER_COLORS[inputTier] + GT_Values.VN[inputTier] + SpecialChars.RESET : Long.valueOf(tag.func_74763_f("maxEUInput")), tag.func_74763_f("maxAmperesIn")));
        } else {
            currenttip.add(String.format(SpecialChars.BLUE + "Output:" + SpecialChars.RESET + " %s(%dA)", GT_Mod.gregtechproxy.mWailaTransformerVoltageTier ? GT_Values.TIER_COLORS[outputTier] + GT_Values.VN[outputTier] + SpecialChars.RESET : Long.valueOf(tag.func_74763_f("maxEUOutput")), tag.func_74763_f("maxAmperesOut")));
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("isAllowedToWork", this.getBaseMetaTileEntity().isAllowedToWork());
        tag.func_74772_a("maxEUInput", this.maxEUInput());
        tag.func_74772_a("maxAmperesIn", this.maxAmperesIn());
        tag.func_74772_a("maxEUOutput", this.maxEUOutput());
        tag.func_74772_a("maxAmperesOut", this.maxAmperesOut());
    }
}

