/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import gregtech.api.enums.Dyes;
import gregtech.api.gui.GT_GUIColorOverride;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.gui.widgets.GT_GuiTooltip;
import gregtech.api.gui.widgets.GT_GuiTooltipManager;
import gregtech.api.interfaces.IGuiScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GT_GUIScreen
extends GuiScreen
implements GT_GuiTooltipManager.GT_IToolTipRenderer,
IGuiScreen {
    protected GT_GuiTooltipManager ttManager = new GT_GuiTooltipManager();
    protected int gui_width = 176;
    protected int gui_height = 107;
    protected int guiTop;
    protected int guiLeft;
    protected boolean drawButtons = true;
    private ResourceLocation mGUIbackgroundLocation;
    private GuiButton selectedButton;
    private GT_GUIColorOverride colorOverride;
    private final int textColor;
    private static final String guiTexturePath = "gregtech:textures/gui/GuiCover.png";
    public String header;
    public GT_GuiFakeItemButton headerIcon;
    protected List<IGuiScreen.IGuiElement> elements = new ArrayList<IGuiScreen.IGuiElement>();
    protected List<GT_GuiIntegerTextBox> textBoxes = new ArrayList<GT_GuiIntegerTextBox>();

    public GT_GUIScreen(int width, int height, String header) {
        this.gui_width = width;
        this.gui_height = height;
        this.header = header;
        this.headerIcon = new GT_GuiFakeItemButton(this, 5, 5, null);
        this.mGUIbackgroundLocation = new ResourceLocation(guiTexturePath);
        this.colorOverride = new GT_GUIColorOverride(guiTexturePath);
        this.textColor = this.getTextColorOrDefault("title", -14540254);
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.gui_width) / 2;
        this.guiTop = (this.field_146295_m - this.gui_height) / 2;
        for (IGuiScreen.IGuiElement element : this.elements) {
            if (element instanceof GuiButton) {
                this.field_146292_n.add(element);
            }
            if (!(element instanceof GT_GuiIntegerTextBox)) continue;
            this.textBoxes.add((GT_GuiIntegerTextBox)element);
        }
        this.onInitGui(this.guiLeft, this.guiTop, this.gui_width, this.gui_height);
        for (IGuiScreen.IGuiElement element : this.elements) {
            element.onInit();
        }
        super.func_73866_w_();
    }

    protected abstract void onInitGui(int var1, int var2, int var3, int var4);

    protected int getTextColorOrDefault(String textType, int defaultColor) {
        return this.colorOverride.getTextColorOrDefault(textType, defaultColor);
    }

    public void onMouseWheel(int x, int y, int delta) {
    }

    public void func_146274_d() {
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.onMouseWheel(i, j, delta);
        }
        super.func_146274_d();
    }

    public void func_73863_a(int mouseX, int mouseY, float parTicks) {
        this.func_146276_q_();
        this.drawBackground(mouseX, mouseY, parTicks);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        if (this.drawButtons) {
            RenderHelper.func_74520_c();
            for (IGuiScreen.IGuiElement e : this.elements) {
                e.draw(mouseX, mouseY, parTicks);
            }
        }
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawForegroundLayer(mouseX, mouseY, parTicks);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    public void drawForegroundLayer(int mouseX, int mouseY, float parTicks) {
        this.drawExtras(mouseX, mouseY, parTicks);
        this.ttManager.onTick(this, mouseX, mouseY);
    }

    public void drawBackground(int mouseX, int mouseY, float parTicks) {
        short[] color = Dyes.MACHINE_METAL.getRGBA();
        GL11.glColor3ub((byte)((byte)color[0]), (byte)((byte)color[1]), (byte)((byte)color[2]));
        this.field_146297_k.field_71446_o.func_110577_a(this.mGUIbackgroundLocation);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.gui_width, this.gui_height);
    }

    public void drawExtras(int mouseX, int mouseY, float parTicks) {
        this.field_146289_q.func_78276_b(this.header, 25, 9, this.textColor);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void closeScreen() {
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField guiTextField : this.textBoxes) {
            guiTextField.func_146178_a();
        }
    }

    public void func_73864_a(int x, int y, int button) {
        for (GT_GuiIntegerTextBox tBox : this.textBoxes) {
            boolean hadFocus = tBox.func_146206_l();
            if (tBox.isEnabled() || hadFocus) {
                tBox.func_146192_a(x, y, button);
            }
            if (tBox.func_146206_l() && button == 1 && tBox.isEnabled()) {
                tBox.func_146180_a("0");
                continue;
            }
            if (!hadFocus || tBox.func_146206_l()) continue;
            this.applyTextBox(tBox);
        }
        super.func_73864_a(x, y, button);
    }

    public void func_73869_a(char c, int key) {
        GT_GuiIntegerTextBox focusedTextBox = null;
        for (GT_GuiIntegerTextBox textBox : this.textBoxes) {
            if (!textBox.func_146206_l()) continue;
            focusedTextBox = textBox;
        }
        if (key == 1) {
            if (focusedTextBox != null) {
                this.resetTextBox(focusedTextBox);
                this.setFocusedTextBox(null);
                return;
            }
            this.closeScreen();
            return;
        }
        if (c == '\t') {
            for (int i = 0; i < this.textBoxes.size(); ++i) {
                GT_GuiIntegerTextBox box = this.textBoxes.get(i);
                if (!box.func_146206_l()) continue;
                this.applyTextBox(box);
                this.setFocusedTextBox(i + 1 < this.textBoxes.size() ? this.textBoxes.get(i + 1) : null);
                return;
            }
            if (!this.textBoxes.isEmpty()) {
                this.setFocusedTextBox(this.textBoxes.get(0));
            }
            return;
        }
        if (focusedTextBox != null && focusedTextBox.func_146201_a(c, key)) {
            return;
        }
        if (key == 28 && focusedTextBox != null) {
            this.applyTextBox(focusedTextBox);
            this.setFocusedTextBox(null);
            return;
        }
        if (key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            if (focusedTextBox != null) {
                this.applyTextBox(focusedTextBox);
                this.setFocusedTextBox(null);
                return;
            }
            this.closeScreen();
            return;
        }
        super.func_73869_a(c, key);
    }

    public void func_146284_a(GuiButton button) {
        this.selectedButton = button;
    }

    @Override
    public void clearSelectedButton() {
        this.selectedButton = null;
    }

    @Override
    public GuiButton getSelectedButton() {
        return this.selectedButton;
    }

    @Override
    public void buttonClicked(GuiButton button) {
    }

    private void setFocusedTextBox(GT_GuiIntegerTextBox boxToFocus) {
        for (GT_GuiIntegerTextBox textBox : this.textBoxes) {
            textBox.func_146195_b(textBox.equals(boxToFocus) && textBox.isEnabled());
        }
    }

    public void applyTextBox(GT_GuiIntegerTextBox box) {
    }

    public void resetTextBox(GT_GuiIntegerTextBox box) {
    }

    public void drawHoveringText(List text, int mouseX, int mouseY, FontRenderer render) {
        super.drawHoveringText(text, mouseX, mouseY, render);
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public void addToolTip(GT_GuiTooltip toolTip) {
        this.ttManager.addToolTip(toolTip);
    }

    @Override
    public boolean removeToolTip(GT_GuiTooltip toolTip) {
        return this.ttManager.removeToolTip(toolTip);
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getXSize() {
        return this.gui_width;
    }

    @Override
    public int getYSize() {
        return this.gui_height;
    }

    @Override
    public RenderItem getItemRenderer() {
        return field_146296_j;
    }

    @Override
    public void addElement(IGuiScreen.IGuiElement element) {
        if (this.elements.contains(element)) {
            return;
        }
        this.elements.add(element);
    }

    @Override
    public boolean removeElement(IGuiScreen.IGuiElement element) {
        return this.elements.remove(element);
    }
}

