/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_Container_BasicMachine;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiSlotTooltip;
import gregtech.api.gui.widgets.GT_GuiSmartTooltip;
import gregtech.api.gui.widgets.GT_GuiTabLine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine_Steel;
import gregtech.api.util.GT_Recipe;
import gregtech.common.power.Power;
import gregtech.nei.NEI_TransferRectHost;
import java.awt.Rectangle;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GT_GUIContainer_BasicMachine
extends GT_GUIContainerMetaTile_Machine
implements NEI_TransferRectHost {
    private static final int NEEDS_STEAM_VENTING = 64;
    private static final GT_GuiTabLine.GT_GuiTabIconSet TAB_ICONSET_BRONZE = new GT_GuiTabLine.GT_GuiTabIconSet(GT_GuiIcon.TAB_NORMAL_BRONZE, GT_GuiIcon.TAB_HIGHLIGHT_BRONZE, GT_GuiIcon.TAB_DISABLED_BRONZE);
    private static final GT_GuiTabLine.GT_GuiTabIconSet TAB_ICONSET_STEEL = new GT_GuiTabLine.GT_GuiTabIconSet(GT_GuiIcon.TAB_NORMAL_STEEL, GT_GuiIcon.TAB_HIGHLIGHT_STEEL, GT_GuiIcon.TAB_DISABLED_STEEL);
    private final int textColor = this.getTextColorOrDefault("title", 0x404040);
    public final String mName;
    public final String mNEI;
    public final byte mProgressBarDirection;
    public final byte mProgressBarAmount;
    private static final String BATTERY_SLOT_TOOLTIP = "GT5U.machines.battery_slot.tooltip";
    private static final String BATTERY_SLOT_TOOLTIP_ALT = "GT5U.machines.battery_slot.tooltip.alternative";
    private static final String UNUSED_SLOT_TOOLTIP = "GT5U.machines.unused_slot.tooltip";
    private static final String SPECIAL_SLOT_TOOLTIP = "GT5U.machines.special_slot.tooltip";
    private static final String FLUID_INPUT_TOOLTIP = "GT5U.machines.fluid_input_slot.tooltip";
    private static final String FLUID_OUTPUT_TOOLTIP = "GT5U.machines.fluid_output_slot.tooltip";
    private static final String STALLED_STUTTERING_TOOLTIP = "GT5U.machines.stalled_stuttering.tooltip";
    private static final String STALLED_VENT_TOOLTIP = "GT5U.machines.stalled_vent.tooltip";
    private static final String FLUID_TRANSFER_TOOLTIP = "GT5U.machines.fluid_transfer.tooltip";
    private static final String ITEM_TRANSFER_TOOLTIP = "GT5U.machines.item_transfer.tooltip";
    private static final String POWER_SOURCE_KEY = "GT5U.machines.powersource.";

    public GT_GUIContainer_BasicMachine(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity, String aName, String aTextureFile, String aNEI) {
        this(aInventoryPlayer, aTileEntity, aName, aTextureFile, aNEI, 0, 1);
    }

    public GT_GUIContainer_BasicMachine(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity, String aName, String aTextureFile, String aNEI, byte aProgressBarDirection, byte aProgressBarAmount) {
        super(new GT_Container_BasicMachine(aInventoryPlayer, aTileEntity), "gregtech:textures/gui/basicmachines/" + aTextureFile);
        this.mProgressBarDirection = aProgressBarDirection;
        this.mProgressBarAmount = (byte)Math.max(1, aProgressBarAmount);
        this.mName = aName;
        this.mNEI = aNEI;
    }

    @Override
    protected void setupTooltips() {
        Object[] batterySlotTooltipArgs;
        String batterySlotTooltipKey;
        super.setupTooltips();
        GT_MetaTileEntity_BasicMachine machine = this.getMachine();
        GT_Recipe.GT_Recipe_Map recipes = machine.getRecipeList();
        final GT_Container_BasicMachine container = this.getContainer();
        Rectangle tProblemArea = new Rectangle(this.field_147003_i + 79, this.field_147009_r + 44, 18, 18);
        if (machine.isSteampowered()) {
            batterySlotTooltipKey = UNUSED_SLOT_TOOLTIP;
            batterySlotTooltipArgs = new String[]{};
            this.addToolTip(new GT_GuiSmartTooltip(tProblemArea, new GT_GuiSmartTooltip.TooltipVisibilityProvider(){

                @Override
                public boolean shouldShowTooltip() {
                    return GT_GUIContainer_BasicMachine.this.hasErrorCode(64);
                }
            }, this.mTooltipCache.getData(STALLED_VENT_TOOLTIP, new Object[0])));
        } else {
            String pTier1 = this.powerTierName(machine.mTier);
            if (machine.mTier == GT_Values.VN.length - 1) {
                batterySlotTooltipKey = BATTERY_SLOT_TOOLTIP_ALT;
                batterySlotTooltipArgs = new String[]{pTier1};
            } else {
                batterySlotTooltipKey = BATTERY_SLOT_TOOLTIP;
                batterySlotTooltipArgs = new String[]{pTier1, this.powerTierName((byte)(machine.mTier + 1))};
            }
            this.addToolTip(new GT_GuiSlotTooltip(container.slotFluidTransferToggle, this.mTooltipCache.getData(FLUID_TRANSFER_TOOLTIP, new Object[0])));
            this.addToolTip(new GT_GuiSlotTooltip(container.slotItemTransferToggle, this.mTooltipCache.getData(ITEM_TRANSFER_TOOLTIP, new Object[0])));
        }
        if (recipes != null && recipes.hasFluidInputs()) {
            this.addToolTip(new GT_GuiSlotTooltip(container.slotFluidInput, this.mTooltipCache.getData(FLUID_INPUT_TOOLTIP, machine.getCapacity())));
        }
        if (recipes != null && recipes.hasFluidOutputs()) {
            this.addToolTip(new GT_GuiSlotTooltip(container.slotFluidOutput, this.mTooltipCache.getData(FLUID_OUTPUT_TOOLTIP, machine.getCapacity())));
        }
        this.addToolTip(new GT_GuiSlotTooltip(this.getContainer().slotBattery, this.mTooltipCache.getData(batterySlotTooltipKey, batterySlotTooltipArgs)));
        this.addToolTip(new GT_GuiSlotTooltip(container.slotSpecial, this.mTooltipCache.getData(recipes != null && recipes.usesSpecialSlot() ? SPECIAL_SLOT_TOOLTIP : UNUSED_SLOT_TOOLTIP, new Object[0])));
        this.addToolTip(new GT_GuiSmartTooltip(tProblemArea, new GT_GuiSmartTooltip.TooltipVisibilityProvider(){

            @Override
            public boolean shouldShowTooltip() {
                return container.mStuttering && !GT_GUIContainer_BasicMachine.this.hasErrorCode(64);
            }
        }, this.mTooltipCache.getData(STALLED_STUTTERING_TOOLTIP, StatCollector.func_74838_a((String)(POWER_SOURCE_KEY + (machine.isSteampowered() ? "steam" : "power"))))));
    }

    private String powerTierName(byte machineTier) {
        return GT_Values.TIER_COLORS[machineTier] + GT_Values.VN[machineTier];
    }

    private GT_MetaTileEntity_BasicMachine getMachine() {
        return (GT_MetaTileEntity_BasicMachine)this.mContainer.mTileEntity.getMetaTileEntity();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.mName, 8, 4, this.textColor);
    }

    @Override
    protected void func_146976_a(float parTicks, int mouseX, int mouseY) {
        super.func_146976_a(parTicks, mouseX, mouseY);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.mContainer != null) {
            if (!this.getMachine().isSteampowered()) {
                if (this.getContainer().mFluidTransfer) {
                    this.func_73729_b(x + 7, y + 62, 176, 18, 18, 18);
                }
                if (this.getContainer().mItemTransfer) {
                    this.func_73729_b(x + 25, y + 62, 176, 36, 18, 18);
                }
            }
            if (this.getContainer().mStuttering) {
                this.func_73729_b(x + 79, y + 44, 176, 54, 18, 18);
            }
            if (this.mContainer.mMaxProgressTime > 0) {
                int tSize = this.mProgressBarDirection < 2 ? 20 : 18;
                int tProgress = Math.max(1, Math.min(tSize * this.mProgressBarAmount, (this.mContainer.mProgressTime > 0 ? 1 : 0) + this.mContainer.mProgressTime * tSize * this.mProgressBarAmount / this.mContainer.mMaxProgressTime)) % (tSize + 1);
                switch (this.mProgressBarDirection) {
                    case 0: {
                        this.func_73729_b(x + 78, y + 24, 176, 0, tProgress, 18);
                        break;
                    }
                    case 1: {
                        this.func_73729_b(x + 78 + 20 - tProgress, y + 24, 196 - tProgress, 0, tProgress, 18);
                        break;
                    }
                    case 2: {
                        this.func_73729_b(x + 78, y + 24, 176, 0, 20, tProgress);
                        break;
                    }
                    case 3: {
                        this.func_73729_b(x + 78, y + 24 + 18 - tProgress, 176, 18 - tProgress, 20, tProgress);
                        break;
                    }
                    case 4: {
                        tProgress = 20 - tProgress;
                        this.func_73729_b(x + 78, y + 24, 176, 0, tProgress, 18);
                        break;
                    }
                    case 5: {
                        tProgress = 20 - tProgress;
                        this.func_73729_b(x + 78 + 20 - tProgress, y + 24, 196 - tProgress, 0, tProgress, 18);
                        break;
                    }
                    case 6: {
                        tProgress = 18 - tProgress;
                        this.func_73729_b(x + 78, y + 24, 176, 0, 20, tProgress);
                        break;
                    }
                    case 7: {
                        tProgress = 18 - tProgress;
                        this.func_73729_b(x + 78, y + 24 + 18 - tProgress, 176, 18 - tProgress, 20, tProgress);
                    }
                }
            }
        }
    }

    @Override
    protected GT_GuiTabLine.GT_GuiTabIconSet getTabBackground() {
        if (this.getMachine().isSteampowered()) {
            return this.getMachine() instanceof GT_MetaTileEntity_BasicMachine_Steel ? TAB_ICONSET_STEEL : TAB_ICONSET_BRONZE;
        }
        return super.getTabBackground();
    }

    private boolean hasErrorCode(int errorCode) {
        return (this.getContainer().mDisplayErrorCode & errorCode) != 0;
    }

    private GT_Container_BasicMachine getContainer() {
        return (GT_Container_BasicMachine)this.mContainer;
    }

    @Override
    public String getNeiTransferRectString() {
        return this.mNEI;
    }

    @Override
    public String getNeiTransferRectTooltip() {
        Power powerInfo = this.getMachine().getPower();
        if (this.getMachine().isSteampowered()) {
            return powerInfo.getTierString() + " Steam recipes";
        }
        return "Recipes available in " + powerInfo.getTierString();
    }

    @Override
    public Object[] getNeiTransferRectArgs() {
        return new Object[]{this.getMachine().getPower()};
    }

    @Override
    public Rectangle getNeiTransferRect() {
        return new Rectangle(65, 13, 36, 18);
    }
}

