/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.GT_Container;
import gregtech.api.gui.GT_Slot_Render;
import gregtech.api.interfaces.metatileentity.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GT_ContainerMetaTile_Machine
extends GT_Container {
    public int mActive = 0;
    public int mMaxProgressTime = 0;
    public int mProgressTime = 0;
    public int mEnergy = 0;
    public int mSteam = 0;
    public int mSteamStorage = 0;
    public int mStorage = 0;
    public int mOutput = 0;
    public int mInput = 0;
    public int mID = 0;
    public int mDisplayErrorCode = 0;
    public long mEnergyLong = 0L;
    public long mStorageLong = 0L;
    private int oActive = 0;
    private int oMaxProgressTime = 0;
    private int oProgressTime = 0;
    private int oEnergy = 0;
    private int oSteam = 0;
    private int oSteamStorage = 0;
    private int oStorage = 0;
    private int oOutput = 0;
    private int oInput = 0;
    private int oID = 0;
    private int oDisplayErrorCode = 0;
    private long oEnergyLong = 0L;
    private long oStorageLong = 0L;
    protected int mTimer = 0;
    protected Runnable circuitSlotClickCallback;

    public GT_ContainerMetaTile_Machine(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity) {
        super(aInventoryPlayer, aTileEntity);
        this.mTileEntity = aTileEntity;
        if (this.mTileEntity != null && this.mTileEntity.getMetaTileEntity() != null) {
            this.addSlots(aInventoryPlayer);
            if (this.doesBindPlayerInventory()) {
                this.bindPlayerInventory(aInventoryPlayer);
            }
            this.func_75142_b();
        } else {
            aInventoryPlayer.field_70458_d.field_71070_bA = aInventoryPlayer.field_70458_d.field_71069_bz;
        }
    }

    public GT_ContainerMetaTile_Machine(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity, boolean doesBindInventory) {
        super(aInventoryPlayer, aTileEntity);
        this.mTileEntity = aTileEntity;
        if (this.mTileEntity != null && this.mTileEntity.getMetaTileEntity() != null) {
            this.addSlots(aInventoryPlayer);
            if (this.doesBindPlayerInventory() && doesBindInventory) {
                this.bindPlayerInventory(aInventoryPlayer);
            }
            this.func_75142_b();
        } else {
            aInventoryPlayer.field_70458_d.field_71070_bA = aInventoryPlayer.field_70458_d.field_71069_bz;
        }
    }

    protected void addCircuitSlot() {
        if (this.mTileEntity.getMetaTileEntity() instanceof IConfigurationCircuitSupport) {
            IConfigurationCircuitSupport ccs = (IConfigurationCircuitSupport)((Object)this.mTileEntity.getMetaTileEntity());
            GT_Slot_Render slotCircuit = new GT_Slot_Render((IInventory)this.mTileEntity, ccs.getCircuitSlot(), ccs.getCircuitSlotX(), ccs.getCircuitSlotY());
            this.func_75146_a(slotCircuit);
            slotCircuit.setEnabled(ccs.allowSelectCircuit());
        }
    }

    @Override
    public void addSlots(InventoryPlayer aInventoryPlayer) {
        this.addCircuitSlot();
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.mTileEntity.isClientSide() || this.mTileEntity.getMetaTileEntity() == null) {
            return;
        }
        this.mStorage = (int)Math.min(Integer.MAX_VALUE, this.mTileEntity.getEUCapacity());
        this.mStorageLong = this.mTileEntity.getEUCapacity();
        this.mEnergy = (int)Math.min(Integer.MAX_VALUE, this.mTileEntity.getStoredEU());
        this.mEnergyLong = this.mTileEntity.getStoredEU();
        this.mSteamStorage = (int)Math.min(Integer.MAX_VALUE, this.mTileEntity.getSteamCapacity());
        this.mSteam = (int)Math.min(Integer.MAX_VALUE, this.mTileEntity.getStoredSteam());
        this.mOutput = (int)Math.min(Integer.MAX_VALUE, this.mTileEntity.getOutputVoltage());
        this.mInput = (int)Math.min(Integer.MAX_VALUE, this.mTileEntity.getInputVoltage());
        this.mDisplayErrorCode = this.mTileEntity.getErrorDisplayID();
        this.mProgressTime = this.mTileEntity.getProgress();
        this.mMaxProgressTime = this.mTileEntity.getMaxProgress();
        this.mActive = this.mTileEntity.isActive() ? 1 : 0;
        ++this.mTimer;
        for (Object crafter : this.field_75149_d) {
            ICrafting player = (ICrafting)crafter;
            if (this.mTimer % 500 == 10 || this.oEnergy != this.mEnergy) {
                player.func_71112_a((Container)this, 0, this.mEnergy & 0xFFFF);
                player.func_71112_a((Container)this, 1, this.mEnergy >>> 16);
            }
            if (this.mTimer % 500 == 10 || this.oStorage != this.mStorage) {
                player.func_71112_a((Container)this, 2, this.mStorage & 0xFFFF);
                player.func_71112_a((Container)this, 3, this.mStorage >>> 16);
            }
            if (this.mTimer % 500 == 10 || this.oOutput != this.mOutput) {
                player.func_71112_a((Container)this, 4, this.mOutput);
            }
            if (this.mTimer % 500 == 10 || this.oInput != this.mInput) {
                player.func_71112_a((Container)this, 5, this.mInput);
            }
            if (this.mTimer % 500 == 10 || this.oDisplayErrorCode != this.mDisplayErrorCode) {
                player.func_71112_a((Container)this, 6, this.mDisplayErrorCode);
            }
            if (this.mTimer % 500 == 10 || this.oProgressTime != this.mProgressTime) {
                player.func_71112_a((Container)this, 11, this.mProgressTime & 0xFFFF);
                player.func_71112_a((Container)this, 12, this.mProgressTime >>> 16);
            }
            if (this.mTimer % 500 == 10 || this.oMaxProgressTime != this.mMaxProgressTime) {
                player.func_71112_a((Container)this, 13, this.mMaxProgressTime & 0xFFFF);
                player.func_71112_a((Container)this, 14, this.mMaxProgressTime >>> 16);
            }
            if (this.mTimer % 500 == 10 || this.oID != this.mID) {
                player.func_71112_a((Container)this, 15, this.mID);
            }
            if (this.mTimer % 500 == 10 || this.oActive != this.mActive) {
                player.func_71112_a((Container)this, 16, this.mActive);
            }
            if (this.mTimer % 500 == 10 || this.oSteam != this.mSteam) {
                player.func_71112_a((Container)this, 17, this.mSteam & 0xFFFF);
                player.func_71112_a((Container)this, 18, this.mSteam >>> 16);
            }
            if (this.mTimer % 500 == 10 || this.oSteamStorage != this.mSteamStorage) {
                player.func_71112_a((Container)this, 19, this.mSteamStorage & 0xFFFF);
                player.func_71112_a((Container)this, 20, this.mSteamStorage >>> 16);
            }
            if (this.mTimer % 500 == 10 || this.oEnergyLong != this.mEnergyLong) {
                player.func_71112_a((Container)this, 21, (int)this.mEnergyLong);
                player.func_71112_a((Container)this, 22, (int)(this.mEnergyLong >>> 32));
            }
            if (this.mTimer % 500 != 10 && this.oStorageLong == this.mStorageLong) continue;
            player.func_71112_a((Container)this, 23, (int)this.mStorageLong);
            player.func_71112_a((Container)this, 24, (int)(this.mStorageLong >>> 32));
        }
        this.oID = this.mID;
        this.oSteam = this.mSteam;
        this.oInput = this.mInput;
        this.oActive = this.mActive;
        this.oOutput = this.mOutput;
        this.oEnergy = this.mEnergy;
        this.oEnergyLong = this.mEnergyLong;
        this.oStorage = this.mStorage;
        this.oStorageLong = this.mStorageLong;
        this.oSteamStorage = this.mSteamStorage;
        this.oProgressTime = this.mProgressTime;
        this.oMaxProgressTime = this.mMaxProgressTime;
        this.oDisplayErrorCode = this.mDisplayErrorCode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        switch (id) {
            case 0: {
                this.mEnergy = this.mEnergy & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 1: {
                this.mEnergy = this.mEnergy & 0xFFFF | value << 16;
                break;
            }
            case 2: {
                this.mStorage = this.mStorage & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 3: {
                this.mStorage = this.mStorage & 0xFFFF | value << 16;
                break;
            }
            case 4: {
                this.mOutput = value;
                break;
            }
            case 5: {
                this.mInput = value;
                break;
            }
            case 6: {
                this.mDisplayErrorCode = value;
                break;
            }
            case 11: {
                this.mProgressTime = this.mProgressTime & 0xFFFF0000 | value;
                break;
            }
            case 12: {
                this.mProgressTime = this.mProgressTime & 0xFFFF | value << 16;
                break;
            }
            case 13: {
                this.mMaxProgressTime = this.mMaxProgressTime & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 14: {
                this.mMaxProgressTime = this.mMaxProgressTime & 0xFFFF | value << 16;
                break;
            }
            case 15: {
                this.mID = value;
                break;
            }
            case 16: {
                this.mActive = value;
                break;
            }
            case 17: {
                this.mSteam = this.mSteam & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 18: {
                this.mSteam = this.mSteam & 0xFFFF | value << 16;
                break;
            }
            case 19: {
                this.mSteamStorage = this.mSteamStorage & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 20: {
                this.mSteamStorage = this.mSteamStorage & 0xFFFF | value << 16;
                break;
            }
            case 21: {
                this.mEnergyLong = this.mEnergyLong & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL;
                break;
            }
            case 22: {
                this.mEnergyLong = this.mEnergyLong & 0xFFFFFFFFL | (long)value << 32;
                break;
            }
            case 23: {
                this.mStorageLong = this.mStorageLong & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL;
                break;
            }
            case 24: {
                this.mStorageLong = this.mStorageLong & 0xFFFFFFFFL | (long)value << 32;
            }
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.mTileEntity.func_70300_a(player);
    }

    @Deprecated
    public String trans(String aKey, String aEnglish) {
        return GT_Utility.trans(aKey, aEnglish);
    }

    public void setCircuitSlotClickCallback(Runnable circuitSlotClickCallback) {
        this.circuitSlotClickCallback = circuitSlotClickCallback;
    }

    @Override
    public ItemStack func_75144_a(int aSlotNumber, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
        IMetaTileEntity machine;
        IConfigurationCircuitSupport ccs;
        if (this.mTileEntity.getMetaTileEntity() instanceof IConfigurationCircuitSupport && (ccs = (IConfigurationCircuitSupport)((Object)(machine = this.mTileEntity.getMetaTileEntity()))).allowSelectCircuit() && aSlotNumber == ccs.getCircuitGUISlot() && aMouseclick < 2) {
            ItemStack newCircuit;
            if (aShifthold == 1) {
                if (aMouseclick == 0) {
                    if (this.circuitSlotClickCallback != null) {
                        this.circuitSlotClickCallback.run();
                    }
                    return null;
                }
                newCircuit = null;
            } else {
                ItemStack cursorStack = aPlayer.field_71071_by.func_70445_o();
                List<ItemStack> tCircuits = ccs.getConfigurationCircuits();
                int index = GT_Utility.findMatchingStackInList(tCircuits, cursorStack);
                if (index < 0) {
                    int curIndex = GT_Utility.findMatchingStackInList(tCircuits, machine.func_70301_a(ccs.getCircuitSlot())) + 1;
                    curIndex = aMouseclick == 0 ? ++curIndex : --curIndex;
                    curIndex = Math.floorMod(curIndex, tCircuits.size() + 1) - 1;
                    newCircuit = curIndex < 0 ? null : tCircuits.get(curIndex);
                } else {
                    newCircuit = tCircuits.get(index);
                }
            }
            this.mTileEntity.func_70299_a(ccs.getCircuitSlot(), newCircuit);
            return newCircuit;
        }
        return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
    }
}

