/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_GUIContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Item_Machines;
import gregtech.common.power.EUPower;
import gregtech.common.power.Power;
import gregtech.common.power.UnspecifiedEUPower;
import gregtech.nei.NEIHandlerAbsoluteTooltip;
import gregtech.nei.NEI_TransferRectHost;
import gregtech.nei.RecipeMapHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Range;
import org.lwjgl.opengl.GL11;

public class GT_NEI_DefaultHandler
extends RecipeMapHandler {
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;
    private static final ConcurrentMap<GT_Recipe.GT_Recipe_Map, SortedRecipeListCache> CACHE = new ConcurrentHashMap<GT_Recipe.GT_Recipe_Map, SortedRecipeListCache>();
    private Power mPower;
    private String mRecipeName;
    private NEIHandlerAbsoluteTooltip mRecipeNameTooltip;
    private static final int RECIPE_NAME_WIDTH = 140;
    public static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());

    public GT_NEI_DefaultHandler(GT_Recipe.GT_Recipe_Map aRecipeMap) {
        super(aRecipeMap);
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    @Deprecated
    public List<GT_Recipe> getSortedRecipes() {
        ArrayList<GT_Recipe> result = new ArrayList<GT_Recipe>(this.mRecipeMap.mRecipeList);
        Collections.sort(result);
        return result;
    }

    private SortedRecipeListCache getCacheHolder() {
        return CACHE.computeIfAbsent(this.mRecipeMap, m -> new SortedRecipeListCache());
    }

    public List<CachedDefaultRecipe> getCache() {
        List<CachedDefaultRecipe> cache;
        SortedRecipeListCache cacheHolder = this.getCacheHolder();
        if (cacheHolder.getCachedRecipesVersion() != GT_Mod.gregtechproxy.getReloadCount() || (cache = cacheHolder.getCachedRecipes()) == null) {
            cache = this.mRecipeMap.mRecipeList.stream().filter(r -> !r.mHidden).sorted().map(x$0 -> new CachedDefaultRecipe((GT_Recipe)x$0)).collect(Collectors.toList());
            cacheHolder.setCachedRecipes(cache);
            cacheHolder.setCachedRecipesVersion(GT_Mod.gregtechproxy.getReloadCount());
        }
        return cache;
    }

    public static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(aString, aX, aY, aColor);
    }

    public TemplateRecipeHandler newInstance() {
        return new GT_NEI_DefaultHandler(this.mRecipeMap);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            if (results.length > 0 && results[0] instanceof Power) {
                this.mPower = (Power)results[0];
                this.loadTieredCraftingRecipesUpTo(this.mPower.getTier());
            } else {
                this.arecipes.addAll(this.getCache());
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GT_OreDictUnificator.get(true, aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        this.addFluidStacks(aResult, tResults);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tResults.stream().anyMatch(stack -> recipe.contains(recipe.mOutputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    private void addFluidStacks(ItemStack aStack, ArrayList<ItemStack> tResults) {
        FluidStack tFluidStack;
        FluidStack tFluid = GT_Utility.getFluidForFilledItem(aStack, true);
        if (tFluid != null) {
            tFluidStack = tFluid;
            tResults.add(GT_Utility.getFluidDisplayStack(tFluid, false));
        } else {
            tFluidStack = GT_Utility.getFluidFromDisplayStack(aStack);
        }
        if (tFluidStack != null) {
            tResults.addAll(GT_Utility.getContainersFromFluid(tFluidStack));
        }
    }

    private void loadTieredCraftingRecipesUpTo(byte upperTier) {
        this.arecipes.addAll(this.getTieredRecipes((byte)0, upperTier));
    }

    private List<CachedDefaultRecipe> getTieredRecipes(byte lowerTier, byte upperTier) {
        List<CachedDefaultRecipe> recipes = this.getCache();
        if (recipes.size() > 0) {
            Range<Integer> indexRange = this.getCacheHolder().getIndexRangeForTiers(lowerTier, upperTier);
            recipes = recipes.subList((Integer)indexRange.getMinimum(), (Integer)indexRange.getMaximum() + 1);
        }
        return recipes;
    }

    public void loadUsageRecipes(ItemStack aInput) {
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GT_OreDictUnificator.get(false, aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        this.addFluidStacks(aInput, tInputs);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tInputs.stream().anyMatch(stack -> recipe.contains(recipe.mInputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            ItemStack candidate = (ItemStack)ingredients[0];
            GT_NEI_DefaultHandler handler = (GT_NEI_DefaultHandler)this.newInstance();
            if (RecipeCatalysts.containsCatalyst((IRecipeHandler)handler, (ItemStack)candidate)) {
                IMetaTileEntity gtTileEntity = GT_Item_Machines.getMetaTileEntity(candidate);
                if (gtTileEntity instanceof GT_MetaTileEntity_BasicMachine) {
                    Power power = ((GT_MetaTileEntity_BasicMachine)gtTileEntity).getPower();
                    handler.loadCraftingRecipes(this.getOverlayIdentifier(), power);
                    return handler;
                }
                handler.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
                return handler;
            }
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        GT_NEI_DefaultHandler handler = (GT_NEI_DefaultHandler)super.getRecipeHandler(outputId, results);
        if (results.length > 0 && results[0] instanceof Power) {
            handler.mPower = (Power)results[0];
        }
        return handler;
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNEIName;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)78);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!NEIClientUtils.shiftKey()) {
            ++cycleTicksStatic;
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        if (this.mRecipeName == null) {
            this.mRecipeName = this.computeRecipeName();
        }
        return this.mRecipeName;
    }

    private String computeRecipeName() {
        String recipeName = GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
        if (this.mPower != null) {
            recipeName = this.addSuffixToRecipeName(recipeName, " (", this.mPower.getTierString() + ")");
        }
        return recipeName;
    }

    private String addSuffixToRecipeName(String recipeName, String separator, String suffix) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int recipeNameWidth = fontRenderer.func_78256_a(recipeName);
        int targetWidth = 140 - fontRenderer.func_78256_a(suffix);
        if (recipeNameWidth + fontRenderer.func_78256_a(separator) > targetWidth) {
            this.setupRecipeNameTooltip(recipeName + separator + suffix);
            separator = "...(";
            recipeName = this.shrinkRecipeName(recipeName, targetWidth - fontRenderer.func_78256_a(separator));
        }
        return recipeName + separator + suffix;
    }

    private String shrinkRecipeName(String recipeName, int targetWidth) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        while (fontRenderer.func_78256_a(recipeName = recipeName.substring(0, recipeName.length() - 2)) > targetWidth) {
        }
        return recipeName;
    }

    private void setupRecipeNameTooltip(String tooltip) {
        this.mRecipeNameTooltip = new NEIHandlerAbsoluteTooltip(tooltip, new Rectangle(13, -34, 139, 11));
    }

    public String getRecipeTabName() {
        return GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
    }

    public String getGuiTexture() {
        return this.mRecipeMap.mNEIGUIPath;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == 10000) break;
                currenttip.add(GT_Utility.trans("150", "Chance: ") + ((FixedPositionedStack)tStack).mChance / 100 + "." + (((FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((FixedPositionedStack)tStack).mChance % 100)) + "%");
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (gregtech.api.enums.ItemList.Display_Fluid.isStackEqual(tStack.item, true, true) || tStack.item.field_77994_a != 0) break;
                currenttip.add(GT_Utility.trans("151", "Does not get consumed in the process"));
                break;
            }
        }
        if (this.mRecipeNameTooltip != null) {
            this.mRecipeNameTooltip.handleTooltip(currenttip, aRecipeIndex);
        }
        return currenttip;
    }

    private Power getPowerFromRecipeMap() {
        EUPower power = this.mRecipeMap.mShowVoltageAmperageInNEI ? new EUPower(1, this.mRecipeMap.mAmperage) : new UnspecifiedEUPower(1, this.mRecipeMap.mAmperage);
        return power;
    }

    public void drawExtras(int aRecipeIndex) {
        GT_Recipe recipe = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe;
        String[] recipeDesc = recipe.getNeiDesc();
        if (recipeDesc == null) {
            this.drawDescription(recipe);
        } else {
            this.drawOverrideDescription(recipeDesc);
        }
    }

    private void drawDescription(GT_Recipe recipe) {
        if (this.mPower == null) {
            this.mPower = this.getPowerFromRecipeMap();
        }
        this.mPower.computePowerUsageAndDuration(recipe.mEUt, recipe.mDuration);
        if (this.mPower.getEuPerTick() > 0) {
            this.drawPowerUsageLines();
        }
        if (this.mPower.getDurationTicks() > 0) {
            this.drawLine(4, GT_Utility.trans("158", "Time: ") + this.mPower.getDurationString());
        }
        this.drawOptionalLine(5, this.getSpecialInfo(recipe.mSpecialValue));
    }

    private void drawPowerUsageLines() {
        this.drawLine(0, GT_Utility.trans("152", "Total: ") + this.mPower.getTotalPowerString());
        this.drawLine(1, GT_Utility.trans("153", "Usage: ") + this.mPower.getPowerUsageString());
        this.drawOptionalLine(2, this.mPower.getVoltageString(), GT_Utility.trans("154", "Voltage: "));
        this.drawOptionalLine(3, this.mPower.getAmperageString(), GT_Utility.trans("155", "Amperage: "));
    }

    private void drawOverrideDescription(String[] recipeDesc) {
        for (int i = 0; i < recipeDesc.length; ++i) {
            if (recipeDesc[i] == null) continue;
            this.drawLine(i, recipeDesc[i]);
        }
    }

    private String getSpecialInfo(int specialValue) {
        String specialInfo = null;
        if (specialValue == -100 && GT_Mod.gregtechproxy.mLowGravProcessing) {
            specialInfo = GT_Utility.trans("159", "Needs Low Gravity");
        } else if (specialValue == -200 && GT_Mod.gregtechproxy.mEnableCleanroom) {
            specialInfo = GT_Utility.trans("160", "Needs Cleanroom");
        } else if (specialValue == -201) {
            specialInfo = GT_Utility.trans("206", "Scan for Assembly Line");
        } else if (specialValue == -300 && GT_Mod.gregtechproxy.mEnableCleanroom) {
            specialInfo = GT_Utility.trans("160", "Needs Cleanroom & LowGrav");
        } else if (specialValue == -400) {
            specialInfo = GT_Utility.trans("216", "Deprecated Recipe");
        } else if (this.hasSpecialValueFormat()) {
            specialInfo = this.formatSpecialValue(specialValue);
        }
        return specialInfo;
    }

    private boolean hasSpecialValueFormat() {
        return GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePre) || GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePost);
    }

    private String formatSpecialValue(int SpecialValue) {
        return this.mRecipeMap.mNEISpecialValuePre + GT_Utility.formatNumbers((long)SpecialValue * (long)this.mRecipeMap.mNEISpecialValueMultiplier) + this.mRecipeMap.mNEISpecialValuePost;
    }

    private void drawOptionalLine(int lineNumber, String line, String prefix) {
        if (line != null) {
            this.drawLine(lineNumber, prefix + line);
        }
    }

    private void drawOptionalLine(int lineNumber, String line) {
        if (line != null) {
            this.drawLine(lineNumber, line);
        }
    }

    private void drawLine(int lineNumber, String line) {
        GT_NEI_DefaultHandler.drawText(10, 73 + lineNumber * 10, line, -16777216);
    }

    @Deprecated
    public String trans(String aKey, String aEnglish) {
        return GT_Utility.trans(aKey, aEnglish);
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new GT_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new GT_RectHandler());
    }

    private static class SortedRecipeListCache {
        private int mCachedRecipesVersion = -1;
        @Nullable
        private SoftReference<List<CachedDefaultRecipe>> mCachedRecipes;
        private Range<Integer>[] mTierIndexes;
        private Range<Byte> mTierRange;

        private SortedRecipeListCache() {
        }

        public int getCachedRecipesVersion() {
            return this.mCachedRecipesVersion;
        }

        public void setCachedRecipesVersion(int aCachedRecipesVersion) {
            this.mCachedRecipesVersion = aCachedRecipesVersion;
        }

        @Nullable
        public List<CachedDefaultRecipe> getCachedRecipes() {
            return this.mCachedRecipes == null ? null : this.mCachedRecipes.get();
        }

        public void setCachedRecipes(@Nonnull List<CachedDefaultRecipe> aCachedRecipes) {
            this.mCachedRecipes = new SoftReference<List<CachedDefaultRecipe>>(aCachedRecipes);
        }

        public Range<Integer> getIndexRangeForTiers(byte lowerTier, byte upperTier) {
            if (this.mTierIndexes == null) {
                this.computeTierIndexes();
            }
            return Range.between((Comparable)Integer.valueOf(this.getLowIndexForTier(lowerTier)), (Comparable)Integer.valueOf(this.getHighIndexForTier(upperTier)));
        }

        private void computeTierIndexes() {
            this.mTierIndexes = new Range[GT_Values.V.length];
            Iterator<CachedDefaultRecipe> iterator = this.mCachedRecipes.get().iterator();
            int index = 0;
            int minIndex = 0;
            int maxIndex = -1;
            byte previousTier = -1;
            byte lowestTier = 0;
            while (iterator.hasNext()) {
                CachedDefaultRecipe recipe = iterator.next();
                byte recipeTier = GT_Utility.getTier(recipe.mRecipe.mEUt);
                if (recipeTier != previousTier) {
                    if (maxIndex != -1) {
                        this.mTierIndexes[previousTier] = Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex));
                    } else {
                        lowestTier = recipeTier;
                    }
                    minIndex = index;
                    previousTier = recipeTier;
                }
                maxIndex = index++;
                if (iterator.hasNext()) continue;
                this.mTierIndexes[recipeTier] = Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex));
                this.mTierRange = Range.between((Comparable)Byte.valueOf(lowestTier), (Comparable)Byte.valueOf(recipeTier));
            }
        }

        private int getLowIndexForTier(byte lowerTier) {
            byte lowTier = (byte)Math.max(((Byte)this.mTierRange.getMinimum()).byteValue(), lowerTier);
            while (this.mTierIndexes[lowTier] == null) {
                lowTier = (byte)(lowTier + 1);
            }
            return (Integer)this.mTierIndexes[lowTier].getMinimum();
        }

        private int getHighIndexForTier(byte upperTier) {
            byte highTier = (byte)Math.min(((Byte)this.mTierRange.getMaximum()).byteValue(), upperTier);
            while (this.mTierIndexes[highTier] == null) {
                highTier = (byte)(highTier - 1);
            }
            return (Integer)this.mTierIndexes[highTier].getMaximum();
        }
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GT_Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public CachedDefaultRecipe(GT_Recipe aRecipe) {
            ArrayList<PositionedStack> maybeOut;
            ArrayList<PositionedStack> maybeIn;
            super((TemplateRecipeHandler)GT_NEI_DefaultHandler.this);
            this.mRecipe = aRecipe;
            try {
                maybeIn = aRecipe.getInputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeIn = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid InputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            try {
                maybeOut = aRecipe.getOutputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeOut = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid OutputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            if (maybeIn != null && maybeOut != null) {
                this.mInputs = maybeIn;
                this.mOutputs = maybeOut;
                return;
            }
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            int tStartIndex = 0;
            switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualInputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 32));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 32));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 32));
                    }
                    ++tStartIndex;
                }
            }
            if (aRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, 120, 52));
            }
            tStartIndex = 0;
            switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualOutputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                }
            }
            if (aRecipe.mFluidInputs.length > 0 && aRecipe.mFluidInputs[0] != null && aRecipe.mFluidInputs[0].getFluid() != null) {
                this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[0], true), 48, 52));
                if (aRecipe.mFluidInputs.length > 1 && aRecipe.mFluidInputs[1] != null && aRecipe.mFluidInputs[1].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[1], true), 30, 52));
                }
            }
            if (aRecipe.mFluidOutputs.length > 1) {
                if (aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), 120, 5));
                }
                if (aRecipe.mFluidOutputs[1] != null && aRecipe.mFluidOutputs[1].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[1], true), 138, 5));
                }
                if (aRecipe.mFluidOutputs.length > 2 && aRecipe.mFluidOutputs[2] != null && aRecipe.mFluidOutputs[2].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[2], true), 102, 23));
                }
                if (aRecipe.mFluidOutputs.length > 3 && aRecipe.mFluidOutputs[3] != null && aRecipe.mFluidOutputs[3].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[3], true), 120, 23));
                }
                if (aRecipe.mFluidOutputs.length > 4 && aRecipe.mFluidOutputs[4] != null && aRecipe.mFluidOutputs[4].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[4], true), 138, 23));
                }
            } else if (aRecipe.mFluidOutputs.length > 0 && aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), 102, 52));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(cycleTicksStatic / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public static class FixedPositionedStack
    extends PositionedStack {
        public final int mChance;
        public boolean permutated = false;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            super(GT_OreDictUnificator.getNonUnifiedStacks(object), x, y, true);
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayList<ItemStack> tDisplayStacks = new ArrayList<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!GT_Utility.isStackValid(tStack)) continue;
                if (tStack.func_77960_j() == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.func_77973_b());
                    if (!permutations.isEmpty()) {
                        for (ItemStack permutation : permutations) {
                            tDisplayStacks.add(GT_Utility.copyAmount(tStack.field_77994_a, permutation));
                        }
                        continue;
                    }
                    ItemStack base = new ItemStack(tStack.func_77973_b(), tStack.field_77994_a);
                    base.field_77990_d = tStack.field_77990_d;
                    tDisplayStacks.add(base);
                    continue;
                }
                tDisplayStacks.add(GT_Utility.copyOrNull(tStack));
            }
            this.items = tDisplayStacks.toArray(new ItemStack[0]);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }

    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            NEI_TransferRectHost host;
            if (this.canHandle(gui) && this.hostRectContainsMouse(host = (NEI_TransferRectHost)gui, this.getMousePos(gui, mousex, mousey))) {
                if (button == 0) {
                    return this.handleTransferRectMouseClick(host, false);
                }
                if (button == 1) {
                    return this.handleTransferRectMouseClick(host, true);
                }
            }
            return false;
        }

        private Point getMousePos(GuiContainer gui, int mousex, int mousey) {
            Point point = new Point(mousex - ((GT_GUIContainer)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], mousey - ((GT_GUIContainer)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]);
            return point;
        }

        private boolean hostRectContainsMouse(NEI_TransferRectHost host, Point mousePos) {
            return host.getNeiTransferRect().contains(mousePos);
        }

        private boolean handleTransferRectMouseClick(NEI_TransferRectHost gui, boolean usage) {
            String mNEI = gui.getNeiTransferRectString();
            Object[] args = gui.getNeiTransferRectArgs();
            return usage ? GuiUsageRecipe.openRecipeGui((String)mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)mNEI, (Object[])args);
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return gui instanceof NEI_TransferRectHost && GT_Utility.isStringValid(((NEI_TransferRectHost)gui).getNeiTransferRectString());
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            NEI_TransferRectHost host;
            if (this.canHandle(gui) && currenttip.isEmpty() && this.hostRectContainsMouse(host = (NEI_TransferRectHost)gui, this.getMousePos(gui, mousex, mousey))) {
                currenttip.add(host.getNeiTransferRectTooltip());
            }
            return currenttip;
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }
}

