/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_Steam
extends GT_MetaTileEntity_LargeTurbine {
    private int excessWater;
    private boolean achievement = false;
    private boolean looseFit = false;

    public GT_MetaTileEntity_LargeTurbine_Steam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_Steam(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1];
        iTextureArray[1] = aFacing == aSide ? (aActive ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_ST_ACTIVE5).extFacing().build() : (this.hasTurbine() ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_ST5).extFacing().build() : TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_ST_EMPTY5).extFacing().build())) : Textures.BlockIcons.casingTexturePages[0][57];
        return iTextureArray;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Steam Turbine").addInfo("Controller block for the Large Steam Turbine").addInfo("Needs a Turbine, place inside controller").addInfo("Outputs Distilled Water as well as producing power").addInfo("Power output depends on turbine and fitting").addInfo("Use screwdriver to adjust fitting of turbine").addSeparator().beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfo("Turbine Casing", 24).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addInputHatch("Steam, Side centered", 2).addOutputHatch("Distilled Water, Side centered", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_Steam(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 9;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 16;
    }

    private int condenseSteam(int steam) {
        this.excessWater += steam;
        int water = this.excessWater / 160;
        this.excessWater %= 160;
        return water;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        if (this.looseFit) {
            aOptFlow *= 4;
            if (aBaseEff > 10000) {
                aOptFlow = (int)((double)aOptFlow * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                aBaseEff = 7500;
            } else if (aBaseEff > 7500) {
                aOptFlow = (int)((double)aOptFlow * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            } else {
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            }
        }
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        int remainingFlow = GT_Utility.safeInt((long)((float)aOptFlow * 1.25f));
        this.realOptFlow = aOptFlow;
        this.storedFluid = 0;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            FluidStack aFluidStack = aFluids.get(i);
            if (GT_ModHandler.isAnySteam(aFluidStack)) {
                flow = Math.min(aFluidStack.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluidStack, flow));
                this.storedFluid += aFluidStack.amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                GT_Mod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "muchsteam");
                this.achievement = true;
                continue;
            }
            if (!GT_ModHandler.isSuperHeatedSteam(aFluidStack)) continue;
            this.depleteInput(new FluidStack(aFluidStack, aFluidStack.amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        int waterToOutput = this.condenseSteam(totalFlow);
        this.addOutput(GT_ModHandler.getDistilledWater(waterToOutput));
        if (totalFlow == aOptFlow) {
            tEU = GT_Utility.safeInt((long)tEU * (long)aBaseEff / 20000L);
        } else {
            float efficiency = 1.0f - Math.abs((float)(totalFlow - aOptFlow) / (float)aOptFlow);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, GT_Utility.safeInt((long)tEU * (long)aBaseEff / 20000L));
        }
        return tEU;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit ^= true;
            GT_Utility.sendChatToPlayer(aPlayer, this.looseFit ? GT_Utility.trans("500", "Fitting: Loose - More Flow") : GT_Utility.trans("501", "Fitting: Tight - More Efficiency"));
        }
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && XSTR.XSTR_INSTANCE.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public String[] getInfoData() {
        ((GT_MetaTileEntity_LargeTurbine)this).looseFit = this.looseFit;
        return super.getInfoData();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }
}

