/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_SpecialFilter;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Recipe;
import gregtech.common.blocks.GT_Item_Machines;
import gregtech.common.gui.GT_GUIContainer_RecipeFilter;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_RecipeFilter
extends GT_MetaTileEntity_SpecialFilter {
    public GT_Recipe.GT_Recipe_Map mRecipeMap;

    public GT_MetaTileEntity_RecipeFilter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"Filters 1 Recipe Type", "Use Screwdriver to regulate output stack size", "Does not consume energy to move Item"});
    }

    public GT_MetaTileEntity_RecipeFilter(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_RecipeFilter(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_RecipeFilter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void clickTypeIcon(boolean aRightClick, ItemStack aHandStack) {
        GT_MetaTileEntity_BasicMachine machine;
        GT_Recipe.GT_Recipe_Map recipeList;
        IMetaTileEntity mte;
        if (!aRightClick && (mte = GT_Item_Machines.getMetaTileEntity(aHandStack)) instanceof GT_MetaTileEntity_BasicMachine && (recipeList = (machine = (GT_MetaTileEntity_BasicMachine)mte).getRecipeList()) != null) {
            this.mInventory[9] = machine.getStackForm(1L);
            this.mRecipeMap = recipeList;
            return;
        }
        this.mInventory[9] = null;
        this.mRecipeMap = null;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_RecipeFilter(this.mName, (int)this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_RECIPEFILTER), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_RECIPEFILTER_GLOW).glow().build());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mRecipeMap != null) {
            aNBT.func_74778_a("mRecipeMap", this.mRecipeMap.mUniqueIdentifier);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mRecipeMap = GT_Recipe.GT_Recipe_Map.sIndexedMappings.getOrDefault(aNBT.func_74779_i("mRecipeMap"), null);
    }

    @Override
    protected boolean isStackAllowed(ItemStack aStack) {
        return this.mRecipeMap != null && this.mRecipeMap.containsInput(aStack);
    }
}

