/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_Cover_Fluidfilter
extends GT_CoverBehaviorBase<FluidFilterData> {
    private final int FILTER_INPUT_DENY_OUTPUT = 0;
    private final int INVERT_INPUT_DENY_OUTPUT = 1;
    private final int FILTER_INPUT_ANY_OUTPUT = 2;
    private final int INVERT_INPUT_ANY_OUTPUT = 3;
    private final int DENY_INPUT_FILTER_OUTPUT = 4;
    private final int DENY_INPUT_INVERT_OUTPUT = 5;
    private final int ANY_INPUT_FILTER_OUTPUT = 6;
    private final int ANY_INPUT_INVERT_OUTPUT = 7;

    public GT_Cover_Fluidfilter() {
        super(FluidFilterData.class);
    }

    @Override
    public FluidFilterData createDataObject() {
        return new FluidFilterData(-1, 0);
    }

    @Override
    public FluidFilterData createDataObject(int aLegacyData) {
        return new FluidFilterData(aLegacyData >>> 3, aLegacyData & 7);
    }

    @Override
    protected String getDescriptionImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        Fluid fluid = FluidRegistry.getFluid((int)aCoverVariable.mFluidID);
        if (fluid == null) {
            return "";
        }
        FluidStack sFluid = new FluidStack(fluid, 1000);
        return String.format("Filtering Fluid: %s  Mode: %s", sFluid.getLocalizedName(), this.getFilterMode(aCoverVariable.mFilterMode));
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected FluidFilterData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable;
    }

    public String getFilterMode(int aFilterMode) {
        switch (aFilterMode) {
            case 0: {
                return GT_Utility.trans("043", "Filter input, Deny output");
            }
            case 1: {
                return GT_Utility.trans("044", "Invert input, Deny output");
            }
            case 2: {
                return GT_Utility.trans("045", "Filter input, Permit any output");
            }
            case 3: {
                return GT_Utility.trans("046", "Invert input, Permit any output");
            }
            case 4: {
                return GT_Utility.trans("307", "Deny input, Filter output");
            }
            case 5: {
                return GT_Utility.trans("308", "Deny input, Invert output");
            }
            case 6: {
                return GT_Utility.trans("309", "Permit any input, Filter output");
            }
            case 7: {
                return GT_Utility.trans("310", "Permit any input, Invert output");
            }
        }
        return "UNKNOWN";
    }

    @Override
    protected FluidFilterData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable.mFilterMode = (aCoverVariable.mFilterMode + (aPlayer.func_70093_af() ? -1 : 1)) % 8;
        if (aCoverVariable.mFilterMode < 0) {
            aCoverVariable.mFilterMode = 7;
        }
        GT_Utility.sendChatToPlayer(aPlayer, this.getFilterMode(aCoverVariable.mFilterMode));
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || aSide > 3 && (double)aY > 0.375 && (double)aY < 0.625 || aSide < 2 && (double)aZ > 0.375 && (double)aZ < 0.625 || aSide == 2 || aSide == 3) {
            ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
            if (tStack == null) {
                return true;
            }
            FluidStack tFluid = GT_Utility.getFluidForFilledItem(tStack, true);
            if (tFluid != null) {
                int aFluid = tFluid.getFluidID();
                aCoverVariable.mFluidID = aFluid;
                aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
                FluidStack sFluid = new FluidStack(FluidRegistry.getFluid((int)aFluid), 1000);
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("047", "Filter Fluid: ") + sFluid.getLocalizedName());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = aCoverVariable.mFilterMode;
        int aFilterFluid = aCoverVariable.mFluidID;
        if (aFilterMode == 4 || aFilterMode == 5) {
            return false;
        }
        if (aFilterMode == 6 || aFilterMode == 7) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 0 || aFilterMode == 2;
        }
        return aFilterMode == 1 || aFilterMode == 3;
    }

    @Override
    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = aCoverVariable.mFilterMode;
        int aFilterFluid = aCoverVariable.mFluidID;
        if (aFilterMode == 0 || aFilterMode == 1) {
            return false;
        }
        if (aFilterMode == 2 || aFilterMode == 3) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 4 || aFilterMode == 6;
        }
        return aFilterMode == 5 || aFilterMode == 7;
    }

    @Override
    protected boolean alwaysLookConnectedImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(byte aSide, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    protected Object getClientGUIImpl(byte aSide, int aCoverID, FluidFilterData coverData, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GT_FluidFilterGUICover(aSide, aCoverID, coverData, aTileEntity);
    }

    public static class FluidFilterData
    implements ISerializableObject {
        private int mFluidID;
        private int mFilterMode;

        public FluidFilterData(int mFluidID, int mFilterMode) {
            this.mFluidID = mFluidID;
            this.mFilterMode = mFilterMode;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidFilterData(this.mFluidID, this.mFilterMode);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.func_74768_a("mFilterMode", this.mFilterMode);
            if (this.mFluidID >= 0) {
                tNBT.func_74778_a("mFluid", FluidRegistry.getFluid((int)this.mFluidID).getName());
            }
            return tNBT;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeByte(this.mFilterMode).writeInt(this.mFluidID);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (aNBT instanceof NBTTagCompound) {
                NBTTagCompound tNBT = (NBTTagCompound)aNBT;
                this.mFilterMode = tNBT.func_74762_e("mFilterMode");
                this.mFluidID = tNBT.func_150297_b("mFluid", 8) ? FluidRegistry.getFluidID((String)tNBT.func_74779_i("mFluid")) : -1;
            }
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.mFilterMode = aBuf.readByte();
            this.mFluidID = aBuf.readInt();
            return this;
        }
    }

    private class GT_FluidFilterGUICover
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private final FluidFilterData coverVariable;
        private final GT_GuiFakeItemButton fluidFilterButton;
        protected String fluidFilterName;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GT_FluidFilterGUICover(byte aSide, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Utility.trans("232", "Filter Input"));
            b = new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Utility.trans("233", "Filter Output"));
            b = new GT_GuiIconButton(this, 2, 10, 61, GT_GuiIcon.BLOCK_INPUT).setTooltipText(GT_Utility.trans("234", "Block Output"));
            b = new GT_GuiIconButton(this, 3, 28, 61, GT_GuiIcon.ALLOW_INPUT).setTooltipText(GT_Utility.trans("235", "Allow Output"));
            b = new GT_GuiIconButton(this, 4, 10, 43, GT_GuiIcon.WHITELIST).setTooltipText(GT_Utility.trans("236", "Whitelist Fluid"));
            b = new GT_GuiIconButton(this, 5, 28, 43, GT_GuiIcon.BLACKLIST).setTooltipText(GT_Utility.trans("237", "Blacklist Fluid"));
            this.fluidFilterButton = new GT_GuiFakeItemButton(this, 10, 81, GT_GuiIcon.SLOT_DARKGRAY);
            this.fluidFilterButton.setMimicSlot(true);
        }

        private int getNewFilterMode(int id) {
            switch (id) {
                case 0: {
                    return this.coverVariable.mFilterMode & 3;
                }
                case 1: {
                    return this.coverVariable.mFilterMode | 4;
                }
                case 2: {
                    return this.coverVariable.mFilterMode & 5;
                }
                case 3: {
                    return this.coverVariable.mFilterMode | 2;
                }
                case 4: {
                    return this.coverVariable.mFilterMode & 6;
                }
                case 5: {
                    return this.coverVariable.mFilterMode | 1;
                }
            }
            return this.coverVariable.mFilterMode;
        }

        private boolean getClickable(int id) {
            switch (id) {
                case 0: 
                case 1: {
                    return (this.coverVariable.mFilterMode >> 2 & 1) != (id & 1);
                }
                case 2: 
                case 3: {
                    return (this.coverVariable.mFilterMode >> 1 & 1) != (id & 1);
                }
                case 4: 
                case 5: {
                    return (this.coverVariable.mFilterMode & 1) != (id & 1);
                }
            }
            return false;
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b(GT_Utility.trans("238", "Filter Direction"), 46, 28, -11184811);
            this.field_146289_q.func_78276_b(GT_Utility.trans("239", "Filter Type"), 46, 46, -11184811);
            this.field_146289_q.func_78276_b(GT_Utility.trans("240", "Block Flow"), 46, 64, -11184811);
            this.field_146289_q.func_78279_b(this.fluidFilterName, 31, 83, this.gui_width - 40, -14540254);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.field_146127_k)) {
                this.coverVariable.mFilterMode = (byte)this.getNewFilterMode(btn.field_146127_k);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            ItemStack item;
            for (Object o : this.field_146292_n) {
                if (!(o instanceof GT_GuiIconButton)) continue;
                GT_GuiIconButton b = (GT_GuiIconButton)o;
                b.field_146124_l = this.getClickable(b.field_146127_k);
                if (this.getClickable(1)) {
                    if (b.field_146127_k == 2) {
                        b.setTooltipText(GT_Utility.trans("311", "Block Output"));
                        continue;
                    }
                    if (b.field_146127_k != 3) continue;
                    b.setTooltipText(GT_Utility.trans("312", "Allow Output"));
                    continue;
                }
                if (b.field_146127_k == 2) {
                    b.setTooltipText(GT_Utility.trans("313", "Block Input"));
                    continue;
                }
                if (b.field_146127_k != 3) continue;
                b.setTooltipText(GT_Utility.trans("314", "Allow Input"));
            }
            Fluid f = FluidRegistry.getFluid((int)this.coverVariable.mFluidID);
            if (f != null && (item = GT_Utility.getFluidDisplayStack(f)) != null) {
                this.fluidFilterButton.setItem(item);
                this.fluidFilterName = item.func_82833_r();
                return;
            }
            this.fluidFilterButton.setItem(null);
            this.fluidFilterName = GT_Utility.trans("315", "Filter Empty");
        }
    }
}

