/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;

public class GT_TooltipEventHandler {
    private static final Map<String, Supplier<String>> tooltipMap = new HashMap<String, Supplier<String>>();
    private static final String BLACK;
    private static final String DARK_BLUE;
    private static final String DARK_GREEN;
    private static final String DARK_AQUA;
    private static final String DARK_RED;
    private static final String DARK_PURPLE;
    private static final String GOLD;
    private static final String GRAY;
    private static final String DARK_GRAY;
    private static final String BLUE;
    private static final String GREEN;
    private static final String AQUA;
    private static final String RED;
    private static final String LIGHT_PURPLE;
    private static final String YELLOW;
    private static final String WHITE;
    private static final String OBFUSCATED;
    private static final String BOLD;
    private static final String STRIKETHROUGH;
    private static final String UNDERLINE;
    private static final String ITALIC;
    private static final String RESET;
    private static final Supplier<String> NEW_LINE;

    public static void init() {
        GT_TooltipEventHandler.addOredictTooltip("ULV", GT_TooltipEventHandler.text(WHITE + "ULV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("LV", GT_TooltipEventHandler.text(GRAY + "LV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("MV", GT_TooltipEventHandler.text(GOLD + "MV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("HV", GT_TooltipEventHandler.text(YELLOW + "HV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("EV", GT_TooltipEventHandler.text(DARK_GRAY + "EV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("IV", GT_TooltipEventHandler.text(GREEN + "IV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("LuV", GT_TooltipEventHandler.text(LIGHT_PURPLE + "LuV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("ZPM", GT_TooltipEventHandler.text(AQUA + "ZPM-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("UV", GT_TooltipEventHandler.text(DARK_GREEN + "UV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("UHV", GT_TooltipEventHandler.text(DARK_RED + "UHV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("UEV", GT_TooltipEventHandler.text(DARK_PURPLE + "UEV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("UIV", GT_TooltipEventHandler.text(DARK_BLUE + BOLD + "UIV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("UMV", GT_TooltipEventHandler.text(RED + BOLD + UNDERLINE + "UMV-Tier"));
        GT_TooltipEventHandler.addOredictTooltip("UXV", GT_TooltipEventHandler.animatedText("UXV-Tier", 1, 100, DARK_PURPLE + BOLD + UNDERLINE, DARK_RED + UNDERLINE + BOLD));
        GT_TooltipEventHandler.addOredictTooltip("MAX", GT_TooltipEventHandler.chain(GT_TooltipEventHandler.animatedText("X", 1, 100, LIGHT_PURPLE + BOLD + OBFUSCATED + UNDERLINE, RED + BOLD + OBFUSCATED + UNDERLINE, GOLD + OBFUSCATED + BOLD + UNDERLINE, YELLOW + OBFUSCATED + BOLD + UNDERLINE, GREEN + OBFUSCATED + BOLD + UNDERLINE, AQUA + OBFUSCATED + BOLD + UNDERLINE, BLUE + OBFUSCATED + BOLD + UNDERLINE), GT_TooltipEventHandler.animatedText("MAX-Tier", 1, 100, RED + BOLD + UNDERLINE, GOLD + BOLD + UNDERLINE, YELLOW + BOLD + UNDERLINE, GREEN + BOLD + UNDERLINE, AQUA + BOLD + UNDERLINE, BLUE + BOLD + UNDERLINE, LIGHT_PURPLE + BOLD + UNDERLINE), GT_TooltipEventHandler.animatedText("X", 1, 100, GOLD + OBFUSCATED + BOLD + UNDERLINE, YELLOW + OBFUSCATED + BOLD + UNDERLINE, GREEN + OBFUSCATED + BOLD + UNDERLINE, AQUA + OBFUSCATED + BOLD + UNDERLINE, BLUE + OBFUSCATED + BOLD + UNDERLINE, LIGHT_PURPLE + OBFUSCATED + BOLD + UNDERLINE, RED + OBFUSCATED + BOLD + UNDERLINE)));
    }

    @SubscribeEvent
    public void renderTooltip(ItemTooltipEvent event) {
        String text;
        Supplier<String> tooltip = tooltipMap.get(GT_TooltipEventHandler.getStackIdentifier(event.itemStack));
        if (tooltip != null && !(text = tooltip.get()).isEmpty()) {
            for (String line : text.split("\n")) {
                event.toolTip.add(line);
            }
        }
    }

    @SafeVarargs
    private static Supplier<String> chain(Supplier<String> ... parts) {
        return () -> {
            String s = "";
            for (Supplier text : parts) {
                s = s + (String)text.get();
            }
            return s;
        };
    }

    private static Supplier<String> text(String text) {
        return () -> text;
    }

    private static Supplier<String> animatedText(String text, int posstep, int delay, String ... formattingArray) {
        if (text == null || text.isEmpty() || formattingArray == null || formattingArray.length == 0) {
            return () -> "";
        }
        delay = delay <= 0 ? (delay = 1) : delay;
        int finalDelay = delay;
        return () -> {
            StringBuilder sb = new StringBuilder(text.length() * 3);
            int offset = (int)(System.currentTimeMillis() / (long)finalDelay % (long)formattingArray.length);
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                int indexColorArray = (i * posstep + formattingArray.length - offset) % formattingArray.length;
                sb.append(formattingArray[indexColorArray]);
                sb.append(c);
            }
            return sb.toString();
        };
    }

    private static void addOredictTooltip(String oredictName, Supplier<String> tooltip) {
        for (ItemStack item : OreDictionary.getOres((String)oredictName)) {
            GT_TooltipEventHandler.addItemTooltip(item, tooltip);
        }
    }

    private static void addItemTooltip(String modID, String registryName, int meta, Supplier<String> tooltip) {
        Item item = GameRegistry.findItem((String)modID, (String)registryName);
        if (item == null || meta < 0 || meta >= Short.MAX_VALUE || tooltip == null) {
            return;
        }
        String identifier = item.func_77658_a() + "@" + meta;
        Supplier<String> previous = tooltipMap.get(identifier);
        if (previous == null) {
            tooltipMap.put(identifier, tooltip);
        } else {
            tooltipMap.put(identifier, GT_TooltipEventHandler.chain(previous, NEW_LINE, tooltip));
        }
    }

    private static void addItemTooltip(ItemStack item, Supplier<String> tooltip) {
        if (item == null || tooltip == null) {
            return;
        }
        String identifier = GT_TooltipEventHandler.getStackIdentifier(item);
        Supplier<String> previous = tooltipMap.get(identifier);
        if (previous == null) {
            tooltipMap.put(identifier, tooltip);
        } else {
            tooltipMap.put(identifier, GT_TooltipEventHandler.chain(previous, NEW_LINE, tooltip));
        }
    }

    private static String getStackIdentifier(ItemStack stack) {
        return stack == null ? "" : stack.func_77973_b().func_77658_a() + "@" + stack.func_77960_j();
    }

    static {
        AQUA = EnumChatFormatting.AQUA.toString();
        BLACK = EnumChatFormatting.BLACK.toString();
        BLUE = EnumChatFormatting.BLUE.toString();
        BOLD = EnumChatFormatting.BOLD.toString();
        DARK_AQUA = EnumChatFormatting.DARK_AQUA.toString();
        DARK_BLUE = EnumChatFormatting.DARK_BLUE.toString();
        DARK_GRAY = EnumChatFormatting.DARK_GRAY.toString();
        DARK_GREEN = EnumChatFormatting.DARK_GREEN.toString();
        DARK_PURPLE = EnumChatFormatting.DARK_PURPLE.toString();
        DARK_RED = EnumChatFormatting.DARK_RED.toString();
        GOLD = EnumChatFormatting.GOLD.toString();
        GRAY = EnumChatFormatting.GRAY.toString();
        GREEN = EnumChatFormatting.GREEN.toString();
        ITALIC = EnumChatFormatting.ITALIC.toString();
        LIGHT_PURPLE = EnumChatFormatting.LIGHT_PURPLE.toString();
        OBFUSCATED = EnumChatFormatting.OBFUSCATED.toString();
        RED = EnumChatFormatting.RED.toString();
        RESET = EnumChatFormatting.RESET.toString();
        STRIKETHROUGH = EnumChatFormatting.STRIKETHROUGH.toString();
        UNDERLINE = EnumChatFormatting.UNDERLINE.toString();
        WHITE = EnumChatFormatting.WHITE.toString();
        YELLOW = EnumChatFormatting.YELLOW.toString();
        NEW_LINE = new Supplier<String>(){

            @Override
            public String get() {
                return "\n";
            }

            public String toString() {
                return "\n";
            }
        };
    }
}

