/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.interfaces.internal.IGT_CraftingRecipe;
import gregtech.api.objects.GT_HashSet;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_IBoxableWrapper;
import gregtech.api.util.GT_ItsNotMyFaultException;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Shapeless_Recipe;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.item.ItemWrapper;
import ic2.api.reactor.IReactorComponent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GT_ModHandler {
    public static final List<IRecipe> sSingleNonBlockDamagableRecipeList = new ArrayList<IRecipe>(1000);
    private static final Map<String, ItemStack> sIC2ItemMap = new HashMap<String, ItemStack>();
    private static final List<IRecipe> sAllRecipeList = new ArrayList<IRecipe>(5000);
    private static final List<IRecipe> sBufferRecipeList = new ArrayList<IRecipe>(1000);
    private static final List<ItemStack> delayedRemovalByOutput = new ArrayList<ItemStack>();
    private static final List<InventoryCrafting> delayedRemovalByRecipe = new ArrayList<InventoryCrafting>();
    public static volatile int VERSION = 509;
    public static Collection<String> sNativeRecipeClasses = new HashSet<String>();
    public static Collection<String> sSpecialRecipeClasses = new HashSet<String>();
    public static GT_HashSet<GT_ItemStack> sNonReplaceableItems = new GT_HashSet();
    public static Object sBoxableWrapper = new GT_IBoxableWrapper();
    private static final Map<IRecipeInput, RecipeOutput> sExtractorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sMaceratorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sCompressorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sOreWashingRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sThermalCentrifugeRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sMassfabRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static boolean sBufferCraftingRecipes = true;
    public static List<Integer> sSingleNonBlockDamagableRecipeList_list = new ArrayList<Integer>(100);
    private static final boolean sSingleNonBlockDamagableRecipeList_create = true;
    private static final ItemStack sMt1 = new ItemStack(Blocks.field_150346_d, 1, 0);
    private static final ItemStack sMt2 = new ItemStack(Blocks.field_150346_d, 1, 0);
    private static final String s_H = "h";
    private static final String s_F = "f";
    private static final String s_I = "I";
    private static final String s_P = "P";
    private static final String s_R = "R";
    private static final ItemStack[][] sShapes1 = new ItemStack[][]{{sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1, null}, {sMt1, null, sMt1, sMt1, null, sMt1, sMt1, sMt1, sMt1}, {null, sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1}, {sMt1, sMt1, sMt1, sMt1, null, sMt1, null, null, null}, {sMt1, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1}, {sMt1, sMt1, sMt1, sMt1, null, sMt1, sMt1, null, sMt1}, {null, null, null, sMt1, null, sMt1, sMt1, null, sMt1}, {null, sMt1, null, null, sMt1, null, null, sMt2, null}, {sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2, null}, {null, sMt1, null, null, sMt2, null, null, sMt2, null}, {sMt1, sMt1, null, sMt1, sMt2, null, null, sMt2, null}, {null, sMt1, sMt1, null, sMt2, sMt1, null, sMt2, null}, {sMt1, sMt1, null, null, sMt2, null, null, sMt2, null}, {null, sMt1, sMt1, null, sMt2, null, null, sMt2, null}, {null, sMt1, null, sMt1, null, null, null, sMt1, sMt2}, {null, sMt1, null, null, null, sMt1, sMt2, sMt1, null}, {null, sMt1, null, sMt1, null, sMt1, null, null, sMt2}, {null, sMt1, null, sMt1, null, sMt1, sMt2, null, null}, {null, sMt2, null, null, sMt1, null, null, sMt1, null}, {null, sMt2, null, null, sMt2, null, sMt1, sMt1, sMt1}, {null, sMt2, null, null, sMt2, null, null, sMt1, null}, {null, sMt2, null, sMt1, sMt2, null, sMt1, sMt1, null}, {null, sMt2, null, null, sMt2, sMt1, null, sMt1, sMt1}, {null, sMt2, null, null, sMt2, null, sMt1, sMt1, null}, {sMt1, null, null, null, sMt2, null, null, null, sMt2}, {null, null, sMt1, null, sMt2, null, sMt2, null, null}, {sMt1, null, null, null, sMt2, null, null, null, null}, {null, null, sMt1, null, sMt2, null, null, null, null}, {sMt1, sMt2, null, null, null, null, null, null, null}, {sMt2, sMt1, null, null, null, null, null, null, null}, {sMt1, null, null, sMt2, null, null, null, null, null}, {sMt2, null, null, sMt1, null, null, null, null, null}, {sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, null, sMt2, null}, {sMt1, sMt1, null, sMt1, sMt1, sMt2, sMt1, sMt1, null}, {null, sMt1, sMt1, sMt2, sMt1, sMt1, null, sMt1, sMt1}, {null, sMt2, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1}, {sMt1, sMt1, sMt1, sMt1, sMt2, sMt1, null, sMt2, null}, {sMt1, sMt1, null, sMt1, sMt2, sMt2, sMt1, sMt1, null}, {null, sMt1, sMt1, sMt2, sMt2, sMt1, null, sMt1, sMt1}, {null, sMt2, null, sMt1, sMt2, sMt1, sMt1, sMt1, sMt1}, {sMt1, null, null, null, sMt1, null, null, null, null}, {null, sMt1, null, sMt1, null, null, null, null, null}, {sMt1, sMt1, null, sMt2, null, sMt1, sMt2, null, null}, {null, sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2}};
    public static List<Integer> sSingleNonBlockDamagableRecipeList_validsShapes1 = new ArrayList<Integer>(44);
    public static boolean sSingleNonBlockDamagableRecipeList_validsShapes1_update = false;
    public static List<Integer> sSingleNonBlockDamagableRecipeList_warntOutput = new ArrayList<Integer>(50);
    public static List<Integer> sVanillaRecipeList_warntOutput = new ArrayList<Integer>(50);
    public static final List<IRecipe> sSingleNonBlockDamagableRecipeList_verified = new ArrayList<IRecipe>(1000);
    public static List<Integer> sAnySteamFluidIDs = new ArrayList<Integer>();
    public static List<Integer> sSuperHeatedSteamFluidIDs = new ArrayList<Integer>();
    private static List<IRecipe> bufferedRecipes;

    public static boolean isWater(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getWater(1L)) || aFluid.isFluidEqual(GT_ModHandler.getDistilledWater(1L));
    }

    public static FluidStack getWater(long aAmount) {
        return FluidRegistry.getFluidStack((String)"water", (int)((int)aAmount));
    }

    public static FluidStack getDistilledWater(long aAmount) {
        FluidStack tFluid = FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)((int)aAmount));
        if (tFluid == null) {
            tFluid = GT_ModHandler.getWater(aAmount);
        }
        return tFluid;
    }

    public static boolean isLava(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getLava(1L));
    }

    public static FluidStack getLava(long aAmount) {
        return FluidRegistry.getFluidStack((String)"lava", (int)((int)aAmount));
    }

    public static boolean isSteam(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getSteam(1L));
    }

    public static boolean isAnySteam(FluidStack aFluid) {
        return aFluid != null && (GT_ModHandler.isSteam(aFluid) || sAnySteamFluidIDs.contains(aFluid.getFluidID()));
    }

    public static boolean isSuperHeatedSteam(FluidStack aFluid) {
        return aFluid != null && sSuperHeatedSteamFluidIDs.contains(aFluid.getFluidID());
    }

    public static FluidStack getSteam(long aAmount) {
        return FluidRegistry.getFluidStack((String)"steam", (int)((int)aAmount));
    }

    public static boolean isMilk(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getMilk(1L));
    }

    public static FluidStack getMilk(long aAmount) {
        return FluidRegistry.getFluidStack((String)"milk", (int)((int)aAmount));
    }

    public static ItemStack getEmptyFuelCan(long aAmount) {
        return ItemList.IC2_Fuel_Can_Empty.get(aAmount, new Object[0]);
    }

    public static ItemStack getEmptyCell(long aAmount) {
        return ItemList.Cell_Empty.get(aAmount, new Object[0]);
    }

    public static ItemStack getAirCell(long aAmount) {
        return ItemList.Cell_Air.get(aAmount, new Object[0]);
    }

    public static ItemStack getWaterCell(long aAmount) {
        return ItemList.Cell_Water.get(aAmount, new Object[0]);
    }

    public static ItemStack getLavaCell(long aAmount) {
        return ItemList.Cell_Lava.get(aAmount, new Object[0]);
    }

    public static ItemStack setFuelValue(ItemStack aStack, short aValue) {
        aStack.func_77982_d(GT_Utility.getNBTContainingShort(aStack.func_77978_p(), "GT.ItemFuelValue", aValue));
        return aStack;
    }

    public static int getFuelValue(ItemStack aStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)aStack);
    }

    public static ItemStack getFuelCan(int aValue) {
        if (aValue < 5) {
            return ItemList.IC2_Fuel_Can_Empty.get(1L, new Object[0]);
        }
        ItemStack rFuelCanStack = ItemList.IC2_Fuel_Can_Filled.get(1L, new Object[0]);
        if (rFuelCanStack == null) {
            return null;
        }
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74768_a("value", aValue / 5);
        rFuelCanStack.func_77982_d(tNBT);
        return rFuelCanStack;
    }

    public static int getFuelCanValue(ItemStack aFuelCan) {
        if (GT_Utility.isStackInvalid(aFuelCan) || !ItemList.IC2_Fuel_Can_Filled.isStackEqual(aFuelCan, false, true)) {
            return 0;
        }
        NBTTagCompound tNBT = aFuelCan.func_77978_p();
        return tNBT == null ? 0 : tNBT.func_74762_e("value") * 5;
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, ItemStack aReplacement) {
        if (GT_Utility.isStringInvalid(aItem) || !GregTech_API.sPreloadStarted) {
            return null;
        }
        if (!sIC2ItemMap.containsKey(aItem)) {
            try {
                ItemStack tStack = IC2Items.getItem((String)aItem);
                sIC2ItemMap.put(aItem, tStack);
                if (tStack == null && GT_Values.D1) {
                    GT_Log.err.println(aItem + " is not found in the IC2 Items!");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return GT_Utility.copyAmount(aAmount, sIC2ItemMap.get(aItem), aReplacement);
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
        ItemStack rStack = GT_ModHandler.getIC2Item(aItem, aAmount, aReplacement);
        if (rStack == null) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMeta);
        return rStack;
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, int aMeta) {
        return GT_ModHandler.getIC2Item(aItem, aAmount, aMeta, null);
    }

    public static ItemStack getIC2Item(String aItem, long aAmount) {
        return GT_ModHandler.getIC2Item(aItem, aAmount, null);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount) {
        return GT_ModHandler.getModItem(aModID, aItem, aAmount, null);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, ItemStack aReplacement) {
        if (GT_Utility.isStringInvalid(aItem) || !GregTech_API.sPreloadStarted) {
            return null;
        }
        return GT_Utility.copyAmount(aAmount, GameRegistry.findItemStack((String)aModID, (String)aItem, (int)((int)aAmount)), aReplacement);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, int aMeta) {
        ItemStack rStack = GT_ModHandler.getModItem(aModID, aItem, aAmount);
        if (rStack == null) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMeta);
        return rStack;
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
        ItemStack rStack = GT_ModHandler.getModItem(aModID, aItem, aAmount, aReplacement);
        if (rStack == null) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMeta);
        return rStack;
    }

    public static boolean getModeKeyDown(EntityPlayer aPlayer) {
        return false;
    }

    public static boolean getBoostKeyDown(EntityPlayer aPlayer) {
        return false;
    }

    public static boolean getJumpKeyDown(EntityPlayer aPlayer) {
        return false;
    }

    public static boolean addValuableOre(Block aBlock, int aMeta, int aValue) {
        if (aValue <= 0) {
            return false;
        }
        try {
            Class.forName("ic2.core.IC2").getMethod("addValuableOre", IRecipeInput.class, Integer.TYPE).invoke(null, new RecipeInputItemStack(new ItemStack(aBlock, 1, aMeta)), aValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addScrapboxDrop(float aChance, ItemStack aOutput) {
        if ((aOutput = GT_OreDictUnificator.get(true, aOutput)) == null || aChance <= 0.0f) {
            return false;
        }
        aOutput.field_77994_a = 1;
        if (GT_Config.troll && !GT_Utility.areStacksEqual(aOutput, new ItemStack(Items.field_151017_I, 1, 0))) {
            return false;
        }
        if ((aChance = (float)GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.scrapboxdrops, aOutput, (double)aChance)) <= 0.0f) {
            return false;
        }
        try {
            GT_Utility.callMethod(GT_Utility.getFieldContent("ic2.api.recipe.Recipes", "scrapboxDrops", true, true), "addDrop", true, false, true, GT_Utility.copyOrNull(aOutput), Float.valueOf(aChance));
            GT_Utility.callMethod(GT_Utility.getFieldContent("ic2.api.recipe.Recipes", "scrapboxDrops", true, true), "addRecipe", true, true, false, GT_Utility.copyOrNull(aOutput), Float.valueOf(aChance));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addToRecyclerBlackList(ItemStack aRecycledStack) {
        if (aRecycledStack == null) {
            return false;
        }
        try {
            Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(aRecycledStack));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addSmeltingRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null || GT_Utility.getContainerItem(aInput, false) != null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.smelting, aInput, true)) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(aInput, GT_Utility.copyOrNull(aOutput), 0.0f);
        return true;
    }

    public static boolean addSmeltingAndAlloySmeltingRecipe(ItemStack aInput, ItemStack aOutput, boolean hidden) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        boolean temp = false;
        if (aInput.field_77994_a == 1 && GT_ModHandler.addSmeltingRecipe(aInput, aOutput)) {
            temp = true;
        }
        return GT_Values.RA.addAlloySmelterRecipe(aInput, (ItemStack)(OrePrefixes.ingot.contains(aOutput) ? ItemList.Shape_Mold_Ingot.get(0L, new Object[0]) : (OrePrefixes.block.contains(aOutput) ? ItemList.Shape_Mold_Block.get(0L, new Object[0]) : (OrePrefixes.nugget.contains(aOutput) ? ItemList.Shape_Mold_Nugget.get(0L, new Object[0]) : null))), aOutput, 130, 3, hidden);
    }

    public static boolean addLiquidTransposerRecipe(ItemStack aEmptyContainer, FluidStack aLiquid, ItemStack aFullContainer, int aMJ) {
        return true;
    }

    public static boolean addLiquidTransposerFillRecipe(ItemStack aEmptyContainer, FluidStack aLiquid, ItemStack aFullContainer, int aMJ) {
        return true;
    }

    public static boolean addLiquidTransposerEmptyRecipe(ItemStack aFullContainer, FluidStack aLiquid, ItemStack aEmptyContainer, int aMJ) {
        return true;
    }

    public static boolean addExtractionRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.extractor, aInput, true)) {
            return false;
        }
        GT_Values.RA.addExtractorRecipe(aInput, aOutput, 300, 2);
        return true;
    }

    @Deprecated
    public static boolean addRCBlastFurnaceRecipe(ItemStack aInput, ItemStack aOutput, int aTime) {
        return true;
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, null, 0, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, 100, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, aChance, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, null, 0, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, 100, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, aChance, null, 0, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance2, ItemStack aOutput3, int aChance3, boolean aOverwrite) {
        aOutput1 = GT_OreDictUnificator.get(true, aOutput1);
        aOutput2 = GT_OreDictUnificator.get(true, aOutput2);
        if (GT_Utility.isStackInvalid(aInput) || GT_Utility.isStackInvalid(aOutput1)) {
            return false;
        }
        if (GT_Utility.getContainerItem(aInput, false) == null) {
            GT_Values.RA.addPulveriserRecipe(aInput, new ItemStack[]{aOutput1, aOutput2, aOutput3}, new int[]{10000, aChance2 <= 0 ? 1000 : 100 * aChance2, aChance3 <= 0 ? 1000 : 100 * aChance3}, 400, 2);
        }
        return true;
    }

    public static boolean addImmersiveEngineeringRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance2, ItemStack aOutput3, int aChance3) {
        return true;
    }

    public static boolean addMagneticraftRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance2, ItemStack aOutput3, int aChance3) {
        return true;
    }

    public static boolean addSawmillRecipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2) {
        return true;
    }

    public static boolean addAlloySmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, int aDuration, int aEUt, boolean aAllowSecondaryInputEmpty) {
        if (aInput1 == null || aInput2 == null && !aAllowSecondaryInputEmpty || aOutput1 == null) {
            return false;
        }
        aOutput1 = GT_OreDictUnificator.get(true, aOutput1);
        return GT_Values.RA.addAlloySmelterRecipe(aInput1, aInput2, aOutput1, aDuration, aEUt);
    }

    public static boolean addInductionSmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, ItemStack aOutput2, int aEnergy, int aChance) {
        return true;
    }

    public static boolean addOreToIngotSmeltingRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(aInput, GT_Utility.copyOrNull(aOutput), 0.0f);
        return true;
    }

    public static void addIC2RecipesToGT(Map<IRecipeInput, RecipeOutput> aIC2RecipeList, GT_Recipe.GT_Recipe_Map aGTRecipeMap, boolean aAddGTRecipe, boolean aRemoveIC2Recipe, boolean aExcludeGTIC2Items) {
        HashMap<ItemStack, ItemStack> aRecipesToRemove = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<IRecipeInput, RecipeOutput> iRecipeInputRecipeOutputEntry : aIC2RecipeList.entrySet()) {
            if (iRecipeInputRecipeOutputEntry.getValue().items.size() <= 0) continue;
            for (ItemStack tStack : iRecipeInputRecipeOutputEntry.getKey().getInputs()) {
                if (!GT_Utility.isStackValid(tStack)) continue;
                if (aAddGTRecipe && aGTRecipeMap.findRecipe(null, false, Long.MAX_VALUE, null, tStack) == null) {
                    try {
                        if (aExcludeGTIC2Items && (tStack.func_77977_a().contains("gt.metaitem.01") || tStack.func_77977_a().contains("gt.blockores") || tStack.func_77977_a().contains("ic2.itemCrushed") || tStack.func_77977_a().contains("ic2.itemPurifiedCrushed"))) continue;
                        switch (aGTRecipeMap.mUnlocalizedName) {
                            case "gt.recipe.macerator": 
                            case "gt.recipe.extractor": 
                            case "gt.recipe.compressor": {
                                aGTRecipeMap.addRecipe(true, new ItemStack[]{GT_Utility.copyAmount(iRecipeInputRecipeOutputEntry.getKey().getAmount(), tStack)}, (ItemStack[])iRecipeInputRecipeOutputEntry.getValue().items.toArray(), null, null, null, null, 300, 2, 0);
                                break;
                            }
                            case "gt.recipe.thermalcentrifuge": {
                                aGTRecipeMap.addRecipe(true, new ItemStack[]{GT_Utility.copyAmount(iRecipeInputRecipeOutputEntry.getKey().getAmount(), tStack)}, (ItemStack[])iRecipeInputRecipeOutputEntry.getValue().items.toArray(), null, null, null, null, 500, 48, 0);
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
                if (!aRemoveIC2Recipe) continue;
                aRecipesToRemove.put(tStack, (ItemStack)iRecipeInputRecipeOutputEntry.getValue().items.get(0));
            }
        }
        GT_Utility.bulkRemoveSimpleIC2MachineRecipe(aRecipesToRemove, aIC2RecipeList);
    }

    public static Map<IRecipeInput, RecipeOutput> getExtractorRecipeList() {
        try {
            return Recipes.extractor.getRecipes();
        }
        catch (Throwable throwable) {
            return sExtractorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getCompressorRecipeList() {
        try {
            return Recipes.compressor.getRecipes();
        }
        catch (Throwable throwable) {
            return sCompressorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getMaceratorRecipeList() {
        try {
            return Recipes.macerator.getRecipes();
        }
        catch (Throwable throwable) {
            return sMaceratorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getThermalCentrifugeRecipeList() {
        try {
            return Recipes.centrifuge.getRecipes();
        }
        catch (Throwable throwable) {
            return sThermalCentrifugeRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getOreWashingRecipeList() {
        try {
            return Recipes.oreWashing.getRecipes();
        }
        catch (Throwable throwable) {
            return sOreWashingRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getMassFabricatorList() {
        try {
            return Recipes.matterAmplifier.getRecipes();
        }
        catch (Throwable throwable) {
            return sMassfabRecipes;
        }
    }

    public static boolean addThermalCentrifugeRecipe(ItemStack aInput, int[] aChances, int aHeat, Object ... aOutput) {
        if (aInput == null || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.thermalcentrifuge, aInput, true)) {
            return false;
        }
        GT_Values.RA.addThermalCentrifugeRecipe(aInput, aOutput.length >= 1 ? (ItemStack)aOutput[0] : null, aOutput.length >= 2 ? (ItemStack)aOutput[1] : null, aOutput.length >= 3 ? (ItemStack)aOutput[2] : null, aChances, 500, 48);
        return true;
    }

    public static boolean addThermalCentrifugeRecipe(ItemStack aInput, int aHeat, Object ... aOutput) {
        if (aInput == null || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.thermalcentrifuge, aInput, true)) {
            return false;
        }
        GT_Values.RA.addThermalCentrifugeRecipe(aInput, aOutput.length >= 1 ? (ItemStack)aOutput[0] : null, aOutput.length >= 2 ? (ItemStack)aOutput[1] : null, aOutput.length >= 3 ? (ItemStack)aOutput[2] : null, 500, 48);
        return true;
    }

    public static boolean addOreWasherRecipe(ItemStack aInput, int[] aChances, int aWaterAmount, Object ... aOutput) {
        if (aInput == null || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.orewashing, aInput, true)) {
            return false;
        }
        GT_Values.RA.addOreWasherRecipe(aInput, (ItemStack)aOutput[0], (ItemStack)aOutput[1], (ItemStack)aOutput[2], GT_ModHandler.getWater(aWaterAmount), aChances, 500, 16);
        GT_Values.RA.addOreWasherRecipe(aInput, (ItemStack)aOutput[0], (ItemStack)aOutput[1], (ItemStack)aOutput[2], GT_ModHandler.getDistilledWater(aWaterAmount / 5), aChances, 300, 16);
        return true;
    }

    public static boolean addOreWasherRecipe(ItemStack aInput, int aWaterAmount, Object ... aOutput) {
        if (aInput == null || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.orewashing, aInput, true)) {
            return false;
        }
        GT_Values.RA.addOreWasherRecipe(aInput, (ItemStack)aOutput[0], (ItemStack)aOutput[1], (ItemStack)aOutput[2], GT_ModHandler.getWater(aWaterAmount), 500, 16);
        GT_Values.RA.addOreWasherRecipe(aInput, (ItemStack)aOutput[0], (ItemStack)aOutput[1], (ItemStack)aOutput[2], GT_ModHandler.getDistilledWater(aWaterAmount / 5), 300, 16);
        return true;
    }

    public static boolean addCompressionRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null || GT_Utility.areStacksEqual(aInput, aOutput, true)) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.compression, aInput, true)) {
            return false;
        }
        GT_Values.RA.addCompressorRecipe(aInput, aOutput, 300, 2);
        return true;
    }

    public static boolean addIC2MatterAmplifier(ItemStack aAmplifier, int aValue) {
        if (aAmplifier == null || aValue <= 0) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.massfabamplifier, aAmplifier, true)) {
            return false;
        }
        try {
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.func_74768_a("amplification", aValue);
            GT_Utility.callMethod(Recipes.matterAmplifier, "addRecipe", false, false, false, aAmplifier, tNBT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addRollingMachineRecipe(ItemStack aResult, Object[] aRecipe) {
        if ((aResult = GT_OreDictUnificator.get(true, aResult)) == null || aRecipe == null || aResult.field_77994_a <= 0) {
            return false;
        }
        try {
            RailcraftCraftingManager.rollingMachine.getRecipeList().add(new ShapedOreRecipe(GT_Utility.copyOrNull(aResult), aRecipe));
        }
        catch (Throwable e) {
            return GT_ModHandler.addCraftingRecipe(GT_Utility.copyOrNull(aResult), aRecipe);
        }
        return true;
    }

    public static void stopBufferingCraftingRecipes() {
        sBufferCraftingRecipes = false;
        GT_ModHandler.bulkRemoveRecipeByOutput(delayedRemovalByOutput);
        GT_ModHandler.bulkRemoveByRecipe(delayedRemovalByRecipe);
        sBufferRecipeList.forEach(GameRegistry::addRecipe);
        delayedRemovalByOutput.clear();
        delayedRemovalByRecipe.clear();
        sBufferRecipeList.clear();
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, false, true, false, false, false, false, false, false, false, false, false, false, true, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, 0L, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & RecipeBits.MIRRORED) != 0L, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & RecipeBits.REVERSIBLE) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS) == 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT) != 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL) != 0L, aRecipe);
    }

    private static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, Object[] aRecipe) {
        aResult = GT_OreDictUnificator.get(true, aResult);
        if (aOnlyAddIfResultIsNotNull && aResult == null) {
            return false;
        }
        if (aResult != null && Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        boolean tDoWeCareIfThereWasARecipe = aOnlyAddIfThereIsAnyRecipeOutputtingThis;
        boolean tThereWasARecipe = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof ItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            StringBuilder shape = new StringBuilder("");
            int idx = 0;
            if (aRecipe[idx] instanceof Boolean) {
                throw new IllegalArgumentException();
            }
            ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
            while (aRecipe[idx] instanceof String) {
                StringBuilder s = new StringBuilder((String)aRecipe[idx++]);
                shape.append((CharSequence)s);
                while (s.length() < 3) {
                    s.append(" ");
                }
                if (s.length() > 3) {
                    throw new IllegalArgumentException();
                }
                block33: for (char c : s.toString().toCharArray()) {
                    switch (c) {
                        case 'b': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolBlade.name());
                            continue block33;
                        }
                        case 'c': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolCrowbar.name());
                            continue block33;
                        }
                        case 'd': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolScrewdriver.name());
                            continue block33;
                        }
                        case 'f': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolFile.name());
                            continue block33;
                        }
                        case 'h': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolHardHammer.name());
                            continue block33;
                        }
                        case 'i': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingIron.name());
                            continue block33;
                        }
                        case 'j': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingMetal.name());
                            continue block33;
                        }
                        case 'k': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolKnife.name());
                            continue block33;
                        }
                        case 'm': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolMortar.name());
                            continue block33;
                        }
                        case 'p': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolDrawplate.name());
                            continue block33;
                        }
                        case 'r': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSoftHammer.name());
                            continue block33;
                        }
                        case 's': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSaw.name());
                            continue block33;
                        }
                        case 'w': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWrench.name());
                            continue block33;
                        }
                        case 'x': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWireCutter.name());
                        }
                    }
                }
            }
            aRecipe = tRecipeList.toArray();
            if (aRecipe[idx] instanceof Boolean) {
                ++idx;
            }
            HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
            HashMap<Character, ItemData> tItemDataMap = new HashMap<Character, ItemData>();
            tItemStackMap.put(Character.valueOf(' '), null);
            boolean tRemoveRecipe = true;
            while (idx < aRecipe.length) {
                if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                    if (GT_Values.D1) {
                        GT_Log.err.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                        for (Object tContent : aRecipe) {
                            GT_Log.err.println(tContent);
                        }
                    }
                    return false;
                }
                Character chr = (Character)aRecipe[idx];
                Object in = aRecipe[idx + 1];
                if (in instanceof ItemStack) {
                    ItemStack is = (ItemStack)in;
                    tItemStackMap.put(chr, GT_Utility.copyOrNull(is));
                    tItemDataMap.put(chr, GT_OreDictUnificator.getItemData(is));
                } else if (in instanceof ItemData) {
                    String tString = in.toString();
                    switch (tString) {
                        case "plankWood": {
                            tItemDataMap.put(chr, new ItemData(Materials.Wood, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneNetherrack": {
                            tItemDataMap.put(chr, new ItemData(Materials.Netherrack, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneObsidian": {
                            tItemDataMap.put(chr, new ItemData(Materials.Obsidian, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneEndstone": {
                            tItemDataMap.put(chr, new ItemData(Materials.Endstone, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        default: {
                            tItemDataMap.put(chr, (ItemData)in);
                        }
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre(in, 1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                    String string = in.toString();
                    aRecipe[idx + 1] = string;
                    in = string;
                } else if (in instanceof String) {
                    if (in.equals(OreDictNames.craftingChest.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Wood, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingBook.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Paper, 10886400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingPiston.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 14515200L, Materials.Wood, 10886400L));
                    } else if (in.equals(OreDictNames.craftingFurnace.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingIndustrialDiamond.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Diamond, 3628800L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingAnvil.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Iron, 36288000L, new MaterialStack[0]));
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre(in, 1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                idx += 2;
            }
            if (aReversible && aResult != null) {
                ItemData[] tData = new ItemData[9];
                int x = -1;
                for (char chr : shape.toString().toCharArray()) {
                    tData[++x] = (ItemData)tItemDataMap.get(Character.valueOf(chr));
                }
                if (GT_Utility.arrayContainsNonNull(tData)) {
                    GT_OreDictUnificator.addItemData(aResult, new ItemData(tData));
                }
            }
            if (aCheckForCollisions && tRemoveRecipe) {
                ItemStack[] tRecipe = new ItemStack[9];
                int x = -1;
                for (char chr : shape.toString().toCharArray()) {
                    tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                    if (tRecipe[x] == null || Items.field_151008_G.getDamage(tRecipe[x]) != Short.MAX_VALUE) continue;
                    Items.field_151008_G.setDamage(tRecipe[x], 0);
                }
                if (tDoWeCareIfThereWasARecipe || !aBuffered) {
                    tThereWasARecipe = GT_ModHandler.removeRecipe(tRecipe) != null || tThereWasARecipe;
                } else {
                    GT_ModHandler.removeRecipeDelayed(tRecipe);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return false;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            if (tDoWeCareIfThereWasARecipe || !aBuffered) {
                tThereWasARecipe = GT_ModHandler.removeRecipeByOutput(aResult, !aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, aRemoveAllOtherShapedsWithSameOutput, aRemoveAllOtherNativeRecipes) || tThereWasARecipe;
            } else {
                GT_ModHandler.removeRecipeByOutputDelayed(aResult);
            }
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tDoWeCareIfThereWasARecipe && !tThereWasARecipe) {
            ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
            int tList_sS = tList.size();
            for (int i = 0; i < tList_sS && !tThereWasARecipe; ++i) {
                IRecipe tRecipe = (IRecipe)tList.get(i);
                if (sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) || !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tRecipe.func_77571_b()), aResult, true)) continue;
                tList.remove(i--);
                tList_sS = tList.size();
                tThereWasARecipe = true;
            }
        }
        if (Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE || Items.field_151008_G.getDamage(aResult) < 0) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        GT_Utility.updateItemStack(aResult);
        if (tThereWasARecipe || !aOnlyAddIfThereIsAnyRecipeOutputtingThis) {
            if (sBufferCraftingRecipes && aBuffered) {
                sBufferRecipeList.add((IRecipe)new GT_Shaped_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            } else {
                GameRegistry.addRecipe((IRecipe)new GT_Shaped_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            }
        }
        return true;
    }

    public static boolean addShapelessEnchantingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, true, false, false, false, aRecipe);
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | RecipeBits.BUFFERED, aRecipe);
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, aRecipe);
    }

    private static boolean addShapelessCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, Object[] aRecipe) {
        aResult = GT_OreDictUnificator.get(true, aResult);
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            ItemStack[] tRecipe = new ItemStack[9];
            int i = 0;
            for (Object tObject : aRecipe) {
                if (tObject == null) {
                    if (GT_Values.D1) {
                        GT_Log.err.println("WARNING: Missing Item for shapeless Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                    }
                    for (Object tContent : aRecipe) {
                        GT_Log.err.println(tContent);
                    }
                    return false;
                }
                if (tObject instanceof ItemStack) {
                    tRecipe[i] = (ItemStack)tObject;
                } else if (tObject instanceof String) {
                    tRecipe[i] = GT_OreDictUnificator.getFirstOre(tObject, 1L);
                    if (tRecipe[i] == null) break;
                }
                ++i;
            }
            if (sBufferCraftingRecipes && aBuffered) {
                GT_ModHandler.removeRecipeDelayed(tRecipe);
            } else {
                GT_ModHandler.removeRecipe(tRecipe);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return false;
        }
        if (Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE || Items.field_151008_G.getDamage(aResult) < 0) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        GT_Utility.updateItemStack(aResult);
        if (sBufferCraftingRecipes && aBuffered) {
            sBufferRecipeList.add(new GT_Shapeless_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        } else {
            GameRegistry.addRecipe((IRecipe)new GT_Shapeless_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        }
        return true;
    }

    public static boolean removeFurnaceSmelting(ItemStack aInput) {
        if (aInput != null) {
            for (Object tInput : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
                if (!GT_Utility.isStackValid(tInput) || !GT_Utility.areStacksEqual(aInput, (ItemStack)tInput, true)) continue;
                FurnaceRecipes.func_77602_a().func_77599_b().remove(tInput);
                return true;
            }
        }
        return false;
    }

    public static ItemStack removeRecipe(ItemStack ... aRecipe) {
        if (aRecipe == null) {
            return null;
        }
        if (Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return null;
        }
        ItemStack rReturn = null;
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < aRecipe.length && i < 9; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        int tList_sS = tList.size();
        try {
            for (int i = 0; i < tList_sS; ++i) {
                while (i < tList_sS) {
                    if ((!(tList.get(i) instanceof IGT_CraftingRecipe) || ((IGT_CraftingRecipe)tList.get(i)).isRemovable()) && ((IRecipe)tList.get(i)).func_77569_a(aCrafting, GT_Values.DW)) {
                        rReturn = ((IRecipe)tList.get(i)).func_77572_b(aCrafting);
                        if (rReturn != null) {
                            tList.remove(i--);
                        }
                        tList_sS = tList.size();
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        return rReturn;
    }

    public static void removeRecipeDelayed(ItemStack ... aRecipe) {
        if (!sBufferCraftingRecipes) {
            GT_ModHandler.removeRecipe(aRecipe);
            return;
        }
        if (aRecipe == null) {
            return;
        }
        if (Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < aRecipe.length && i < 9; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        delayedRemovalByRecipe.add(aCrafting);
    }

    public static void bulkRemoveByRecipe(List<InventoryCrafting> toRemove) {
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        GT_Mod.GT_FML_LOGGER.info("BulkRemoveByRecipe: tList: " + tList.size() + " toRemove: " + toRemove.size());
        Set tListToRemove = tList.parallelStream().filter(tRecipe -> {
            if (tRecipe instanceof IGT_CraftingRecipe && !((IGT_CraftingRecipe)tRecipe).isRemovable()) {
                return false;
            }
            return toRemove.stream().anyMatch(aCrafting -> tRecipe.func_77569_a(aCrafting, GT_Values.DW));
        }).collect(Collectors.toSet());
        tList.removeIf(tListToRemove::contains);
    }

    public static boolean removeRecipeByOutputDelayed(ItemStack aOutput) {
        if (sBufferCraftingRecipes) {
            return delayedRemovalByOutput.add(aOutput);
        }
        return GT_ModHandler.removeRecipeByOutput(aOutput);
    }

    public static boolean removeRecipeByOutputDelayed(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers) {
        if (sBufferCraftingRecipes && aIgnoreNBT && !aNotRemoveShapelessRecipes && !aOnlyRemoveNativeHandlers) {
            return delayedRemovalByOutput.add(aOutput);
        }
        return GT_ModHandler.removeRecipeByOutput(aOutput, aIgnoreNBT, aNotRemoveShapelessRecipes, aOnlyRemoveNativeHandlers);
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput) {
        return GT_ModHandler.removeRecipeByOutput(aOutput, true, false, false);
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers) {
        if (aOutput == null) {
            return false;
        }
        boolean rReturn = false;
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        aOutput = GT_OreDictUnificator.get(aOutput);
        int tList_sS = tList.size();
        for (int i = 0; i < tList_sS; ++i) {
            IRecipe tRecipe = (IRecipe)tList.get(i);
            if (aNotRemoveShapelessRecipes && (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) || (aOnlyRemoveNativeHandlers ? !sNativeRecipeClasses.contains(tRecipe.getClass().getName()) : sSpecialRecipeClasses.contains(tRecipe.getClass().getName()))) continue;
            ItemStack tStack = tRecipe.func_77571_b();
            if (tRecipe instanceof IGT_CraftingRecipe && !((IGT_CraftingRecipe)tRecipe).isRemovable() || !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tStack), aOutput, aIgnoreNBT)) continue;
            tList.remove(i--);
            tList_sS = tList.size();
            rReturn = true;
        }
        return rReturn;
    }

    public static boolean bulkRemoveRecipeByOutput(List<ItemStack> toRemove) {
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        Set setToRemove = toRemove.parallelStream().map(GT_OreDictUnificator::get_nocopy).collect(Collectors.toSet());
        GT_Mod.GT_FML_LOGGER.info("BulkRemoveRecipeByOutput: tList: " + tList.size() + " setToRemove: " + setToRemove.size());
        Set tListToRemove = tList.parallelStream().filter(tRecipe -> {
            if (tRecipe instanceof IGT_CraftingRecipe && !((IGT_CraftingRecipe)tRecipe).isRemovable()) {
                return false;
            }
            if (sSpecialRecipeClasses.contains(tRecipe.getClass().getName())) {
                return false;
            }
            ItemStack tStack = GT_OreDictUnificator.get_nocopy(tRecipe.func_77571_b());
            return setToRemove.stream().anyMatch(aOutput -> GT_Utility.areStacksEqual(tStack, aOutput, true));
        }).collect(Collectors.toSet());
        tList.removeIf(tListToRemove::contains);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack getAllRecipeOutput(World aWorld, ItemStack ... aRecipe) {
        if (aRecipe == null || aRecipe.length == 0) {
            return null;
        }
        if (aWorld == null) {
            aWorld = GT_Values.DW;
        }
        boolean temp = false;
        for (ItemStack itemStack : aRecipe) {
            if (itemStack == null) continue;
            temp = true;
            break;
        }
        if (!temp) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        List tList = CraftingManager.func_77594_a().func_77592_b();
        List<IRecipe> list = sAllRecipeList;
        synchronized (list) {
            if (sAllRecipeList.size() != tList.size()) {
                sAllRecipeList.clear();
                sAllRecipeList.addAll(tList);
            }
            int j = sAllRecipeList.size();
            for (int i = 0; i < j; ++i) {
                IRecipe tRecipe = sAllRecipeList.get(i);
                if (!tRecipe.func_77569_a(aCrafting, aWorld)) continue;
                if (i > 10) {
                    sAllRecipeList.remove(i);
                    sAllRecipeList.add(i - 10, tRecipe);
                }
                return tRecipe.func_77572_b(aCrafting);
            }
        }
        int tIndex = 0;
        ItemStack tStack1 = null;
        ItemStack tStack2 = null;
        int j = aCrafting.func_70302_i_();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack = aCrafting.func_70301_a(i);
            if (tStack == null) continue;
            if (tIndex == 0) {
                tStack1 = tStack;
            }
            if (tIndex == 1) {
                tStack2 = tStack;
            }
            ++tIndex;
        }
        if (tIndex == 2) {
            assert (tStack1 != null && tStack2 != null);
            if (tStack1.func_77973_b() == tStack2.func_77973_b() && tStack1.field_77994_a == 1 && tStack2.field_77994_a == 1 && tStack1.func_77973_b().isRepairable()) {
                int tNewDamage = tStack1.func_77958_k() + tStack1.func_77960_j() - tStack2.func_77960_j() + tStack1.func_77958_k() / 20;
                return new ItemStack(tStack1.func_77973_b(), 1, tNewDamage < 0 ? 0 : tNewDamage);
            }
        }
        return null;
    }

    public static ItemStack getRecipeOutput(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutput(false, true, aRecipe);
    }

    public static ItemStack getRecipeOutputNoOreDict(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutput(false, false, aRecipe);
    }

    public static ItemStack getRecipeOutput(boolean aUncopiedStack, ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutput(aUncopiedStack, true, aRecipe);
    }

    public static ItemStack getRecipeOutput(boolean aUncopiedStack, boolean allowOreDict, ItemStack ... aRecipe) {
        if (aRecipe == null || Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        boolean found = false;
        for (IRecipe iRecipe : tList) {
            ItemStack tOutput;
            found = false;
            if (!allowOreDict && iRecipe instanceof ShapedOreRecipe) continue;
            try {
                found = iRecipe.func_77569_a(aCrafting, GT_Values.DW);
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            if (!found) continue;
            ItemStack itemStack = tOutput = aUncopiedStack ? iRecipe.func_77571_b() : iRecipe.func_77572_b(aCrafting);
            if (tOutput == null || tOutput.field_77994_a <= 0) {
                if (GregTech_API.sPostloadFinished) continue;
                throw new GT_ItsNotMyFaultException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that.");
            }
            if (aUncopiedStack) {
                return tOutput;
            }
            return GT_Utility.copyOrNull(tOutput);
        }
        return null;
    }

    public static List<ItemStack> getVanillyToolRecipeOutputs(ItemStack ... aRecipe) {
        if (!GregTech_API.sPostloadStarted || GregTech_API.sPostloadFinished) {
            sSingleNonBlockDamagableRecipeList.clear();
        }
        if (sSingleNonBlockDamagableRecipeList.isEmpty()) {
            for (IRecipe tRecipe : (ArrayList)CraftingManager.func_77594_a().func_77592_b()) {
                boolean temp;
                ItemStack tStack = tRecipe.func_77571_b();
                if (!GT_Utility.isStackValid(tStack) || tStack.func_77976_d() != 1 || tStack.func_77958_k() <= 0 || tStack.func_77973_b() instanceof ItemBlock || tStack.func_77973_b() instanceof IReactorComponent || GT_ModHandler.isElectricItem(tStack) || GT_Utility.isStackInList(tStack, sNonReplaceableItems) || tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) continue;
                if (tRecipe instanceof ShapedOreRecipe) {
                    temp = true;
                    for (Object object : ((ShapedOreRecipe)tRecipe).getInput()) {
                        if (object == null) continue;
                        if (object instanceof ItemStack && (((ItemStack)object).func_77973_b() == null || ((ItemStack)object).func_77976_d() < 2 || ((ItemStack)object).func_77958_k() > 0 || ((ItemStack)object).func_77973_b() instanceof ItemBlock)) {
                            temp = false;
                            break;
                        }
                        if (!(object instanceof List) || !((List)object).isEmpty()) continue;
                        temp = false;
                        break;
                    }
                    if (!temp) continue;
                    sSingleNonBlockDamagableRecipeList.add(tRecipe);
                    continue;
                }
                if (tRecipe instanceof ShapedRecipes) {
                    temp = true;
                    for (ItemStack itemStack : ((ShapedRecipes)tRecipe).field_77574_d) {
                        if (itemStack == null || itemStack.func_77973_b() != null && itemStack.func_77976_d() >= 2 && itemStack.func_77958_k() <= 0 && !(itemStack.func_77973_b() instanceof ItemBlock)) continue;
                        temp = false;
                        break;
                    }
                    if (!temp) continue;
                    sSingleNonBlockDamagableRecipeList.add(tRecipe);
                    continue;
                }
                sSingleNonBlockDamagableRecipeList.add(tRecipe);
            }
            GT_Log.out.println("GT_Mod: Created a List of Tool Recipes containing " + sSingleNonBlockDamagableRecipeList.size() + " Recipes for recycling." + (sSingleNonBlockDamagableRecipeList.size() > 1024 ? " Scanning all these Recipes is the reason for the startup Lag you receive right now." : ""));
        }
        List<ItemStack> rList = GT_ModHandler.getRecipeOutputs(sSingleNonBlockDamagableRecipeList, true, aRecipe);
        if (!GregTech_API.sPostloadStarted || GregTech_API.sPostloadFinished) {
            sSingleNonBlockDamagableRecipeList.clear();
        }
        return rList;
    }

    public static List<ItemStack> getRecipeOutputs(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutputs(CraftingManager.func_77594_a().func_77592_b(), false, aRecipe);
    }

    public static List<ItemStack> getRecipeOutputsBuffered(ItemStack ... aRecipe) {
        if (bufferedRecipes == null) {
            bufferedRecipes = CraftingManager.func_77594_a().func_77592_b().stream().filter(tRecipe -> !(tRecipe instanceof ShapelessRecipes) && !(tRecipe instanceof ShapelessOreRecipe) && !(tRecipe instanceof IGT_CraftingRecipe)).filter(tRecipe -> {
                try {
                    ItemStack tOutput = ((IRecipe)tRecipe).func_77571_b();
                    if (tOutput.field_77994_a == 1 && tOutput.func_77958_k() > 0 && tOutput.func_77976_d() == 1) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }).collect(Collectors.toList());
        }
        return GT_ModHandler.getRecipeOutputs(bufferedRecipes, false, aRecipe);
    }

    public static List<ItemStack> getRecipeOutputs(List<IRecipe> aList, boolean aDeleteFromList, ItemStack ... aRecipe) {
        List<Object> rList = new ArrayList<ItemStack>();
        if (aRecipe == null || Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return rList;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        if (!aDeleteFromList) {
            HashSet stacks = new HashSet();
            aList.stream().filter(tRecipe -> {
                if (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe || tRecipe instanceof IGT_CraftingRecipe) {
                    return false;
                }
                try {
                    return tRecipe.func_77569_a(aCrafting, GT_Values.DW);
                }
                catch (Throwable e) {
                    e.printStackTrace(GT_Log.err);
                    return false;
                }
            }).forEach(tRecipe -> stacks.add(tRecipe.func_77572_b(aCrafting)));
            rList = stacks.stream().filter(tOutput -> tOutput.field_77994_a == 1 && tOutput.func_77958_k() > 0 && tOutput.func_77976_d() == 1).collect(Collectors.toList());
        } else {
            Iterator<IRecipe> iterator = aList.iterator();
            while (iterator.hasNext()) {
                IRecipe tRecipe2 = iterator.next();
                boolean matched = false;
                try {
                    matched = tRecipe2.func_77569_a(aCrafting, GT_Values.DW);
                }
                catch (Throwable e) {
                    e.printStackTrace(GT_Log.err);
                }
                if (!matched) continue;
                ItemStack tOutput2 = tRecipe2.func_77572_b(aCrafting);
                if (tOutput2 == null || tOutput2.field_77994_a <= 0) {
                    if (GregTech_API.sPostloadFinished) continue;
                    throw new GT_ItsNotMyFaultException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that.");
                }
                if (tOutput2.field_77994_a != 1 || tOutput2.func_77958_k() <= 0 || tOutput2.func_77976_d() != 1 || tRecipe2 instanceof ShapelessRecipes || tRecipe2 instanceof ShapelessOreRecipe || tRecipe2 instanceof IGT_CraftingRecipe) continue;
                rList.add(GT_Utility.copyOrNull(tOutput2));
                iterator.remove();
            }
        }
        return rList;
    }

    @Deprecated
    public static ItemStack getMaceratorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return GT_Utility.copyOrNull(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getMaceratorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    @Deprecated
    public static ItemStack getExtractorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return GT_Utility.copyOrNull(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getExtractorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    @Deprecated
    public static ItemStack getCompressorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return GT_Utility.copyOrNull(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getCompressorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    public static ItemStack getSmeltingOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        if (aInput == null || aInput.field_77994_a < 1) {
            return null;
        }
        ItemStack rStack = GT_OreDictUnificator.get(FurnaceRecipes.func_77602_a().func_151395_a(aInput));
        if (rStack != null && (aOutputSlot == null || GT_Utility.areStacksEqual(rStack, aOutputSlot) && rStack.field_77994_a + aOutputSlot.field_77994_a <= aOutputSlot.func_77976_d())) {
            if (aRemoveInput) {
                --aInput.field_77994_a;
            }
            return rStack;
        }
        return null;
    }

    public static ItemStack[] getMachineOutput(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, boolean aRemoveInput, NBTTagCompound rRecipeMetaData, ItemStack ... aOutputSlots) {
        block8: {
            if (aOutputSlots == null || aOutputSlots.length <= 0) {
                return new ItemStack[0];
            }
            if (aInput == null) {
                return new ItemStack[aOutputSlots.length];
            }
            try {
                for (Map.Entry<IRecipeInput, RecipeOutput> tEntry : aRecipeList.entrySet()) {
                    ItemStack[] tList;
                    if (!tEntry.getKey().matches(aInput)) continue;
                    if (tEntry.getKey().getAmount() > aInput.field_77994_a || (tList = tEntry.getValue().items.toArray(new ItemStack[0])).length == 0) break;
                    ItemStack[] rList = new ItemStack[aOutputSlots.length];
                    rRecipeMetaData.func_74782_a("return", (NBTBase)tEntry.getValue().metadata);
                    for (int i = 0; i < aOutputSlots.length && i < tList.length; i = (int)((byte)(i + 1))) {
                        if (tList[i] == null) continue;
                        if (aOutputSlots[i] == null || GT_Utility.areStacksEqual(tList[i], aOutputSlots[i]) && tList[i].field_77994_a + aOutputSlots[i].field_77994_a <= aOutputSlots[i].func_77976_d()) {
                            rList[i] = GT_Utility.copyOrNull(tList[i]);
                            continue;
                        }
                        return new ItemStack[aOutputSlots.length];
                    }
                    if (aRemoveInput) {
                        aInput.field_77994_a -= tEntry.getKey().getAmount();
                    }
                    return rList;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block8;
                e.printStackTrace(GT_Log.err);
            }
        }
        return new ItemStack[aOutputSlots.length];
    }

    public static ItemStack getRecyclerOutput(ItemStack aInput, int aScrapChance) {
        if (aInput == null || aScrapChance != 0) {
            return null;
        }
        try {
            if (Recipes.recyclerWhitelist.isEmpty()) {
                return Recipes.recyclerBlacklist.contains(aInput) ? null : ItemList.IC2_Scrap.get(1L, new Object[0]);
            }
            return Recipes.recyclerWhitelist.contains(aInput) ? ItemList.IC2_Scrap.get(1L, new Object[0]) : null;
        }
        catch (Throwable throwable) {
            try {
                return Recipes.recyclerBlacklist.contains(aInput) ? null : ItemList.IC2_Scrap.get(1L, new Object[0]);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    public static ItemStack getRandomScrapboxDrop() {
        return Recipes.scrapboxDrops.getDrop(ItemList.IC2_Scrapbox.get(1L, new Object[0]), false);
    }

    public static int chargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate) {
        try {
            int tTier;
            if (GT_ModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
                if (!aIgnoreLimit && tTier >= 0) {
                    aCharge = (int)Math.min((long)aCharge, GT_Values.V[Math.max(0, Math.min(GT_Values.V.length - 1, tTier))]);
                }
                if (aCharge > 0) {
                    int rCharge;
                    return rCharge + ((rCharge = (int)Math.max(0.0, ElectricItem.manager.charge(aStack, (double)aCharge, tTier, true, aSimulate))) * 4 > aTier ? aTier : 0);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public static int dischargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate, boolean aIgnoreDischargability) {
        try {
            int tTier;
            if (GT_ModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
                if (!aIgnoreLimit && tTier >= 0) {
                    aCharge = (int)Math.min((long)aCharge, GT_Values.V[Math.max(0, Math.min(GT_Values.V.length - 1, tTier))] + (long)GT_Values.B[Math.max(0, Math.min(GT_Values.V.length - 1, tTier))]);
                }
                if (aCharge > 0) {
                    int rCharge = (int)Math.max(0.0, ElectricItem.manager.discharge(aStack, (double)(aCharge + (aCharge * 4 > aTier ? aTier : 0)), tTier, true, !aIgnoreDischargability, aSimulate));
                    return rCharge - (rCharge * 4 > aTier ? aTier : 0);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public static boolean canUseElectricItem(ItemStack aStack, int aCharge) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                return ElectricItem.manager.canUse(aStack, (double)aCharge);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean useElectricItem(ItemStack aStack, int aCharge, EntityPlayer aPlayer) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                ElectricItem.manager.use(aStack, 0.0, (EntityLivingBase)aPlayer);
                if (ElectricItem.manager.canUse(aStack, (double)aCharge)) {
                    return ElectricItem.manager.use(aStack, (double)aCharge, (EntityLivingBase)aPlayer);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean damageOrDechargeItem(ItemStack aStack, int aDamage, int aDecharge, EntityLivingBase aPlayer) {
        if (GT_Utility.isStackInvalid(aStack) || aStack.func_77976_d() <= 1 && aStack.field_77994_a > 1) {
            return false;
        }
        if (aPlayer != null && aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d) {
            return true;
        }
        if (aStack.func_77973_b() instanceof IDamagableItem) {
            return ((IDamagableItem)aStack.func_77973_b()).doDamageToItem(aStack, aDamage);
        }
        if (GT_ModHandler.isElectricItem(aStack)) {
            if (GT_ModHandler.canUseElectricItem(aStack, aDecharge)) {
                if (aPlayer != null && aPlayer instanceof EntityPlayer) {
                    return GT_ModHandler.useElectricItem(aStack, aDecharge, (EntityPlayer)aPlayer);
                }
                return GT_ModHandler.dischargeElectricItem(aStack, aDecharge, Integer.MAX_VALUE, true, false, true) >= aDecharge;
            }
        } else if (aStack.func_77973_b().func_77645_m()) {
            if (aPlayer == null) {
                aStack.func_77964_b(aStack.func_77960_j() + aDamage);
            } else {
                aStack.func_77972_a(aDamage, aPlayer);
            }
            if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                aStack.func_77964_b(aStack.func_77958_k() + 1);
                ItemStack tStack = GT_Utility.getContainerItem(aStack, true);
                if (tStack != null) {
                    aStack.func_150996_a(tStack.func_77973_b());
                    aStack.func_77964_b(tStack.func_77960_j());
                    aStack.field_77994_a = tStack.field_77994_a;
                    aStack.func_77982_d(tStack.func_77978_p());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean useSolderingIron(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aPlayer == null || aStack == null) {
            return false;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sSolderingToolList)) {
            if (aPlayer instanceof EntityPlayer) {
                EntityPlayer tPlayer = (EntityPlayer)aPlayer;
                if (tPlayer.field_71075_bZ.field_75098_d) {
                    return true;
                }
                if (GT_ModHandler.isElectricItem(aStack) && ElectricItem.manager.getCharge(aStack) > 1000.0 && GT_ModHandler.consumeSolderingMaterial(tPlayer)) {
                    if (GT_ModHandler.canUseElectricItem(aStack, 10000)) {
                        return GT_ModHandler.useElectricItem(aStack, 10000, (EntityPlayer)aPlayer);
                    }
                    GT_ModHandler.useElectricItem(aStack, (int)ElectricItem.manager.getCharge(aStack), (EntityPlayer)aPlayer);
                    return false;
                }
            } else {
                GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer);
                return true;
            }
        }
        return false;
    }

    public static boolean consumeSolderingMaterial(EntityPlayer aPlayer) {
        if (aPlayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
            if (!GT_Utility.isStackInList(aPlayer.field_71071_by.field_70462_a[i], GregTech_API.sSolderingMetalList)) continue;
            if (aPlayer.field_71071_by.field_70462_a[i].field_77994_a < 1) {
                return false;
            }
            if (aPlayer.field_71071_by.field_70462_a[i].field_77994_a == 1) {
                aPlayer.field_71071_by.field_70462_a[i] = null;
            } else {
                --aPlayer.field_71071_by.field_70462_a[i].field_77994_a;
            }
            if (aPlayer.field_71069_bz != null) {
                aPlayer.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public static boolean isChargerItem(ItemStack aStack) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                return ((IElectricItem)aStack.func_77973_b()).canProvideEnergy(aStack);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isElectricItem(ItemStack aStack) {
        try {
            return aStack != null && aStack.func_77973_b() instanceof IElectricItem && ((IElectricItem)aStack.func_77973_b()).getTier(aStack) < Integer.MAX_VALUE;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isElectricItem(ItemStack aStack, byte aTier) {
        try {
            return aStack != null && aStack.func_77973_b() instanceof IElectricItem && ((IElectricItem)aStack.func_77973_b()).getTier(aStack) == aTier;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void registerBoxableItemToToolBox(ItemStack aStack) {
        if (aStack != null) {
            GT_ModHandler.registerBoxableItemToToolBox(aStack.func_77973_b());
        }
    }

    public static void registerBoxableItemToToolBox(Item aItem) {
        if (aItem != null && sBoxableWrapper != null) {
            try {
                ItemWrapper.registerBoxable((Item)aItem, (IBoxable)((IBoxable)sBoxableWrapper));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getCapsuleCellContainerCountMultipliedWithStackSize(ItemStack ... aStacks) {
        int rAmount = 0;
        for (ItemStack tStack : aStacks) {
            if (tStack == null) continue;
            rAmount += GT_ModHandler.getCapsuleCellContainerCount(tStack) * tStack.field_77994_a;
        }
        return rAmount;
    }

    public static int getCapsuleCellContainerCount(ItemStack aStack) {
        if (aStack == null) {
            return 0;
        }
        if (GT_Utility.areStacksEqual(GT_Utility.getContainerForFilledItem(aStack, true), ItemList.Cell_Empty.get(1L, new Object[0]))) {
            return 1;
        }
        if (GT_Utility.areStacksEqual(aStack, GT_ModHandler.getIC2Item("waterCell", 1L, Short.MAX_VALUE))) {
            return 1;
        }
        for (OrePrefixes cellType : OrePrefixes.CELL_TYPES) {
            if (!cellType.contains(aStack)) continue;
            return 1;
        }
        return 0;
    }

    static {
        sNativeRecipeClasses.add(ShapedRecipes.class.getName());
        sNativeRecipeClasses.add(ShapedOreRecipe.class.getName());
        sNativeRecipeClasses.add(GT_Shaped_Recipe.class.getName());
        sNativeRecipeClasses.add(ShapelessRecipes.class.getName());
        sNativeRecipeClasses.add(ShapelessOreRecipe.class.getName());
        sNativeRecipeClasses.add(GT_Shapeless_Recipe.class.getName());
        sNativeRecipeClasses.add(AdvRecipe.class.getName());
        sNativeRecipeClasses.add(AdvShapelessRecipe.class.getName());
        sNativeRecipeClasses.add("appeng.recipes.game.ShapedRecipe");
        sNativeRecipeClasses.add("appeng.recipes.game.ShapelessRecipe");
        sNativeRecipeClasses.add("forestry.core.utils.ShapedRecipeCustom");
        sSpecialRecipeClasses.add(RecipeFireworks.class.getName());
        sSpecialRecipeClasses.add(RecipesArmorDyes.class.getName());
        sSpecialRecipeClasses.add(RecipeBookCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapExtending.class.getName());
        sSpecialRecipeClasses.add("jds.bibliocraft.BiblioSpecialRecipes");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQBlockRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQuantumComputerRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.QBlockRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.FacadeRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.DisassembleRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.carts.LocomotivePaintingRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RotorRepairRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTableCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTicketCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.TankCartFilterRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.LocomotiveEmblemRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostColorRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostEmblemRecipe");
        sSpecialRecipeClasses.add("mods.immibis.redlogic.interaction.RecipeDyeLumarButton");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesVoidRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe");
        sSpecialRecipeClasses.add("twilightforest.item.TFMapCloningRecipe");
        sSpecialRecipeClasses.add("forestry.lepidopterology.MatingRecipe");
        sSpecialRecipeClasses.add("micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes");
        sSpecialRecipeClasses.add("shedar.mods.ic2.nuclearcontrol.StorageArrayRecipe");
        bufferedRecipes = null;
    }

    public static class ThermalExpansion {
        public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        }

        public static void addSmelterBlastOre(Materials aMaterial) {
        }

        public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        }

        public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        }

        public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        }

        public static void addMagmaticFuel(String fluidName, int energy) {
        }

        public static void addCompressionFuel(String fluidName, int energy) {
        }

        public static void addCoolant(String fluidName, int energy) {
        }
    }

    public static class RecipeBits {
        public static long MIRRORED = GT_Values.B[0];
        public static long BUFFERED = GT_Values.B[1];
        public static long KEEPNBT = GT_Values.B[2];
        public static long DISMANTLEABLE = GT_Values.B[3];
        public static long NOT_REMOVABLE = GT_Values.B[4];
        public static long REVERSIBLE = GT_Values.B[5];
        public static long DELETE_ALL_OTHER_RECIPES = GT_Values.B[6];
        public static long DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT = GT_Values.B[7];
        public static long DELETE_ALL_OTHER_SHAPED_RECIPES = GT_Values.B[8];
        public static long DELETE_ALL_OTHER_NATIVE_RECIPES = GT_Values.B[9];
        public static long DO_NOT_CHECK_FOR_COLLISIONS = GT_Values.B[10];
        public static long ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT = GT_Values.B[11];
        public static long ONLY_ADD_IF_RESULT_IS_NOT_NULL = GT_Values.B[12];
        public static long DONT_REMOVE_SHAPELESS = GT_Values.B[13];
    }
}

