/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GT_ExoticEnergyInputHelper {
    private static final List<Class<?>> sExoticEnergyHatchType = new ArrayList();

    public static void register(Class<? extends GT_MetaTileEntity_Hatch> clazz) {
        if (!GT_MetaTileEntity_Hatch.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a subclass of " + GT_MetaTileEntity_Hatch.class.getName());
        }
        sExoticEnergyHatchType.add(clazz);
    }

    public static void tryRegister(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!GT_MetaTileEntity_Hatch.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a subclass of " + GT_MetaTileEntity_Hatch.class.getName());
        }
        sExoticEnergyHatchType.add(clazz);
    }

    public static boolean drainEnergy(long aEU, Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            long tDrain = Math.min(gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getStoredEU(), aEU);
            gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            aEU -= tDrain;
        }
        return aEU <= 0L;
    }

    public static boolean isExoticEnergyInput(IMetaTileEntity aHatch) {
        for (Class<?> clazz : sExoticEnergyHatchType) {
            if (!clazz.isInstance(aHatch)) continue;
            return true;
        }
        return false;
    }

    public static long getMaxInputVoltageMulti(Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        long rVoltage = 0L;
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
            rVoltage += gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage;
    }

    public static long getMaxInputAmpsMulti(Collection<? extends GT_MetaTileEntity_Hatch> hatches) {
        long rAmp = 0L;
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : hatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
            rAmp += gT_MetaTileEntity_Hatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rAmp;
    }

    static {
        GT_ExoticEnergyInputHelper.tryRegister("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti");
        GT_ExoticEnergyInputHelper.tryRegister("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel");
    }
}

