/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.net.GT_Packet_RequestCoverData;
import gregtech.api.net.GT_Packet_SendCoverData;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.GT_Client;
import gregtech.common.covers.GT_Cover_Fluidfilter;
import java.util.Arrays;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class CoverableGregTechTileEntity
extends BaseTileEntity
implements IGregTechTileEntity {
    public static final String[] COVER_DATA_NBT_KEYS = (String[])Arrays.stream(ForgeDirection.VALID_DIRECTIONS).mapToInt(Enum::ordinal).mapToObj(i -> "mCoverData" + i).toArray(String[]::new);
    protected final GT_CoverBehaviorBase<?>[] mCoverBehaviors = new GT_CoverBehaviorBase[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    protected int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    protected ISerializableObject[] mCoverData = new ISerializableObject[6];
    protected final boolean[] mCoverNeedUpdate = new boolean[]{false, false, false, false, false, false};
    protected short mID = 0;
    public long mTickTimer = 0L;

    protected void saveCoverNBT(NBTTagCompound aNBT) {
        for (int i = 0; i < this.mCoverData.length; ++i) {
            if (this.mCoverSides[i] == 0 || this.mCoverData[i] == null) continue;
            aNBT.func_74782_a(COVER_DATA_NBT_KEYS[i], this.mCoverData[i].saveDataToNBT());
        }
        aNBT.func_74783_a("mCoverSides", this.mCoverSides);
    }

    protected void saveMetaTileNBT(NBTTagCompound aNBT) {
        try {
            if (this.hasValidMetaTileEntity()) {
                NBTTagList tItemList = new NBTTagList();
                for (int i = 0; i < this.getMetaTileEntity().getRealInventory().length; ++i) {
                    ItemStack tStack = this.getMetaTileEntity().getRealInventory()[i];
                    if (tStack == null) continue;
                    NBTTagCompound tTag = new NBTTagCompound();
                    tTag.func_74768_a("IntSlot", i);
                    tStack.func_77955_b(tTag);
                    tItemList.func_74742_a((NBTBase)tTag);
                }
                aNBT.func_74782_a("Inventory", (NBTBase)tItemList);
                try {
                    this.getMetaTileEntity().saveNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
                    GT_Mod.logStackTrace(e);
                }
            }
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
            GT_Mod.logStackTrace(e);
        }
    }

    protected void loadMetaTileNBT(NBTTagCompound aNBT) {
        if (this.mID != 0 && this.createNewMetatileEntity(this.mID)) {
            NBTTagList tItemList = aNBT.func_150295_c("Inventory", 10);
            for (int i = 0; i < tItemList.func_74745_c(); ++i) {
                NBTTagCompound tTag = tItemList.func_150305_b(i);
                int tSlot = tTag.func_74762_e("IntSlot");
                if (tSlot < 0 || tSlot >= this.getMetaTileEntity().getRealInventory().length) continue;
                this.getMetaTileEntity().getRealInventory()[tSlot] = GT_Utility.loadItem(tTag);
            }
            try {
                this.getMetaTileEntity().loadNBTData(aNBT);
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("Encountered Exception while loading MetaTileEntity.");
                GT_Mod.logStackTrace(e);
            }
        }
    }

    protected void loadCoverNBT(NBTTagCompound aNBT) {
        byte i;
        this.mCoverSides = aNBT.func_74759_k("mCoverSides");
        if (this.mCoverSides.length != 6) {
            this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
        }
        for (i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehaviorNew(this.mCoverSides[i]);
        }
        this.mCoverData = new ISerializableObject[6];
        if (aNBT.func_150297_b("mCoverData", 11) && aNBT.func_74759_k("mCoverData").length == 6) {
            int[] tOldData = aNBT.func_74759_k("mCoverData");
            for (int i2 = 0; i2 < tOldData.length; ++i2) {
                if (this.mCoverBehaviors[i2] instanceof GT_Cover_Fluidfilter) {
                    String filterKey = String.format("fluidFilter%d", i2);
                    if (!aNBT.func_74764_b(filterKey)) continue;
                    this.mCoverData[i2] = this.mCoverBehaviors[i2].createDataObject(tOldData[i2] & 7 | FluidRegistry.getFluidID((String)aNBT.func_74779_i(filterKey)) << 3);
                    continue;
                }
                if (this.mCoverBehaviors[i2] == null || this.mCoverBehaviors[i2] == GregTech_API.sNoBehavior) continue;
                this.mCoverData[i2] = this.mCoverBehaviors[i2].createDataObject(tOldData[i2]);
            }
        } else {
            for (i = 0; i < 6; i = (byte)((byte)(i + 1))) {
                if (this.mCoverBehaviors[i] == null) continue;
                this.mCoverData[i] = aNBT.func_74764_b(COVER_DATA_NBT_KEYS[i]) ? this.mCoverBehaviors[i].createDataObject(aNBT.func_74781_a(COVER_DATA_NBT_KEYS[i])) : this.mCoverBehaviors[i].createDataObject();
                if (!this.mCoverBehaviors[i].isDataNeededOnClient(i, this.mCoverSides[i], this.mCoverData[i], this)) continue;
                this.issueCoverUpdate(i);
            }
        }
    }

    protected boolean doCoverThings() {
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            GT_CoverBehaviorBase<?> tCover;
            int tCoverTickRate;
            if (this.getCoverIDAtSide(i) == 0 || (tCoverTickRate = (tCover = this.getCoverBehaviorAtSideNew(i)).getTickRate(i, this.getCoverIDAtSide(i), this.mCoverData[i], this)) <= 0 || this.mTickTimer % (long)tCoverTickRate != 0L) continue;
            byte tRedstone = tCover.isRedstoneSensitive(i, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer) ? this.getInputRedstoneSignal(i) : (byte)0;
            this.mCoverData[i] = tCover.doCoverThings(i, tRedstone, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer);
            if (this.hasValidMetaTileEntity()) continue;
            return false;
        }
        return true;
    }

    protected void checkDropCover() {
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (this.getCoverIDAtSide(i) == 0 || this.getMetaTileEntity().allowCoverOnSide(i, new GT_ItemStack(this.getCoverIDAtSide(i)))) continue;
            this.dropCover(i, i, true);
        }
    }

    protected void updateCoverBehavior() {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehaviorNew(this.mCoverSides[i]);
        }
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        if (this.isServerSide() && this.getCoverBehaviorAtSideNew(aSide).isDataNeededOnClient(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this)) {
            this.mCoverNeedUpdate[aSide] = true;
        }
    }

    public ITexture getCoverTexture(byte aSide) {
        if (this.getCoverIDAtSide(aSide) == 0) {
            return null;
        }
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return Textures.BlockIcons.HIDDEN_TEXTURE[0];
        }
        ITexture coverTexture = this.getCoverBehaviorAtSideNew(aSide).getSpecialCoverTexture(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this);
        return coverTexture != null ? coverTexture : GregTech_API.sCovers.get(new GT_ItemStack(this.getCoverIDAtSide(aSide)));
    }

    protected void requestCoverDataIfNeeded() {
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (!this.getCoverBehaviorAtSideNew(i).isDataNeededOnClient(i, this.getCoverIDAtSide(i), this.getComplexCoverDataAtSide(i), this)) continue;
            GT_Values.NW.sendToServer(new GT_Packet_RequestCoverData(i, this.getCoverIDAtSide(i), this));
        }
    }

    protected abstract boolean hasValidMetaTileEntity();

    protected boolean createNewMetatileEntity(short aID) {
        if (aID > 0 && aID < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aID] != null) {
            if (this.hasValidMetaTileEntity()) {
                this.getMetaTileEntity().setBaseMetaTileEntity(null);
            }
            GregTech_API.METATILEENTITIES[aID].newMetaEntity(this).setBaseMetaTileEntity(this);
            this.mTickTimer = 0L;
            this.mID = aID;
            return true;
        }
        GT_Log.err.println("MetaID " + aID + " not loadable => locking TileEntity!");
        return false;
    }

    @Override
    public void setCoverIDAtSide(byte aSide, int aID) {
        if (aSide >= 0 && aSide < 6 && this.mCoverSides[aSide] != aID) {
            if (aID == 0 && this.isClientSide()) {
                this.mCoverBehaviors[aSide].onDropped(aSide, this.mCoverSides[aSide], this.mCoverData[aSide], this);
            }
            this.mCoverSides[aSide] = aID;
            this.mCoverBehaviors[aSide] = GregTech_API.getCoverBehaviorNew(aID);
            this.mCoverData[aSide] = this.mCoverBehaviors[aSide].createDataObject();
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    @Override
    @Deprecated
    public GT_CoverBehavior getCoverBehaviorAtSide(byte aSide) {
        if (aSide >= 0 && aSide < this.mCoverBehaviors.length && this.mCoverBehaviors[aSide] instanceof GT_CoverBehavior) {
            return (GT_CoverBehavior)this.mCoverBehaviors[aSide];
        }
        return GregTech_API.sNoBehavior;
    }

    @Override
    public void setCoverItemAtSide(byte aSide, ItemStack aCover) {
        GregTech_API.getCoverBehaviorNew(aCover).placeCover(aSide, aCover, this);
    }

    @Override
    public int getCoverIDAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverSides[aSide];
        }
        return 0;
    }

    @Override
    public ItemStack getCoverItemAtSide(byte aSide) {
        return this.getCoverBehaviorAtSideNew(aSide).getDisplayStack(this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide));
    }

    @Override
    public boolean canPlaceCoverIDAtSide(byte aSide, int aID) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public boolean canPlaceCoverItemAtSide(byte aSide, ItemStack aCover) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    @Deprecated
    public int getCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6 && this.mCoverData[aSide] instanceof ISerializableObject.LegacyCoverData) {
            return ((ISerializableObject.LegacyCoverData)this.mCoverData[aSide]).get();
        }
        return 0;
    }

    @Override
    @Deprecated
    public void setCoverDataAtSide(byte aSide, int aData) {
        if (aSide >= 0 && aSide < 6 && this.mCoverData[aSide] instanceof ISerializableObject.LegacyCoverData) {
            this.mCoverData[aSide] = new ISerializableObject.LegacyCoverData(aData);
        }
    }

    @Override
    public void setCoverDataAtSide(byte aSide, ISerializableObject aData) {
        if (aSide >= 0 && aSide < 6 && this.getCoverBehaviorAtSideNew(aSide) != null && this.getCoverBehaviorAtSideNew(aSide).cast(aData) != null) {
            this.mCoverData[aSide] = aData;
        }
    }

    @Override
    public ISerializableObject getComplexCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6 && this.getCoverBehaviorAtSideNew(aSide) != null) {
            return this.mCoverData[aSide];
        }
        return GregTech_API.sNoBehavior.createDataObject();
    }

    @Override
    public GT_CoverBehaviorBase<?> getCoverBehaviorAtSideNew(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverBehaviors[aSide];
        }
        return GregTech_API.sNoBehavior;
    }

    @Override
    public boolean dropCover(byte aSide, byte aDroppedSide, boolean aForced) {
        if (this.getCoverBehaviorAtSideNew(aSide).onCoverRemoval(aSide, this.getCoverIDAtSide(aSide), this.mCoverData[aSide], this, aForced) || aForced) {
            ItemStack tStack = this.getCoverBehaviorAtSideNew(aSide).getDrop(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this);
            if (tStack != null) {
                this.getCoverBehaviorAtSideNew(aSide).onDropped(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this);
                EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(aDroppedSide, 1) + 0.5, (double)this.getOffsetY(aDroppedSide, 1) + 0.5, (double)this.getOffsetZ(aDroppedSide, 1) + 0.5, tStack);
                tEntity.field_70159_w = 0.0;
                tEntity.field_70181_x = 0.0;
                tEntity.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)tEntity);
            }
            this.setCoverIDAtSide(aSide, 0);
            this.updateOutputRedstoneSignal(aSide);
            return true;
        }
        return false;
    }

    protected void updateOutputRedstoneSignal(byte aSide) {
        this.setOutputRedstoneSignal(aSide, (byte)0);
    }

    @Override
    public void receiveCoverData(byte coverSide, int coverID, int coverData) {
        if (coverSide >= 0 && coverSide < 6 && this.mCoverSides[coverSide] == coverID) {
            this.setCoverDataAtSide(coverSide, coverData);
        }
    }

    @Override
    public void receiveCoverData(byte aCoverSide, int aCoverID, ISerializableObject aCoverData, EntityPlayerMP aPlayer) {
        if (aCoverSide >= 0 && aCoverSide < 6 && this.mCoverSides[aCoverSide] == aCoverID) {
            this.setCoverDataAtSide(aCoverSide, aCoverData);
            if (this.isClientSide()) {
                this.getCoverBehaviorAtSideNew(aCoverSide).onDataChanged(aCoverSide, aCoverID, aCoverData, this);
            }
        }
    }

    protected void sendCoverDataIfNeeded() {
        byte mCoverNeedUpdateLength = this.mCoverNeedUpdate.length;
        for (byte i = 0; i < mCoverNeedUpdateLength; i = (byte)((byte)(i + 1))) {
            if (!this.mCoverNeedUpdate[i]) continue;
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_SendCoverData(i, this.getCoverIDAtSide(i), this.getComplexCoverDataAtSide(i), this), this.field_145851_c, this.field_145849_e);
            this.mCoverNeedUpdate[i] = false;
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        byte side = (byte)accessor.getSide().ordinal();
        String filterKey = "filterInfo" + side;
        if (tag.func_74764_b(filterKey)) {
            currenttip.add(tag.func_74779_i(filterKey));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        for (byte side = 0; side < 6; side = (byte)(side + 1)) {
            if (!(this.getCoverBehaviorAtSideNew(side) instanceof GT_Cover_Fluidfilter)) continue;
            tag.func_74778_a("filterInfo" + side, this.getCoverBehaviorAtSideNew(side).getDescription(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this));
        }
    }
}

