/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import gregtech.loaders.misc.GT_BeeDefinition;
import gregtech.loaders.misc.GT_Bees;
import java.util.Arrays;
import java.util.function.Consumer;

public enum GT_BranchDefinition {
    ORGANIC("Fuelis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
    }),
    IC2("Industrialis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
    }),
    GTALLOY("Amalgamis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
    }),
    THAUMIC("Arcanis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "book"));
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }),
    GEM("Ornamentis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }),
    METAL("Metaliferis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
    }),
    RAREMETAL("Mineralis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
    }),
    RADIOACTIVE("Criticalis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.END);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_Bees.speedBlinding);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_BeeDefinition.getEffect((byte)1, "radioactive"));
    }),
    TWILIGHT("Nemoris Obscuri", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }),
    HEE("Finis Expansiones", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "book"));
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGER);
    }),
    SPACE("Cosmicis", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "rock"));
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTEST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGEST);
    }),
    PLANET("Planetaris", alleles -> {
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GT_BeeDefinition.getFlowers((byte)1, "rock"));
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTEST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGER);
    });

    private static IAllele[] defaultTemplate;
    private final IClassification branch;
    private final Consumer<IAllele[]> mBranchProperties;

    private GT_BranchDefinition(String scientific, Consumer<IAllele[]> aBranchProperties) {
        this.branch = BeeManager.beeFactory.createBranch(this.name().toLowerCase(), scientific);
        this.mBranchProperties = aBranchProperties;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERANT_FLYER, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }

    protected final void setBranchProperties(IAllele[] template) {
        this.mBranchProperties.accept(template);
    }

    public final IAllele[] getTemplate() {
        IAllele[] template = GT_BranchDefinition.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public final IClassification getBranch() {
        return this.branch;
    }
}

