/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaGenerated_Item_98
extends GT_MetaGenerated_Item {
    public static GT_MetaGenerated_Item_98 INSTANCE;
    private final Map<Integer, RegisteredFluidData> registeredFluidDataMap = new HashMap<Integer, RegisteredFluidData>();
    private final EnumMap<CellType, IIconContainer> iconContainerMap = new EnumMap(CellType.class);

    private GT_MetaGenerated_Item_98() {
        super("metaitem.98", (short)32766, (short)0);
    }

    public static synchronized void preInit() {
        if (INSTANCE == null) {
            INSTANCE = new GT_MetaGenerated_Item_98();
        }
        for (CellType cellType : CellType.values()) {
            IIconContainer iconContainer = Materials.Water.mIconSet.mTextures[((CellType)cellType).prefix.mTextureIndex];
            GT_MetaGenerated_Item_98.INSTANCE.iconContainerMap.put(cellType, iconContainer);
        }
    }

    public static synchronized void init() {
        INSTANCE.createItems();
        INSTANCE.registerOreDict();
    }

    private void createItems() {
        ItemStack emptyCell = ItemList.Cell_Empty.get(1L, new Object[0]);
        HashSet<Integer> idSet = new HashSet<Integer>();
        for (FluidCell tCell : FluidCell.values()) {
            int id = tCell.getId();
            String fluidName = tCell.getFluidName();
            CellType cellType = tCell.getDisplayType();
            if (idSet.contains(id)) {
                throw new IllegalStateException("Got ID collision for ID: " + id);
            }
            idSet.add(id);
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid == null) continue;
            ItemStack itemStack = new ItemStack((Item)this, 1, id);
            FluidStack fluidStack = new FluidStack(fluid, cellType.capacity);
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(fluidStack, itemStack, emptyCell));
            tCell.setStack(itemStack);
            GT_LanguageManager.addStringLocalization(this.func_77667_c(itemStack) + ".name", ((CellType)cellType).prefix.mLocalizedMaterialPre + fluid.getLocalizedName(fluidStack) + ((CellType)cellType).prefix.mLocalizedMaterialPost);
            int color = fluid.getColor();
            short[] rgba = new short[]{(short)((color & 0xFF0000) >> 16), (short)((color & 0xFF00) >> 8), (short)(color & 0xFF), (short)((color & 0xFF000000) >> 24)};
            this.registeredFluidDataMap.put(id, new RegisteredFluidData(fluid, rgba, this.iconContainerMap.get((Object)cellType)));
        }
        this.mEnabledItems.clear();
        this.mVisibleItems.clear();
    }

    private void registerOreDict() {
        GT_OreDictUnificator.add(OrePrefixes.cellMolten, Materials.Water, GT_ModHandler.getIC2Item("steamCell", 1L));
        GT_OreDictUnificator.add(OrePrefixes.cellMolten, Materials.Water, FluidCell.STEAM.getNoCopy());
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        RegisteredFluidData fluidData = this.registeredFluidDataMap.get(aStack.func_77960_j());
        if (fluidData == null) {
            return Materials._NULL.mRGBa;
        }
        return fluidData.rgba;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        return ItemList.Cell_Empty.get(1L, new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        Arrays.stream(FluidCell.values()).map(FluidCell::get).filter(Objects::nonNull).forEach(aList::add);
    }

    @Override
    public final IIcon func_77617_a(int aMetaData) {
        IIconContainer iconContainer = this.getIconContainer(aMetaData);
        if (iconContainer != null) {
            return iconContainer.getIcon();
        }
        return null;
    }

    @Override
    public IIconContainer getIconContainer(int aMetaData) {
        RegisteredFluidData fluidData = this.registeredFluidDataMap.get(aMetaData);
        if (fluidData == null) {
            return null;
        }
        return fluidData.iconContainer;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return 64;
    }

    private static class RegisteredFluidData {
        private final Fluid fluid;
        private final short[] rgba;
        private final IIconContainer iconContainer;

        private RegisteredFluidData(Fluid fluid, short[] rgba, IIconContainer iconContainer) {
            this.fluid = fluid;
            this.rgba = rgba;
            this.iconContainer = iconContainer;
        }
    }

    private static enum CellType {
        REGULAR(1000, OrePrefixes.cell),
        SMALL(144, OrePrefixes.cell),
        MOLTEN(144, OrePrefixes.cellMolten),
        PLASMA(1000, OrePrefixes.cellPlasma);

        private final int capacity;
        private final OrePrefixes prefix;

        private CellType(int capacity, OrePrefixes prefix) {
            this.capacity = capacity;
            this.prefix = prefix;
        }
    }

    public static enum FluidCell {
        DRILLING_FLUID(5, "liquid_drillingfluid", CellType.REGULAR),
        SQUID_INK(6, "squidink", CellType.SMALL),
        UNKNOWN_NUTRIENT_AGAR(7, "unknownnutrientagar", CellType.REGULAR),
        SEAWEED_BROTH(8, "seaweedbroth", CellType.REGULAR),
        SUPER_LIGHT_RADOX(9, "superlightradox", CellType.REGULAR),
        ENZYME_SOLUTION(10, "enzymessollution", CellType.REGULAR),
        ESCHERICHIA_COLI_FLUID(11, "escherichiakolifluid", CellType.REGULAR),
        PENICILLIN(12, "penicillin", CellType.REGULAR),
        FLUORESCENT_DNA(13, "fluorecentddna", CellType.REGULAR),
        POLYMERASE(17, "polymerase", CellType.REGULAR),
        COMBUSTION_PROMOTER(14, "combustionpromotor", CellType.REGULAR),
        BACTERIAL_SLUDGE(1, "bacterialsludge", CellType.REGULAR),
        STEAM(0, "steam", CellType.REGULAR),
        BACTERIA(15, "binnie.bacteria", CellType.REGULAR),
        MUTAGEN(2, "mutagen", CellType.REGULAR),
        LIQUID_DNA(16, "liquiddna", CellType.REGULAR),
        LIQUID_ENDER(3, "ender", CellType.REGULAR),
        ENDER_GOO(4, "endergoo", CellType.REGULAR);

        private final int mId;
        private final String mfluidName;
        private final CellType mType;
        @Nullable
        private ItemStack mStack;

        private FluidCell(int aId, String aFluidName, CellType aType) {
            this.mId = aId;
            this.mfluidName = aFluidName;
            this.mType = aType;
        }

        public int getId() {
            return this.mId;
        }

        public String getFluidName() {
            return this.mfluidName;
        }

        public CellType getDisplayType() {
            return this.mType;
        }

        @Nullable
        public ItemStack get() {
            return GT_Utility.copy(this.mStack);
        }

        @Nullable
        public ItemStack getNoCopy() {
            return this.mStack;
        }

        @Nullable
        public ItemStack get(int aStackSize) {
            return GT_Utility.copyAmount(aStackSize, this.mStack);
        }

        private void setStack(ItemStack mStack) {
            this.mStack = mStack;
        }
    }
}

