/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Single_Recipe_Check;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public abstract class GT_MetaTileEntity_MultiBlockBase
extends MetaTileEntity {
    public static boolean disableMaintenance;
    public boolean mMachine = false;
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftHammer = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    public boolean mRunningOnLoad = false;
    public int mPollution = 0;
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;
    public int mEUt = 0;
    public int mEfficiencyIncrease = 0;
    public int mStartUpCheck = 100;
    public int mRuntime = 0;
    public int mEfficiency = 0;
    public volatile int mUpdate = 0;
    public ItemStack[] mOutputItems = null;
    public FluidStack[] mOutputFluids = null;
    public String mNEI;
    public int damageFactorLow = 5;
    public float damageFactorHigh = 0.6f;
    public boolean mLockedToSingleRecipe = false;
    public GT_Single_Recipe_Check mSingleRecipeCheck = null;
    public ArrayList<GT_MetaTileEntity_Hatch_Input> mInputHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Output> mOutputHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_InputBus> mInputBusses = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_OutputBus> mOutputBusses = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Dynamo> mDynamoHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Muffler> mMufflerHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Energy> mEnergyHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Maintenance> mMaintenanceHatches = new ArrayList();

    public GT_MetaTileEntity_MultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 2);
        disableMaintenance = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.disableMaintenance", false);
        this.damageFactorLow = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorLow", 5);
        this.damageFactorHigh = (float)GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorHigh", (double)0.6f);
        this.mNEI = "";
    }

    public GT_MetaTileEntity_MultiBlockBase(String aName) {
        super(aName, 2);
        disableMaintenance = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.disableMaintenance", false);
        this.damageFactorLow = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorLow", 5);
        this.damageFactorHigh = (float)GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorHigh", (double)0.6f);
    }

    public static boolean isValidMetaTileEntity(MetaTileEntity aMetaTileEntity) {
        return aMetaTileEntity.getBaseMetaTileEntity() != null && aMetaTileEntity.getBaseMetaTileEntity().getMetaTileEntity() == aMetaTileEntity && !aMetaTileEntity.getBaseMetaTileEntity().isDead();
    }

    @Override
    public boolean isDisplaySecondaryDescription() {
        return Keyboard.isKeyDown((int)42);
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.supportsSingleRecipeLocking()) {
            boolean bl = this.mLockedToSingleRecipe = !this.mLockedToSingleRecipe;
            if (this.mLockedToSingleRecipe) {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("219", "Single recipe locking enabled. Will lock to next recipe."));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("220", "Single recipe locking disabled."));
                this.mSingleRecipeCheck = null;
            }
        }
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex > 0;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        return aProgress;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        NBTTagCompound tNBT;
        int i;
        aNBT.func_74768_a("mEUt", this.mEUt);
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        aNBT.func_74768_a("mEfficiencyIncrease", this.mEfficiencyIncrease);
        aNBT.func_74768_a("mEfficiency", this.mEfficiency);
        aNBT.func_74768_a("mPollution", this.mPollution);
        aNBT.func_74768_a("mRuntime", this.mRuntime);
        aNBT.func_74757_a("mLockedToSingleRecipe", this.mLockedToSingleRecipe);
        if (this.mOutputItems != null) {
            aNBT.func_74768_a("mOutputItemsLength", this.mOutputItems.length);
            for (i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null) continue;
                tNBT = new NBTTagCompound();
                this.mOutputItems[i].func_77955_b(tNBT);
                aNBT.func_74782_a("mOutputItem" + i, (NBTBase)tNBT);
            }
        }
        if (this.mOutputFluids != null) {
            aNBT.func_74768_a("mOutputFluidsLength", this.mOutputFluids.length);
            for (i = 0; i < this.mOutputFluids.length; ++i) {
                if (this.mOutputFluids[i] == null) continue;
                tNBT = new NBTTagCompound();
                this.mOutputFluids[i].writeToNBT(tNBT);
                aNBT.func_74782_a("mOutputFluids" + i, (NBTBase)tNBT);
            }
        }
        aNBT.func_74757_a("mWrench", this.mWrench);
        aNBT.func_74757_a("mScrewdriver", this.mScrewdriver);
        aNBT.func_74757_a("mSoftHammer", this.mSoftHammer);
        aNBT.func_74757_a("mHardHammer", this.mHardHammer);
        aNBT.func_74757_a("mSolderingTool", this.mSolderingTool);
        aNBT.func_74757_a("mCrowbar", this.mCrowbar);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int aOutputFluidsLength;
        this.mEUt = aNBT.func_74762_e("mEUt");
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        if (this.mMaxProgresstime > 0) {
            this.mRunningOnLoad = true;
        }
        this.mEfficiencyIncrease = aNBT.func_74762_e("mEfficiencyIncrease");
        this.mEfficiency = aNBT.func_74762_e("mEfficiency");
        this.mPollution = aNBT.func_74762_e("mPollution");
        this.mRuntime = aNBT.func_74762_e("mRuntime");
        this.mLockedToSingleRecipe = aNBT.func_74767_n("mLockedToSingleRecipe");
        int aOutputItemsLength = aNBT.func_74762_e("mOutputItemsLength");
        if (aOutputItemsLength > 0) {
            this.mOutputItems = new ItemStack[aOutputItemsLength];
            for (int i = 0; i < this.mOutputItems.length; ++i) {
                this.mOutputItems[i] = GT_Utility.loadItem(aNBT, "mOutputItem" + i);
            }
        }
        if ((aOutputFluidsLength = aNBT.func_74762_e("mOutputFluidsLength")) > 0) {
            this.mOutputFluids = new FluidStack[aOutputFluidsLength];
            for (int i = 0; i < this.mOutputFluids.length; ++i) {
                this.mOutputFluids[i] = GT_Utility.loadFluid(aNBT, "mOutputFluids" + i);
            }
        }
        this.mWrench = aNBT.func_74767_n("mWrench");
        this.mScrewdriver = aNBT.func_74767_n("mScrewdriver");
        this.mSoftHammer = aNBT.func_74767_n("mSoftHammer");
        this.mHardHammer = aNBT.func_74767_n("mHardHammer");
        this.mSolderingTool = aNBT.func_74767_n("mSolderingTool");
        this.mCrowbar = aNBT.func_74767_n("mCrowbar");
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    @Override
    public byte getTileEntityBaseType() {
        return 2;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdate = 50;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.mInputHatches.clear();
                this.mInputBusses.clear();
                this.mOutputHatches.clear();
                this.mOutputBusses.clear();
                this.mDynamoHatches.clear();
                this.mEnergyHatches.clear();
                this.mMufflerHatches.clear();
                this.mMaintenanceHatches.clear();
                this.mMachine = this.checkMachine(aBaseMetaTileEntity, this.mInventory[1]);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    for (GT_MetaTileEntity_Hatch_Maintenance tHatch : this.mMaintenanceHatches) {
                        if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
                        if (disableMaintenance) {
                            this.mWrench = true;
                            this.mScrewdriver = true;
                            this.mSoftHammer = true;
                            this.mHardHammer = true;
                            this.mSolderingTool = true;
                            this.mCrowbar = true;
                            continue;
                        }
                        if (!(!tHatch.mAuto || this.mWrench && this.mScrewdriver && this.mSoftHammer && this.mHardHammer && this.mSolderingTool && this.mCrowbar)) {
                            tHatch.autoMaintainance();
                        }
                        if (tHatch.mWrench) {
                            this.mWrench = true;
                        }
                        if (tHatch.mScrewdriver) {
                            this.mScrewdriver = true;
                        }
                        if (tHatch.mSoftHammer) {
                            this.mSoftHammer = true;
                        }
                        if (tHatch.mHardHammer) {
                            this.mHardHammer = true;
                        }
                        if (tHatch.mSolderingTool) {
                            this.mSolderingTool = true;
                        }
                        if (tHatch.mCrowbar) {
                            this.mCrowbar = true;
                        }
                        tHatch.mWrench = false;
                        tHatch.mScrewdriver = false;
                        tHatch.mSoftHammer = false;
                        tHatch.mHardHammer = false;
                        tHatch.mSolderingTool = false;
                        tHatch.mCrowbar = false;
                    }
                    if (this.getRepairStatus() > 0) {
                        if (this.mMaxProgresstime > 0 && this.doRandomMaintenanceDamage()) {
                            if (this.onRunningTick(this.mInventory[1])) {
                                if (!this.polluteEnvironment(this.getPollutionPerTick(this.mInventory[1]))) {
                                    this.stopMachine();
                                }
                                if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                                    if (this.mOutputItems != null) {
                                        for (ItemStack tStack : this.mOutputItems) {
                                            if (tStack == null) continue;
                                            try {
                                                GT_Mod.achievements.issueAchivementHatch(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), tStack);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            this.addOutput(tStack);
                                        }
                                    }
                                    if (this.mOutputFluids != null) {
                                        this.addFluidOutputs(this.mOutputFluids);
                                    }
                                    this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
                                    this.mOutputItems = null;
                                    this.mProgresstime = 0;
                                    this.mMaxProgresstime = 0;
                                    this.mEfficiencyIncrease = 0;
                                    if (aBaseMetaTileEntity.isAllowedToWork()) {
                                        this.checkRecipe(this.mInventory[1]);
                                    }
                                    if (this.mOutputFluids != null && this.mOutputFluids.length > 0 && this.mOutputFluids.length > 1) {
                                        try {
                                            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "oilplant");
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                        } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe(this.mInventory[1]);
                            }
                            if (this.mMaxProgresstime <= 0) {
                                this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                            }
                        }
                    } else {
                        this.stopMachine();
                    }
                } else {
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mWrench ? 0 : 1) | (this.mScrewdriver ? 0 : 2) | (this.mSoftHammer ? 0 : 4) | (this.mHardHammer ? 0 : 8) | (this.mSolderingTool ? 0 : 16) | (this.mCrowbar ? 0 : 32) | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
            boolean active = aBaseMetaTileEntity.isActive() && this.mPollution > 0;
            for (GT_MetaTileEntity_Hatch_Muffler aMuffler : this.mMufflerHatches) {
                IGregTechTileEntity iGTTileEntity = aMuffler.getBaseMetaTileEntity();
                if (iGTTileEntity == null || iGTTileEntity.isDead()) continue;
                iGTTileEntity.setActive(active);
            }
        }
    }

    public boolean polluteEnvironment(int aPollutionLevel) {
        this.mPollution += aPollutionLevel;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            if (this.mPollution < 10000) break;
            if (!tHatch.polluteEnvironment(this)) continue;
            this.mPollution -= 10000;
        }
        return this.mPollution < 10000;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            this.addEnergyOutput((long)this.mEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        if (this.mEUt < 0 && !this.drainEnergyInput((long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.criticalStopMachine();
            return false;
        }
        return true;
    }

    public abstract boolean isCorrectMachinePart(ItemStack var1);

    public abstract boolean checkRecipe(ItemStack var1);

    public abstract boolean checkMachine(IGregTechTileEntity var1, ItemStack var2);

    public abstract int getMaxEfficiency(ItemStack var1);

    public int getPollutionPerTick(ItemStack aStack) {
        return this.getPollutionPerSecond(aStack) / 20;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    public abstract int getDamageToComponent(ItemStack var1);

    public abstract boolean explodesOnComponentBreak(ItemStack var1);

    public void stopMachine() {
        this.mOutputItems = null;
        this.mEUt = 0;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.getBaseMetaTileEntity().disableWorking();
    }

    public void criticalStopMachine() {
        this.stopMachine();
        this.getBaseMetaTileEntity().setShutdownStatus(true);
    }

    public int getRepairStatus() {
        return (this.mWrench ? 1 : 0) + (this.mScrewdriver ? 1 : 0) + (this.mSoftHammer ? 1 : 0) + (this.mHardHammer ? 1 : 0) + (this.mSolderingTool ? 1 : 0) + (this.mCrowbar ? 1 : 0);
    }

    public int getIdealStatus() {
        return 6;
    }

    public int getCurrentEfficiency(ItemStack itemStack) {
        int maxEff = this.getMaxEfficiency(itemStack);
        return maxEff - (this.getIdealStatus() - this.getRepairStatus()) * maxEff / 10;
    }

    public boolean doRandomMaintenanceDamage() {
        if (!this.isCorrectMachinePart(this.mInventory[1]) || this.getRepairStatus() == 0) {
            this.stopMachine();
            return false;
        }
        if (this.mRuntime++ > 1000) {
            this.mRuntime = 0;
            if (this.getBaseMetaTileEntity().getRandomNumber(6000) == 0) {
                switch (this.getBaseMetaTileEntity().getRandomNumber(6)) {
                    case 0: {
                        this.mWrench = false;
                        break;
                    }
                    case 1: {
                        this.mScrewdriver = false;
                        break;
                    }
                    case 2: {
                        this.mSoftHammer = false;
                        break;
                    }
                    case 3: {
                        this.mHardHammer = false;
                        break;
                    }
                    case 4: {
                        this.mSolderingTool = false;
                        break;
                    }
                    case 5: {
                        this.mCrowbar = false;
                    }
                }
            }
            if (this.mInventory[1] != null && this.getBaseMetaTileEntity().getRandomNumber(2) == 0 && !this.mInventory[1].func_77977_a().startsWith("gt.blockmachines.basicmachine.") && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
                NBTTagCompound tNBT = this.mInventory[1].func_77978_p();
                if (tNBT != null) {
                    NBTTagCompound nBTTagCompound = tNBT.func_74775_l("GT.CraftingComponents");
                }
                ((GT_MetaGenerated_Tool)this.mInventory[1].func_77973_b()).doDamage(this.mInventory[1], (long)this.getDamageToComponent(this.mInventory[1]) * (long)Math.min((double)(this.mEUt / this.damageFactorLow), Math.pow(this.mEUt, this.damageFactorHigh)));
                if (this.mInventory[1].field_77994_a == 0) {
                    this.mInventory[1] = null;
                }
            }
        }
        return true;
    }

    public void explodeMultiblock() {
        GT_Log.exp.println("MultiBlockExplosion at: " + this.getBaseMetaTileEntity().getXCoord() + " | " + this.getBaseMetaTileEntity().getYCoord() + " | " + this.getBaseMetaTileEntity().getZCoord() + " DIMID: " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g + ".");
        GT_Pollution.addPollution(this.getBaseMetaTileEntity(), GT_Mod.gregtechproxy.mPollutionOnExplosion);
        this.mInventory[1] = null;
        for (MetaTileEntity metaTileEntity : this.mInputBusses) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mOutputBusses) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mInputHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mOutputHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mDynamoHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mMufflerHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mEnergyHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mMaintenanceHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        this.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
    }

    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (this.mDynamoHatches.size() > 0) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        long aVoltage;
        int injected = 0;
        long totalOutput = 0L;
        long aFirstVoltageFound = -1L;
        boolean aFoundMixedDynamos = false;
        for (GT_MetaTileEntity_Hatch_Dynamo aDynamo : this.mDynamoHatches) {
            if (aDynamo == null) {
                return false;
            }
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(aDynamo)) continue;
            aVoltage = aDynamo.maxEUOutput();
            long aTotal = aDynamo.maxAmperesOut() * aVoltage;
            if (aFirstVoltageFound == -1L) {
                aFirstVoltageFound = aVoltage;
            } else if (aFirstVoltageFound != aVoltage) {
                aFoundMixedDynamos = true;
            }
            totalOutput += aTotal;
        }
        if (totalOutput < aEU || aFoundMixedDynamos && !aAllowMixedVoltageDynamos) {
            this.explodeMultiblock();
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Dynamo aDynamo : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(aDynamo)) continue;
            long leftToInject = aEU - (long)injected;
            aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int ampsOnCurrentHatch = (int)Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject);
            for (int i = 0; i < ampsOnCurrentHatch; ++i) {
                aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aVoltage, false);
            }
            injected = (int)((long)injected + aVoltage * (long)ampsOnCurrentHatch);
            if (aRemainder <= 0 || (long)ampsOnCurrentHatch >= aDynamo.maxAmperesOut()) continue;
            aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aRemainder, false);
            injected += aRemainder;
        }
        return injected > 0;
    }

    public long getMaxInputVoltage() {
        long rVoltage = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            rVoltage += tHatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage;
    }

    protected void calculateOverclockedNessMultiInternal(int aEUt, int aDuration, int mAmperage, long maxInputVoltage, boolean perfectOC) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier(maxInputVoltage));
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            int ocTimeShift;
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            int n = ocTimeShift = perfectOC ? 2 : 1;
            while (tempEUt <= GT_Values.V[mTier - 1] * (long)mAmperage) {
                tempEUt <<= 2;
                int oldTime = this.mMaxProgresstime;
                this.mMaxProgresstime >>= ocTimeShift;
                if (this.mMaxProgresstime < 1) {
                    if (oldTime == 1) break;
                    xEUt *= (long)(oldTime * (perfectOC ? 1 : 2));
                    break;
                }
                xEUt <<= 2;
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = (int)xEUt;
                if (this.mEUt == 0) {
                    this.mEUt = 1;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
    }

    protected void calculateOverclockedNessMulti(int aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, false);
    }

    protected void calculatePerfectOverclockedNessMulti(int aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, true);
    }

    public boolean drainEnergyInput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEU, false)) continue;
            return true;
        }
        return false;
    }

    protected static boolean dumpFluid(List<GT_MetaTileEntity_Hatch_Output> aOutputHatches, FluidStack copiedFluidStack, boolean restrictiveHatchesOnly) {
        for (GT_MetaTileEntity_Hatch_Output tHatch : aOutputHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || restrictiveHatchesOnly && tHatch.mMode == 0 || (!GT_ModHandler.isSteam(copiedFluidStack) ? !tHatch.outputsLiquids() || tHatch.isFluidLocked() && tHatch.getLockedFluidName() != null && !tHatch.getLockedFluidName().equals(copiedFluidStack.getUnlocalizedName()) : !tHatch.outputsSteam())) continue;
            int tAmount = tHatch.fill(copiedFluidStack, false);
            if (tAmount >= copiedFluidStack.amount) {
                boolean filled = tHatch.fill(copiedFluidStack, true) >= copiedFluidStack.amount;
                tHatch.onEmptyingContainerWhenEmpty();
                return filled;
            }
            if (tAmount <= 0) continue;
            copiedFluidStack.amount -= tHatch.fill(copiedFluidStack, true);
            tHatch.onEmptyingContainerWhenEmpty();
        }
        return false;
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack copiedFluidStack = aLiquid.copy();
        if (!GT_MetaTileEntity_MultiBlockBase.dumpFluid(this.mOutputHatches, copiedFluidStack, true)) {
            GT_MetaTileEntity_MultiBlockBase.dumpFluid(this.mOutputHatches, copiedFluidStack, false);
        }
        return false;
    }

    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (FluidStack outputFluidStack : mOutputFluids2) {
            this.addOutput(outputFluidStack);
        }
    }

    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tLiquid;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || (tLiquid = tHatch.getFluid()) == null || !tLiquid.isFluidEqual(aLiquid) || (tLiquid = tHatch.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        aStack = GT_Utility.copyOrNull(aStack);
        for (GT_MetaTileEntity_Hatch_OutputBus tHatch : this.mOutputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.storeAll(aStack)) continue;
            return true;
        }
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (GT_MetaTileEntity_Hatch_Output tHatch : this.mOutputHatches) {
                if (outputSuccess || !GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    public boolean depleteInput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        FluidStack aLiquid = GT_Utility.getFluidForFilledItem(aStack, true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mInputHatches) {
            gT_MetaTileEntity_Hatch_Input.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Input) || !GT_Utility.areStacksEqual(aStack, gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a(0)) || gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus : this.mInputBusses) {
            gT_MetaTileEntity_Hatch_InputBus.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_InputBus)) continue;
            for (int i = gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GT_Utility.areStacksEqual(aStack, gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a(i)) || gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
                gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_OutputBus tHatch : this.mOutputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mInputHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Input)) continue;
            gT_MetaTileEntity_Hatch_Input.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus : this.mInputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_InputBus)) continue;
            gT_MetaTileEntity_Hatch_InputBus.updateSlots();
        }
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    public boolean addMaintenanceToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        return false;
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        return false;
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        return false;
    }

    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        return false;
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(-this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    protected ItemStack[] getCompactedInputs() {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        return tInputList.toArray(new ItemStack[0]);
    }

    protected FluidStack[] getCompactedFluids() {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block0: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block0;
            }
        }
        return tFluidList.toArray(new FluidStack[0]);
    }
}

