/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import gregtech.api.gui.GT_GUIScreen;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class GT_GUIDialogSelectItem
extends GT_GUIScreen {
    public static final int UNSELECTED = -1;
    private static final int cols = 9;
    private static final int rows = 3;
    private final GuiScreen parent;
    private final Consumer<ItemStack> selectedCallback;
    private final List<ItemStack> stacks;
    private final List<GT_GuiFakeItemButton> slots = new ArrayList<GT_GuiFakeItemButton>();
    private final GT_GuiFakeItemButton btnCurrent = new GT_GuiFakeItemButton(this, 8, 25, GT_GuiIcon.SLOT_DARKGRAY).setMimicSlot(true);
    private final boolean noDeselect;
    private int selected;
    private int scroll = 0;
    private GT_GuiIconButton btnUp;
    private GT_GuiIconButton btnDown;

    public GT_GUIDialogSelectItem(String header, ItemStack headerItem, GuiScreen parent, Consumer<ItemStack> selectedCallback, List<ItemStack> stacks) {
        this(header, headerItem, parent, selectedCallback, stacks, -1);
    }

    public GT_GUIDialogSelectItem(String header, ItemStack headerItem, GuiScreen parent, Consumer<ItemStack> selectedCallback, List<ItemStack> stacks, int selected) {
        this(header, headerItem, parent, selectedCallback, stacks, selected, false);
    }

    public GT_GUIDialogSelectItem(String header, ItemStack headerItem, GuiScreen parent, Consumer<ItemStack> selectedCallback, List<ItemStack> stacks, int selected, boolean noDeselect) {
        super(176, 107, header);
        this.noDeselect = noDeselect;
        if (headerItem != null) {
            this.headerIcon.setItem(headerItem);
        }
        this.parent = parent;
        this.selectedCallback = selectedCallback;
        this.stacks = stacks;
        if (stacks.size() > 27) {
            this.btnUp = new GT_GuiIconButton(this, 0, 134, 25, GT_GuiIcon.GREEN_ARROW_UP);
            this.btnDown = new GT_GuiIconButton(this, 1, 152, 25, GT_GuiIcon.GREEN_ARROW_DOWN);
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.slots.add(new GT_GuiFakeItemButton(this, 8 + 18 * j, 44 + 18 * i, GT_GuiIcon.SLOT_GRAY).setMimicSlot(true));
            }
        }
        this.setSelected(noDeselect ? Math.max(0, selected) : selected);
        this.ensureSelectedDisplayed();
    }

    @Override
    protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
        this.btnCurrent.setX(10 + this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"GT5U.gui.select.current")));
    }

    @Override
    public void closeScreen() {
        this.selectedCallback.accept(this.getCandidate(this.getSelected()));
        this.field_146297_k.func_147108_a(this.parent);
        if (this.parent == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    @Override
    public void buttonClicked(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.setScroll(this.scroll - 1);
                return;
            }
            case 1: {
                this.setScroll(this.scroll + 1);
                return;
            }
        }
        super.buttonClicked(button);
    }

    @Override
    public void drawExtras(int mouseX, int mouseY, float parTicks) {
        int y = 25 + (18 - this.getFontRenderer().field_78288_b) / 2;
        this.getFontRenderer().func_78276_b(StatCollector.func_74838_a((String)"GT5U.gui.select.current"), 8, y, -11184811);
        super.drawExtras(mouseX, mouseY, parTicks);
    }

    @Override
    public void func_73864_a(int x, int y, int button) {
        int mx = x - this.guiLeft;
        int my = y - this.guiTop;
        if (button == 0) {
            if (this.btnCurrent.getBounds().contains(mx, my)) {
                this.ensureSelectedDisplayed();
                return;
            }
            int slotsSize = this.slots.size();
            for (int i = 0; i < slotsSize; ++i) {
                GT_GuiFakeItemButton slot = this.slots.get(i);
                if (!slot.getBounds().contains(mx, my)) continue;
                this.setSelected(this.slotIndexToListIndex(i));
                return;
            }
        } else if (button == 1 && this.getSelected() >= 0) {
            if (this.btnCurrent.getBounds().contains(mx, my)) {
                this.setSelected(-1);
                return;
            }
            GT_GuiFakeItemButton slot = this.getSlot(this.listIndexToSlotIndex(this.getSelected()));
            if (slot != null && slot.getBounds().contains(mx, my)) {
                this.setSelected(-1);
            }
        }
        super.func_73864_a(x, y, button);
    }

    @Override
    public void onMouseWheel(int x, int y, int delta) {
        if (delta < 0) {
            this.setScroll(this.scroll + 1);
        } else if (delta > 0) {
            this.setScroll(this.scroll - 1);
        }
    }

    private void fillSlots() {
        int i = 0;
        int j = this.scroll * 9;
        while (i < this.slots.size()) {
            this.slots.get(i).setItem(this.getCandidate(j)).setBgIcon(j == this.getSelected() ? GT_GuiIcon.SLOT_DARKGRAY : GT_GuiIcon.SLOT_GRAY);
            ++i;
            ++j;
        }
    }

    private void ensureSelectedDisplayed() {
        if (this.getSelected() < this.scroll * 9) {
            this.setScroll(this.getSelected() / 9);
        } else if (this.getSelected() > (this.scroll + 3) * 9) {
            this.setScroll((this.getSelected() - 18) / 9);
        } else {
            this.setScroll(this.scroll);
        }
    }

    private int slotIndexToListIndex(int index) {
        int mapped = this.scroll * 9 + index;
        return mapped >= this.stacks.size() ? -1 : mapped;
    }

    private int listIndexToSlotIndex(int index) {
        return index - this.scroll * 9;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        if (selected == this.selected) {
            return;
        }
        int newSelected = GT_Utility.clamp(selected, -1, this.stacks.size() - 1);
        if (this.noDeselect && newSelected == -1) {
            return;
        }
        GT_GuiFakeItemButton selectedSlot = this.getSlot(this.selected);
        if (selectedSlot != null) {
            selectedSlot.setBgIcon(GT_GuiIcon.SLOT_GRAY);
        }
        this.selected = newSelected;
        this.btnCurrent.setItem(this.getCandidate(this.selected));
        selectedSlot = this.getSlot(this.selected);
        if (selectedSlot != null) {
            selectedSlot.setBgIcon(GT_GuiIcon.SLOT_DARKGRAY);
        }
    }

    private void setScroll(int scroll) {
        if (this.stacks.size() > 27) {
            int lo = 0;
            int hi = (this.stacks.size() - 27) / 9 + 1;
            this.scroll = GT_Utility.clamp(scroll, lo, hi);
            this.btnUp.field_146124_l = this.scroll != lo;
            this.btnDown.field_146124_l = this.scroll != hi;
        }
        this.fillSlots();
    }

    private ItemStack getCandidate(int listIndex) {
        return listIndex < 0 || listIndex >= this.stacks.size() ? null : this.stacks.get(listIndex);
    }

    private GT_GuiFakeItemButton getSlot(int slotIndex) {
        return slotIndex < 0 || slotIndex >= this.slots.size() ? null : this.slots.get(slotIndex);
    }
}

