/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GT_Cover_SolarPanel
extends GT_CoverBehavior {
    private final int mVoltage;

    public GT_Cover_SolarPanel(int aVoltage) {
        this.mVoltage = aVoltage;
    }

    @Override
    public boolean isRedstoneSensitive(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aSide != 1) {
            return 0;
        }
        int coverState = aCoverVariable & 3;
        int coverNum = aCoverVariable >> 2;
        if (aTimer % 100L == 0L) {
            if (aTileEntity.getWorld().func_72911_I()) {
                return aTileEntity.getBiome().field_76751_G > 0.0f && aTileEntity.getSkyAtSide(aSide) ? Math.min(20, coverNum) << 2 : coverNum << 2;
            }
            if (aTileEntity.getWorld().func_72896_J() && aTileEntity.getBiome().field_76751_G > 0.0f) {
                if (aTileEntity.getSkyAtSide(aSide)) {
                    coverNum = Math.min(30, coverNum);
                }
                if (aTileEntity.getWorld().field_73008_k >= 4) {
                    if (!aTileEntity.getWorld().func_72935_r()) return coverNum << 2;
                    coverState = 2;
                }
            } else {
                coverState = aTileEntity.getWorld().func_72935_r() ? 1 : 2;
            }
        }
        if (coverState == 1) {
            aTileEntity.injectEnergyUnits((byte)6, (100L - (long)coverNum) * (long)this.mVoltage / 100L, 1L);
        }
        if (aTimer % 28800L != 0L || coverNum >= 100 || coverNum <= 10 && XSTR.XSTR_INSTANCE.nextInt(3) != 2) return coverState + (coverNum << 2);
        ++coverNum;
        return coverState + (coverNum << 2);
    }

    @Override
    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.field_71075_bZ.field_75098_d) {
            GT_Utility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (aCoverVariable.get() >> 2) + "% dirt");
            aCoverVariable.set(aCoverVariable.get() & 3);
            return true;
        }
        for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = aPlayer.field_71071_by.field_70462_a[i];
            if (is == null || !is.func_77977_a().equals(new ItemStack(Items.field_151131_as).func_77977_a())) continue;
            aPlayer.field_71071_by.field_70462_a[i] = new ItemStack(Items.field_151133_ar);
            if (aPlayer.field_71069_bz != null) {
                aPlayer.field_71069_bz.func_75142_b();
            }
            GT_Utility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (aCoverVariable.get() >> 2) + "% dirt");
            aCoverVariable.set(aCoverVariable.get() & 3);
            return true;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "You need water bucket in inventory to clean the panel.");
        return false;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.field_71075_bZ.field_75098_d) {
            GT_Utility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (aCoverVariable >> 2) + "% dirt");
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable & 3);
            return true;
        }
        for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = aPlayer.field_71071_by.field_70462_a[i];
            if (is == null || !is.func_77977_a().equals(new ItemStack(Items.field_151131_as).func_77977_a())) continue;
            aPlayer.field_71071_by.field_70462_a[i] = new ItemStack(Items.field_151133_ar);
            if (aPlayer.field_71069_bz != null) {
                aPlayer.field_71069_bz.func_75142_b();
            }
            GT_Utility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (aCoverVariable >> 2) + "% dirt");
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable & 3);
            return true;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "You need water bucket in inventory to clean the panel.");
        return false;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }
}

